(* This file was mangled by Mangler 1.40 (c) Copyright 1993-1994 by Berend de Boer *)
{ Created : 01-06-'90

Notes:
- use InitBBError to initialize this unit.
- when initialized you have a text file ferr to which you can write using
  normal WriteLn calls. Every line in this log file is preceeded by the
  current date and time.
- for DPMI and Windows environment it installs a HeapErrorFunc which
  returns a nil pointer when memory could not be allocated instead of
  aborting with a 203 run-time error.
- default log files do not grow larger as 100K. When on startup the log
  file is greater than 100K it's renamed to .LO0 and a new log file is
  created. You can change the default of 100K by setting LogFileSizeLimit
  to another value before calling InitBBError.

Last changes :
91-07-10  Adapted for use in TP6.0 and Turbo Vision
92-07-02  Added log file ferr where an application can write error codes to
92-12-04  Added code to clear IOResult so an errormessage can be written to
          the log file
93-01-18  Installed a simple Heap function to return 1 when a request for
          memory could not be fulfilled
93-01-28  Deleted statements which disposed an Application if an error was
          detected
93-05-05  Added a dump stack procedure
93-12-01  Added a hook for the Post Mortem Debugger, simple change the
          procedure variable HandleRunTimeError
94-03-17  Renamed InstallExitHandler to InitBBError
94-05-16  Adapted to Windows target
94-10-24  Improved stack walking with better near call detection
96-01-27  Complete revamped log file mechanism: every line in the log file
          is now preceeded by its current date and time.
}



{$IFDEF MSDOS}
{$O+,F+,D-}
{$ENDIF}

{$I-,V-,Q-,R-,S-}
unit BBError;

interface

const
  _200K = 200 * 1024;
  LogFileSizeLimit:longint = _200K;

const
  LogFileOpened: Boolean = False;


const
  FatalErrorText:string[128] = 'Fatal error. Errorcode: ';

type
  HandleRunTimeErrorProcedureType = procedure(StackFrame: word);
  DumpStackProcedureType = procedure(Addr: pointer; StackFrame: word);

var
  ferr: text;
  HandleRunTimeError: HandleRunTimeErrorProcedureType;
  DumpStack: DumpStackProcedureType;


function  GetLogicalAddr(Addr: pointer): pointer;
function  IsValidPtr(Addr: pointer): Boolean;
procedure LogError(const s: string);
function  InitBBError(const AFileName: string; bAppend: Boolean): Boolean;




 IMPLEMENTATION USES {$IFDEF Debug}ASSERTIONS ,{$ENDIF}{$IFDEF Windows}WINDOS ,WINPROCS ,{$IFDEF Ver80}SYSUTILS
,{$ELSE}WINAPI ,STRINGS ,{$ENDIF}{$ELSE}DOS ,STRINGS ,{$ENDIF}{$IFDEF DPMI}WINAPI ,{$ENDIF}BBFILE ,BBGUI ,BBUTIL ;
TYPE O10O0l011OlOI=RECORD OIOll11llII,OI1lOlO1I0O:WORD;END ;FUNCTION GETLOGICALADDR (ADDR:POINTER):POINTER ;ASSEMBLER;
ASM {} {$IFNDEF MsDos} {} MOV DX , WORD PTR ADDR+ 2 {} CMP DX , 0 {} JE @@end {} VERR DX {} JE @@selok {} XOR DX , DX {}
JMP @@end {} @@selok : {} MOV ES , DX {} MOV DX , WORD PTR ES : [ 0 ] {} @@end : {} MOV AX , WORD PTR ADDR{} {$ENDIF} {}
{$IFDEF MsDos} {} MOV CX , WORD PTR ADDR{} MOV BX , WORD PTR ADDR+ 2 {} MOV AX , OVRLOADLIST{} @@0 : {} OR AX , AX {}
JE @@3 {} MOV ES , AX {} MOV AX , ES : WORD PTR 16 {} OR AX , AX {} JE @@1 {} SUB AX , BX {} JA @@1 {} NEG AX {}
CMP AX , 1000h {} JAE @@1 {} MOV DX , 16 {} MUL DX {} ADD AX , CX {} JC @@1 {} CMP AX , ES : WORD PTR 8 {} JB @@2 {}
@@1 : {} MOV AX , ES : WORD PTR 20 {} JMP @@0 {} @@2 : {} MOV CX , AX {} MOV BX , ES {} @@3 : {} SUB BX , PREFIXSEG{}
SUB BX , 10h {} MOV AX , CX {} MOV DX , BX {} {$ENDIF} {} END;FUNCTION ISVALIDPTR (ADDR:POINTER):BOOLEAN ;ASSEMBLER;
ASM {} {$IFNDEF MsDos} {} XOR AX , AX {} MOV DX , WORD PTR ADDR+ 2 {} CMP DX , 0 {} JE @@exit {} VERR DX {} JNE @@exit {}
INC AX {} @@exit : {} {$ELSE} {} MOV AX , 1 {} {$ENDIF} {} END;PROCEDURE O100I0IOIOl (OOlIl0OOIIOO:POINTER;
O100llIl00IOl:WORD);FAR;VAR O101O01III1II:WORD;O100Ol00I:POINTER;OI11OO1I0:WORD;PROCEDURE O1011O1IO1O10
(OOlIl0OOIIOO:POINTER);BEGIN WITH O10O0l011OlOI(OOlIl0OOIIOO) DO WRITELN (FERR ,'  ',HEXSTR (OI1lOlO1I0O ),':',HEXSTR
(OIOll11llII ));END ;FUNCTION OOIO11111111 :BOOLEAN ;VAR OOIl0I00O1O0:POINTER;BEGIN OOIO11111111 :=FALSE ;IF O100Ol00I
=NIL THEN EXIT ;O10O0l011OlOI (OOIl0I00O1O0 ).OIOll11llII :=O10O0l011OlOI (OOlIl0OOIIOO ).OIOll11llII ;
{$IFDEF MsDos}O10O0l011OlOI (OOIl0I00O1O0 ).OI1lOlO1I0O :=OI11OO1I0 ;{$ELSE}IF GETSELECTORLIMIT (OI11OO1I0 )<=
O10O0l011OlOI (OOIl0I00O1O0 ).OIOll11llII THEN EXIT ;O10O0l011OlOI (OOIl0I00O1O0 ).OI1lOlO1I0O :=ALLOCSELECTOR (OI11OO1I0
);IF O10O0l011OlOI (OOIl0I00O1O0 ).OI1lOlO1I0O =0 THEN EXIT ;{$ENDIF}WITH O10O0l011OlOI(OOIl0I00O1O0) DO OOIO11111111
:=(MEMW [ SSEG :O100llIl00IOl + 4 ] =O101O01III1II )OR ((OIOll11llII >= 5 )AND (MEM [ OI1lOlO1I0O :OIOll11llII - 3 ] =$E8
)AND (MEM [ OI1lOlO1I0O :OIOll11llII - 5 ] <> $9A ));{$IFNDEF MsDos}FREESELECTOR (O10O0l011OlOI (OOIl0I00O1O0
).OI1lOlO1I0O );{$ENDIF}END ;BEGIN IF NOT LOGFILEOPENED THEN EXIT ;LOGERROR ('**Stack dump. Callers shown only**');IF ODD
(O100llIl00IOl )THEN DEC (O100llIl00IOl );O101O01III1II :=MEMW [ SSEG :O100llIl00IOl ] ;IF ODD (O101O01III1II )THEN DEC
(O101O01III1II );O100Ol00I :=OOlIl0OOIIOO ;OI11OO1I0 :=O10O0l011OlOI (O100Ol00I ).OI1lOlO1I0O ;WHILE (O101O01III1II >
O100llIl00IOl )AND (MEMW [ SSEG :O100llIl00IOl ] <> 0 ) DO BEGIN O10O0l011OlOI (OOlIl0OOIIOO ).OIOll11llII :=MEMW [ SSEG
:O100llIl00IOl + 2 ] ;IF OOIO11111111 THEN O10O0l011OlOI (OOlIl0OOIIOO ).OI1lOlO1I0O :=O10O0l011OlOI (O100Ol00I
).OI1lOlO1I0O ELSE BEGIN OI11OO1I0 :=MEMW [ SSEG :O100llIl00IOl + 4 ] ;O10O0l011OlOI (OOlIl0OOIIOO ).OI1lOlO1I0O :=MEMW [
SSEG :O100llIl00IOl + 4 ] ;OOlIl0OOIIOO :=GETLOGICALADDR (OOlIl0OOIIOO );IF OOlIl0OOIIOO =NIL THEN BREAK ;
{$IFNDEF MsDos}IF O10O0l011OlOI (OOlIl0OOIIOO ).OI1lOlO1I0O =0 THEN O10O0l011OlOI (OOlIl0OOIIOO ).OI1lOlO1I0O
:=O10O0l011OlOI (O100Ol00I ).OI1lOlO1I0O ;{$ENDIF}END ;O100llIl00IOl :=O101O01III1II ;O1011O1IO1O10 (OOlIl0OOIIOO );
O101O01III1II :=MEMW [ SSEG :O100llIl00IOl ] ;IF ODD (O101O01III1II )THEN DEC (O101O01III1II );O100Ol00I :=OOlIl0OOIIOO ;
END ;FLUSH (FERR );END ;PROCEDURE LOGERROR (CONST S:STRING );BEGIN IF LOGFILEOPENED THEN WRITELN (FERR ,S );END ;
PROCEDURE O10O0I0llIOl0 (O100llIl00IOl:WORD);FAR;BEGIN WRITELN (FERR ,'Erroraddr: ',HEXSTR (O10O0l011OlOI (ERRORADDR
).OI1lOlO1I0O ),':',HEXSTR (O10O0l011OlOI (ERRORADDR ).OIOll11llII ));INFOBOX (FATALERRORTEXT + STRW (EXITCODE ),0 );
DUMPSTACK (ERRORADDR ,O100llIl00IOl );END ;VAR O1lO11Il00lI:POINTER;PROCEDURE O10O0I0O00I10 ;FAR;VAR OIO1OO11I1:WORD;
O10l010OlIl11:INTEGER;BEGIN ASM {} MOV AX , BP {} SHR AX , 1 {} SHL AX , 1 {} MOV OIO1OO11I1, AX {} END;EXITPROC
:=O1lO11Il00lI ;O10l010OlIl11 :=IORESULT ;WRITELN (FERR ,'MemAvail on exit: ',MEMAVAIL );IF (EXITCODE =0 )OR (ERRORADDR
=NIL )THEN BEGIN WRITELN (FERR ,'Program terminates normally.');END ELSE BEGIN WRITELN (FERR
,'Program terminated with ExitCode ',EXITCODE ,'.');HANDLERUNTIMEERROR (OIO1OO11I1 );END ;CLOSE (FERR );END ;
{$IFNDEF MsDos}FUNCTION O1011I1OlOIO1 (OI1OIIIl0lO1:WORD):INTEGER ;FAR;BEGIN O1011I1OlOIO1 :=1 ;END ;
{$ENDIF}TYPE OO11O1O11l0=^OO11O1O11ll;OO11O1O11ll=RECORD OI110Ol101lI:TEXT;O101IOO1OO110:BOOLEAN;OOlIlOlII1l1:ARRAY [ 1
.. 11 ]  OF BYTE;END ;FUNCTION OOIl0lO1IO00 (VAR OO1l:TTEXTREC):INTEGER ;FAR;CONST O10OOll1=#10;VAR OI11II10lI0I:STRING ;
O10OOI0l111IO:OO11O1O11l0;O10l010OlIl11:INTEGER;BEGIN O10l010OlIl11 :=IORESULT ;IF LOGFILEOPENED AND (OO1l.BUFPOS > 0
)THEN BEGIN MOVE (OO1l.USERDATA ,O10OOI0l111IO ,SIZEOF (OO11O1O11l0 ));WITH OO1l,O10OOI0l111IO^ DO BEGIN APPEND
(OI110Ol101lI );IF O101IOO1OO110 THEN BEGIN WRITE (OI110Ol101lI ,GETDATESTR ,' ',GETTIMESTR ,' ');O101IOO1OO110 :=FALSE ;
END ;MOVE (BUFPTR ^,OI11II10lI0I [ 1 ] ,BUFPOS );OI11II10lI0I [ 0 ] :=CHR (BUFPOS );WRITE (OI110Ol101lI ,OI11II10lI0I );
O101IOO1OO110 :=POS (O10OOll1 ,OI11II10lI0I )<> 0 ;CLOSE (OI110Ol101lI );END ;END ;OO1l.BUFPOS :=0 ;OOIl0lO1IO00
:=IORESULT ;END ;FUNCTION O100l0IlO0II1 (VAR OO1l:TTEXTREC):INTEGER ;FAR;BEGIN O100l0IlO0II1 :=0 ;END ;
FUNCTION OOIl11ll0OOl (VAR OO1l:TTEXTREC):INTEGER ;FAR;VAR O10OOI0l111IO:OO11O1O11l0;BEGIN IF LOGFILEOPENED THEN
BEGIN MOVE (OO1l.USERDATA ,O10OOI0l111IO ,SIZEOF (OO11O1O11l0 ));WITH OO1l,O10OOI0l111IO^ DO BEGIN CLOSE (OI110Ol101lI );
END ;LOGFILEOPENED :=FALSE ;END ;OOIl11ll0OOl :=IORESULT ;END ;FUNCTION OOI1OIOIOOO1 (VAR OO1l:TTEXTREC):INTEGER ;
FAR;CONST OIOI1OOIOlO=$0001 ;OOlO1I11Ol0O=$0020 ;VAR O10OOI0l111IO:OO11O1O11l0;O101IO1IOlIl1:TSEARCHREC;
OI1l0l1Il00O:WORD;O10l010OlIl11:INTEGER;OII01l11lI0:FILE ;BEGIN MOVE (OO1l.USERDATA ,O10OOI0l111IO ,SIZEOF (OO11O1O11l0
));WITH OO1l,O10OOI0l111IO^ DO BEGIN IF (MODE =FMINPUT )THEN BEGIN INOUTFUNC :=@ O100l0IlO0II1 ;FLUSHFUNC :=@
O100l0IlO0II1 ;END ELSE BEGIN INOUTFUNC :=@ OOIl0lO1IO00 ;FLUSHFUNC :=@ OOIl0lO1IO00 ;END ;CLOSEFUNC :=@ OOIl11ll0OOl ;
O101IOO1OO110 :=TRUE ;{$IFDEF Windows}{$IFDEF VER80}DOSERROR :=FINDFIRST (STRPAS (NAME ),ARCHIVE ,O101IO1IOlIl1 );
{$ELSE}FINDFIRST (NAME ,ARCHIVE ,O101IO1IOlIl1 );{$ENDIF}{$ELSE}FINDFIRST (STRPAS (NAME ),ARCHIVE ,O101IO1IOlIl1 );
{$ENDIF}IF DOSERROR =0 THEN BEGIN IF O101IO1IOlIl1.SIZE > LOGFILESIZELIMIT THEN BEGIN ASSIGN (OII01l11lI0
,FFORCEEXTENSION (STRPAS (NAME ),'.LO0'));ERASE (OII01l11lI0 );O10l010OlIl11 :=IORESULT ;RENAME (OI110Ol101lI
,FFORCEEXTENSION (STRPAS (NAME ),'.LO0'));ASSIGN (OI110Ol101lI ,STRPAS (NAME ));REWRITE (OI110Ol101lI );CLOSE
(OI110Ol101lI );END ;END ELSE BEGIN REWRITE (OI110Ol101lI );CLOSE (OI110Ol101lI );END ;OI1l0l1Il00O :=FILEMODE ;FILEMODE
:=OIOI1OOIOlO + OOlO1I11Ol0O ;APPEND (OI110Ol101lI );FILEMODE :=OI1l0l1Il00O ;WRITELN (OI110Ol101lI );LOGFILEOPENED
:=INOUTRES =0 ;OOI1OIOIOOO1 :=IORESULT ;END ;END ;PROCEDURE O100O1llOl (VAR OIl0:TEXT;CONST Ol1O0OOI:STRING );
VAR O10OOI0l111IO:OO11O1O11l0;BEGIN FILLCHAR (OIl0 ,SIZEOF (TTEXTREC ),0 );WITH TTEXTREC(OIl0) DO BEGIN HANDLE :=$FFFF ;
MODE :=FMCLOSED ;BUFSIZE :=SIZEOF (BUFFER );BUFPTR :=@ BUFFER ;OPENFUNC :=@ OOI1OIOIOOO1 ;STRPCOPY (NAME ,Ol1O0OOI );NEW
(O10OOI0l111IO );MOVE (O10OOI0l111IO ,USERDATA ,SIZEOF (OO11O1O11l0 ));ASSIGN (O10OOI0l111IO ^.OI110Ol101lI ,Ol1O0OOI );
END ;END ;FUNCTION INITBBERROR (CONST AFILENAME:STRING ;BAPPEND:BOOLEAN):BOOLEAN ;BEGIN INITBBERROR :=FALSE ;IF NOT
BAPPEND THEN DOSDEL (AFILENAME );O100O1llOl (FERR ,AFILENAME );REWRITE (FERR );IF LOGFILEOPENED THEN BEGIN DUMPSTACK
:=O100I0IOIOl ;HANDLERUNTIMEERROR :=O10O0I0llIOl0 ;O1lO11Il00lI :=EXITPROC ;EXITPROC :=@ O10O0I0O00I10 ;WRITELN (FERR
,'** ',PARAMSTR (0 ),' started **');WRITELN (FERR ,'MemAvail on start: ',MEMAVAIL );END ;{$IFNDEF MsDos}HEAPERROR :=@
O1011I1OlOIO1 ;{$ENDIF}INITBBERROR :=IORESULT =0 ;END ;END .
