unit xap_u;

interface

uses acrcy,dlgama_u,gamain_u,anorpr_u,probst_u,betain_u;

function xap(indic:integer;var ifault:integer;x,df1,df2:double):double;

implementation

function xap(indic:integer;var ifault:integer;x,df1,df2:double):double;

{
c   this function serves to accurately (as specified) calculate prob:
c        abilities from given data for specified distributions.
c
c   the input parameter 'indic'  is used to specify which distribution
c      indic = 1   chi square(d) distribution.
c      indic = 2   f distribution.
c      indic = 3   t distribution.
c      indic = 4   normal distribution.
c
c   output information is stored in **ifault**.
c      ifault = 0  function had no errors.
c      ifault = 1  degrees of freedom are illegal (<= zero, or not integral for t)
c      ifault = 2  the input value is + zero, and shouldn't be.
c      ifault = 3  the value of **indic** is not 1,2,3 or 4.
c
c   probability output is total area under curve from 0 or minus infinit
c        to the value x.  where appropriate, it is the one tailed value.
}
var
  lnbeta,
  t,
  xin,
  a,
  dlga,
  f,
  p,q,pq
   :double;

  idf,
  ier
   :integer;

begin
      acu := 1.0e-7;
      xap := 0.0;
      ifault := 3;
      if(indic<1)  or (indic>4) then
        exit;
      if (indic = 4) then
      begin
        ifault := 0;
        xap := anorpr(x);
        exit;
      end;
   {10} ifault := 1;
      if (df1<=0.0) then
        exit;
      if (indic = 3) then
      begin
   {60} ifault := 0;
{     calculating the t distribution }
        t := x;
        idf := trunc(df1 + 1.0e-8);
        if df1 - idf > 1.0e-8 then
        begin
          ifault := 1;
          exit;
        end;
        xap := probst(t,idf);
        exit;
      end;
   {20} ifault := 2;
      if(x<0.0) then
        exit;
      if (indic<>2) then
      begin
    {30}ifault := 0;
{  calculating the chi square(d) distribution. }
        xin := 0.5 * x;
        a := 0.5 * df1;
        dlga := dlgama(a);
        xap := gamain(xin,a,dlga,ier);
        exit;
      end;
      {40} ifault := 1;
      if (df2<=0.0) then
        exit;
      ifault := 0;
{   calculating the f distribution. }
      f := x;
      p := 0.5 * df1;
      q := 0.5 * df2;
   {50} pq := p + q;
      xin := 1.0 - q / (q + p*f);
      lnbeta := dlgama(p) + dlgama(q) - dlgama(pq);
      xap := betain(xin, p, q, lnbeta, ier);
end;

end.