unit dlgama_u;

interface

function dlgama(a:double):double;

implementation

function dlgama(a:double):double;

{
c        double precision function to calculate natural logarithm
c        of gamma function
c
c        input and output are both double precision
c
c        based on equations    6.1.40 and 6.1.15 on pages 256 and 257
c              of abramowitz and stegun
c
c        should give about 24 or 25 significant digits.
}
var
  w,temp,y,y2,series
   : double;

  i,n : integer;

const
  hfln2p = 0.9189385332046727417803297;
  a1=0.8333333333333333333333333e-1;
  a3=-0.2777777777777777777777778e-2;
  a5=0.7936507936507936507936508e-3;
  a7=-0.5952380952380952380952381e-3;
  a9=0.8417508417508417508417508e-3;
  a11=-0.1917526917526917526917527e-2;
  a13=0.6410256410256410256410256e-2;
  a15=-0.2955065359477124183006536e-1;
  a17=0.1796443723688305731649385;
  a19=-1.392432216905901116427432;
  a21=13.40286404416839199447895;
  a23=-156.8482846260020173063651;

begin
  dlgama := 0.0;
  if (abs(a)<1.0e-20) then
    exit;

  w := a;
  temp := 0.0;
  if (w-20.0 <= 0.0) then
  begin
    {10} n := 21 - trunc(w);

    temp := 1.0;
    for i := 1 to n do
    begin
      temp := w * temp;
    { 20} w := w + 1.0;
    end;
    temp := ln(temp);
  end;
  {30} y := 1.0 / w;
  y2 := y * y;
  series := (((a23)*y2+a21)*y2+a19);
  series := (((series*y2+a17)*y2+a15)*y2+a13);
  series := (((series*y2+a11)*y2+a9)*y2+a7);
  series := (((series*y2+a5)*y2+a3)*y2+a1)*y;

  dlgama := (w-0.5)*ln(w) - w + hfln2p + series - temp;
end;

end.


