
' $segment
' $linesize:132
' $title: 'DOSFUNC.BAS, Copyright 1993 by Daniel T. Drinnon'
'  RBBS-PC Copyright 1992 by D. Thomas Mack, all rights reserved.
'  Name ...............: DOSFUNC.BAS
'  First Released .....: August 17, 1993
'  Copyright ..........: 1993,1994,1995,1996
'  Purpose.............: DOS Function calls for RBBS-PC CDOR
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
' $INCLUDE: 'RBBS-VAR.BAS'

   TYPE RegTypeX
      ax      AS INTEGER
      bx      AS INTEGER
      cx      AS INTEGER
      dx      AS INTEGER
      bp      AS INTEGER
      si      AS INTEGER
      di      AS INTEGER
      flags   AS INTEGER
      ds      AS INTEGER
      es      AS INTEGER
   END TYPE
'
' =============================================================================
' * CheckShare - Returns ZOK = ZTrue if SHARE is loaded
' =============================================================================

    SUB CheckShare
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    CALL CheckNovell (Installed)
    IF Installed = 0 THEN
       ZOK = ZTrue
       EXIT SUB
    END IF
    ZOK = ZFalse
    InRegs.ax = &H1000
    CALL InterruptX(&H2F, InRegs, OutRegs)
    CheckShareVal = OutRegs.ax AND &HFF
    IF CheckShareVal = &HFF THEN
       ZOK = ZTrue
    ELSE
       ZSnoop = ZTrue
       '* "ERROR - SHARE NOT INSTALLED"
       CALL FormatString (848,ZTrue,ZFalse,0,ZFalse,0,"")
       CALL DelayTime (5)
    END IF
    END SUB

' =============================================================================
' * CheckOS - Returns Operating System
' =============================================================================

    SUB CheckOS
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    ZTaskerType = 0
    'Check for DesqView
    InRegs.ax = &H2B00
    InRegs.cx = &H4445
    InRegs.dx = &H5351
    CALL InterruptX(&H21, InRegs, OutRegs)
    IF NOT OutRegs.ax AND &HFF THEN
       ZTaskerType = 1
       EXIT SUB
    END IF
    'Check for OS/2
    InRegs.ax = &H3001
    CALL InterruptX(&H21, InRegs, OutRegs)
    RetVal = (OutRegs.AX - INT(OutRegs.AX / 256) * 256)
    IF RetVal = &H0A OR RetVal = &H14 THEN
       ZTaskerType = 2
       EXIT SUB
    END IF
    'Check for Windows
    InRegs.ax = &H1600
    CALL InterruptX(&H2F, InRegs, OutRegs)
    RetVal = (OutRegs.AX - INT(OutRegs.AX / 256) * 256)
    IF RetVal = &H00 OR RetVal = &H01 OR RetVal = &H80 OR RetVal = &HFF THEN
       EXIT SUB
    ELSE
       ZTaskerType = 3
    END IF
    END SUB

' =============================================================================
' * GiveBack - Operating System TimeSlicer
' =============================================================================

    SUB GiveBack
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    STATIC TaskerSet
    IF NOT TaskerSet THEN
       CALL CheckOS
       TaskerSet = ZTrue
    END IF
    SELECT CASE ZTaskerType
       CASE 0
          EXIT SUB
       CASE 1
          InRegs.ax = &H1000
          CALL InterruptX(&H15, InRegs, OutRegs)
          EXIT SUB
       CASE 2,3
          InRegs.ax = &H1680
          CALL InterruptX(&H2F, InRegs, OutRegs)
          EXIT SUB
       CASE ELSE
    END SELECT
    END SUB

' =============================================================================
' * CheckPrinter - Returns ZOK = ZTrue if Printer Ready
' =============================================================================

    SUB CheckPrinter (PrinterNumber)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    ZOK = ZFalse
    IF PrinterNumber = 0 THEN
       EXIT SUB
    END IF
    InRegs.ax = &H0200
    InRegs.dx = PrinterNumber - 1
    CALL InterruptX(&H17, InRegs, OutRegs)
    PrinterAlive = (OutRegs.ax AND &HFF00) / &H100
    ZOK = (((PrinterAlive AND &H29) = 0) AND ((PrinterAlive AND &H90) = &H90))
    END SUB

' =============================================================================
' * SetFileHandles - Sets Maximum number of File Handles (not needed yet!)
' =============================================================================

'   SUB SetFileHandles (Handles)
'   DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
'   InRegs.ax = &H6700
'   InRegs.bx = Handles
'   CALL InterruptX(&H21, InRegs, OutRegs)
'   END SUB

' =============================================================================
' * DelFile - Deletes a File
' =============================================================================

    SUB DelFile (FileName$,ECODE)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    NameFile$ = FileName$ + CHR$(0)
    InRegs.ds = SSEG(NameFile$)
    InRegs.dx = SADD(NameFile$)
    InRegs.ax = &H4100
    CALL InterruptX(&H21, InRegs, OutRegs)
    ECODE = (OutRegs.Flags AND 1)
    END SUB

' =============================================================================
' * GetFDateTime - Gets File Date and Time
' =============================================================================

    SUB GetFDate (FileName$,FDATE,FTIME)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    NameFile$ = FileName$ + CHR$(0)
    InRegs.ds = SSEG(NameFile$)
    InRegs.dx = SADD(NameFile$)
    InRegs.ax = &H3D00
    CALL InterruptX(&H21, InRegs, OutRegs)
    IF OutRegs.flags AND 1 THEN
       EXIT SUB
    END IF
    Handle = OutRegs.ax
    InRegs.ax = &H5700
    InRegs.bx = Handle
    CALL InterruptX(&H21, InRegs, OutRegs)
    FTIME = OutRegs.cx
    FDATE = OutRegs.dx
    InRegs.ax = &H3E00
    InRegs.bx = Handle
    CALL InterruptX(&H21, InRegs,OutRegs)
    END SUB

' =============================================================================
' * SetFDateTime - Sets File Date and Time
' =============================================================================

    SUB SetFDate (FileName$,FDATE,FTIME)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    NameFile$ = FileName$ + CHR$(0)
    InRegs.ds = SSEG(NameFile$)
    InRegs.dx = SADD(NameFile$)
    InRegs.ax = &H3D02
    CALL InterruptX(&H21, InRegs, OutRegs)
    IF OutRegs.flags AND 1 THEN
       EXIT SUB
    END IF
    Handle = OutRegs.ax
    InRegs.ax = &H5701
    InRegs.bx = Handle
    InRegs.cx = FTIME
    InRegs.dx = FDATE
    CALL InterruptX(&H21, InRegs, OutRegs)
    InRegs.ax = &H3E00
    InRegs.bx = Handle
    CALL InterruptX(&H21, InRegs,OutRegs)
    END SUB

' =============================================================================
' * ScrollUp - Scrolls Local Display Screen up 1 line
' =============================================================================

    SUB ScrollUp
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX

    Bottom = ((ZLocalPageLength-2) * &HFF) + 80 + ZLocalPageLength-2

    InRegs.ax = &H0601
    InRegs.bx = &H0F00
    InRegs.cx = &H0000
    InRegs.dx = Bottom
    CALL InterruptX(&H10, InRegs, OutRegs)

    END SUB

' =============================================================================
' * ClearViewPort - Clears all but 'line 25'
' =============================================================================

    SUB ClearViewPort
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX

    Bottom = ((ZLocalPageLength-2) * &HFF) + 80 + ZLocalPageLength-2

    InRegs.ax = &H0600
    InRegs.bx = &H0F00
    InRegs.cx = &H0000
    InRegs.dx = Bottom
    CALL InterruptX(&H10, InRegs, OutRegs)

    END SUB

' =============================================================================
' * WriteChar - Writes Any ASCII Character to the screen
' =============================================================================

    SUB WriteChar (Char,Attr)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX

    InRegs.ax = &H0900 + Char
    InRegs.bx = &H0000 + Attr
    InRegs.cx = &H0001

    CALL InterruptX(&H10, InRegs, OutRegs)
    END SUB

