
/*********************************************************************
*                                                                    *
*  KBSEC 1.1  -  Utilidad para medir con alta precisin la velocidad *
*                de transferencia de un disco virtual (en lectura).  *
*                                                                    *
*                (c) 1992 Ciriaco Garca de Celis                    *
*                                                                    *
*  - No debe estar instalado un programa cach; compilar en modelo   *
*  de memoria LARGO con la opcin Test stack overflow desactivada. *
*                                                                    *
*********************************************************************/

#include <stdio.h>
#include <dos.h>
#include <conio.h>

#define MAXBUF 64512L  /* 63 Kb  (no sobrepasar 64 Kb en un acceso) */
#define TIEMPO 110L    /* 6 segundos * 18,2  110 tics (error < 1%) */
#define TM 18.2      /* cadencia de interrupciones del temporizador */
#define HORA_BIOS MK_FP(0x40, 0x6c)    /* variable de hora del BIOS */

unsigned long ti, vueltas, far *cbios;
unsigned segmento, tamsect, far *pantalla;
unsigned char far *sbuffer;
static unsigned tiempo;
int unidad;
void interrupt (*viejaIRQ0)(), interrupt nuevaIRQ0(),
  prep_hw(), rest_hw();


void main(int argc, char **argv)
{
  if (allocmem ((unsigned) ((MAXBUF+0x1800) >> 4), &segmento)!=-1) {
    printf("\nMemoria insuficiente.\n"); exit(255); }

  sbuffer=MK_FP((segmento+0x100) & 0xff00 | 0x80, 0); /* 2Kb+n*4Kb */

  if (argc<2) { printf("\nIndique la unidad a probar.\n"); exit(1); }
  unidad=(argv[1][0] | 0x20) - 'a';
  if ((unidad<2) || (absread (unidad, 1, 0L, sbuffer)!=0)) {
    printf ("\nIndique unidad C o superior de menos de 32 Mb.\n");
    exit (2); }

  tamsect = sbuffer[11] | (sbuffer[12]<<8);
  ti = (long) tamsect * ((sbuffer[0x14] << 8) | sbuffer[0x13]);
  if ((ti < MAXBUF) || (ti > 33554431L)) {
    printf ("\nNecesario disco de %2.0f Kb a 32 Mb\n", MAXBUF/1024.0);
    exit (3); }

  textmode (C80); clrscr();
  printf ("\nCalculando velocidad (espere %2.0f seg.)...", TIEMPO/TM);

  pantalla=MK_FP((peekb(0x40,0x49)==7 ? 0xB000:0xB800), 0x140);

  prep_hw(); ti=tiempo=vueltas=0;
  while (ti==tiempo); /* esperar pulso del reloj */ ti+=TIEMPO;

  while (ti >= tiempo)
    if (absread (unidad, MAXBUF / tamsect, 0L, sbuffer)!=0) {
      rest_hw(ti-tiempo); printf ("\nError al acceder al disco.\n");
      exit(254); }
    else if (!(vueltas++ & 7)) *pantalla++=0xf07;  /* "imprimir" */

  rest_hw(TIEMPO); clrscr();

  printf("\nKBSEC 1.1: Velocidad de transferencia efectiva unidad %c:\
    %6.0f Kb/seg.\n", unidad+'A',MAXBUF/1024.0*vueltas/(TIEMPO/TM));
}


void interrupt nuevaIRQ0 () /* rutina ejecutada cada 55 ms */
{
   tiempo++;                /* incrementar nuestro contador de hora */
   outportb (0x20,0x20);    /* EOI al controlador de interrupciones */
}

void prep_hw()
{
  viejaIRQ0=getvect(8);      /* preservar vector de int. peridica */
  setvect (8, nuevaIRQ0);    /* instalar nueva rutina de control   */
  outportb (0x21, 0xfe);     /* inhibir todas las int. salvo timer */
}

void rest_hw (unsigned long tiempo_transcurrido_con_reloj_parado)
{
  outportb (0x21, 0);         /* autorizar todas las interrupciones */
  setvect (8, viejaIRQ0);     /* restaurar vector de int. peridica */
  cbios=HORA_BIOS; *cbios+=tiempo_transcurrido_con_reloj_parado;
}
