/* auto3.c - sieve, penregs and filecopy benchmarks */
#include "stdio.h"

#define true 1
#define false 0
#define size 8190
#define sizepl 8191

int sieve()          /* sieve benchmark - no register vars. */
 {
	int i,prime,k,count;
	char flags[sizepl];

	count=0;
	for(i = 0; i<=size;i++)
	   flags[i]=true;
	   for(i=0;i <= size; i++){
	      if(flags[i]){
	         prime = i+i+3;
	         k=i+prime;
	         while(k<=size){
					flags[k] = false;
	            k += prime;
	            }
	         count = count+1;
	         }
	      }
	return(count);
 }


int siever()            /* sieve with register variables */
 {
   register int k ,prime ;
	int i , count;
	char flags[sizepl];

	count=0;
	for(i = 0; i<=size;i++)
	   flags[i]=true;
	   for(i=0;i <= size; i++){
	      if(flags[i]){
	         prime = i+i+3;
	         k=i+prime;
	         while(k<=size){
	            flags[k] = false;
	            k += prime;
	            }
	         count = count+1;
	         }
	      }
	return(count);
	}


int penregs()           /* string copy with register variables */
 {
    int i ;
    char s[501] , s2[501] ;

    for(i=0 ; i < 500 ; i=i+1 )
       { s[i] = 'a' ; } ;
    s[500] = '\0' ;

    for( i=0 ; i < 100 ; i=i+1 )
       { rscopy(s2,s) ; } ;
 }

         
int rscopy(to,from)     /* string copy function */
 char *to ;             /* pointer to destination string */
 char *from ;           /* pointer to source string */
 {
    register char *t , *f ;

    t = to ; f = from ;
    while( (*t++ = *f++) != '\0' ) /* check for end of string */
      { ; } ; /* copy one char and advance ptrs */
 }

extern int nblock ;
extern char *inname , *outname ;

int rwfile()            /* file copy benchmark - read/write */
 {
#define  NO_FILE    (-1)
#define  RD_MODE     0x8000
#define  WR_MODE     0x8001

    int    in ,
           out ;
    int c ;
    long n ;
    char buffer[8096] ;

    in = open(inname,RD_MODE);
    out = creat(outname,WR_MODE);
    if( (in == NO_FILE) || (out == NO_FILE) )
      { printf("can't open a file");
        exit(0) ;
      }
    n=0;
    c = read(in,buffer,nblock) ;
    while( c > 0 )
      { n=n+c ;
        write(out,buffer,c);
        c = read(in,buffer,nblock) ;
      } 
    close(in);
    close(out);
 }

