/*
                       PSRM
   Function: this subroutine takes records from PS and then rout them
             to the appropriate procedures which are responsible for
             processing that records.

  CopyRight 1995. Nicholas Poljakov all rights reserved.

 */
#include <state1.h>
#include <stdio.h>
#include <rcb.h>
#include <drcb.h>
#include <termps.h>
#include <rpl.h>
#include <nib.h>
#include <tcb.h>
#include <scb.h>
#include <lucb.h>
#include <malloc.h>
#include <string.h>

int gtf();
int change_ses();
int rm_act_ses();
int rm_deact();
int unbind_pr_er();
int sk_r_wt(void *);
int SendBlock(void *, void *);
int setrc(void *, void *);
int sendhsf(void *);
int sendhs(void *);
int sendbm(void *, void *);
int sendat(void *);
int rtsend(void *);
unsigned long rmfmh5(void *, void *);
int recwait(void *);
int rcvru(void *, void *);
int rcvhs(void *, void *, void *, void *);
int ralloc(void *, void *);
int ps_conv(int, void *);
int proterr(void *, unsigned long);
int preptrcv(void *, void *);
int post_rcb(void *);
struct repass *postopen(void *);
int phsrec(void *);
int pfmh5(void *);
int opndst(void *);
int obtsess(void *, unsigned char);
int Lrf_handler(void *);
int get_sess(void *, void *);
int get_attr(void *);
int fsm_error(unsigned char, void *);
int fsm_conv(unsigned char, unsigned char, void *);
int flush (void *);
int dcp(void *);
int dealloc(void *);
int crtp(void *);
int conv(void *);
int chkparm(void *, void *);
int check_end(unsigned int, void *);
struct rqb *call_appl(void *);
int buffmng(unsigned char, void *, void *, void *, unsigned, unsigned char, unsigned);
unsigned long attltck(void *);
unsigned long attacheck(void *);
char *cgetmem(int, int);
int sendhsf(void *);
int opndst(void *);
int alloc_rcb(void *, void *);
int allocate(void *);
int clsdst(void *);


int psrm(code, in_rec, out_rec)

int code;
char *in_rec;
char *out_rec;

{
  struct rcb *p_rcb;
  struct rcb *temp_rcb;
  struct rcb *temp1_rcb;
  struct rcbd *p_rcbd;
  struct drcb *p_drcb;
  struct termps *p_termps;
  struct scb *p_scb;
  struct lucb *p_lucb;
  struct tcb *p_tcb;
  struct tcb *temp_tcb;
  struct tcb *temp1_tcb;

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;           /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "psrm");
pnum = 1;
drec = &code;
lenr = sizeof(int);
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/
#endif

   switch (code)
    {
     case ALLOCATE_RCB:
      {
        alloc_rcb(in_rec, out_rec);
        break;
      }
     case GET_SESSION:
      {
       get_sess(in_rec, out_rec);
       break;
      }
     case DEALLOCATE_RCB:
      {
	  p_drcb = (struct drcb *)in_rec;
          p_rcb = p_drcb->p_rcb;
          p_tcb = p_drcb->p_tcb;
          temp_rcb = p_rcb -> prev;
          temp1_rcb = p_rcb -> next;
          if (temp_rcb != NULL) {
                temp_rcb -> next = temp1_rcb;
          }
          else
                p_tcb -> rcb_list_ptr = temp1_rcb;
          if (temp1_rcb != NULL) {
                temp1_rcb -> prev = temp_rcb;
          }
          p_scb = p_rcb -> p_scb;
	  if (p_scb != NULL) {         /* 30.11.92 */
            p_scb -> p_rcb = NULL;
            p_scb -> use = FREE;
	  }
          p_scb -> p_rcb = NULL;
          p_scb -> use = FREE;
          free(p_rcb);
          p_tcb -> cur_conv--;
        break;
      }

     case TERMINATE_PS:
       {
	    p_termps = (struct termps *)in_rec;
            p_tcb = p_termps->p_tcb;
            p_rcb = p_tcb -> rcb_list_ptr;
            p_lucb = p_tcb -> p_lucb;
            while (p_rcb != NULL) {
                  p_scb = p_rcb -> p_scb;
                  p_scb -> p_rcb = NULL;
                  p_scb -> use = FREE;
                  temp_rcb = p_rcb;
                  p_rcb = p_rcb -> next;
                  free(temp_rcb);
            }
            temp_tcb = p_tcb -> prev;
            temp1_tcb = p_tcb -> next;
            if (temp_tcb == NULL) {
                p_lucb -> tcb_list_ptr = temp1_tcb;
            }
            else
                temp_tcb -> next = temp1_tcb;
            if (temp1_tcb != NULL)
                temp1_tcb -> prev = temp_tcb;
            p_lucb -> cur_tps--;
            free(p_tcb);
            break;
       }
     case CHANGE_SESSION:
       {
        change_ses(in_rec, out_rec);
        break;
       }
     case RM_ACTIVATE_SESSION:
       {
        rm_act_ses(in_rec, out_rec);
        break;
       }
     case RM_DEACTIVATE_SESSION:
       {
        rm_deact(in_rec, out_rec);
        break;
       }
     case UNBIND_PROTOCOL_ERROR:
       {
        unbind_pr_er(in_rec);
        break;
       }
     }
    return (0);
}
int change_ses(in_rec, out_rec)
char *in_rec;
char *out_rec;
  {
   return (0);
  }

int rm_act_ses(in_rec, out_rec)
char *in_rec;
char *out_rec;
  {
   return (0);
   }

int rm_deact(in_rec, out_rec)
char *in_rec;
char *out_rec;
   {
    return (0);
    }

int unbind_pr_er(in_rec)
char *in_rec;
   {
   return (0);
    }
