 /**********************************************************
 *                                                         *
 *                   F L U S H                             *
 *                                                         *
 *    Function  : handles the FLUSH verb processing.       *
 *                                                         *
 *    Input     : FLUSH verb parametrs.                    *
 *    Output    : Flushe output buffers and shut down the  *
 *                other activities depend on the values of *
 *                "conv_state" and "error_state" variables.*
 *                                                         *
 *                                                         *
 * CopyRight 1995. Nicholas Poljakov all rights reserved.  *
 *                                                         *
 **********************************************************/
#include <stdio.h>
#include <flush.h>
#include <state1.h>
#include <rcb.h>
#include <tcb.h>
#include <lucb.h>
#include <cma.h>
#include <psp.h>
#include <prefix.h>
#include <string.h>

extern struct psp psp_ini;
int sk_r_wt(void *);
int SendBlock(void *, void *);
int setrc(void *, void *);
int sendhsf(void *);
int sendhs(void *);
int sendbm(void *, void *);
int sendat(void *);
int rtsend(void *);
unsigned long rmfmh5(void *, void *);
int recwait(void *);
int rcvru(void *, void *);
int rcvhs(void *, void *, void *, void *);
int ralloc(void *, void *);
int psrm(int, void *, void *);
int ps_conv(int, void *);
int proterr(void *, unsigned long);
int preptrcv(void *, void *);
int post_rcb(void *);
struct repass *postopen(void *);
int phsrec(void *);
int pfmh5(void *);
int opndst(void *);
int obtsess(void *, unsigned char);
int Lrf_handler(void *);
int get_sess(void *, void *);
int get_attr(void *);
int fsm_error(unsigned char, void *);
int fsm_conv(unsigned char, unsigned char, void *);
int dcp(void *);
int dealloc(void *);
int crtp(void *);
int conv(void *);
int chkparm(void *, void *);
int check_end(unsigned int, void *);
struct rqb *call_appl(void *);
int buffmng(unsigned char, void *, void *, void *, unsigned, unsigned char, unsigned);
unsigned long attltck(void *);
unsigned long attacheck(void *);
char *cgetmem(int, int);
int sendhsf(void *);
int opndst(void *);
int alloc_rcb(void *, void *);
int allocate(void *);
int clsdst(void *);

flush (pptr)
struct flush *pptr;
{
        struct prefix *p_prf;
        struct prefix *temp;
        struct rcb *p_rcb;
        struct tcb *p_tcb;
        struct lucb *p_lucb;
        struct cma ar;
        unsigned int type;
        char *p;

        int  fsm_conv();
        int  fsm_error();
        char s;
        char r;
        int code;
        int state;

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;           /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "flush");
pnum = 1;
drec = pptr;
lenr = sizeof(struct flush);
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/
#endif

        s = 'S';
        r = 'R';

        if (chkparm(pptr, &ar) == -1) {
           return(0);
        }
        p_rcb = ar.p_rcb;
        p_tcb = ar.p_tcb;

     /* Check if the RCB is in the wait queue */
        if (sk_r_wt(p_rcb) == 0) {
           pptr -> prim_rc = INCOMPLETE;
           return (0);
        }

    /*   place the verb code into the RCB  */
        p_rcb -> verb_code = Flush;
        p_rcb -> verb_ptr = pptr;

        pptr -> prim_rc = 0;
        pptr -> sec_rc = 0;

        type = 0xffff;

        if ((p_rcb -> error_state == RCVD_ERROR)||
            (p_rcb -> error_state == NO_RQS)) {
            switch (p_rcb -> conv_state) {
                case SEND              :  break;
                case PREP_TO_RCV_DEFER :
                case deall_defer       :
                                          if (p_rcb -> conv_state == deall_defer) {
                                              type = Deallocate_flush;
                                          }
                                          else
                                              type = PREP_TO_RCV_FLUSH;
                                          break;
                default                :  pptr -> prim_rc = STATE_CHECK;
                                          return 0;
            }
            if ((state = fsm_conv(s, Flush, p_rcb)) == -1) {
                 pptr -> prim_rc = PORT_ABENDED;
                 return 0;
            }
            if (state == 1) {
                 pptr -> prim_rc = PORT_DISABLED;
                 return 0;
            }
            if (type != 0xffff) {
		buffmng('A', NULL, p, p_rcb, 0, 0, type);
            }
            if (p_rcb -> conv_state == deall_defer) {
                /* Purge the chain of input records */
                p_prf = p_rcb -> first_in;
                while (p_prf != NULL) {
                     if ((p = p_prf -> text) != NULL) {
                        free( p );
                     }
                     temp = p_prf;
                     p_prf = p_prf -> next;
                     free( temp );
                }
            }
            sendhsf(p_rcb);
        }
        else
                pptr -> prim_rc = PORT_BUSY;
        return 0;
}
