/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 1.0, Jan. 1992   *
******************************************************************************
* Global definitions of	Graphics interface.			             *
*****************************************************************************/

#ifndef	GRAPH_GEN_H	/* Define only once */
#define	GRAPH_GEN_H

#include "irit_sm.h"

#ifdef __TURBOC__

#include <graphics.h>
#include <intr_lib.h>
#include <intr_gr.h>

#else

#ifdef DJGCC

#include <intr_lib.h>
#include <intr_gr.h>

#endif /* DJGCC */

#ifdef  BLACK
#undef  BLACK
#endif
#define BLACK		0 /* Must be inorder of XViewColorDefs - xgrphgen.c. */
#ifdef  RED
#undef  RED
#endif
#define RED		4
#ifdef  GREEN
#undef  GREEN
#endif
#define GREEN		2
#ifdef  BLUE
#undef  BLUE
#endif
#define BLUE		1
#ifdef  YELLOW
#undef  YELLOW
#endif
#define YELLOW		14
#ifdef  CYAN
#undef  CYAN
#endif
#define CYAN		3
#ifdef  MAGENTA
#undef  MAGENTA
#endif
#define MAGENTA		5
#ifdef  WHITE
#undef  WHITE
#endif
#define WHITE		15
#define MAX_COLOR	15

#define SOLID_LINE	1
#define DOTTED_LINE	2

#endif /* __MSDOS__ */

/* Name	of generic matric transformation saved by this program:	*/
#define GENERIC_MAT_FILE  "generic#.mat"   /* Generic mat file name to save. */
#define GENERIC_GIF_FILE  "generic#.gif"   /* Generic gif file name to save. */
#define GENERIC_PS_FILE   "generic#.ps"	    /* Generic PS file name to save. */

/* The current NormalLength is divided by scalar to form real normal length: */
#define NORMAL_DEFAULT_LENGTH	10
#define NORMAL_SCALER_LENGTH	100

#define DEFAULT_COLOR		1      /* For objects with no color defined. */

#define VIEW_PERSPECTIVE	1			      /* View modes. */
#define VIEW_ORTHOGRAPHIC	2
#define DEFAULT_PERSPECTIVE_Z	-5.0		   /* Default Z focal point. */

#define TRANS_SCREEN	1     /* Screen, Object coords. transformation mode. */
#define TRANS_OBJECT	2

#define DEFAULT_NUM_OF_ISOLINES		10
#define DEFAULT_SAMPLES_PER_CURVE	6

typedef enum {
    EVENT_NONE,
    EVENT_QUIT,
    EVENT_SCR_OBJ_TGL,
    EVENT_PERS_ORTHO_TGL,
    EVENT_PERS_ORTHO_Z,
    EVENT_ROTATE_X,
    EVENT_ROTATE_Y,
    EVENT_ROTATE_Z,
    EVENT_TRANSLATE_X,
    EVENT_TRANSLATE_Y,
    EVENT_TRANSLATE_Z,
    EVENT_SCALE,
    EVENT_DEPTH_CUE,
    EVENT_DRAW_SOLID,
    EVENT_SAVE_MATRIX,
    EVENT_SAVE_GIF,
    EVENT_SAVE_PS,
    EVENT_RESET_MATRIX
} GraphicEventType;

extern int
    GlblDoGraphics,		              /* If FALSE, disable graphics. */
    GlblWasCtrlBrk,			 /* TRUE if display was interrupted. */
    GlblTransformMode,		      /* Screen, Object coords. trans. mode. */
    GlblViewMode,			   /* Perspective, Orthographic etc. */
    GlblDepthCue,				   /* Activate depth cueing. */
    GlblDrawSolid;			 /* Use hardware Z buffer rendering. */

/* And finally the external routine prototypes: */

GraphicEventType GGGetGraphicEvent(RealType *ChangeFactor);
int GGIsAbortKeyPressed(void);

#if defined(__MSDOS__) || defined(DJGCC)

/* Interfacing routines to intr_lib - variables/functions from dosgraph.c */
extern int ViewWindowID, InputWindowID, StatusWindowID, TransWindowID;

/* These constants should be supplied by the host program. */
extern int
    GlblWindowFrameWidth,	     	      /* Window color configuration. */
    GlblViewFrameColor,
    GlblViewBackColor,
    GlblTransFrameColor,
    GlblTransBackColor,
    GlblStatusFrameColor,
    GlblStatusBackColor,
    GlblInputFrameColor,
    GlblInputBackColor,
    GlblDrawHeader,              /* Window general attributes configuration. */
    GlblSmoothTextScroll,
    GlblIntrSaveMethod,
    GlblMouseSensitivity,
    GlblJoystickExists,
    GlblMouseExists;
extern char
    *GlblViewWndwPos,		     	   /* Window position configuration. */
    *GlblTransWndwPos,
    *GlblStatusWndwPos,
    *GlblInputWndwPos,
    *GlblIntrSaveDisk;

void GGInitIntrLibWindows(int GraphDriver, int FullTransMode);
void GGClosIntrLibWindows(void);
void GGSetStatusInputWindows(IntrBType HasStatusWndw, IntrBType HasInputWndw);

#ifdef __MSDOS__
/* Use intr_lib routines to emulate inline the functions below. */
#define GGInstallBGI(BGIDriverPath, NameMode) \
	       { GRInstallSVGA(NameMode); GRSetBGIPath(BGIDriverPath); }
#endif /* __MSDOS__ */

#define GGInitGraph(GraphDriver, FullTransMode) \
	 			GGInitIntrLibWindows(GraphDriver, FullTransMode)
#define GGCloseGraph()          GGClosIntrLibWindows();
#define GGMyMove(x, y)          IntrWndwRMoveTo(x, y)
#define GGMyDraw(x, y)          IntrWndwRLineTo(x, y)
#define GGMySetColor(color)     GRSetColor(color)
#define GGMySetLineStyle(Style) GRSetLineStyle(Style, 0, GR_NORM_WIDTH)
#define GGClearTransArea()      IntrWndwClear(TransWindowID)
#define GGClearViewArea()       IntrWndwClear(ViewWindowID)
#define GGClearInputArea()      IntrWndwClear(InputWindowID)
#define GGClearStatusArea()     IntrWndwClear(StatusWindowID)
#define GGViewPortTransArea()   IntrWndwPop(TransWindowID, FALSE, FALSE)
#define GGViewPortViewArea()    IntrWndwPop(ViewWindowID, FALSE, FALSE)
#define GGViewPortInputArea()   IntrWndwPop(InputWindowID, FALSE, FALSE)
#define GGViewPortStatusArea()  IntrWndwPop(StatusWindowID, FALSE, FALSE)
#define GGTone			GRTone

#else

#ifdef __GL__
extern char *GlblTransPrefPos;
extern char *GlblViewPrefPos;
#endif /* __GL__ */

void GGInitGraph(int argc, char **argv, int FullTransMode, int TransAlways);
void GGCloseGraph(void);
void GGMyMove(RealType x, RealType y);
void GGMyDraw(RealType x, RealType y);
void GGMySetColor(int color);
void GGMySetLineStyle(int Style);
void GGClearViewArea(void);
#define GGClearTransArea() GGClearViewArea()
void GGTone(int Frequency, int Duration);
void GGGraphicFlush(void);
#ifdef __GL__				       /* Only on gl based systems. */
void GGMyDrawPolygonSolid(double *Vertex, float *Normal, int NewPoly);
#endif /* __GL__ */

#endif /* __MSDOS__ || DJGCC */

#endif /* GRAPH_GEN_H */

