/******************************************************************************
* Cagd_err.c - handler for all cagd library fatal errors.		      *
*******************************************************************************
* Written by Gershon Elber, May. 91.					      *
******************************************************************************/

#include "cagd_loc.h"

typedef struct CagdErrorStruct {
    CagdFatalErrorType ErrorNum;
    char *ErrorDesc;
} CagdErrorStruct;

static CagdErrorStruct ErrMsgs[] =
{
    { CAGD_ERR_180_ARC,			"Attempt to construct a 180 degrees arc" },
    { CAGD_ERR_PT_OR_LEN_MISMATCH,	"Curve PtType or Length mismatch surface" },
    { CAGD_ERR_CRVS_INCOMPATIBLE,	"Curves for rules surface are incompatible" },
    { CAGD_ERR_RAT_LIN_NO_SUPPORT,	"Derivative of rational/linear is not supported" },
    { CAGD_ERR_DIR_NOT_CONST_UV,	"Dir is not one of CONST_U/V_DIR" },
    { CAGD_ERR_T_NOT_IN_CRV,		"Given t is not in curve parametric domain" },
    { CAGD_ERR_U_NOT_IN_SRF,		"Given u is not in u surface parametric domain" },
    { CAGD_ERR_V_NOT_IN_SRF,		"Given v is not in v surface parametric domain" },
    { CAGD_ERR_INDEX_NOT_IN_MESH,	"Index is out of mesh range" },
    { CAGD_ERR_NUM_KNOT_MISMATCH,	"Number of knots does not match" },
    { CAGD_ERR_PARSER_STACK_OV,		"Parser Internal stack overflow.." },
    { CAGD_ERR_KNOT_NOT_ORDERED,	"Provided knots are not in ascending order" },
    { CAGD_ERR_UNDEF_CRV,		"Undefined curve type" },
    { CAGD_ERR_UNDEF_SRF,		"Undefined surface type" },
    { CAGD_ERR_UNSUPPORT_PT,		"Unsupported point type" },
    { CAGD_ERR_POWER_NO_SUPPORT,	"Power basis type is not supported" },
    { CAGD_ERR_NOT_IMPLEMENTED,		"Not implemented" },
    { CAGD_ERR_ALLOC_ERR,		"Memory allocation error" },
    { CAGD_ERR_NOT_ENOUGH_MEM,		"Not enough memory, exit" },
    { CAGD_ERR_WRONG_ORDER,		"Provided order is wrong" },
    { CAGD_ERR_UNDEFINE_ERR,		NULL }
};

/******************************************************************************
* Returns a string describing a the given error.			      *
******************************************************************************/
char *CagdDescribeError(CagdFatalErrorType ErrorNum)
{
    int i = 0;

    for ( ; ErrMsgs[i].ErrorDesc != NULL; i++)
	if (ErrorNum == ErrMsgs[i].ErrorNum)
	    return ErrMsgs[i].ErrorDesc;

    return "Undefined error";
}
