/******************************************************************************
* Cagd_dbg.c - Provide a routine to print Surface/Curve objects to stderr.    *
*******************************************************************************
* Written by Gershon Elber, Sep. 91.					      *
******************************************************************************/

#include "cagd_loc.h"

/******************************************************************************
* Prints curves and surfaces to stderr.					      *
******************************************************************************/
void CagdDbg(void *Obj)
{
    char *ErrorMsg;
    CagdCrvStruct
	*Crv = (CagdCrvStruct *) Obj;
    CagdSrfStruct
	*Srf = (CagdSrfStruct *) Obj;
    CagdGeomType 
	GType = Crv -> GType;

    switch (GType) {
	case CAGD_CBEZIER_TYPE:
	case CAGD_CBSPLINE_TYPE:
	case CAGD_CPOWER_TYPE:
	    CagdCrvWriteToFile2(Crv, stderr, 0, "CagdDbg", &ErrorMsg);
	    break;
	case CAGD_SBEZIER_TYPE:
	case CAGD_SBSPLINE_TYPE:
	case CAGD_SPOWER_TYPE:
	    CagdSrfWriteToFile2(Srf, stderr, 0, "CagdDbg", &ErrorMsg);
	    break;
    }

    if (ErrorMsg)
	fprintf(stderr, "CagdDbg Error: %s\n", ErrorMsg);
}
