/******************************************************************************
* CagdPoly.c - Generic Curve/Surface to polygon/polylines conversion routines.*
*******************************************************************************
* Written by Gershon Elber, July. 90.					      *
******************************************************************************/

#include "cagd_loc.h"

/*****************************************************************************
* Routine to convert a single surface to set of triangles		     *
* approximating it. FineNess is a finess control on result and the bigger it *
* is more triangles may result. a value of 10 is a good start value.	     *
* NULL is returned in case of an error, otherwise list of CagdPolygonStruct. *
*****************************************************************************/
CagdPolygonStruct *CagdSrf2Polygons(CagdSrfStruct *Srf, int FineNess,
			CagdBType ComputeNormals, CagdBType FourPerFlat)
{
    switch (Srf -> GType) {
	case CAGD_SBEZIER_TYPE:
	    return BzrSrf2Polygons(Srf, FineNess, ComputeNormals, FourPerFlat);
	case CAGD_SBSPLINE_TYPE:
	    return BspSrf2Polygons(Srf, FineNess, ComputeNormals, FourPerFlat);
	case CAGD_SPOWER_TYPE:
	    FATAL_ERROR(CAGD_ERR_POWER_NO_SUPPORT);
	    return NULL;
	default:
	    FATAL_ERROR(CAGD_ERR_UNDEF_SRF);
	    return NULL;
    }
}

/*****************************************************************************
* Routine to convert a single surface to NumOfIsolines polylines list	     *
* in each param. direction with SamplesPerCurve in each isoparametric curve. *
* Polyline are always E3 of CagdPolylineStruct type.			     *
* Iso parametric curves are sampled equally spaced in parametric space.	     *
* NULL is returned in case of an error, otherwise list of CagdPolylineStruct.*
*****************************************************************************/
CagdPolylineStruct *CagdSrf2Polylines(CagdSrfStruct *Srf, int NumOfIsocurves,
							  int SamplesPerCurve)
{
    switch (Srf -> GType) {
	case CAGD_SBEZIER_TYPE:
	    return BzrSrf2Polylines(Srf, NumOfIsocurves, SamplesPerCurve);
	case CAGD_SBSPLINE_TYPE:
	    return BspSrf2Polylines(Srf, NumOfIsocurves, SamplesPerCurve);
	case CAGD_SPOWER_TYPE:
	    FATAL_ERROR(CAGD_ERR_POWER_NO_SUPPORT);
	    return NULL;
	default:
	    FATAL_ERROR(CAGD_ERR_UNDEF_SRF);
	    return NULL;
    }
}

/*****************************************************************************
* Routine to convert a single curve to polyline with SamplesPerCurve	     *
* samples. Polyline is always E3 of CagdPolylineStruct type.		     *
* Curve is sampled equally spaced in parametric space.			     *
* NULL is returned in case of an error, otherwise CagdPolylineStruct.	     *
*****************************************************************************/
CagdPolylineStruct *CagdCrv2Polyline(CagdCrvStruct *Crv, int SamplesPerCurve)
{
    switch (Crv -> GType) {
	case CAGD_CBEZIER_TYPE:
	    return BzrCrv2Polyline(Crv, SamplesPerCurve);
	case CAGD_CBSPLINE_TYPE:
	    return BspCrv2Polyline(Crv, SamplesPerCurve);
	case CAGD_CPOWER_TYPE:
	    FATAL_ERROR(CAGD_ERR_POWER_NO_SUPPORT);
	    return NULL;
	default:
	    FATAL_ERROR(CAGD_ERR_UNDEF_CRV);
	    return NULL;
    }
}
