/*

Micro BASIC Interpeter (structures.h)

This module keeps the formats for all data structures
used in MBASIC.

*** Copyleft - Andre Murta - August 1992/December 2002 ***

Adapted from Herbert Schildt Little C (Dr. Dobbs Journal, August 1989)

*/

#include <mbasic.h>

#ifndef __STRUCTURES_H
#define __STRUCTURES_H

/* used by DATA and READ commands */
struct data_read
{
    struct data_read *previous;

    short type;
    union {
        double dv;
        char sv[STRING_LEN];
    } value;

    struct data_read *next;
};

/* array items in memory */
struct node
{
    struct node *previous;     /* pointer to previous node in list */

    /* Variable index */
    int var_index;

    /* Array indexes - three dimensions maximum */
    struct indexes {
        int x;
        int y;
        int z;
    } index;

    short type;
    union {
        double dv;
        char sv[STRING_LEN];
    } value;

    struct node *next;         /* pointer to next node in the list */
};

/* local or global variables in memory */
struct variables {
    short type;
    unsigned short isdim; /* TRUE or FALSE to check if is dimensioned var */
    unsigned short dim;
    char name[VAR_LEN];
    union {
        double dv;
        char sv[STRING_LEN];
    } value;

    /* Three dimensions maximum */
    struct ranges {
        int x;
        int y;
        int z;
    } range;

    /* Used only if associated with a file using FIELD command */
    unsigned short field_index;
    short is_field;
    short data_file_index;
    short size;
    struct indexes index;
};

/* user defined funtions */
struct user_function {
  char name[VAR_LEN];
  char *loc; /* location of entry point in file */
  short argc;
  struct variables args[FUNC_MAX_ARGS];
};

/* labels control structure */
struct label {
	char name[LAB_LEN];
	char *p;
};

/* FOR control structure */
struct for_stack {
	int var;
	short isdim;
	struct indexes index;
	short method;
	double target;
	double step;
	char *loc;
};

/* WHILE control structure */
struct while_stack {
    double cond;
    char *loc;
};

/* data files control structure */
struct dtfiles {
    char filename[STRING_LEN];
    FILE *fp;
    short locked;
    short method;
    short io_error;
    int recsize;
};

/* command table structure */
struct commands {       /* keyword lookup table */
	char command[20];
	char tok;
};

#endif
