/*

Micro BASIC Interpeter (mbasic.h)

This is the main module header.

*** Copyleft - Andre Murta - August 1992/December 2002 ***

Adapted from Herbert Schildt Little C (Dr. Dobbs Journal, August 1989)

*/

#ifndef __MBASIC_H
#define __MBASIC_H

#define TRUE            1
#define FALSE           0

#define NUM_LAB         512
#define NUM_VARS        512
#define NUM_FUNCS       128
#define NUM_FILES       64
#define FUNC_MAX_ARGS   16
#define NUM_LOCAL_VARS  128
#define LAB_LEN         10
#define FOR_NEST        25
#define WHILE_NEST      25
#define SUB_NEST        25
#define VAR_LEN         32
#define STRING_LEN      255

#define DELIMITER       1
#define VARIABLE        2
#define NUMBER          3
#define COMMAND         4
#define _STRING         5
#define UNKNOW          6

#define NUMERIC_VAR     1
#define STRING_VAR      2

#define MBASIC_VERSION 2.0
#define PARSER_VERSION 2.0
#define ENVIRONMENT_VERSION 32

/* Operators */
enum double_ops {LT=1, LE, GT, GE, EQ, NE, AND, OR, ADD, SUB, MUL, DIV, EXP, MOD, NEG, LPAREN, RPAREN,
                 DCOMMA, COMMA, QUOTE, LBRACK, RBRACK, LKEY, RKEY, QUESTION, DOLLAR, ASSIGN, SHARP};

/* Commands */
#define PRINT           28
#define INPUT           29
#define IF              30
#define THEN            31
#define FOR             32
#define NEXT            33
#define TO              34
#define DOWNTO          35
#define GOTO            36
#define EOL             37
#define FINISHED        38
#define GOSUB           39
#define RETURN          40
#define END             41
#define ELSE            42
#define WHILE           43
#define WEND            44
#define STEP            45
#define REM             46
#define LET             47
#define DIM             48
#define CLS             49
#define RANDOMIZE       50
#define DATA            51
#define READ            52
#define LINE            53
#define LOCATE          54
#define COLOR           55
#define TEXTMODE        56
#define FILES           57
#define DELLINE         58
#define INSLINE         59
#define DEFFN           60
#define CHAIN           61
#define HIGHVIDEO       62
#define NORMVIDEO       63
#define LOWVIDEO        64
#define OPEN            65
#define READING         66
#define WRITING         67
#define APPENDING       68
#define RANDOM          69
#define SEQUENTIAL      70
#define AS              71
#define CLOSE           72
#define FIELD           73
#define GET             74
#define PUT             75
#define SEEK            76
#define NONEWLINE       77
#define FPRINT          78
#define FINPUT          79
#define CLEAR           80
#define FLASH           81
#define _WINDOW          82

#endif
