/**********************************************************************/
/* Install PMDF support files                                         */
/**********************************************************************/
/**********************************************************************/
/* Variable Dictionary                                                */
/*                                                                    */
/* BootDrive       User's boot drive                                  */
/* Debug           Set to "test" to manually set kernel version       */
/*                 Set to "cleanup" to only run cleanup proc          */
/* ErrorFlag       Error? (yes/no)                                    */
/* FileFound       File name found during file search                 */
/* FileSearch      File name to search for on disk/diskette           */
/* InstPath        Path where the problem det code is installed       */
/* Line            Output to install log                              */
/* Medium          Install code is on diskette, hard file, CD ROM?    */
/* ok              "Pull" variable to allow user to continue          */
/* OutFileLog      Run-time log for PMDF package install              */
/* PathCheck.n     Does install path exist?                           */
/* SrcDrive        Drive where the source code is located             */
/* SrcPath1        Path where the PMDF source code part1 is located   */
/* SrcPath2        Path where the PMDF source code part2 is located   */
/*                                                                    */
/**********************************************************************/
/* Change Log                                                         */
/*                                                                    */
/* chg  date      by        description                               */
/* ---  --------  --------  ----------------------------------------- */
/*  00  94-09-19  Reese     Create PMDFInst based on PDPInst/PDPInst2 */
/*                                                                    */
/**********************************************************************/

/*trace '?r'*/
ADDRESS CMD "@CLS";
ADDRESS CMD "@ECHO OFF";

CALL RxFuncAdd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs';
CALL SysLoadFuncs;

Env  = "OS2ENVIRONMENT";

Arg Debug;

/**********************************************************************/
/* Determine boot drive                                               */
/**********************************************************************/

BootDrive       = SUBSTR(value('SYSTEM_INI',,Env),1,1);
OutFileLog      = BootDrive || ":\OS2\Install\PMDFInst.LOG";

/*
rc = SysFileDelete(OutFileLog);   /* Erase any old versions of log    */
*/

Line = LINEOUT(OutFileLog, "----- START OF PMDFInst -----");
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, Date() Time());
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, "This is the run-time log for the PMDF");
Line = LINEOUT(OutFileLog, "v0922 install package.  It can be    ");
Line = LINEOUT(OutFileLog, "deleted at any time without affecting");
Line = LINEOUT(OutFileLog, "the PMDF functions.                  ");

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Path/Drive values:");
Line = LINEOUT(OutFileLog, "Debug               = " Debug);
Line = LINEOUT(OutFileLog, "BootDrive           = " BootDrive);


/**********************************************************************/
/* Figure out if user is installing from CD-ROM or diskettes          */
/**********************************************************************/

If Debug <> "DESKTOP" then do;
      SrcDrive   = SUBSTR(Directory(),1,1);
      FileSearch = "\OS2Image\DMPD1" || "\DF_RET.EXE"; /* assume CD-ROM */
/*      FileSearch = "\OS2Image\DMPD1" || "\PMDF.EXE"; /* assume CD-ROM */ */
      FileFound  = STREAM(FileSearch, "c", "query exists");
      Line = LINEOUT(OutFileLog,,
         "\OS2Image\DMPD1\DF_RET.EXE FileFound = " || FileFound);

      If FileFound = " " then do; /* User may be using diskettes      */
         FileSearch = SrcDrive || ":\DF_RET.EXE";
         FileFound  = STREAM(FileSearch, "c", "query exists");
         Line = LINEOUT(OutFileLog,,
            SrcDrive || ":\DF_RET.EXE FileFound = " || FileFound);

         If FileFound = " " then do; /* User not in install directory */
           FileSearch = SrcDrive || ":DF_RET.EXE";
           FileFound  = STREAM(FileSearch, "c", "query exists");
           Line = LINEOUT(OutFileLog,,
              SrcDrive || ":DF_RET.EXE FileFound = " || FileFound);
           If FileFound = " " then do; /* User not in install directory */
            BEEP(262, 250);       /* Alert user with a beep           */
            SAY " ";
            SAY "If you are installing from the command line, you must";
            SAY "be in the path that contains the install code.  Please";
            SAY "change directories and try again.";
            EXIT;
           End;
           Else do;
             Medium     = 2;       /* 1=diskette, 2=hardfile, 3=CD-ROM */
             SrcPath1   = SrcDrive || ":";
             SrcPath2   = SrcDrive || ":..\DMPD2\";
           End;
         End;                     /* End If FileFound = " "           */

         Else do;                 /* Source code is on diskettes      */
            Medium     = 1;       /* 1=diskette, 2=hardfile, 3=CD-ROM */
            SrcPath1   = SrcDrive || ":\";
            SrcPath2   = SrcDrive || ":\";
            /* set up for testing diskettes inserted correctly        */
            FileSearch = SrcDrive || ":\PMDF.EXE";
         End;                     /* End else do (user has diskettes  */
      End;                        /* End If FileFound = " "           */
      Else do;                    /* Source code is on CD-ROM         */
         Medium     = 3;          /* 1=diskette, 2=hardfile, 3=CD-ROM */
         SrcPath1   = SrcDrive || ":\OS2Image\DMPD1";
         SrcPath2   = SrcDrive || ":\OS2Image\DMPD2";
      End;                        /* End else do (user has CD-ROM)    */

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Path/Drive values:");
Line = LINEOUT(OutFileLog, "SrcDrive            = " SrcDrive);
Line = LINEOUT(OutFileLog, "SrcPath1            = " SrcPath1);
Line = LINEOUT(OutFileLog, "SrcPath2            = " SrcPath2);

End;                              /* End if debug <> DESKTOP          */


/**********************************************************************/
/* Get PMDF Install path from user                                    */
/**********************************************************************/

Do forever;
   SAY " ";
   SAY " ";
   SAY "**********";
   SAY " ";
   If Debug <> "DESKTOP" then do;
      SAY "Install path default is '"||BootDrive||":\OS2\SYSTEM\PMDF'.";
      SAY " ";
      SAY "Please tell me the new install drive and path (x:[\path])...";
      SAY "or type 'E' to exit...";
      SAY "or press Enter to set it to '" || BootDrive ||,
         ":\OS2\SYSTEM\PMDF'.";
   End;                           /* End If debug <> "DESKTOP"        */
   Else do;
      SAY "PMDF.EXE path default is '" || BootDrive || ":\OS2\SYSTEM\PMDF'.";
      SAY " ";
      SAY "Please tell me the install drive and path (x:[\path]) where";
      SAY "  your PMDF.EXE file is located...";
      SAY "or type 'E' to exit...";
      SAY "or press Enter to accept '" || BootDrive || ":\OS2\SYSTEM\PMDF'.";
   End;                           /* End Else do                      */
   SAY " ";
   Pull InstPath;
   If (InstPath = "E" | InstPath = "EXIT") then do;
      Line = LINEOUT(OutFileLog, "User typed EXIT at InstPath.");
      Line = LINEOUT(OutFileLog, "----- END OF PMDFInst -----");
      EXIT;
   End;
   If InstPath = " " then do;
      InstPath = BootDrive || ":\OS2\SYSTEM\PMDF";
      Line = LINEOUT(OutFileLog, " ");
      Line = LINEOUT(OutFileLog, ">> Create PMDF directory:");
      rc = SysMkDir(InstPath);
      Line = LINEOUT(OutFileLog,,
         "SysMkDir InstPath                 RC = " rc);
      Error = 0;
   End;                           /* End If InstPath = " "            */
   Else do;
      InstPath = STRIP(InstPath, "t", "\");
      If SUBSTR(InstPath, 2, 1) <> ":" then do;
         BEEP(262, 250);          /* Alert user with a beep           */
         SAY " ";
         SAY "ERROR:  format of install path must be x:[\path]";
         Error = 1;
      End;                        /* End Else do                      */
      Else
         If (LENGTH(InstPath)) > 2 then
            If SUBSTR(InstPath, 3, 1) <> "\" then do;
               BEEP(262, 250);    /* Alert user with a beep           */
               SAY " ";
               SAY "ERROR:  format of install path must be x:\path";
               Error = 1;
            End;                  /* End If LENGTH(InstPath) > 2      */
            Else do;
               Line = LINEOUT(OutFileLog, " ");
               Line = LINEOUT(OutFileLog,,
                  ">> Try to create Install directory:");
               rc = SysMkDir(InstPath);
               Line = LINEOUT(OutFileLog,,
                  "SysMkDir InstPath                 RC = " rc);
               If (POS("\", InstPath, 4)) > 0 then do;
                  Call SysFileTree InstPath, 'PathCheck.', 'SD';
                  If PathCheck.0 = 0 then do;
                     BEEP(262, 250); /* Alert user with a beep        */
                     SAY " ";
                     SAY "ERROR:  cannot find specified Install",
                         "directory.";
                     SAY "        Please create the directory, then",
                        "try again";
                     Error = 1;
                  End;
                  Else Error = 0;
               End;               /* End If POS > 0                   */
               Else Error = 0;
            End;                  /* End Else do                      */
         Else Error = 0;
   End;                           /* End Else do                      */
   If Error = 0 then do;
      If Debug = "DESKTOP" then do;
         FileSearch = InstPath || "\PMDF.EXE";
         FileFound  = STREAM(FileSearch, "c", "query exists");
         Line = LINEOUT(OutFileLog, "InstPath\PMDF.EXE FileFound = " ||,
            FileFound);

         If FileFound = " " then do; /* User did not give correct path*/
            BEEP(262, 250);       /* Alert user with a beep           */
            SAY " ";
            SAY "PMDF.EXE not found in specified",
               "drive\path.  Please try again.";
         End;                     /* End If FileFound = " "           */
         Else LEAVE;              /* Everything ok - get out          */
      End;                        /* End If Debug = DESKTOP           */
      Else LEAVE;                 /* Will create path                 */
   End;                           /* End If Error = 0                 */
End;                              /* End Do forever                   */

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Path/Drive values:");
Line = LINEOUT(OutFileLog, "InstPath            = " InstPath);


/**********************************************************************/
/* Begin installation                                                 */
/**********************************************************************/

If debug <> "DESKTOP" then do;

SAY " ";
SAY "**********";
SAY " ";
SAY "Installing PMDF package...";
SAY " ";


/**********************************************************************/
/* Rename old PMDFVers file if user re-installs w/o de-installing     */
/**********************************************************************/

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Check for existing PMDFVers.LST file:");

/*-------------------------*/
/* Remove old PMDFVers.Lst */
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Copy InstPath\PMDFVers.Lst InstPath\PMDFVers.Old");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Copy" InstPath||"\PMDFVers.Lst",
   InstPath||"\PMDFVers.Old",
   "1>>" OutFileLog "2>>&1";

rc = SysFileDelete(InstPath || "\PMDFVers.Lst");
Line = LINEOUT(OutFileLog,,
   "SysFileDelete \PMDFVers.Lst         RC = " rc);


/**********************************************************************/
/* Install PMDF files                                                 */
/**********************************************************************/

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Install PMDF files:");

/*-------------------------*/
/* Copy PMDF files         */
/*-------------------------*/
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog,,
   "Copy SrcPath1* InstPath\*");
Line = LINEOUT(OutFileLog);       /* Close the file                   */

ADDRESS CMD,
   "Copy" SrcPath1"* " InstPath,
   "1>>" OutFileLog "2>>&1";

If Medium = 1 then do forever;
   BEEP(262, 250);                /* Alert user with a beep           */
   SAY " ";
   SAY "**********";
   SAY " ";
   SAY "Please insert diskette #2, then press Enter...";
   SAY "or type 'E' to exit (abort installation).";
   Pull ok;
   If (ok = "E" | ok = "EXIT") then do;
      Line = LINEOUT(OutFileLog, "User typed EXIT.");
      CALL Cleanup InstPath;
      Line = LINEOUT(OutFileLog, " ");
      Line = LINEOUT(OutFileLog, "----- END OF PMDFInst -----");
      Line = LINEOUT(OutFileLog); /* Close the file                   */
      EXIT;
   End;                           /* End If FileFound = EXIT          */
   FileFound  = STREAM(FileSearch, "c", "query exists");
   If FileFound <> "" then LEAVE;
End;                              /* End Do forever                   */

SAY " ";
SAY "Installing...";

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog,,
   "Copy SrcPath2 InstPath\*");
Line = LINEOUT(OutFileLog);       /* Close the file                   */

ADDRESS CMD,
   "Copy" SrcPath2 InstPath,
   "1>>" OutFileLog "2>>&1";

End;                              /* End if debug <> DESKTOP          */

/**********************************************************************/
/* Create Problem Determination folder on the desktop                 */
/**********************************************************************/

SAY " ";
SAY "**********";
SAY " ";
SAY "Installing desktop objects...";

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Create DESKTOP folders & objects:");

rc = SysCreateObject("WPFolder","Problem^Determination","<WP_DESKTOP>",,
   "ICONVIEW    = NONGRID,NORMAL;"                                   ||,
   "TREEVIEW    = LINES,NORMAL;"                                     ||,
   "DETAILSVIEW = MINI;"                                             ||,
   "ICONFONT    = 8.Helv;"                                           ||,
   "TREEFONT    = 14.System;"                                        ||,
   "DETAILSFONT = 8.Helv;"                                           ||,
   "ICONFILE    = " || InstPath || "\Dump2.ICO;"                     ||,
   "HELPPANEL   = 1277;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "OBJECTID=<PDPWARP_FOLDER>",,
   "r");

If rc <> 1 then do;
   SAY "Folder: PROBLEM DETERMINATION could not be created/updated!";
   Line = LINEOUT(OutFileLog,,
          "Folder:  PROBLEM DETERMINATION could not be "             ||,
          "created/updated!  RC = " rc);
   CALL Cleanup InstPath;
   Line = LINEOUT(OutFileLog, " ");
   Line = LINEOUT(OutFileLog, "----- ABEND OF PMDFInst -----");
   Line = LINEOUT(OutFileLog); /* Close the file                      */
   EXIT;
End;                      /* If rc <> 1                               */

Line = LINEOUT(OutFileLog,,
       "Folder:  PROBLEM DETERMINATION created/updated ok.");


/**********************************************************************/
/* Create PM Dump Facility Executable                                 */
/**********************************************************************/

rc = SysCreateObject("WPProgram","PM Dump Facility","<PDPWARP_FOLDER>",,
   "EXENAME     = " || InstPath || "\PMDF.EXE;"                      ||,
   "STARTUPDIR  = " || InstPath || ";"                               ||,
   "PROGTYPE    = PM;"                                               ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "ASSOCFILTER = DUMPDATA.*,PDUMP.*,*.DMP,,;"                       ||,
   "OBJECTID    = <PDPWARP_PMDF>",,
   'r');

If rc <> 1 then do;
   SAY "Program: PMDF could not be created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: PMDF",
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: PMDF",
            "created/updated ok.");


/**********************************************************************/
/*  EXIT                                                              */
/**********************************************************************/

CALL Cleanup InstPath;

SAY " ";
SAY "**********";
SAY " ";
SAY "Done...";
SAY " ";
SAY " ";
SAY " ";
SAY " ";
SAY " ";
SAY " ";

CALL SysSleep 2;

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, "----- END OF PMDFInst -----");

EXIT;

/**********************************************************************/
/*  Clean-up Procedure                                                */
/**********************************************************************/

Cleanup:

   Arg InstPath;
   Line = LINEOUT(OutFileLog, " ");
   Line = LINEOUT(OutFileLog, ">> Start of Clean-up procedure:");

   rc = SysFileDelete(InstPath || "\PMDFInst.CMD");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete PMDFInst.CMD          RC = " rc);


   Line = LINEOUT(OutFileLog, "Clean-up procedure has Executed.");

Return;

