/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Set/Display default Windows task */
/* 9/5/97 fixed possible acidental exponential comparison */
signal on halt name haltexit
arg tdb .

if wininit() then exit 8

trace 'o'
if tdb='' then do
   deftdb=value('DF_WDEFTDB',,'OS2ENVIRONMENT')
   if deftdb='' then do
      curtdb=value('DF_WCURTDB',,'OS2ENVIRONMENT')
      deftdb=curtdb
      x=value('DF_WDEFTDB',curtdb,'OS2ENVIRONMENT')
   end  /* Do */
   say 'Current Windows task:' deftdb
   exit 0
end  /* Do */
else if tdb='*' then do
   curtdb=value('DF_WCURTDB',,'OS2ENVIRONMENT')
   x=value('DF_WDEFTDB',curtdb,'OS2ENVIRONMENT')
   say 'Current Windows task:' curtdb
   exit 0
end  /* Do */
else do
   nexttdb=value('DF_WHEADTDB',,'OS2ENVIRONMENT')
   if nexttdb='' then signal error
   tdb=x2d(tdb)
   nexttdb=x2d(nexttdb)
   do while nexttdb<> 0
      if tdb=nexttdb then do
         x=value('DF_WDEFTDB',d2x(tdb),'OS2ENVIRONMENT')
         exit 0
      end  /* Do */
      nexttdb=getwords('#'nexttdb't:0',1)
      if nexttdb='' then signal error
      else nexttdb=x2d(nexttdb)
   end /* do */
end  /* Do */
say 'Invalid task number'
exit 8

say value('DF_W'sym,,'OS2ENVIRONMENT')
haltexit: exit 0

error: say 'Unable to process command'
exit 8


wininit: procedure expose nothing

address df 'cmd output .p#'
o=output.0-1
if pos('*vdm',output.o)=0 then do
   say 'Current thread slot is not a VDM'
   return 0=1
end  /* Do */

vdm_slot=substr(output.o,2,4)
init_slot=value('DF_WWINVDM',,'OS2ENVIRONMENT')
if 'x'init_slot='x'vdm_slot then do
   /* just need to reset to vars that change in case we are under the kdb */
   dsel=value('DF_WKDSEL',,'OS2ENVIRONMENT')
   address df 'cmd output dw #'dsel':220  l8' /* make sure we use protmode addressing */
   o=output.0-1
   parse var output.o . tp hp . ht ct .
   otp=value('DF_WTOPPDB',tp,'OS2ENVIRONMENT')
   ohp=value('DF_WHEADPDB',hp,'OS2ENVIRONMENT')
   oht=value('DF_WHEADTDB',ht,'OS2ENVIRONMENT')
   oct=value('DF_WCURTDB',ct,'OS2ENVIRONMENT')   /* bug fix - was DF_WHCURTDB */
   if '#'otp<>'#'tp | '#'ohp<>'#'hp | '#'oht<>'#'ht | '#'oct<>'#'ct then,
      t=value('DF_WDEFTDB',ct,'OS2ENVIRONMENT')
   return 0=0
end /* do */
else do
   say 'Searching for WINDOWS kernel data segment'
   found=0=1
   do i = 1 to 8192
      sel=d2x((i*8)+7)
      if i//64 = 0 then do
         say 'Kernel data segment not found before' sel'. Continuing search'
      end /* do */
      address df 'cmd output dl' sel 'l1'
      o=output.0-1
      if word(output.o,2)='Code' then do
         x=getwords('#'sel':0',1)
         if x='f4cc' then do
            dsel=right(d2x(((i+3)*8)+7),4,'0')
            if translate(getwords('#'sel':30',1))=dsel then do
               say 'Windows Kernel Data Segment selector:' dsel
               x=value('DF_WKDSEL',dsel,'OS2ENVIRONMENT')
               x=value('DF_WWINVDM',vdm_slot,'OS2ENVIRONMENT')
               found=0=0
               leave
            end  /* Do */
         end  /* Do */
      end  /* Do */
   end /* do */

   if found then return 0=1

   say 'Initialising global variables'
   dseg='#'dsel':218' /* set starting address */
   doff=0             /* set current offset from this address */

   x=winsetvar('hGlobalHeap','w')
   x=winsetvar('pGlobalHeap','w')
   x=winsetvar('hExeHead','w')
   x=winsetvar('hExeSweep','w')
   x=winsetvar('TopPDB','w')
   x=winsetvar('headPDB','w')
   x=winsetvar('topsizePDB','w')
   x=winsetvar('headTDB','w')
   x=winsetvar('curTDB','w')
   x=winsetvar('loadTDB','w')
   x=winsetvar('lockTDB','w')
   x=winsetvar('SelTableLen','w')
   x=winsetvar('SelTableStart','d')
   x=winsetvar('hBmDPMI','d')
   x=winsetvar('winVer','w')
   x=winsetvar('fwinx','w')
   x=winsetvar('f8087','w')
   x=winsetvar('PHTcount','w')
   x=winsetvar('hGDI','w')
   x=winsetvar('hUser','w')
   x=winsetvar('hShell','w')
   x=winsetvar('flMDepth','w')
   x=winsetvar('wdefrip','w')
   x=winsetvar('num_tasks','b')
   x=winsetvar('InScheduler','b')
   x=winsetvar('graphics','b')
   /* spare byte */
   doff=doff+1
   x=winsetvar('fastfp','b')
   x=winsetvar('MaxCodeSwapArea','w')
   x=winsetvar('SelLowHeap','w')
   x=winsetvar('cpLowHeap','w')
   x=winsetvar('SelHighHeap','w')
   x=winsetvar('SelWoaPDB','w')
   x=winsetvar('sel_alias_array','w')
   x=winsetvar('temp_sel','w')
   x=winsetvar('dressed_for_success','D')
   x=winsetvar('InDos','d')
   x=winsetvar('pSftLink','d')
   x=winsetvar('lpWinSftLink','d')
   x=winsetvar('pFileTable','d')
   x=winsetvar('FileEntrySize','w')
   x=winsetvar('curDTA','d')
   x=winsetvar('cur_dos_PDB','w')
   x=winsetvar('Win_PDB','w')
   x=winsetvar('cur_drive_owner','w')
   x=winsetvar('fBreak','b')
   x=winsetvar('LastDriveSwapped','b')
   x=winsetvar('DOS_version','b')
   x=winsetvar('DOS_revision','b')
   x=winsetvar('fInt21','b')
   x=winsetvar('fNovell','b')
   x=winsetvar('fPadCode','b')
   x=winsetvar('CurDOSDrive','b')
   x=winsetvar('DOSDrives','b')

   t=value('DF_WCURTDB',,'OS2ENVIRONMENT')
   t=value('DF_WDEFTDB',t,'OS2ENVIRONMENT')

end /* do */

return 0=0

winsetvar: procedure expose dseg doff dsel
arg vname,type
type=translate(type)
if type='B' then do
   x=getbytes(dseg'+'doff't',1)
   doff=doff+1
end  /* Do */
else if type ='W' then do
   x=getwords(dseg'+'doff't',1)
   doff=doff+2
end  /* Do */
else if type ='D' then do
   x=getdwords(dseg'+'doff't',1)
   doff=doff+4
end  /* Do */
y=value('DF_W'vname,x,'OS2ENVIRONMENT')

return 0

getbytes: procedure
arg address,length
address df "cmd output DB" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DB "address"+"i"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

getdwords: procedure
arg address,length
address df "cmd output DD" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DD "address"+"i*4"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor



