
/*rexx   Wpshl.cmd                                        */
/*       Mike Paolini   (paolini@vnet.ibm.com)            */
/* Version 1.0b    Apirl 24, 1997                          */
/*  -1.0a looked before I leaped into slot 8 hoping for valid address symbol...   */
/*  -1.0a discovered Kernel debugger & df give different output -- may insert a blank line for no reason. */
/*   processing from the bottom up now.                       */
/*  -1.0a added "?" support                 */
/*  -1.0a Stopped circular processing of SMS when apps send sync messages to itself. Added message, & beep.  */
/*  -1.0b added logic for determining PM version.   */
/*  -1.0b add multiple slot tries to shift slot  */
/*  -1.0c enviroment parse for shell stuff            */
/*   -1.0c added force PMVersion                                   */
/* (C) Copyright IBM Corp. 1997                           */
/*                                                        */
/*Find the who holds what in the WPSHL, works on Warp 4.0 */
/**********************************************************/

signal on halt name haltexit
arg help
force=false
say 'WPSHL.cmd Version 1.0c '
if help="?"  then do
   say 'This command walks the the main PMQs to find who has "focus." '
   say 'It will follow SMS changes, and tries to detect queues marked badapp. '
   say 'No inputs are needed.  It should work with Warp 3.0  >FP17 and Warp 4.0'
   exit
end  /* Do */
if help="/?" then do
   say 'This command walks the the main PMQs to find who has "focus." '
   say 'It will follow SMS changes, and tries to detect queues marked badapp. '
   say 'No inputs are needed.  It should work with Warp 3.0  >FP17 and Warp 4.0'
   exit
end  /* Do */
if help='!' then force='true'

PMslot=validatesym()

if PMslot=1 then
   do
      pmvers=0
      pmvers=pmver()
      /* say 'PMVER'pmvers */
      if pmver='00000084' then
          do
           say 'This version of PM, 'pmvers', is not yet supported with WPSHL.cmd.'
          end
      else if pmvers='00000080' then
         do
            say 'PM version is: 'pmvers
            call basicfocus
            call parseenv  /* parse enviro for shell stuff */
         end
      else if force='true' then
         do
            say 'Processing continuing off of force switch.'
            call basicfocus
     /*    call parseenv   parse enviro for shell stuff */
         end
      else
         do
           if pmvers='' then
             do
               pmvers='PMMERGE symbol not found.'
             end
           say 'PM version not supported.  PM version is: 'pmvers
           say 'Attemping to process anyway (as version detection is not always correct).'
           call basicfocus
/*         call parseenv   parse enviro for shell stuff */

         end

    end
haltexit: exit 0



 /******************/

pmver: procedure
say ''
address df "cmd output2 s %(dw(pmqshell)) l100 'S' 'T' "
o=output2.0-1
magic=word(output2.o,1)
/* Past end of segment: 9f47:0000a4f0 typically returned when we are not in the correct slot */
/* 'PAST' would be the word placed in magic */
address df 'cmd output2 ?' magic '- %(dw(pmqshell))'
o=output2.0-1
magic_offset=substr(output2.o,2)
if translate(strip(magic))='PAST' then  magic_offset='Symbol not found.'
return magic_offset



/***************/

validatesym: procedure
PMslot=0

/* first pase through we check to see if we are in a PM slot */
address df 'cmd output2 .p #'
o=output2.0-1
parse var output2.o slotid Pid Ppid Csid Ord Sta Pri pTSD pPTDA pTcb Disp SG Name .
/* Note  Disp may be blank causing the name to be placed in SG
instead.  */
/* say translate(strip(Name)) */
/* say translate(strip(SG))   */
select
   when translate(strip(Name))='PMSHL32' then
      do
       PMslot=1
      end

   when translate(strip(Name))='PMSHELL' then
      do
       PMslot=1
      end

   when translate(strip(SG))='PMSHL32'  then
      do
       PMslot=1
      end

   when translate(strip(SG))='PMSHELL' then
      do
       PMslot=1
      end
   otherwise

end

/* lets try a quick find for a  PM slot. */
if  PMSlot=0 then
   do  s=7 to 10
     address df 'cmd output2 .p 's
     o=output2.0-1
     parse var output2.o slotid Pid Ppid Csid Ord Sta Pri pTSD pPTDA pTcb Disp SG Name .
/* Note  Disp may be blank causing the name to be placed in SG
instead.  */
/* say translate(strip(Name)) */
/* say translate(strip(SG))   */
select
   when translate(strip(Name))='PMSHL32' then
      do
       address df 'cmd output2 .s 's
       say 'Slot has been changed to 's' for symbol support.'
       PMslot=1
       leave
      end

   when translate(strip(Name))='PMSHELL' then
      do
       address df 'cmd output2 .s 's
       say 'Slot has been changed to 's' for symbol support.'
       PMslot=1
       leave
      end

   when translate(strip(SG))='PMSHL32'  then
      do
       address df 'cmd output2 .s 's
       say 'Slot has been changed to 's' for symbol support.'
       PMslot=1
       leave
      end

   when translate(strip(SG))='PMSHELL' then
      do
       address df 'cmd output2 .s 's
       say 'Slot has been changed to 's' for symbol support.'
       PMslot=1
       leave
      end
   otherwise

  end /*end select */
end /*do loop*/
if PMSlot=0 then say 'Either we are not in a PMslot, or PMMERGE is not linked....'
return PMslot




 /******************/

basicfocus: procedure

/*      output
##dd pmqsyslock L1
bfbf:0000f310  pointer
##
        end output */

say ' '
address df 'cmd output2 dd' pmqsyslock 'L1'
o=output2.0-1
parse var output2.o addr ddpslock .
ddpslock=strip(ddpslock)
say 'pmqsyslock      %0'ddpslock
address df 'cmd output2 dd' pmqfocus 'L1'
o=output2.0-1
parse var output2.o addr ddpfocus  .
ddpfocus=strip(ddpfocus)
say 'pmqfocus        %0'ddpfocus
address df 'cmd output2 dd' pmqmousewake 'L1'
o=output2.0-1
parse var output2.o addr ddpMwake  .
ddpMwake=strip(ddpMwake)
say 'pmqmousewake    %0'ddpMwake
address df 'cmd output2 dd' pmqkeywake 'L1'
o=output2.0-1
parse var output2.o addr ddpKBwake  .
ddpKBwake=strip(ddpKBwake)
say 'pmqkeywake      %0'ddpKBwake
address df 'cmd output2 dd' pmqhardsysmodal 'L1'
o=output2.0-1
parse var output2.o addr ddpHardSM  .
ddpHardSM=strip(ddpHardSM)
say 'pmqhardsysmodal %0'ddpHardSM

say ' '
say '-------------------------------'
say ' '
/* Mouse click processing */
if ddpslock\=ddpfocus then say '***The system is likely handling a mouse click'


/*syslock */
if length(ddpslock)=8 & ddpslock \= 0 then
  do
  say 'pmqSyslock is held by '
  call PMQformat ddpslock, 0, 0
  say '----------------'
  end

else do
  say 'pmqSyslock is not held'
  say '----------------'
  end

/*focus */
if length(ddpfocus)=8 & ddpfocus \= 0 then
  do
  say 'pmqFocus is held by '
  call PMQformat ddpfocus, 0, 0
  say '----------------'
  end

else do
  say 'pmqFocus is not held'
  say '----------------'
  end

/*mouse*/
if length(ddpMwake)=8 & ddpMwake \= 0 then
  do
  say 'pmqMousewake is held by '
  call PMQformat ddpMwake, 0, 0
  say '----------------'
  end

else do
  say 'pmqMousewake is not held'
  say '----------------'
  end

/*keyboard*/
if length(ddpKBwake)=8 & ddpKBwake \= 0 then
  do
  say 'pmqKeywake is held by '
  call PMQformat ddpKBwake, 0, 0
  say '----------------'
  end

else do
  say 'pmqKeywake is not held'
  say '----------------'
  end

/*harderror*/
if length(ddpKBwake)=8 & ddpHardSM \= 0 then
  do
  say 'pmqHardSysModal is held by '
  call PMQformat ddpHardSM, 0, 0
  say '----------------'
  end

else do
  say 'pmqHardSysModal is not held'
  say '----------------'
  end

return 0

/*******end basicfocus ********/


/* output SMS struct
##dd %017ccff50
%17ccff50  00000000 17ccff50 00000000 00000000
%17ccff60  0570a6e4 00000000  FromPMQ    ToPMQ
%17ccff70  00000000 00000000     PWND      MSG
%17ccff80       MP1      MP2 17ccff50 17ccff50
%17ccff90  00000000 00000000 057094f2 00000000
%17ccffa0  17cc84ac 17ccca50 17cc4cd0 00000003
%17ccffb0  17cc5180 00000048 00000000 00000000
%17ccffc0  17ccff50 17ccffc0 00000000 00000000
##
        end output  */


/* output  PMQ struct
##dd %017cc84ac  L30
%17cc84ac  17cc87d8 00000020 00000000 00000bb8
%17cc84bc  80002fff 80018001      PID      ORD
%17cc84cc  00000000 00000000 00000011 80030057
%17cc84dc  056ea019 000001fd 00000181  Syncmsg
%17cc84ec  00000000 00000010 00000000 00000000
%17cc84fc   BadPWND BadQueue 00000000 00000000
%17cc850c  00000000 00000000 00000000 00000000
%17cc851c  00000000 8000003f 00000000 14090000
%17cc852c  00005453 0000011f 00000000 17cc842c
%17cc853c  0bff0402 00000000 00000000 00000001
%17cc854c      SLOT 2050534d 00000158 00000000
%17cc855c  00000002 5eb45345 13040019 00000004
##
        end output PMQ*/

/* PMQformat */

PMQformat:

RecrusionPMQ=ARG(2)
RecrusionSMS=ARG(3)
firsttimeSlot=0
PMQ=ARG(1)

  Do While PMQ \= 0
      RecrusionPMQ=RecrusionPMQ+1
      say 'Chain PMQ#: 'RecrusionPMQ
      say 'PMQ: %0'strip(PMQ)
      address df 'cmd output2 dd %0'||strip(PMQ) 'L30'
      o=output2.0-11
      parse var output2.o addr w1 w2 PID ORD .
      o=output2.0-2
      parse var output2.o addr SLOT .
      o=output2.0-9
      parse var output2.o addr w1 w2 w3 SMSsync .
      o=output2.0-7
      parse var output2.o addr BadPWND BadQueue .
      address df 'cmd output2 .p 'strip(SLOT)
      o=output2.0-1
      parse var output2.o slotid PidA Ppid Csid OrdA Sta Pri pTSD pPTDA pTcb Disp SG Name .
      say 'Which is to PID:' PID 'ORD:' ORD 'SLOT: ' SLOT 'Name: ' Name
      say ' '
      if BadPWND \=0 then say '***This is marked BadApp. BadPWND: 'BadPWND
      if BadQueue \=0 then say '***This is marked BadApp. BadWindow: ' BadQueue
      /* attempt to stop circular processing on apps that send Sync message to themselves */
      if firsttimeSlot=SLOT then
         do
            say '********************************************************'
            say '*** I think we have wrapped back to where we started...*'
            say '********************************************************'
            call beep 262,250
            SMSsync=0  /* Break loop */
         end
      if RecrusionPMQ = 1 then firsttimeSlot=SLOT
      PMQ=0  /* break loop */
      if SMSsync \= 0 then
        do
        RecrusionSMS=RecrusionSMS+1
        say 'Chain SMS#: 'RecrusionSMS
        say ' '
        say '***This process has sent SyncMsg and needs a response.'
        say 'SMS address is: %0'strip(SMSsync)
        address df 'cmd output2 dd %0'|| strip(SMSsync)
        o=output2.0-7
        parse var output2.o addr w1 w2 FromPMQ ToPMQ .
        o=output2.0-6
        parse var output2.o addr w1 w2 PWND MSG .
        o=output2.0-5
        parse var output2.o addr MP1 MP2 .
        say 'PWND: 'PWND ' MSG: ' MSG ' MP1: 'MP1' MP2: ' MP2
        PMQ=ToPMQ  /* continue loop */
      end
    end


RecrusionPMQ=RecrusionPMQ-1
return  0


/* End PMQformat */

phandletable: procedure
/*  One day this program will walk this to determine Bad App stuff */
return  0


/********************************




 parseenv
**********************************/



parseenv: procedure
/* numbered=ARG(1) */
say 'Finding relivant set statements...'
say ' '
letter=''
k=0

/* 0030:0000fa4e  00ac
#        */
address df 'cmd output2 dw ptda_environ l1'
o=output2.0-1
parse var output2.o addr hwndobj .

/*   say "HW"hwndobj */

address df 'cmd output2 .moc ' hwndobj

/**har     par      cpg        va    flg next prev link hash hob   hal
 009e %feed5d9e 00000010 %1fa30000 3d9 0620 0407 0000 054c 00ac 0000  hco=0000d
 hob   har hobnxt flgs own  hmte  sown,cnt lt st xf
 00ac  009e 0000  0838 00ad 00ad  0000 00  00 00 00 shared    c:epwinit.dll
 hco=000d pco=ffe5a05c  hconext=00000 hptda=0438 f=1d  pid=001b c:pmshell.exe
#       */

harhdr=''
lines=output2.0
/* say 'lines:'lines  */
i=0
do while translate(harhdr)\='*HAR'
  i=i+1
  if i > lines then
     do
        say 'Error: .MOC not vaild '
        return 0
     end
  parse var output2.i harhdr parhdr cpghdr VAhdr .
  o=i+1
  parse var output2.o har par cpg VA .
/*  say i translate(harhdr) */
/*  say output2.i  */
/*  say output2.o */
end

say 'Enviroment stored at: 'VA
say ' '
address df 'cmd output2 db 'VA' l2000'
  do i=1 to 2000
/* say output2.i */
/*      %00050000           55    53    45    52     5f    49    4e     49-3d  45     3a     5c     4f      53    32     5c     USER_INI=E:\OS2\ */
   parse var output2.i addr hex.1 hex.2 hex.3 hex.4  hex.5 hex.6 hex.7  hex.8  hex.10 hex.11 hex.12 hex.13 hex.14 hex.15 hex.16 ascii .
   if addr=x2c(20) then skip=true  /* atempt at removing extra line from dumps */
   else if addr='' then skip=true    /* atempt at removing extra line from dumps */
   else if translate(addr)='INVALID' then
      do
        say '---------------'
        say 'Error process environment data is not where it is supposed to be...'
        say output2.i
        return 1
      end
   else do
        hex.9=substr(hex.8,4,2)
        hex.8=substr(hex.8,1,2)
        do j=1 to 16
         if hex.j = '00' then
           do
             z=j+1
             if hex.z = '00' then
              do
               say '---------------'
               say 'Environmental proccesing complete, if nothing was displayed, then system defaults are likely in use.'
               say 'env.cmd can be used to get all environment data'
               return 0  /* we got the double null and must have hit the end */
              end
           k=k+1
           select
              when substr(letter,1,21)='SHAPIEXCEPTIONHANDLER' then say letter
              when substr(letter,1,21)='SHELLEXCEPTIONHANDLER' then say letter
              when substr(letter,1,21)='PM_ASYNC_FOCUS_CHANGE' then say letter
              when substr(letter,1,15)='SHELLHANDLESINC' then say letter
              when substr(letter,1,9)='AUTOSTART' then say letter
              when substr(letter,1,21)='RESTARTOBJECTS' then say letter
              when substr(letter,1,8)='USER_INI' then say letter
              when substr(letter,1,10)='SYSTEM_INI' then say letter
              when substr(letter,1,12)='RUNWORKPLACE' then say letter
              when substr(letter,1,8)= 'TRAPDUMP' then say letter
              when substr(letter,1,13)='SURPRESSPOPUP' then say letter
              when substr(letter,1,4)='TEMP' then say letter
              when substr(letter,1,3)='TMP' then say letter
            otherwise
            end
           letter=''
           end
         else
         /*      say hex.j */
         letter=letter||x2c(hex.j)
         end
     end
  end

return 0

