/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format a PM32 SMS structure */
/* 9/5/97 fixed possible acidental exponential comparison */
signal on halt name haltexit

arg sms .

if sms='' then do
   say 'SMS <psms>'
   exit 0
end /* do */

pmver=pmver()
if '#'pmver='#00000084' then call fmtsms(sms)
else if '#'pmver='#00000080' then call fmtsms1(sms)
else say 'PM version not supported'


haltexit: exit 0


pmver: procedure
magic_offset=value('DF_PMVER',,'OS2ENVIRONMENT')
say 'Warning: PMMERGE symbols assumed and current slot is a PM thread/app.'
say ''
if magic_offset='' then do
   address df "cmd output s %(dw(pmqshell)) l100 'S' 'T' "
   o=output.0-1
   magic=word(output.o,1)
   address df 'cmd output ?' magic '- %(dw(pmqshell))'
   o=output.0-1
   magic_offset=substr(output.o,2)
   x=value('DF_PMVER',magic_offset,'OS2ENVIRONMENT')
end
return magic_offset


fmtsms: procedure
arg psms

say ' '
address df 'cmd output dd' psms 'L0d'
o=output.0-4
parse var output.o addr d0 d1 d2 d3 .
say '+00 Next                        ' d0
say '+04 Send list head              ' d1
say '+08 Send next                   ' d2
say '+0c Receive next                ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+10 Time sent                   ' d0
say '+14 pMQ sender                  ' d1
say '+18 pMQ receiver                ' d2
say '+1c Result                      ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+20 Flags                       ' d0
say '+24 pWND                        ' d1
say '+28 Msg id                      ' d2
say '+2c Msg parm 1                  ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+30 Msg parm 2                  ' d0

return


fmtsms1: procedure
arg psms

say ' '
address df 'cmd output dd' psms 'L0e'
o=output.0-4
parse var output.o addr d0 d1 d2 d3 .
say '+00 Next                        ' d0
say '+04 Send list head              ' d1
say '+08 Send next                   ' d2
say '+0c Receive next                ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+10 Time sent                   ' d0
say '+14 Time of hang test           ' d1
say '+18 pMQ sender                  ' d2
say '+1c pMQ receiver                ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+20 Result                      ' d0
say '+24 Flags                       ' d1
say '+28 pWND                        ' d2
say '+2c Msg id                      ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+30 Msg parm 1                  ' d0
say '+34 Msg parm 2                  ' d1

return
