/* rexx */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* repeat a command string against a substitution list.              */
/*                                                                   */
/* Syntax: %RUNLIST file cmd_str                                    */
/*                                                                   */
/* where:                                                           */
/*                                                                   */
/*        <cmd_str>  specifies a string of one or more commands      */
/*                   separated by semicolons. This command string    */
/*                   is executed once for each line in the list file.*/
/*                   The @ character in the command string acts as a */
/*                   substituton character and replaced with the     */
/*                   contents of the current line of the list file.  */
/*                   The @ character may appear multiple times       */
/*                   within the command string.                      */
/*                                                                   */
/*        <file>     Specifies a list of lines to be substituted into*/
/*                   the command string where ever the @ chararter   */
/*                   appears in the command string.                  */
/*                                                                   */
/* Change Log:                                                       */
/* 29/01/98 Version 0 created.                                       */

signal on halt name haltexit
trace 'o'
arg list cmd
if list='?' | cmd='' then do
   call helpmsg
   exit 0
end /* do */
num=0
do while lines(list)>0
   num=num+1
   sub=linein(list)
   cmdline=cmd
   i=pos('@',cmdline)
   do while i <> 0
      cmdline=left(cmdline,i-1) || sub || substr(cmdline,i+1)
      i=pos('@',cmdline,i+length(sub))
   end /* do */
   say ''
   say num':' cmdline
   p=pos(';',cmdline)
   if p>0 then do
      nextcmd=left(cmdline,p-1)
      cmdline=substr(cmdline,p+1)
   end  /* Do */
   else nextcmd=cmdline
   nextcmd=strip(nextcmd,'b',' ')
   do while nextcmd<>''
      if left(nextcmd,1)='%' then interpret 'call' substr(nextcmd,2)
      else do
        address df 'cmd output' nextcmd
        do i = 1 to output.0
           say output.i
        end /* do */
      end  /* Do */
      if p>0 then do
         p=pos(';',cmdline)
         if p>0 then do
            nextcmd=left(cmdline,p-1)
            cmdline=substr(cmdline,p+1)
         end  /* Do */
         else nextcmd=cmdline
      end
      else nextcmd=''
      nextcmd=strip(nextcmd,'b',' ')
   end /* do */
end /* do */
x=lineout(list)
haltexit: say '#'
exit 0

helpmsg: procedure
   say " repeat a command string against a substitution list.              "
   say "                                                                   "
   say " Syntax: %RUNLIST file cmd_str                                    "
   say "                                                                   "
   say " where:                                                           "
   say "                                                                   "
   say "        <cmd_str>  specifies a string of one or more commands      "
   say "                   separated by semicolons. This command string    "
   say "                   is executed once for each line in the list file."
   say "                   The @ character in the command string acts as a "
   say "                   substituton character and replaced with the     "
   say "                   contents of the current line of the list file.  "
   say "                   The @ character may appear multiple times       "
   say "                   within the command string.                      "
   say "                                                                   "
   say "        <file>     Specifies a list of lines to be substituted into"
   say "                   the command string where ever the @ chararter   "
   say "                   appears in the command string.                  "
   say "                                                                   "
   say "                                                                   "
   say " Example: %RUNLIST sel.lst dg @;db #@:0 L20;%RMP @                 "
   say "          where sel.lst contains                                   "
   say " 23e0                                                              "
   say " 2f88                                                              "
   say " 2f90                                                              "
   say "                                                                   "
   say " The following 9 commands will be executed:                        "
   say " dg 23e0; db #23e0:0 L20; %RMP 23e0                                "
   say " dg 2f88; db #2f88:0 L20; %RMP 2f88                                "
   say " dg 2f90; db #2f90:0 L20; %RMP 2f90                                "
   say "                                                                   "
   say "                                                                   "

return
