/* IBM Confidential                                                  */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/*rexx                                                               */
/* format various tables chained from and OS/2 MTE                   */
/*                                                                   */
/* Syntax: MTE <addr|handle|name> <options>                          */
/*                                                                   */
/* where:      <addr>     is a valid DF address expression for the   */
/*                        beginning of the MTE                       */
/*                                                                   */
/*             <handle>   is the load module handle (hmte)           */
/*                                                                   */
/*             <name>     is the module name as a quoted string      */
/*                                                                   */
/*             <options>  specify various tables to be formatted:    */
/*                        /e specifies the Entry Point Table         */
/*                        /r specifies the Resource Table            */
/*                        /n specifies the Names Tables              */
/*                        /i specifies the Import Module Names Table */
/*                        Options may be combined, each with a       */
/*                        leading /                                  */
/* Change Log:                                                       */
/* 25/09/96 Version 1 created.                                       */
/* 9/5/97 fixed possible acidental exponential comparison */

signal on halt name haltexit
numeric digits 20
arg parms

args=''
opts=''
do while parms<>''
   parse var parms parm parms
   if left(parm,1)='/' then opts=opts||substr(parm,2)
   else args=args parm
end /* do */
if words(args)>1 then do
   say 'Invalid parameters'
   call helpmsg
   exit 0
end /* do */
mod=strip(args,'b',' ')

if mod='' | mod='?' then do
   call helpmsg
   exit 0
end /* do */

psmte=''
address df 'cmd output .lm' mod
o=output.0-1
parse var output.o 'hmte=' hmte . 'pmte=' pmte . 'mflags='mflags .
if hmte='' then do
   say 'MTE not linked'
   if left(mod,1)='%' then do
      pmte=mod
      address df 'cmd output da' pmte'+18'
      o=output.0-1
      name=word(output.o,2)
      if datatype(name,'a') then exit 0
      address df 'cmd output dd' pmte 'L4'
      o=output.0-1
      parse var output.o pmte hmteflg psmte . mflags .
      hmte=left(hmteflg,4)
      say 'hmte='hmte 'pmte='pmte 'mflags='mflags name
   end /* do */
   else exit 0
end /* do */
else say output.o


names=0=1
resources=0=1
impmods=0=1
entries=0=1

if pos('N',opts)>0 then names=0=0
if pos('R',opts)>0 then resources=0=0
if pos('E',opts)>0 then entries=0=0
if pos('I',opts)>0 then impmods=0=0
if pos('T',opts)>0 then trace(i)

if psmte='' then psmte=getdwords(pmte'+4',1)
if datatype(psmte,'x') then do
   say 'Unable to locate the SMTE for' mod
   exit 0
end /* do */

if names then do
   call fmtnames
   call fmtnames 'n'
end /* do */
if resources then call fmtres
if entries then call fmtents
if impmods then call fmtimps

haltexit: exit 0

fmtnames: procedure expose psmte mod
arg n
if n='N' then do
   tabname='Non-Resident'
   taboff='50'
end /* do */
else do
   tabname='Resident'
   taboff='34'
end /* do */

presnt=getdwords(psmte'+'taboff,1)
if datatype(presnt,'x') then do
   say 'Unable to access the' tabname 'Names Table'
   return
end /* do */

if '#'presnt='#00000000' then do
   say tabname 'Names Table not used'
   return
end /* do */
presnt='%'presnt
address df 'cmd output ?'presnt
o=output.0-1
if words(output.o)=1 then do
   say 'Unable to access the' tabname 'Names Table'
   return
end /* do */
else do
   len=getbytes(presnt,1)
   off=0
   Say tabname 'Names Table at 'presnt
   Say '  Ord# Name'
   do while len<>'00'
      address df 'cmd output da' presnt'+'off't+1 l0'len'+1'
      o=output.0-1
      name=word(output.o,2)
      ord=getwords(presnt'+'off't+1+'len,1)
      say '  'ord name
      off=off+x2d(len)+3
      len=getbytes(presnt'+'off't',1)
   end /* do */
end /* do */

return

fmtres: procedure expose psmte mod

pres=getdwords(psmte'+2c',1)
cres=x2d(getdwords(psmte'+30',1))
if datatype(pres,'x') then do
   say 'Unable to access the Resource Table'
   return
end /* do */

if '#'pres='#00000000' then do
   say 'Resource Table not used'
   return
end /* do */
pres='%'pres
address df 'cmd output ?' pres
o=output.0-1
if words(output.o)=1 then do
   say 'Unable to access the Resource Table'
   return
end /* do */
else do
   Say 'Resource Table at 'pres 'with' cres 'entries.'
   Say '  Res# Type  Id    Size    obj:off'
   do i=0 to cres-1
      roff=i*14
      /*res=getwords(pres'+'roff't',7)*/
      address df 'cmd output dw' pres'+'roff't L7'
      o=output.0-1
      parse var output.o . type id size1 size2 obj off1 off2 .
      size=size2||size1
      off=off2||off1
      select
         when type='0001' then name='Pointer'
         when type='0002' then name='BitMap'
         when type='0003' then name='Menu Template'
         when type='0004' then name='Dialog'
         when type='0005' then name='String Table'
         when type='0006' then name='Font Directory'
         when type='0007' then name='Font'
         when type='0008' then name='Accelerator Table'
         when type='0009' then name='Binary Data'
         when type='000a' then name='Message Table'
         when type='000b' then name='Dialog Include File Name'
         when type='000c' then name='Key to VKey Tables'
         when type='000d' then name='Key to UGL Tables'
         when type='000e' then name='Glyph to Char Tables'
         when type='000f' then name='Screen Display Info'
         when type='0010' then name='Function Key Area (short)'
         when type='0011' then name='Function Key Area (long)'
         when type='0012' then name='Help Table'
         when type='0013' then name='Help Subtable'
         when type='0014' then name='DBCS Font Driver Directory'
         when type='0015' then name='DBCS Font Driver'
      otherwise
      name='UNKNOWN'
      end  /* select */
      say '  'right(i+1,4,'0') type id size obj':'off name
   end /* do */
end /* do */
return

fmtimps: procedure expose psmte mod immods.
arg q
if q='Q' then quite=0=0
else quite=0=1
immods.=''
pimp=getdwords(psmte'+44',1)
if datatype(pimp,'x') then do
   say 'Unable to access the Import Module Names Table'
   return
end /* do */

if '#'pimp='#00000000' then do
   say 'Import Module Names Table not used'
   return
end /* do */
pimp='%'pimp
address df 'cmd output ?' pimp
o=output.0-1
if words(output.o)=1 then do
   say 'Unable to access the Import Module Names Table'
   return
end /* do */
else do
   if quite then Say 'Import Module Names Table at' pimp':'
   i=0
   len=getbytes(pimp,1)
   off=1
   do while len<>'00'
      i=i+1
      address df 'cmd output da' pimp'+'off't L0'len'+1'
      o=output.0-1
      name =word(output.o,2)
      mod=right(d2x(i),4,'0')
      immods.mod=name
      if quite then say '  'name
      off=off+x2d(len)
      len=getbytes(pimp'+'off't',1)
      off=off+1
   end /* do */
end /* do */
return

fmtents: procedure expose psmte mod mflags immods. impmods

pent=getdwords(psmte'+38',1)
if datatype(pent,'x') then do
   say 'Unable to access the Entry Table'
   return
end /* do */

if '#'pent='#00000000' then do
   say 'Entry Table not used'
   return
end /* do */

pent='%'pent
address df 'cmd output ?'pent
o=output.0-1
if words(output.o)=1 then do
   say 'Unable to access the Entry Table'
   return
end /* do */
else do
   Say 'Entry Table at 'pent
   ord=1
   mf=x2c(mflags)
   /*mvdm ?*/
   if bitand(mf,'00020000'x)='00020000'x then do
      address df 'cmd output dw 'pent 'L1'
      o=output.0-1
      parse var output.o '%'addr b1 .
      if datatype(addr,'x') then do
         say output.o
         return
      end /* do */
      off=2
      elen=4
      cnt=d2x(x2d(b1)%elen)
      say '0x'cnt 'MVDM (Kernel) 32-bit entries'
      call kinitord
      do x2d(cnt)
         ent32=getdwords(pent'+'off't',1)
         say '  'right(d2x(ord),4,'0')': %'ent32 kordinals.MVDM.ord
         ord=ord+1
         off=off+elen
      end /* do */
   end /* do */
   /* doscalls */
   else if bitand(mf,'00000800'x)='00000800'x then do
      address df 'cmd output dw 'pent 'L1'
      o=output.0-1
      parse var output.o '%'addr b1 .
      if datatype(addr,'x') then do
         say output.o
         return
      end /* do */
      off=2
      elen=3
      cnt=d2x(x2d(b1)%elen)
      say '0x'cnt 'DOSCALLS (Kernel) Entries'
      call kinitord
      do x2d(cnt)
         address df 'cmd output db' pent'+'off't l3'
         o=output.0-1
         parse var output.o '%'addr b1 b2 b3 .
         if datatype(addr,'x') then do
            say output.o
            return
         end /* do */
         flags=b1
         if flags='00' then flags=flags', DOSCALL1 entry'
         else if flags='01' then flags=flags', Absolute Symbol'
         else if flags='02' then flags=flags', Call Gate'
         else if flags='03' then flags=flags', Aux Gate Ordinal'
         else if flags='04' then flags=flags', Aux Absolute Ordinal'
         ent16=b3||b2
         say '  'right(d2x(ord),4,'0')': gate sel='ent16 'flags='flags kordinals.DOSCALLS.ord
         ord=ord+1
         off=off+elen
      end /* do */

   end /* do */
   /* fshmod */
   else if bitand(mf,'00400000'x)='00400000'x then do
      /* this is a hack to find the length of the FSH entry table*/
      /* MVDM MTE follows it! */
      address df "cmd output .lm 'MVDM"
      o=output.0-1
      parse var output.o . 'pmte=%'pvdm .
      cnt=(x2d(pvdm)-x2d(substr(pent,2)))/4
      off=0
      elen=4
      say '0x'd2x(cnt) 'FSHELPER (Kernel) 16-bit entries'
      call kinitord
      do cnt
         ent32=getdwords(pent'+'off't',1)
         fseg=left(ent32,4)
         foff=right(ent32,4)
         say '  'right(d2x(ord),4,'0')':' fseg':'foff kordinals.FSHELPER.ord
         ord=ord+1
         off=off+elen
      end /* do */
   end /* do */

   else do

      if bitand(x2c(mflags),'00000400'x)='00000400'x then call kinitord
      else kordinals.=''
      address df 'cmd output db 'pent 'L4'
      o=output.0-1
      parse var output.o '%'addr b1 b2 b3 b4 .
      if datatype(addr,'x') then do
         say output.o
         return
      end /* do */
      cnt=b1
      type=b2
      object=b4||b3
      off=4
      do while cnt<>'00'
         ents=x2d(cnt)
         type=c2x(bitand(x2c(type),'7f'x))
         select
            when type='00' then do
               name='Unused'
               elen=0
               off=off-2
            end /* do */
            when type='01' then do
               name='16-bit'
               elen=3
            end /* do */
            when type='02' then do
               name='16-bit Call Gate'
               elen=5
            end /* do */
            when type='03' then do
               name='32-bit'
               elen=5
            end /* do */
            when type='04' then do
               name='Forwarder'
               elen=7
            end /* do */

         otherwise
         name='UNKNOWN'
         elen=0
         return
         end  /* select */
         say '0x'cnt name 'entries:'
         if elen>0 then do ents
            address df 'cmd output db' pent'+'off't l0'elen
            o=output.0-1
            parse var output.o '%'addr b1 b2 b3 b4 b5 b6 b7 .
            if datatype(addr,'x') then do
               say output.o
               return
            end /* do */
            select
               when type='01' then do
                  flag=b1
                  if (bitand(x2c(flag),'01'x)='01'x) then flag=flag', exported'
                  off16=b3||b2
                  say '  'right(d2x(ord),4,'0')':' object':'off16 'flags='flag kordinals.DOSCALLS.ord
               end /* do */
               when type='02' then do
                  flag=b1
                  wc=(c2d(bitand(x2c(flag),'f8'x)))%8
                  if (bitand(x2c(flag),'01'x)='01'x) then flag=flag', exported'
                  flag=flag', WC='wc
                  off16=b3||b2
                  sel=b5||b4
                  say '  'right(d2x(ord),4,'0')':' object':'off16 'sel='sel 'flags='flag kordinals.DOSCALLS.ord
               end /* do */
               when type='03' then do
                  flag=b1
                  if (bitand(x2c(flag),'01'x)='01'x) then flag=flag', exported'
                  off32=b5||b4||b3||b2
                  say '  'right(d2x(ord),4,'0')':' object':'off32 'flags='flag kordinals.DOSCALLS.ord
               end /* do */
               when type='04' then do
                  if impmods then do
                     call fmtimps 'Q'
                     impmods=0=0
                  end /* do */
                  flag=b1
                  mod=b3||b2
                  impord=b7||b6||b5||b4
                  xf=x2c(flag)
                  if (bitand(xf,'04'x)='04'x) then do
                     if bitand(xf,'40'x)='40'x then name='Gate='impord
                     else name='Address='impord
                  end /* do */
                  else do
                     if bitand(xf,'01'x)='01'x then name='Ordinal='immods.mod'.'impord
                     else name='Procedure='immods.mod'.'impord
                  end /* do */
                  say '  'right(d2x(ord),4,'0')': flags='flag name kordinals.DOSCALLS.ord
               end /* do */
            otherwise
            nop
            end  /* select */
            ord=ord+1
            off=off+elen
         end /* do */
         else ord=ord+ents
         address df 'cmd output db' pent'+'off't L4'
         o=output.0-1
         parse var output.o '%'addr b1 b2 b3 b4 .
         if datatype(addr,'x') then do
            say output.o
            return
         end /* do */
         cnt=b1
         type=b2
         object=b4||b3
         off=off+4
      end /* do */
   end /* do */
end /* do */

return

helpmsg: procedure

   say "Format various tables chained from an OS/2 MTE                    "
   say "                                                                  "
   say "Syntax: MTE <options> <addr|handle|name> <options>                "
   say "                                                                  "
   say "where:      <addr>     is a valid DF address expression for the   "
   say "                       beginning of the MTE. If a linear address  "
   say "                       is specified then an attempt to format the "
   say "                       MTE will be made even if it is no longer   "
   say "                       linked.                                    "
   say "                                                                  "
   say "            <handle>   is the load module handle (hmte)           "
   say "                                                                  "
   say "            <name>     is the module name as a quoted string      "
   say "                                                                  "
   say "            <options>  specify various tables to be formatted:    "
   say " "
   say "                       /e specifies the Entry Point Table         "
   say "                       /r specifies the Resource Table            "
   say "                       /n specifies the Names Tables              "
   say "                       /i specifies the Import Module Names Table "
   say " "
   say "                       Options may be combined, with or without a "
   say "                       leading /                                  "
   say " "
return

getdwords: procedure
arg address,length
address df "cmd output DD" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DD "address"+"i*4"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor
getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor
getbytes: procedure
arg address,length
address df "cmd output DB" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DB "address"+"i"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor
kinitord: procedure expose kordinals.
kordinals.=''
kordinals.FSHELPER.1='SEGALLOC'
kordinals.FSHELPER.2='SEGFREE'
kordinals.FSHELPER.3='SEGREALLOC'
kordinals.FSHELPER.4='FORCENOSWAP'
kordinals.FSHELPER.5='INTERR'
kordinals.FSHELPER.6='SEMREQUEST'
kordinals.FSHELPER.7='SEMCLEAR'
kordinals.FSHELPER.8='PROBEBUF'
kordinals.FSHELPER.9='GETPRIORITY'
kordinals.FSHELPER.10='IOSEMCLEAR'
kordinals.FSHELPER.11='FLUSHBUF'
kordinals.FSHELPER.12='CRITERROR'
kordinals.FSHELPER.13='DEVIOCTL'
kordinals.FSHELPER.14='GETVOLPARM'
kordinals.FSHELPER.15='FINDDUPHVPB'
kordinals.FSHELPER.16='DOVOLIO'
kordinals.FSHELPER.17='ADDSHARE'
kordinals.FSHELPER.18='REMOVESHARE'
kordinals.FSHELPER.19='GETOVERLAPBUF'
kordinals.FSHELPER.20='ISCURDIRPREFIX'
kordinals.FSHELPER.21='LOADCHAR'
kordinals.FSHELPER.22='PREVCHAR'
kordinals.FSHELPER.23='STORECHAR'
kordinals.FSHELPER.24='SEMSET'
kordinals.FSHELPER.25='SEMSETWAIT'
kordinals.FSHELPER.26='SEMWAIT'
kordinals.FSHELPER.27='WILDMATCH'
kordinals.FSHELPER.28='YIELD'
kordinals.FSHELPER.29='DOVOLIO2'
kordinals.FSHELPER.30='FINDCHAR'
kordinals.FSHELPER.31='SETBOOTDRIVE'
kordinals.FSHELPER.32='CANONICALIZE'
kordinals.FSHELPER.33='DOVOLIO'
kordinals.FSHELPER.34='INTERR'
kordinals.FSHELPER.35='SEGALLOC'
kordinals.FSHELPER.36='SEGFREE'
kordinals.FSHELPER.37='SEGREALLOC'
kordinals.FSHELPER.38='CALLRM'
kordinals.FSHELPER.39='LOCK'
kordinals.FSHELPER.40='PHYSTOVIRT'
kordinals.FSHELPER.41='UNLOCK'
kordinals.FSHELPER.42='UNPHYSTOVIRT'
kordinals.FSHELPER.43='VIRT2PHYS'
kordinals.FSHELPER.44='QSYSINFO'
kordinals.FSHELPER.45='NAMEFROMSFN'
kordinals.FSHELPER.46='UPPERCASE'
kordinals.FSHELPER.47='CHECKEANAME'
kordinals.FSHELPER.48='CALLDRIVER'
kordinals.FSHELPER.49='SETVOLUME'
kordinals.FSHELPER.50='STACKSPACE'
kordinals.FSHELPER.51='REGISTERPERFCTRS'
kordinals.FSHELPER.52='IOBOOST'
kordinals.FSHELPER.53='QUERYSERVERTHREAD'
kordinals.FSHELPER.54='QUERYOPLOCK'
kordinals.FSHELPER.55='EXTENDTIMESLICE'
kordinals.MVDM.1='VDHSetDosDevice'
kordinals.MVDM.2='_TKSSBase'
kordinals.MVDM.3='VDHInstallUserHook'
kordinals.MVDM.4='VDHPopup'
kordinals.MVDM.5='VDHKillVDM'
kordinals.MVDM.6='VDHSetPriority'
kordinals.MVDM.7='VDHFreezeVDM'
kordinals.MVDM.8='VDHThawVDM'
kordinals.MVDM.9='VDHIsVDMFrozen'
kordinals.MVDM.10='VDHInstallFaultHandler'
kordinals.MVDM.11='VDHEnumerateVDMs'
kordinals.MVDM.12='VDHHandleFromSGID'
kordinals.MVDM.13='VDHHandleFromPID'
kordinals.MVDM.14='VDHInstallIOHook'
kordinals.MVDM.15='VDHRemoveIOHook'
kordinals.MVDM.16='VDHSetIOHookState'
kordinals.MVDM.17='VDHInstallIntHook'
kordinals.MVDM.18='VDHArmBPHook'
kordinals.MVDM.19='VDHArmSTIHook'
kordinals.MVDM.20='VDHArmReturnHook'
kordinals.MVDM.21='VDHInstallFaultHook'
kordinals.MVDM.22='VDHRemoveFaultHook'
kordinals.MVDM.23='VDHOpenPDD'
kordinals.MVDM.24='VDHRegisterVDD'
kordinals.MVDM.25='VDHOpenVDD'
kordinals.MVDM.26='VDHRequestVDD'
kordinals.MVDM.27='VDHAllocMem'
kordinals.MVDM.28='VDHFreeMem'
kordinals.MVDM.29='VDHAllocDosMem'
kordinals.MVDM.30='VDHCreateBlockPool'
kordinals.MVDM.31='VDHAllocBlock'
kordinals.MVDM.32='VDHFreeBlock'
kordinals.MVDM.33='VDHDestroyBlockPool'
kordinals.MVDM.34='VDHCopyMem'
kordinals.MVDM.35='VDHExchangeMem'
kordinals.MVDM.36='VDHLockMem'
kordinals.MVDM.37='VDHUnLockMem'
kordinals.MVDM.38='VDHQuerySel'
kordinals.MVDM.39='VDHCreateSel'
kordinals.MVDM.40='VDHDestroySel'
kordinals.MVDM.41='VDHAllocPages'
kordinals.MVDM.42='VDHReallocPages'
kordinals.MVDM.43='VDHFreePages'
kordinals.MVDM.44='VDHFindFreePages'
kordinals.MVDM.45='VDHGetDirtyPageInfo'
kordinals.MVDM.46='VDHQueryFreePages'
kordinals.MVDM.47='VDHReservePages'
kordinals.MVDM.48='VDHMapPages'
kordinals.MVDM.49='VDHArmTimerHook'
kordinals.MVDM.50='VDHDisarmTimerHook'
kordinals.MVDM.51='VDHOpen'
kordinals.MVDM.52='VDHClose'
kordinals.MVDM.53='VDHRead'
kordinals.MVDM.54='VDHWrite'
kordinals.MVDM.55='VDHPushInt'
kordinals.MVDM.56='VDHPopInt'
kordinals.MVDM.57='VDHPushRegs'
kordinals.MVDM.58='VDHPopRegs'
kordinals.MVDM.59='VDHPushFarCall'
kordinals.MVDM.60='VDHViewHandle'
kordinals.MVDM.61='VDHRegisterAPI'
kordinals.MVDM.62='VDHGetError'
kordinals.MVDM.63='VDHSetError'
kordinals.MVDM.64='VDHQuerySysValue'
kordinals.MVDM.65='VDHPutSysValue'
kordinals.MVDM.66='VDHSeek'
kordinals.MVDM.67='VDHDevIOCtl'
kordinals.MVDM.68='VDHPhysicalDisk'
kordinals.MVDM.69='VDHFSCtl'
kordinals.MVDM.70='VDHYield'
kordinals.MVDM.71='VDHArmContextHook'
kordinals.MVDM.72='VDHHaltSystem'
kordinals.MVDM.73='VDHGetCodePageFont'
kordinals.MVDM.74='VDHReleaseCodePageFont'
kordinals.MVDM.75='_VDHPanic'
kordinals.MVDM.76='_printf'
kordinals.MVDM.77='VDHSetTimer0'
kordinals.MVDM.78='VDHDevBeep'
kordinals.MVDM.79='VDHSetFlags'
kordinals.MVDM.80='VDHAssertTask'
kordinals.MVDM.81='VDHAssertVDMTask'
kordinals.MVDM.82='VDHAssertTaskOnly'
kordinals.MVDM.83='VDHAssertVDMTaskOnly'
kordinals.MVDM.84='VDHAssertInitOnly'
kordinals.MVDM.85='VDHCheckHVDM'
kordinals.MVDM.86='VDHAllocHook'
kordinals.MVDM.87='VDHQueryHookData'
kordinals.MVDM.88='VDHFreeHook'
kordinals.MVDM.89='VDHReleaseNPX'
kordinals.MVDM.90='VDHNPXReset'
kordinals.MVDM.91='VDHNPXClearBusy'
kordinals.MVDM.92='VDHNPXRegisterVDD'
kordinals.MVDM.93='VDHUnreservePages'
kordinals.MVDM.94='VDHQueryLin'
kordinals.MVDM.95='VDHCreateSem'
kordinals.MVDM.96='VDHDestroySem'
kordinals.MVDM.97='VDHQuerySem'
kordinals.MVDM.98='VDHResetEventSem'
kordinals.MVDM.99='VDHPostEventSem'
kordinals.MVDM.100='VDHWaitEventSem'
kordinals.MVDM.101='VDHRequestMutexSem'
kordinals.MVDM.102='VDHReleaseMutexSem'
kordinals.MVDM.103='VDHRegisterProperty'
kordinals.MVDM.104='VDHQueryProperty'
kordinals.MVDM.105='VDHRegisterPerfCtrs'
kordinals.MVDM.106='VDHDecodeProperty'
kordinals.MVDM.107='UNUSED'
kordinals.MVDM.108='VDHPushStack'
kordinals.MVDM.109='VDHPopStack'
kordinals.MVDM.110='VDHAllocDMABuffer'
kordinals.MVDM.111='VDHFreeDMABuffer'
kordinals.MVDM.112='INTSetVDMIRQ'
kordinals.MVDM.113='INTUnsetVDMIRQ'
kordinals.MVDM.114='INTEOIVDMIRQ'
kordinals.MVDM.115='VDHSwitchToV86'
kordinals.MVDM.116='VDHSwitchToVPM'
kordinals.MVDM.117='VDHCheckVPMIntVector'
kordinals.MVDM.118='VDHGetVPMIntVector'
kordinals.MVDM.119='VDHSetVPMIntVector'
kordinals.MVDM.120='VDHArmVPMBPHook'
kordinals.MVDM.121='VDHBeginUseVPMStack'
kordinals.MVDM.122='VDHEndUseVPMStack'
kordinals.MVDM.123='_flVdmStatus'
kordinals.MVDM.124='VDHCloseVDD'
kordinals.MVDM.125='_pdhdHostData'
kordinals.MVDM.126='VDHRegisterDPMI'
kordinals.MVDM.127='_flVpmIRQHooks'
kordinals.MVDM.128='VDHChangeVPMIF'
kordinals.MVDM.129='VDHGetSelBase'
kordinals.MVDM.130='VDHReadUBuf'
kordinals.MVDM.131='VDHWriteUBuf'
kordinals.MVDM.132='VDHCheckPagePerm'
kordinals.MVDM.133='VDHRaiseException'
kordinals.MVDM.134='VDHStartHWInt'
kordinals.MVDM.135='VDHGetVPMExcept'
kordinals.MVDM.136='VDHSetVPMExcept'
kordinals.MVDM.137='VDHProbeUBuf'
kordinals.MVDM.138='VDHPrepVPMIret'
kordinals.MVDM.139='VDHPopVPMFarRet'
kordinals.MVDM.140='VDHCheckVPMExcept'
kordinals.MVDM.141='VDHSetBoost'
kordinals.MVDM.142='VDHWakeRamSem'
kordinals.MVDM.143='VDHRequestRamSem'
kordinals.MVDM.144='VDHProcessToGlobal'
kordinals.MVDM.145='VDHValidatePID'
kordinals.MVDM.146='VDHMapMemBlock'
kordinals.MVDM.147='DevWOHandle'
kordinals.MVDM.148='VDHVMGetHandle'
kordinals.MVDM.149='VDHVMAttach'
kordinals.MVDM.150='VDHCreateThread'
kordinals.MVDM.151='VDHExitThread'
kordinals.MVDM.152='_em86Is32Sel'
kordinals.MVDM.153='INTGetIRR'
kordinals.MVDM.154='VDHWaitRamSem'
kordinals.MVDM.155='VDHPortIO'
kordinals.MVDM.156='VDHVMDetach'
kordinals.MVDM.157='VDHGetFlags'
kordinals.DOSCALLS.1='DOSICREATETHREAD'
kordinals.DOSCALLS.2='DOSCWAIT'
kordinals.DOSCALLS.3='DOSENTERCRITSEC'
kordinals.DOSCALLS.4='DOSIEXECPGM'
kordinals.DOSCALLS.5='DOSEXIT'
kordinals.DOSCALLS.6='DOSEXITCRITSEC'
kordinals.DOSCALLS.7='DOSEXITLIST'
kordinals.DOSCALLS.8='DOSGETINFOSEG'
kordinals.DOSCALLS.9='DOSGETPRTY'
kordinals.DOSCALLS.10='DOSKILLPROCESS'
kordinals.DOSCALLS.11='DOSSETPRTY'
kordinals.DOSCALLS.12='DOSPTRACE'
kordinals.DOSCALLS.13='DOSHOLDSIGNAL'
kordinals.DOSCALLS.14='DOSSETSIGHANDLER'
kordinals.DOSCALLS.15='DOSFLAGPROCESS'
kordinals.DOSCALLS.16='DOSMAKEPIPE'
kordinals.DOSCALLS.17='DOSISYSSEMCLEAR'
kordinals.DOSCALLS.18='DOSISEMREQUEST'
kordinals.DOSCALLS.19='DOSISYSSEMSET'
kordinals.DOSCALLS.20='DOSSEMSETWAIT'
kordinals.DOSCALLS.21='DOSISEMWAIT'
kordinals.DOSCALLS.22='DOSMUXSEMWAIT'
kordinals.DOSCALLS.23='DOSCLOSESEM'
kordinals.DOSCALLS.24='DOSCREATESEM'
kordinals.DOSCALLS.25='DOSOPENSEM'
kordinals.DOSCALLS.26='DOSRESUMETHREAD'
kordinals.DOSCALLS.27='DOSSUSPENDTHREAD'
kordinals.DOSCALLS.28='DOSSETDATETIME'
kordinals.DOSCALLS.29='DOSTIMERASYNC'
kordinals.DOSCALLS.30='DOSTIMERSTART'
kordinals.DOSCALLS.31='DOSTIMERSTOP'
kordinals.DOSCALLS.32='DOSSLEEP'
kordinals.DOSCALLS.33='DOSGETDATETIME'
kordinals.DOSCALLS.34='DOSALLOCSEG'
kordinals.DOSCALLS.35='DOSALLOCSHRSEG'
kordinals.DOSCALLS.36='DOSGETSHRSEG'
kordinals.DOSCALLS.37='DOSGIVESEG'
kordinals.DOSCALLS.38='DOSREALLOCSEG'
kordinals.DOSCALLS.39='DOSFREESEG'
kordinals.DOSCALLS.40='DOSALLOCHUGE'
kordinals.DOSCALLS.41='DOSGETHUGESHIFT'
kordinals.DOSCALLS.42='DOSREALLOCHUGE'
kordinals.DOSCALLS.43='DOSCREATECSALIAS'
kordinals.DOSCALLS.44='DOSLOADMODULE'
kordinals.DOSCALLS.45='DOSGETPROCADDR'
kordinals.DOSCALLS.46='DOSFREEMODULE'
kordinals.DOSCALLS.47='DOSGETMODHANDLE'
kordinals.DOSCALLS.48='DOSGETMODNAME'
kordinals.DOSCALLS.49='DOSGETMACHINEMODE'
kordinals.DOSCALLS.50='DOSBEEP'
kordinals.DOSCALLS.51='DOSCLIACCESS'
kordinals.DOSCALLS.52='DOSDEVCONFIG'
kordinals.DOSCALLS.53='DOSDEVIOCTL'
kordinals.DOSCALLS.54='DOSSGSWITCH'
kordinals.DOSCALLS.55='DOSSGSWITCHME'
kordinals.DOSCALLS.56='DOSBUFRESET'
kordinals.DOSCALLS.57='DOSCHDIR'
kordinals.DOSCALLS.58='DOSCHGFILEPTR'
kordinals.DOSCALLS.59='DOSCLOSE'
kordinals.DOSCALLS.60='DOSDELETE'
kordinals.DOSCALLS.61='DOSDUPHANDLE'
kordinals.DOSCALLS.62='DOSFILELOCKS'
kordinals.DOSCALLS.63='DOSFINDCLOSE'
kordinals.DOSCALLS.64='DOSFINDFIRST'
kordinals.DOSCALLS.65='DOSFINDNEXT'
kordinals.DOSCALLS.66='DOSMKDIR'
kordinals.DOSCALLS.67='DOSMOVE'
kordinals.DOSCALLS.68='DOSNEWSIZE'
kordinals.DOSCALLS.69='DOSPORTACCESS'
kordinals.DOSCALLS.70='DOSOPEN'
kordinals.DOSCALLS.71='DOSQCURDIR'
kordinals.DOSCALLS.72='DOSQCURDISK'
kordinals.DOSCALLS.73='DOSQFHANDSTATE'
kordinals.DOSCALLS.74='DOSQFILEINFO'
kordinals.DOSCALLS.75='DOSQFILEMODE'
kordinals.DOSCALLS.76='DOSQFSINFO'
kordinals.DOSCALLS.77='DOSQHANDTYPE'
kordinals.DOSCALLS.78='DOSQVERIFY'
kordinals.DOSCALLS.79='DOSIREAD'
kordinals.DOSCALLS.80='DOSRMDIR'
kordinals.DOSCALLS.81='DOSSELECTDISK'
kordinals.DOSCALLS.82='DOSSETFHANDSTATE'
kordinals.DOSCALLS.83='DOSSETFILEINFO'
kordinals.DOSCALLS.84='DOSSETFILEMODE'
kordinals.DOSCALLS.85='DOSSETMAXFH'
kordinals.DOSCALLS.86='DOSSETVERIFY'
kordinals.DOSCALLS.87='DOSIWRITE'
kordinals.DOSCALLS.88='DOSSYSTEMSERVICE'
kordinals.DOSCALLS.89='DOSSETVEC'
kordinals.DOSCALLS.90='DOSSYSTRACE'
kordinals.DOSCALLS.91='DOSGETENV'
kordinals.DOSCALLS.92='DOSGETVERSION'
kordinals.DOSCALLS.93='DOSQTRACEINFO'
kordinals.DOSCALLS.94='DOSGETPID'
kordinals.DOSCALLS.95='DOSOPEN2'
kordinals.DOSCALLS.96='DOSLIBINIT'
kordinals.DOSCALLS.97='DOSSETFSINFO'
kordinals.DOSCALLS.98='DOSQPATHINFO'
kordinals.DOSCALLS.99='DOSDEVIOCTL2'
kordinals.DOSCALLS.100='DOSICANONICALIZE'
kordinals.DOSCALLS.101='DOSSETFGND'
kordinals.DOSCALLS.102='DOSSWAPTASKINIT'
kordinals.DOSCALLS.103='DOSREADPHYS'
kordinals.DOSCALLS.104='DOSSETPATHINFO'
kordinals.DOSCALLS.105='DOSSGSWITCHPROC2'
kordinals.DOSCALLS.106='STRUCHECK'
kordinals.DOSCALLS.107='STRURESUPDATE'
kordinals.DOSCALLS.108='DOSISETRELMAXFH'
kordinals.DOSCALLS.109='DOSIDEVIOCTL'
kordinals.DOSCALLS.110='DOS32FORCEDELETE'
kordinals.DOSCALLS.111='DOS32KILLTHREAD'
kordinals.DOSCALLS.112='DOSQUERYRASINFO'
kordinals.DOSCALLS.113='DOS32DUMPPROCESS'
kordinals.DOSCALLS.114='DOS32SUPPRESSPOPUPS'
kordinals.DOSCALLS.118='DOSOPEN2COMPT'
kordinals.DOSCALLS.119='DOSGETSTDA'
kordinals.DOSCALLS.120='DOSERROR'
kordinals.DOSCALLS.121='DOSGETSEG'
kordinals.DOSCALLS.122='DOSLOCKSEG'
kordinals.DOSCALLS.123='DOSUNLOCKSEG'
kordinals.DOSCALLS.124='DOSSGSWITCHPROC'
kordinals.DOSCALLS.125='DOSIRAMSEMWAKE'
kordinals.DOSCALLS.126='DOSSIZESEG'
kordinals.DOSCALLS.127='DOSMEMAVAIL'
kordinals.DOSCALLS.128='DOSIRAMSEMREQUEST'
kordinals.DOSCALLS.129='DOSPHYSICALDISK'
kordinals.DOSCALLS.130='DOSGETCP'
kordinals.DOSCALLS.131='DOSISETCP'
kordinals.DOSCALLS.132='DOSGLOBALSEG'
kordinals.DOSCALLS.133='DOSPROFILE'
kordinals.DOSCALLS.134='DOSSENDSIGNAL'
kordinals.DOSCALLS.135='DOSHUGESHIFT'
kordinals.DOSCALLS.136='DOSHUGEINCR'
kordinals.DOSCALLS.137='DOSREAD'
kordinals.DOSCALLS.138='DOSWRITE'
kordinals.DOSCALLS.139='DOSERRCLASS'
kordinals.DOSCALLS.140='DOSSEMREQUEST'
kordinals.DOSCALLS.141='DOSSEMCLEAR'
kordinals.DOSCALLS.142='DOSSEMWAIT'
kordinals.DOSCALLS.143='DOSSEMSET'
kordinals.DOSCALLS.144='DOSEXECPGM'
kordinals.DOSCALLS.145='DOSCREATETHREAD'
kordinals.DOSCALLS.146='DOSSUBSET'
kordinals.DOSCALLS.147='DOSSUBALLOC'
kordinals.DOSCALLS.148='DOSSUBFREE'
kordinals.DOSCALLS.149='DOSREADASYNC'
kordinals.DOSCALLS.150='DOSWRITEASYNC'
kordinals.DOSCALLS.151='DOSSEARCHPATH'
kordinals.DOSCALLS.152='DOSSCANENV'
kordinals.DOSCALLS.153='DOSSETCP'
kordinals.DOSCALLS.154='DOSQPROCSTATUS'
kordinals.DOSCALLS.155='DOSGETRESOURCE'
kordinals.DOSCALLS.156='DOSGETPPID'
kordinals.DOSCALLS.157='DOSCALLBACK'
kordinals.DOSCALLS.158='DOSICALLBACK'
kordinals.DOSCALLS.159='DOSRETFORWARD'
kordinals.DOSCALLS.160='DOSR2STACKREALLOC'
kordinals.DOSCALLS.161='DOSFSRAMSEMREQUEST'
kordinals.DOSCALLS.162='DOSFSRAMSEMCLEAR'
kordinals.DOSCALLS.163='DOSQAPPTYPE'
kordinals.DOSCALLS.164='DOSSETPROCCP'
kordinals.DOSCALLS.165='DOSDYNAMICTRACE'
kordinals.DOSCALLS.166='DOSQSYSINFO'
kordinals.DOSCALLS.167='DOSIMAKENMPIPE'
kordinals.DOSCALLS.168='DOSICALLNMPIPE'
kordinals.DOSCALLS.169='DOSICONNECTNMPIPE'
kordinals.DOSCALLS.170='DOSIDISCONNECTNMPIPE'
kordinals.DOSCALLS.171='DOSIPEEKNMPIPE'
kordinals.DOSCALLS.172='DOSIQNMPIPEINFO'
kordinals.DOSCALLS.173='DOSIQNMPHANDSTATE'
kordinals.DOSCALLS.174='DOSISETNMPHANDSTATE'
kordinals.DOSCALLS.175='DOSITRANSACTNMPIPE'
kordinals.DOSCALLS.176='DOSIWAITNMPIPE'
kordinals.DOSCALLS.177='DOSISETNMPIPESEM'
kordinals.DOSCALLS.178='DOSIQNMPIPESEMSTATE'
kordinals.DOSCALLS.179='DOSIRAWREADNMPIPE'
kordinals.DOSCALLS.180='DOSIRAWWRITENMPIPE'
kordinals.DOSCALLS.181='DOSFSATTACH'
kordinals.DOSCALLS.182='DOSQFSATTACH'
kordinals.DOSCALLS.183='DOSFSCTL'
kordinals.DOSCALLS.184='DOSFINDFIRST2'
kordinals.DOSCALLS.185='DOSMKDIR2'
kordinals.DOSCALLS.186='DOSFILEIO'
kordinals.DOSCALLS.187='DOSFINDNOTIFYCLOSE'
kordinals.DOSCALLS.188='DOSFINDNOTIFYFIRST'
kordinals.DOSCALLS.189='DOSFINDNOTIFYNEXT'
kordinals.DOSCALLS.190='DOSSETTRACEINFO'
kordinals.DOSCALLS.191='DOSEDITNAME'
kordinals.DOSCALLS.192='DOSLOGMODE'
kordinals.DOSCALLS.193='DOSLOGENTRY'
kordinals.DOSCALLS.194='DOSGETLOGBUFFER'
kordinals.DOSCALLS.195='DOSLOGREGISTER'
kordinals.DOSCALLS.196='DOSLOGREAD'
kordinals.DOSCALLS.197='DOSFINDFROMNAME'
kordinals.DOSCALLS.198='DOSOPLOCKRELEASE'
kordinals.DOSCALLS.199='DOSOPLOCKWAIT'
kordinals.DOSCALLS.200='DOSICOPY'
kordinals.DOSCALLS.201='DOSCOPY'
kordinals.DOSCALLS.202='DOSIQAPPTYPE'
kordinals.DOSCALLS.203='DOSFORCEDELETE'
kordinals.DOSCALLS.204='DOSENUMATTRIBUTE'
kordinals.DOSCALLS.205='DOSOPLOCKSHUTDOWN'
kordinals.DOSCALLS.206='DOSSHUTDOWN'
kordinals.DOSCALLS.207='DOSGETRESOURCE2'
kordinals.DOSCALLS.208='DOSFREERESOURCE'
kordinals.DOSCALLS.209='DOS32SETMAXFH'
kordinals.DOSCALLS.210='DOS32SETVERIFY'
kordinals.DOSCALLS.211='DOS32ERRCLASS'
kordinals.DOSCALLS.212='DOS32ERROR'
kordinals.DOSCALLS.213='DOSCREATEVDM'
kordinals.DOSCALLS.214='DOSMAXPATHLEN'
kordinals.DOSCALLS.215='DOSPAGESIZE'
kordinals.DOSCALLS.216='DOSLOCALINFO'
kordinals.DOSCALLS.217='DOSGLOBALINFO'
kordinals.DOSCALLS.218='DOS32SETFILEINFO'
kordinals.DOSCALLS.219='DOS32SETPATHINFO'
kordinals.DOSCALLS.220='DOS32SETDEFAULTDISK'
kordinals.DOSCALLS.221='DOS32SETFHSTATE'
kordinals.DOSCALLS.222='DOS32SETFSINFO'
kordinals.DOSCALLS.223='DOS32QUERYPATHINFO'
kordinals.DOSCALLS.224='DOS32QUERYHTYPE'
kordinals.DOSCALLS.225='DOS32QUERYVERIFY'
kordinals.DOSCALLS.226='DOS32DELETEDIR'
kordinals.DOSCALLS.227='DOS32SCANENV'
kordinals.DOSCALLS.228='DOS32SEARCHPATH'
kordinals.DOSCALLS.229='DOS32SLEEP'
kordinals.DOSCALLS.230='DOS32GETDATETIME'
kordinals.DOSCALLS.231='DOS32DEVCONFIG'
kordinals.DOSCALLS.232='DOS32ENTERCRITSEC'
kordinals.DOSCALLS.233='DOS32EXITCRITSEC'
kordinals.DOSCALLS.234='DOS32EXIT'
kordinals.DOSCALLS.235='DOS32KILLPROCESS'
kordinals.DOSCALLS.236='DOS32SETPRIORITY'
kordinals.DOSCALLS.237='DOS32RESUMETHREAD'
kordinals.DOSCALLS.238='DOS32SUSPENDTHREAD'
kordinals.DOSCALLS.239='DOS32CREATEPIPE'
kordinals.DOSCALLS.240='DOS32CALLNPIPE'
kordinals.DOSCALLS.241='DOS32CONNECTNPIPE'
kordinals.DOSCALLS.242='DOS32DISCONNECTNPIPE'
kordinals.DOSCALLS.243='DOS32CREATENPIPE'
kordinals.DOSCALLS.244='DOS32PEEKNPIPE'
kordinals.DOSCALLS.245='DOS32QUERYNPHSTATE'
kordinals.DOSCALLS.246='DOS32RAWREADNPIPE'
kordinals.DOSCALLS.247='DOS32RAWWRITENPIPE'
kordinals.DOSCALLS.248='DOS32QUERYNPIPEINFO'
kordinals.DOSCALLS.249='DOS32QUERYNPIPESEMSTATE'
kordinals.DOSCALLS.250='DOS32SETNPHSTATE'
kordinals.DOSCALLS.251='DOS32SETNPIPESEM'
kordinals.DOSCALLS.252='DOS32TRANSACTNPIPE'
kordinals.DOSCALLS.253='DOS32WAITNPIPE'
kordinals.DOSCALLS.254='DOS32RESETBUFFER'
kordinals.DOSCALLS.255='DOS32SETCURRENTDIR'
kordinals.DOSCALLS.256='DOS32SETFILEPTR'
kordinals.DOSCALLS.257='DOS32CLOSE'
kordinals.DOSCALLS.258='DOS32COPY'
kordinals.DOSCALLS.259='DOS32DELETE'
kordinals.DOSCALLS.260='DOS32DUPHANDLE'
kordinals.DOSCALLS.261='DOS32EDITNAME'
kordinals.DOSCALLS.263='DOS32FINDCLOSE'
kordinals.DOSCALLS.264='DOS32FINDFIRST'
kordinals.DOSCALLS.265='DOS32FINDNEXT'
kordinals.DOSCALLS.266='DOSOPENVDD'
kordinals.DOSCALLS.267='DOSREQUESTVDD'
kordinals.DOSCALLS.268='DOSCLOSEVDD'
kordinals.DOSCALLS.269='DOS32FSATTACH'
kordinals.DOSCALLS.270='DOS32CREATEDIR'
kordinals.DOSCALLS.271='DOS32MOVE'
kordinals.DOSCALLS.272='DOS32SETFILESIZE'
kordinals.DOSCALLS.273='DOS32OPEN'
kordinals.DOSCALLS.274='DOS32QUERYCURRENTDIR'
kordinals.DOSCALLS.275='DOS32QUERYCURRENTDISK'
kordinals.DOSCALLS.276='DOS32QUERYFHSTATE'
kordinals.DOSCALLS.277='DOS32QUERYFSATTACH'
kordinals.DOSCALLS.278='DOS32QUERYFSINFO'
kordinals.DOSCALLS.279='DOS32QUERYFILEINFO'
kordinals.DOSCALLS.280='DOS32WAITCHILD'
kordinals.DOSCALLS.281='DOS32READ'
kordinals.DOSCALLS.282='DOS32WRITE'
kordinals.DOSCALLS.283='DOS32EXECPGM'
kordinals.DOSCALLS.284='DOS32DEVIOCTL'
kordinals.DOSCALLS.285='DOS32FSCTL'
kordinals.DOSCALLS.286='DOS32BEEP'
kordinals.DOSCALLS.287='DOS32PHYSICALDISK'
kordinals.DOSCALLS.288='DOS32SETCP'
kordinals.DOSCALLS.289='DOS32SETPROCESSCP'
kordinals.DOSCALLS.290='DOS32STOPTIMER'
kordinals.DOSCALLS.291='DOS32QUERYCP'
kordinals.DOSCALLS.292='DOS32SETDATETIME'
kordinals.DOSCALLS.293='THK32ALLOCBLOCK'
kordinals.DOSCALLS.294='THK32FREEBLOCK'
kordinals.DOSCALLS.295='THK32R3DS'
kordinals.DOSCALLS.296='DOS32EXITLIST'
kordinals.DOSCALLS.297='DOS32ALLOCPROTECTEDMEM'
kordinals.DOSCALLS.298='DOS32ALIASMEM'
kordinals.DOSCALLS.299='DOS32ALLOCMEM'
kordinals.DOSCALLS.300='DOS32ALLOCSHAREDMEM'
kordinals.DOSCALLS.301='DOS32GETNAMEDSHAREDMEM'
kordinals.DOSCALLS.302='DOS32GETSHAREDMEM'
kordinals.DOSCALLS.303='DOS32GIVESHAREDMEM'
kordinals.DOSCALLS.304='DOS32FREEMEM'
kordinals.DOSCALLS.305='DOS32SETMEM'
kordinals.DOSCALLS.306='DOS32QUERYMEM'
kordinals.DOSCALLS.307='DOS32QUERYMEMSTATE'
kordinals.DOSCALLS.308='DOS32OPENVDD'
kordinals.DOSCALLS.309='DOS32REQUESTVDD'
kordinals.DOSCALLS.310='DOS32CLOSEVDD'
kordinals.DOSCALLS.311='DOS32CREATETHREAD'
kordinals.DOSCALLS.312='DOS32GETINFOBLOCKS'
kordinals.DOSCALLS.313='DOSALLOCPROTSEG'
kordinals.DOSCALLS.314='DOSALLOCSHRPROTSEG'
kordinals.DOSCALLS.315='DOSALLOCPROTHUGE'
kordinals.DOSCALLS.316='DOS32DYNAMICTRACE'
kordinals.DOSCALLS.317='DOS32DEBUG'
kordinals.DOSCALLS.318='DOS32LOADMODULE'
kordinals.DOSCALLS.319='DOS32QUERYMODULEHANDLE'
kordinals.DOSCALLS.320='DOS32QUERYMODULENAME'
kordinals.DOSCALLS.321='DOS32QUERYPROCADDR'
kordinals.DOSCALLS.322='DOS32FREEMODULE'
kordinals.DOSCALLS.323='DOS32QUERYAPPTYPE'
kordinals.DOSCALLS.324='DOS32CREATEEVENTSEM'
kordinals.DOSCALLS.325='DOS32OPENEVENTSEM'
kordinals.DOSCALLS.326='DOS32CLOSEEVENTSEM'
kordinals.DOSCALLS.327='DOS32RESETEVENTSEM'
kordinals.DOSCALLS.328='DOS32POSTEVENTSEM'
kordinals.DOSCALLS.329='DOS32WAITEVENTSEM'
kordinals.DOSCALLS.330='DOS32QUERYEVENTSEM'
kordinals.DOSCALLS.331='DOS32CREATEMUTEXSEM'
kordinals.DOSCALLS.332='DOS32OPENMUTEXSEM'
kordinals.DOSCALLS.333='DOS32CLOSEMUTEXSEM'
kordinals.DOSCALLS.334='DOS32REQUESTMUTEXSEM'
kordinals.DOSCALLS.335='DOS32RELEASEMUTEXSEM'
kordinals.DOSCALLS.336='DOS32QUERYMUTEXSEM'
kordinals.DOSCALLS.337='DOS32CREATEMUXWAITSEM'
kordinals.DOSCALLS.338='DOS32OPENMUXWAITSEM'
kordinals.DOSCALLS.339='DOS32CLOSEMUXWAITSEM'
kordinals.DOSCALLS.340='DOS32WAITMUXWAITSEM'
kordinals.DOSCALLS.341='DOS32ADDMUXWAITSEM'
kordinals.DOSCALLS.342='DOS32DELETEMUXWAITSEM'
kordinals.DOSCALLS.343='DOS32QUERYMUXWAITSEM'
kordinals.DOSCALLS.344='DOS32SUBSETMEM'
kordinals.DOSCALLS.345='DOS32SUBALLOCMEM'
kordinals.DOSCALLS.346='DOS32SUBFREEMEM'
kordinals.DOSCALLS.347='DOS32SUBUNSETMEM'
kordinals.DOSCALLS.348='DOS32QUERYSYSINFO'
kordinals.DOSCALLS.349='DOS32WAITTHREAD'
kordinals.DOSCALLS.350='DOS32ASYNCTIMER'
kordinals.DOSCALLS.351='DOS32STARTTIMER'
kordinals.DOSCALLS.352='DOS32GETRESOURCE'
kordinals.DOSCALLS.353='DOS32FREERESOURCE'
kordinals.DOSCALLS.354='DOS32SETEXCEPTIONHANDLER'
kordinals.DOSCALLS.355='DOS32UNSETEXCEPTIONHANDLER'
kordinals.DOSCALLS.356='DOS32RAISEEXCEPTION'
kordinals.DOSCALLS.357='DOS32UNWINDEXCEPTION'
kordinals.DOSCALLS.358='DOS32QUERYPAGEUSAGE'
kordinals.DOSCALLS.359='DOSQUERYMODFROMCS'
kordinals.DOSCALLS.360='DOS32QUERYMODFROMEIP'
kordinals.DOSCALLS.361='DOSFPDATAAREA'
kordinals.DOSCALLS.362='DOS32TMRQUERYFREQ'
kordinals.DOSCALLS.363='DOS32TMRQUERYTIME'
kordinals.DOSCALLS.364='DOS32ALIASPERFCTRS'
kordinals.DOSCALLS.365='DOS32CONFIGUREPERF'
kordinals.DOSCALLS.366='DOS32DECONPERF'
kordinals.DOSCALLS.367='DOS32REGISTERPERFCTRS'
kordinals.DOSCALLS.368='DOS32QUERYSYSSTATE'
kordinals.DOSCALLS.369='DOS32FLATCS'
kordinals.DOSCALLS.370='DOS32FLATDS'
kordinals.DOSCALLS.371='DOS32QUERYABIOSSUPPORT'
kordinals.DOSCALLS.372='DOS32ENUMATTRIBUTE'
kordinals.DOSCALLS.373='DOS32QUERYDOSPROPERTY'
kordinals.DOSCALLS.374='DOS32SETDOSPROPERTY'
kordinals.DOSCALLS.375='DOSQUERYDOSPROPERTY'
kordinals.DOSCALLS.376='DOSSETDOSPROPERTY'
kordinals.DOSCALLS.377='DOS32PROFILE'
kordinals.DOSCALLS.378='DOS32SETSIGNALEXCEPTIONFOC'
kordinals.DOSCALLS.379='DOS32SENDSIGNALEXCEPTION'
kordinals.DOSCALLS.380='DOS32ENTERMUSTCOMPLETE'
kordinals.DOSCALLS.381='DOS32EXITMUSTCOMPLETE'
kordinals.DOSCALLS.382='DOS32SETRELMAXFH'
kordinals.DOSCALLS.383='MSGPUTMESSAGE'
kordinals.DOSCALLS.384='MSGTRUEGETMESSAGE'
kordinals.DOSCALLS.385='MSGINSMESSAGE'
kordinals.DOSCALLS.386='MSG32INSERTMESSAGE'
kordinals.DOSCALLS.387='MSG32PUTMESSAGE'
kordinals.DOSCALLS.388='MSG32TRUEGETMESSAGE'
kordinals.DOSCALLS.389='MSGIQUERYMESSAGECP'
kordinals.DOSCALLS.390='MSG32IQUERYMESSAGECP'
kordinals.DOSCALLS.391='NLSCASEMAP'
kordinals.DOSCALLS.392='NLSGETCOLLATE'
kordinals.DOSCALLS.393='NLSGETCTRYINFO'
kordinals.DOSCALLS.394='NLSGETDBCSEV'
kordinals.DOSCALLS.395='NLS32QUERYCTRYINFO'
kordinals.DOSCALLS.396='NLS32QUERYDBCSENV'
kordinals.DOSCALLS.397='NLS32MAPCASE'
kordinals.DOSCALLS.398='NLS32QUERYCOLLATE'
kordinals.DOSCALLS.399='NPIPEMAKENMPIPE'
kordinals.DOSCALLS.400='NPIPEQNMPIPEINFO'
kordinals.DOSCALLS.401='NPIPECONNECTNMPIPE'
kordinals.DOSCALLS.402='NPIPEDISCONNECTNMPIPE'
kordinals.DOSCALLS.403='NPIPEQNMPHANDSTATE'
kordinals.DOSCALLS.404='NPIPESETNMPHANDSTATE'
kordinals.DOSCALLS.405='NPIPEPEEKNMPIPE'
kordinals.DOSCALLS.406='NPIPEWAITNMPIPE'
kordinals.DOSCALLS.407='NPIPETRANSACTNMPIPE'
kordinals.DOSCALLS.408='NPIPECALLNMPIPE'
kordinals.DOSCALLS.409='NPIPERAWREADNMPIPE'
kordinals.DOSCALLS.410='NPIPERAWWRITENMPIPE'
kordinals.DOSCALLS.411='NPIPESETNMPIPESEM'
kordinals.DOSCALLS.412='NPIPEQNMPIPESEMSTATE'
kordinals.DOSCALLS.413='HPFSSTARTLAZYWRITER'
kordinals.DOSCALLS.414='QUEINSTANCEDATA'
kordinals.DOSCALLS.415='DOS32SHUTDOWN'
kordinals.DOSCALLS.416='DOS32ICACHEMODULE'
kordinals.DOSCALLS.417='DOS32REPLACEMODULE'
kordinals.DOSCALLS.418='DOS32ACKNOWLEDGESIGNALEXC'
kordinals.DOSCALLS.419='DOS32TIB'
kordinals.DOSCALLS.420='DOSTMRQUERYFREQ'
kordinals.DOSCALLS.421='DOSTMRQUERYTIME'
kordinals.DOSCALLS.422='DOSREGISTERPERFCTRS'
kordinals.DOSCALLS.423='DOSFLATTOSEL'
kordinals.DOSCALLS.424='DOSSELTOFLAT'
kordinals.DOSCALLS.425='DOS32FLATTOSEL'
kordinals.DOSCALLS.426='DOS32SELTOFLAT'
kordinals.DOSCALLS.427='DOSIODELAYCNT'
kordinals.DOSCALLS.428='DOS32SETFILELOCKS'
kordinals.DOSCALLS.429='DOS32CANCELLOCKREQUEST'
kordinals.DOSCALLS.430='LOGOPEN'
kordinals.DOSCALLS.431='LOGCLOSE'
kordinals.DOSCALLS.432='LOGADDENTRIES'
kordinals.DOSCALLS.433='LOGGETENTRIES'
kordinals.DOSCALLS.434='LOGSETSTATE'
kordinals.DOSCALLS.435='LOGSETNAME'
kordinals.DOSCALLS.436='LOGQUERYSTATE'
kordinals.DOSCALLS.437='DOSOPENCHANGENOTIFY'
kordinals.DOSCALLS.438='DOSRESETCHANGENOTIFY'
kordinals.DOSCALLS.439='DOSCLOSECHANGENOTIFY'
kordinals.DOSCALLS.440='DOS32OPENCHANGENOTIFY'
kordinals.DOSCALLS.441='DOS32RESETCHANGENOTIFY'
kordinals.DOSCALLS.442='DOS32CLOSECHANGENOTIFY'
kordinals.DOSCALLS.443='DOSQUERYABIOSSUPPORT'
kordinals.DOSCALLS.444='DOS32FORCESYSTEMDUMP'
kordinals.DOSCALLS.Y454='DOS32ALLOCTHREADLOCALMEMOR'
kordinals.DOSCALLS.455='DOS32FREETHREADLOCALMEMORY'
kordinals.DOSCALLS.460='DOS32VERIFYPIDTID'
kordinals.DOSCALLS.464='PTDA_LANMAN_SEC'
kordinals.DOSCALLS.465='PTDA_PID'
kordinals.DOSCALLS.466='SAS_SEL'
kordinals.DOSCALLS.467='TCB_OPCOOKIE'
kordinals.DOSCALLS.468='TCB_OPFLAGS'
kordinals.DOSCALLS.469='TCB_NEWFLAGS'
kordinals.DOSCALLS.470='TCB_USER_ID'
kordinals.DOSCALLS.471='TCB_PROC_ID'
kordinals.DOSCALLS.472='TCB_FSHARING'
kordinals.DOSCALLS.473='TCB_SRVATTRIB'
kordinals.DOSCALLS.474='TCB_ALLOWED'
kordinals.DOSCALLS.475='TCB_PRTCB'
kordinals.DOSCALLS.476='TCB_NUMBER'
kordinals.DOSCALLS.477='TCB_THISSFT'
kordinals.DOSCALLS.478='TCB_THISCDS'
kordinals.DOSCALLS.479='TKOPTDA'
kordinals.DOSCALLS.480='PTDA_CRITSEC'
kordinals.DOSCALLS.481='PTDA_HOLDSIGCNT'
kordinals.DOSCALLS.482='PTDA_PPTDAPARENT'
kordinals.DOSCALLS.483='PTDA_PGDATA'
kordinals.DOSCALLS.484='PTDA_HANDLE'
kordinals.DOSCALLS.485='PTDA_MODULE'
kordinals.DOSCALLS.486='PTDA_LDTHANDLE'
kordinals.DOSCALLS.487='PTDA_CODEPAGE_TAG'
kordinals.DOSCALLS.488='PTDA_JFN_LENGTH'
kordinals.DOSCALLS.489='PTDA_JFN_PTABLE'
kordinals.DOSCALLS.490='PTDA_JFN_FLG_PTR'
kordinals.DOSCALLS.491='PTDA_EXTERR_LOCUS'
kordinals.DOSCALLS.492='PTDA_EXTERR'
kordinals.DOSCALLS.493='PTDA_EXTERR_ACTION'
kordinals.DOSCALLS.494='PTDA_EXTERR_CLASS'
kordinals.DOSCALLS.495='PTDA_PPID'
kordinals.DOSCALLS.496='PTDA_PROCTYPE'
kordinals.DOSCALLS.497='PTDA_CURRTCB'
kordinals.DOSCALLS.498='PTDA_CURRTSD'
kordinals.DOSCALLS.499='PTDA_SIGNATURE'
kordinals.DOSCALLS.545='DOS32EXCEPTIONCALLBACK'
kordinals.DOSCALLS.548='DOS32R3EXCEPTIONDISPATCHER'
kordinals.DOSCALLS.549='DOSLIBIDISP'
kordinals.DOSCALLS.550='DOSLIBIDISP16'
kordinals.DOSCALLS.551='DOSLIBIDISP32'
kordinals.DOSCALLS.552='DOSR3EXITADDR'
kordinals.DOSCALLS.553='DOS32R3EXITADDR'
kordinals.DOSCALLS.554='DOS32IREAD'
kordinals.DOSCALLS.556='DOS32IWRITE'
kordinals.DOSCALLS.565='DOSISETFILEINFO'
kordinals.DOSCALLS.566='DOSISETPATHINFO'
kordinals.DOSCALLS.569='DOSIFINDNEXT'
kordinals.DOSCALLS.572='DOS32QUERYRESOURCESIZE'
kordinals.DOSCALLS.573='DOSQUERYRESOURCESIZE'
kordinals.DOSCALLS.574='DOSPMSEMWAIT'
kordinals.DOSCALLS.575='DOSPMMUXSEMWAIT'
kordinals.DOSCALLS.576='THK16_UNITHUNK'
kordinals.DOSCALLS.577='HT16_STARTUP'
kordinals.DOSCALLS.580='DOS32INITIALIZEPORTHOLE'
kordinals.DOSCALLS.582='DOS32QUERYHEADERINFO'
kordinals.DOSCALLS.583='DOSINITIALIZEPORTHOLE'
kordinals.DOSCALLS.584='DOSQUERYHEADERINFO'
kordinals.DOSCALLS.585='MON32MONREAD'
kordinals.DOSCALLS.586='DOS32QUERYPROCTYPE'
kordinals.DOSCALLS.587='DOSQUERYPROCTYPE'
kordinals.DOSCALLS.588='MON32MONWRITE'
kordinals.DOSCALLS.589='DOSISIGDISPATCH'
kordinals.DOSCALLS.592='DOS32DLLTERMDISP'
kordinals.DOSCALLS.594='DOS32IRAISEEXCEPTION'
kordinals.DOSCALLS.597='DOS32IQUERYFHSTATE'
kordinals.DOSCALLS.598='DOS32ISETFHSTATE'
kordinals.DOSCALLS.599='DOSLDTSEL'
kordinals.DOSCALLS.600='DOS32R3FRESTOR'
kordinals.DOSCALLS.601='DOSIFINDFIRST'
kordinals.DOSCALLS.615='DOS32IPROTECTWRITE'
kordinals.DOSCALLS.617='DOSIPROTECTSETFILEINFO'
kordinals.DOSCALLS.618='DOS32IPROTECTSETFILEINFO'
kordinals.DOSCALLS.619='DOS32IPROTECTSETFHSTATE'
kordinals.DOSCALLS.620='DOS32IPROTECTQUERYFHSTATE'
kordinals.DOSCALLS.621='DOS32PROTECTSETFILEPTR'
kordinals.DOSCALLS.622='DOSPROTECTCLOSE'
kordinals.DOSCALLS.623='DOSPROTECTFILEIO'
kordinals.DOSCALLS.624='DOSPROTECTFILELOCKS'
kordinals.DOSCALLS.625='DOSIPROTECTREAD'
kordinals.DOSCALLS.626='DOSIPROTECTWRITE'
kordinals.DOSCALLS.627='DOSPROTECTNEWSIZE'
kordinals.DOSCALLS.628='DOSPROTECTOPEN'
kordinals.DOSCALLS.629='DOSPROTECTQFHANDSTATE'
kordinals.DOSCALLS.630='DOSPROTECTSETFHANDSTATE'
kordinals.DOSCALLS.631='DOSPROTECTQFILEINFO'
kordinals.DOSCALLS.632='DOSPROTECTSETFILEINFO'
kordinals.DOSCALLS.634='DOSPROTECTCHGFILEPTR'
kordinals.DOSCALLS.635='DOSPROTECTENUMATTRIBUTE'
kordinals.DOSCALLS.636='DOS32PROTECTENUMATTRIBUTE'
kordinals.DOSCALLS.637='DOS32PROTECTOPEN'
kordinals.DOSCALLS.638='DOS32PROTECTCLOSE'
kordinals.DOSCALLS.639='DOS32PROTECTSETFILELOCKS'
kordinals.DOSCALLS.640='DOS32PROTECTSETFILESIZE'
kordinals.DOSCALLS.641='DOS32PROTECTREAD'
kordinals.DOSCALLS.642='DOS32PROTECTWRITE'
kordinals.DOSCALLS.643='DOS32PROTECTSETFILEINFO'
kordinals.DOSCALLS.644='DOS32PROTECTSETFHSTATE'
kordinals.DOSCALLS.645='DOS32PROTECTQUERYFHSTATE'
kordinals.DOSCALLS.646='DOS32PROTECTQUERYFILEINFO'
kordinals.DOSCALLS.647='DOS32IPROTECTREAD'
kordinals.DOSCALLS.649='MSGCLOSEMESSAGEFILE'
kordinals.DOSCALLS.650='DOSLDRDIRTYWORKER'
kordinals.DOSCALLS.651='DOS16LDRDIRTYWORKER'
kordinals.DOSCALLS.661='QUEDOS32READQUEUE'
kordinals.DOSCALLS.662='QUEDOS32PURGEQUEUE'
kordinals.DOSCALLS.663='QUEDOS32CLOSEQUEUE'
kordinals.DOSCALLS.664='QUEDOS32QUERYQUEUE'
kordinals.DOSCALLS.665='QUEDOS32PEEKQUEUE'
kordinals.DOSCALLS.666='QUEDOS32WRITEQUEUE'
kordinals.DOSCALLS.667='QUEDOS32OPENQUEUE'
kordinals.DOSCALLS.668='QUEDOS32CREATEQUEUE'
kordinals.DOSCALLS.669='SMGDOS32STARTSESSION'
kordinals.DOSCALLS.670='SMGDOS32SELECTSESSION'
kordinals.DOSCALLS.671='SMGDOS32SETSESSION'
kordinals.DOSCALLS.672='SMGDOS32STOPSESSION'
kordinals.DOSCALLS.673='SMGREGISTERNOTIFICATION'
kordinals.DOSCALLS.674='QUEDOSREADQUEUE'
kordinals.DOSCALLS.675='QUEDOSPURGEQUEUE'
kordinals.DOSCALLS.676='QUEDOSCLOSEQUEUE'
kordinals.DOSCALLS.677='QUEDOSQUERYQUEUE'
kordinals.DOSCALLS.678='QUEDOSPEEKQUEUE'
kordinals.DOSCALLS.679='QUEDOSWRITEQUEUE'
kordinals.DOSCALLS.680='QUEDOSOPENQUEUE'
kordinals.DOSCALLS.681='QUEDOSCREATEQUEUE'
kordinals.DOSCALLS.682='CHRDOSSMGETME'
kordinals.DOSCALLS.683='CHRDOSSMFREEMEM'
kordinals.DOSCALLS.684='CHRDOSSMGETSGCB'
kordinals.DOSCALLS.685='CHRDOSSMINITSGCB'
kordinals.DOSCALLS.686='SMGDOSSMSGDOPOPUP'
kordinals.DOSCALLS.687='SMGDOSSMSWITCH'
kordinals.DOSCALLS.688='SMGDOSSMSERVEAPPREQ'
kordinals.DOSCALLS.689='SMGDOSGETTIMES'
kordinals.DOSCALLS.690='SMGDOSSMSETTITLE'
kordinals.DOSCALLS.691='SMGDOSSCRUNLOCK'
kordinals.DOSCALLS.692='SMGDOSSMDOAPPREQ'
kordinals.DOSCALLS.693='SMGDOSSTOPSESSION'
kordinals.DOSCALLS.694='SMGDOSSELECTSESSION'
kordinals.DOSCALLS.695='SMGDOSSCRLOCK'
kordinals.DOSCALLS.696='SMGDOSSAVREDRAWWAIT'
kordinals.DOSCALLS.697='SMGDOSSAVREDRAWUNDO'
kordinals.DOSCALLS.698='SMGDOSSMSGENDPOPUP'
kordinals.DOSCALLS.699='SMGDOSSETSESSION'
kordinals.DOSCALLS.700='SMGDOSSETMNLOCKTIME'
kordinals.DOSCALLS.701='SMGDOSMODEUNDO'
kordinals.DOSCALLS.702='SMGDOSSTARTSESSION'
kordinals.DOSCALLS.703='SMGDOSSMGETSTATUS'
kordinals.DOSCALLS.704='SMGDOSSMMODEWAIT'
kordinals.DOSCALLS.705='SMGDOSSMTERMINATE'
kordinals.DOSCALLS.706='SMGDOSSMGETAPPREQ'
kordinals.DOSCALLS.707='SMGDOSSMINITIALIZE'
kordinals.DOSCALLS.708='SMGDOSSMSTART'
kordinals.DOSCALLS.709='SMGDOSSMPARENTSWITCH'
kordinals.DOSCALLS.710='SMGDOSSMPAUSE'
kordinals.DOSCALLS.711='SMGDOSSMHDEINIT'
kordinals.DOSCALLS.712='SMGDOSSMPMPRESENT'
kordinals.DOSCALLS.713='SMGDOSSMREGISTERDD'
kordinals.DOSCALLS.714='SMGDOSSMNOTIFYDD'
kordinals.DOSCALLS.715='SMGDOSSMNOTIFYDD2'
kordinals.DOSCALLS.716='SMGDOSSMOPENDD'
kordinals.DOSCALLS.717='SMGDOSSMSETSESSIONTYPE'
kordinals.DOSCALLS.718='CHRBASEINIT'
kordinals.DOSCALLS.719='MOUDOSGETPTRSHAPE'
kordinals.DOSCALLS.720='MOUDOSSETPTRSHAPE'
kordinals.DOSCALLS.721='MOUDOSGETNUMMICKEYS'
kordinals.DOSCALLS.722='MOUDOSGETTHRESHOLD'
kordinals.DOSCALLS.723='MOUDOSSHELLINIT'
kordinals.DOSCALLS.724='MOUDOSGETSCALEFACT'
kordinals.DOSCALLS.725='MOUDOSFLUSHQUE'
kordinals.DOSCALLS.726='MOUDOSGETNUMBUTTONS'
kordinals.DOSCALLS.727='MOUDOSCLOSE'
kordinals.DOSCALLS.728='MOUDOSSETTHRESHOLD'
kordinals.DOSCALLS.729='MOUDOSSETSCALEFACT'
kordinals.DOSCALLS.730='MOUDOSGETNUMQUEEL'
kordinals.DOSCALLS.731='MOUDOSDEREGISTER'
kordinals.DOSCALLS.732='MOUDOSGETEVENTMASK'
kordinals.DOSCALLS.733='MOUDOSSETEVENTMASK'
kordinals.DOSCALLS.734='MOUDOSOPEN'
kordinals.DOSCALLS.735='MOUDOSREMOVEPTR'
kordinals.DOSCALLS.736='MOUDOSGETPTRPOS'
kordinals.DOSCALLS.737='MOUDOSREADEVENTQUE'
kordinals.DOSCALLS.738='MOUDOSSETPTRPOS'
kordinals.DOSCALLS.739='MOUDOSGETDEVSTATUS'
kordinals.DOSCALLS.740='MOUDOSSYNCH'
kordinals.DOSCALLS.741='MOUDOSREGISTER'
kordinals.DOSCALLS.742='MOUDOSSETDEVSTATUS'
kordinals.DOSCALLS.743='MOUDOSDRAWPTR'
kordinals.DOSCALLS.744='MOUDOSINITREAL'
kordinals.DOSCALLS.745='KBDDOSSETCUSTXT'
kordinals.DOSCALLS.746='KBDDOSPROCESSINIT'
kordinals.DOSCALLS.747='KBDDOSGETCP'
kordinals.DOSCALLS.748='KBDDOSCHARIN'
kordinals.DOSCALLS.749='KBDDOSSETCP'
kordinals.DOSCALLS.750='KBDDOSLOADINSTANCE'
kordinals.DOSCALLS.751='KBDDOSSYNCH'
kordinals.DOSCALLS.752='KBDDOSREGISTER'
kordinals.DOSCALLS.753='KBDDOSSTRINGIN'
kordinals.DOSCALLS.754='KBDDOSGETSTATUS'
kordinals.DOSCALLS.755='KBDDOSSETSTATUS'
kordinals.DOSCALLS.756='KBDDOSGETFOCUS'
kordinals.DOSCALLS.757='KBDDOSFLUSHBUFFER'
kordinals.DOSCALLS.758='KBDDOSXLATE'
kordinals.DOSCALLS.759='KBDDOSSWITCHFGND'
kordinals.DOSCALLS.760='KBDDOSSHELLINIT'
kordinals.DOSCALLS.761='KBDDOSCLOSE'
kordinals.DOSCALLS.762='KBDDOSFREEFOCUS'
kordinals.DOSCALLS.763='KBDDOSFREE'
kordinals.DOSCALLS.764='KBDDOSDEREGISTER'
kordinals.DOSCALLS.765='KBDDOSSETFGND'
kordinals.DOSCALLS.766='KBDDOSPEEK'
kordinals.DOSCALLS.767='KBDDOSOPEN'
kordinals.DOSCALLS.768='KBDDOSGETHWID'
kordinals.DOSCALLS.769='KBDDOSSETHWID'
kordinals.DOSCALLS.770='VIODOSENDPOPUP'
kordinals.DOSCALLS.771='VIODOSGETPHYSBUF'
kordinals.DOSCALLS.772='VIODOSGETANSI'
kordinals.DOSCALLS.773='VIODOSFREE'
kordinals.DOSCALLS.774='VIODOSSETANSI'
kordinals.DOSCALLS.775='VIODOSDEREGISTER'
kordinals.DOSCALLS.776='VIODOSSCROLLUP'
kordinals.DOSCALLS.777='VIODOSPRTSC'
kordinals.DOSCALLS.778='VIODOSGETCURPOS'
kordinals.DOSCALLS.779='VIODOSWRTCELLSTR'
kordinals.DOSCALLS.780='VIODOSPOPUP'
kordinals.DOSCALLS.781='VIODOSSCROLLRT'
kordinals.DOSCALLS.782='VIODOSWRTCHARSTR'
kordinals.DOSCALLS.783='VIODOSAVS_PRTSC'
kordinals.DOSCALLS.784='VIODOSSETCURPOS'
kordinals.DOSCALLS.785='VIODOSSRFUNBLOCK'
kordinals.DOSCALLS.786='VIODOSSRFBLOCK'
kordinals.DOSCALLS.787='VIODOSSCRUNLOCK'
kordinals.DOSCALLS.788='VIODOSWRTTTY'
kordinals.DOSCALLS.789='VIODOSSAVE'
kordinals.DOSCALLS.790='VIODOSGETMODE'
kordinals.DOSCALLS.791='VIODOSSETMODE'
kordinals.DOSCALLS.792='VIODOSSCRLOCK'
kordinals.DOSCALLS.793='VIODOSREADCELLSTR'
kordinals.DOSCALLS.794='VIODOSSAVREDRAWWAIT'
kordinals.DOSCALLS.795='VIODOSWRTNATTR'
kordinals.DOSCALLS.796='VIODOSGETCURTYPE'
kordinals.DOSCALLS.797='VIODOSSAVREDRAWUNDO'
kordinals.DOSCALLS.798='VIODOSGETFONT'
kordinals.DOSCALLS.799='VIODOSREADCHARSTR'
kordinals.DOSCALLS.800='VIODOSGETBUF'
kordinals.DOSCALLS.801='VIODOSSETCURTYPE'
kordinals.DOSCALLS.802='VIODOSSETFONT'
kordinals.DOSCALLS.803='VIODOSHETINIT'
kordinals.DOSCALLS.804='VIODOSMODEUNDO'
kordinals.DOSCALLS.805='VIODOSSSWSWITCH'
kordinals.DOSCALLS.806='VIODOSMODEWAIT'
kordinals.DOSCALLS.807='VIODOSAVS_PRTSCTOGGLE'
kordinals.DOSCALLS.808='VIODOSGETCP'
kordinals.DOSCALLS.809='VIODOSRESTORE'
kordinals.DOSCALLS.810='VIODOSSETCP'
kordinals.DOSCALLS.811='VIODOSSHOWBUF'
kordinals.DOSCALLS.812='VIODOSSCROLLLF'
kordinals.DOSCALLS.813='VIODOSREGISTER'
kordinals.DOSCALLS.814='VIODOSGETCONFIG'
kordinals.DOSCALLS.815='VIODOSSCROLLDN'
kordinals.DOSCALLS.816='VIODOSWRTCHARSTRATT'
kordinals.DOSCALLS.817='VIODOSGETSTATE'
kordinals.DOSCALLS.818='VIODOSPRTSCTOGGLE'
kordinals.DOSCALLS.819='VIODOSSETSTATE'
kordinals.DOSCALLS.820='VIODOSWRTNCELL'
kordinals.DOSCALLS.821='VIODOSWRTNCHAR'
kordinals.DOSCALLS.822='VIODOSSHELLINIT'
kordinals.DOSCALLS.823='VIODOSASSOCIATE'
kordinals.DOSCALLS.824='VIODOSCREATEPS'
kordinals.DOSCALLS.825='VIODOSDELETESETID'
kordinals.DOSCALLS.826='VIODOSGETDEVICECELLSIZE'
kordinals.DOSCALLS.827='VIODOSGETORG'
kordinals.DOSCALLS.828='VIODOSCREATELOGFONT'
kordinals.DOSCALLS.829='VIODOSDESTROYPS'
kordinals.DOSCALLS.830='VIODOSQUERYSETIDS'
kordinals.DOSCALLS.831='VIODOSSETORG'
kordinals.DOSCALLS.832='VIODOSQUERYFONTS'
kordinals.DOSCALLS.833='VIODOSSETDEVICECELLSIZE'
kordinals.DOSCALLS.834='VIODOSSHOWPS'
kordinals.DOSCALLS.835='VIODOSGETPSADDRESS'
kordinals.DOSCALLS.836='VIODOSQUERYCONSOLE'
kordinals.DOSCALLS.837='VIODOSREDRAWSIZE'
kordinals.DOSCALLS.838='VIODOSGLOBALREG'
kordinals.DOSCALLS.839='XVIODOSSETCASTATE'
kordinals.DOSCALLS.840='XVIODOSCHECKCHARTYPE'
kordinals.DOSCALLS.841='XVIODOSDESTROYCA'
kordinals.DOSCALLS.842='XVIODOSCREATECA'
kordinals.DOSCALLS.843='VIOCDOSHECKCHARTYPE'
kordinals.DOSCALLS.844='XVIODOSGETCASTATE'
kordinals.DOSCALLS.845='BVSDOSMAIN'
kordinals.DOSCALLS.846='BVSDOSREDRAWSIZE'
kordinals.DOSCALLS.847='BVSDOSGETPTRDRAWNAME'
kordinals.DOSCALLS.848='ANSIDOSINJECT'
kordinals.DOSCALLS.849='ANSIDOSKEYDEF'
kordinals.DOSCALLS.850='ANSIDOSINTERP'
kordinals.DOSCALLS.851='BKSDOSMAIN'
kordinals.DOSCALLS.852='BMSDOSMAIN'
kordinals.DOSCALLS.853='MOUDOSGETHOTKEY'
kordinals.DOSCALLS.854='MOUDOSSETHOTKEY'
kordinals.DOSCALLS.855='SMGDOSSMSYSINIT'
kordinals.DOSCALLS.856='SMGQHKEYBDHANDLE'
kordinals.DOSCALLS.857='SMGQHMOUSEHANDLE'
kordinals.DOSCALLS.858='CHRQueueRamSem'
kordinals.DOSCALLS.859='CHRArray'
kordinals.DOSCALLS.860='CHRPIDArray'
kordinals.DOSCALLS.861='CHRInitialized'
kordinals.DOSCALLS.862='CHRArraySize'
kordinals.DOSCALLS.863='CHRBVSGLOBAL'
kordinals.DOSCALLS.864='CHRSMGINSTANCE'
kordinals.DOSCALLS.865='CHRBVHINSTANCE'
kordinals.DOSCALLS.115='THK32ALLOCMEM'
kordinals.DOSCALLS.116='THK32FREEMEM'
kordinals.DOSCALLS.117='THK32ALLOCSTACK'
kordinals.DOSCALLS.262='THK32FREESTACK'
kordinals.DOSCALLS.546='THK32STRLEN'
kordinals.DOSCALLS.547='THK32_UNITHUNK'
kordinals.DOSCALLS.578='HT16_CLEANUP'
kordinals.DOSCALLS.579='HT32_STARTUP'
kordinals.DOSCALLS.581='HT32_CLEANUP'
kordinals.DOSCALLS.590='DOS32PMPOSTEVENTSEM'
kordinals.DOSCALLS.591='DOS32PMWAITEVENTSEM'
kordinals.DOSCALLS.593='DOS32PMREQUESTMUTEXSEM'
kordinals.DOSCALLS.595='DOS32PMWAITMUXWAITSEM'
kordinals.DOSCALLS.596='DOS32PM16SEMCHK'
kordinals.DOSCALLS.866='THK32ALIASMEM'
kordinals.DOSCALLS.867='THK32FREEALIAS'
kordinals.DOSCALLS.868='THK32ALLOCVARLEN'
kordinals.DOSCALLS.869='THK32HANDLEBOUNDARY'
kordinals.DOSCALLS.870='THK32HANDLESTRING'
kordinals.DOSCALLS.871='THK32DEALLOC'
kordinals.DOSCALLS.872='THK32XHNDLR'
kordinals.DOSCALLS.873='DOS32SETEXTLIBPATH'
kordinals.DOSCALLS.874='DOS32QUERYEXTLIBPATH'
kordinals.DOSCALLS.875='DOS32PM16SEMRST'
kordinals.DOSCALLS.876='DOS32SYSCTL'
kordinals.DOSCALLS.998='DOSSETEXTLIBPATH'
kordinals.DOSCALLS.999='DOSQUERYEXTLIBPATH'
kordinals.DOSCALLS.1000='T32EXITLIST'
kordinals.DOSCALLS.1001='T32ALLOCPROTECTEDMEM'
kordinals.DOSCALLS.1002='T32ALIASMEM'
kordinals.DOSCALLS.1003='T32ALLOCMEM'
kordinals.DOSCALLS.1004='T32ALLOCSHAREDMEM'
kordinals.DOSCALLS.1005='T32GETNAMEDSHAREDMEM'
kordinals.DOSCALLS.1006='T32GETSHAREDMEM'
kordinals.DOSCALLS.1007='T32GIVESHAREDMEM'
kordinals.DOSCALLS.1008='T32FREEMEM'
kordinals.DOSCALLS.1009='T32SETMEM'
kordinals.DOSCALLS.1010='T32QUERYMEM'
kordinals.DOSCALLS.1011='T32QUERYMEMSTATE'
kordinals.DOSCALLS.1012='T32OPENVDD'
kordinals.DOSCALLS.1013='T32REQUESTVDD'
kordinals.DOSCALLS.1014='T32CLOSEVDD'
kordinals.DOSCALLS.1015='T32CREATETHREAD'
kordinals.DOSCALLS.1016='T32DYNAMICTRACE'
kordinals.DOSCALLS.1017='T32DEBUG'
kordinals.DOSCALLS.1018='T32QUERYPROCADDR'
kordinals.DOSCALLS.1019='T32CREATEEVENTSEM'
kordinals.DOSCALLS.1020='T32OPENEVENTSEM'
kordinals.DOSCALLS.1021='T32CLOSEEVENTSEM'
kordinals.DOSCALLS.1022='T32RESETEVENTSEM'
kordinals.DOSCALLS.1023='T32POSTEVENTSEM'
kordinals.DOSCALLS.1024='T32WAITEVENTSEM'
kordinals.DOSCALLS.1025='T32QUERYEVENTSEM'
kordinals.DOSCALLS.1026='T32CREATEMUTEXSEM'
kordinals.DOSCALLS.1027='T32OPENMUTEXSEM'
kordinals.DOSCALLS.1028='T32CLOSEMUTEXSEM'
kordinals.DOSCALLS.1029='T32REQUESTMUTEXSEM'
kordinals.DOSCALLS.1030='T32RELEASEMUTEXSEM'
kordinals.DOSCALLS.1031='T32QUERYMUTEXSEM'
kordinals.DOSCALLS.1032='T32CREATEMUXWAITSEM'
kordinals.DOSCALLS.1033='T32OPENMUXWAITSEM'
kordinals.DOSCALLS.1034='T32CLOSEMUXWAITSEM'
kordinals.DOSCALLS.1035='T32WAITMUXWAITSEM'
kordinals.DOSCALLS.1036='T32ADDMUXWAITSEM'
kordinals.DOSCALLS.1037='T32DELETEMUXWAITSEM'
kordinals.DOSCALLS.1038='T32QUERYMUXWAITSEM'
kordinals.DOSCALLS.1039='T32QUERYSYSINFO'
kordinals.DOSCALLS.1040='T32WAITTHREAD'
kordinals.DOSCALLS.1041='T32GETRESOURCE'
kordinals.DOSCALLS.1042='T32FREERESOURCE'
kordinals.DOSCALLS.1043='T32EXCEPTIONCALLBACK'
kordinals.DOSCALLS.1044='T32QUERYPAGEUSAGE'
kordinals.DOSCALLS.1045='T32FORCESYSTEMDUMP'
kordinals.DOSCALLS.1046='TI32ASYNCTIMER'
kordinals.DOSCALLS.1047='TI32STARTTIMER'
kordinals.DOSCALLS.1048='T32QUERYABIOSSUPPORT'
kordinals.DOSCALLS.1049='T32QUERYMODFROMEIP'
kordinals.DOSCALLS.1050='T32ALIASPERFCTRS'
kordinals.DOSCALLS.1051='T32CONFIGUREPERF'
kordinals.DOSCALLS.1052='T32DECONPERF'
kordinals.DOSCALLS.1053='T32REGISTERPERFCTRS'
kordinals.DOSCALLS.1054='T32QUERYSYSSTATE'
kordinals.DOSCALLS.1055='T32IREAD'
kordinals.DOSCALLS.1056='T32IWRITE'
kordinals.DOSCALLS.1057='T32TMRQUERYFREQ'
kordinals.DOSCALLS.1058='T32TMRQUERYTIME'
kordinals.DOSCALLS.1059='T32IMONREAD'
kordinals.DOSCALLS.1060='T32IMONWRITE'
kordinals.DOSCALLS.1061='T32QUERYRESOURCESIZE'
kordinals.DOSCALLS.1062='T32PROFILE'
kordinals.DOSCALLS.1063='T32SETSIGNALEXCEPTIONFOC'
kordinals.DOSCALLS.1064='T32SENDSIGNALEXCEPTION'
kordinals.DOSCALLS.1065='T32STARTTIMER'
kordinals.DOSCALLS.1066='T32STOPTIMER'
kordinals.DOSCALLS.1067='T32ASYNCTIMER'
kordinals.DOSCALLS.1068='T32INITIALIZEPORTHOLE'
kordinals.DOSCALLS.1069='T32QUERYHEADERINFO'
kordinals.DOSCALLS.1070='T32QUERYPROCTYPE'
kordinals.DOSCALLS.1071='T32IEXITMUSTCOMPLETE'
kordinals.DOSCALLS.1072='T32ICACHEMODULE'
kordinals.DOSCALLS.1073='T32DLLTERM'
kordinals.DOSCALLS.1074='T32IRAISEEXCEPTION'
kordinals.DOSCALLS.1075='T32ACKNOWLEDGESIGNALEXC'
kordinals.DOSCALLS.1076='T32QUERYDOSPROPERTY'
kordinals.DOSCALLS.1077='T32SETDOSPROPERTY'
kordinals.DOSCALLS.1078='T32SETFILELOCKS'
kordinals.DOSCALLS.1079='T32CANCELLOCKREQUEST'
kordinals.DOSCALLS.1080='T32KILLTHREAD'
kordinals.DOSCALLS.1081='TQUERYRASINFO'
kordinals.DOSCALLS.1082='T32DUMPPROCESS'
kordinals.DOSCALLS.1083='T32SUPPRESSPOPUPS'
kordinals.DOSCALLS.1084='T32IPROTECTWRITE'
kordinals.DOSCALLS.1085='T32PROTECTSETFILELOCKS'
kordinals.DOSCALLS.1086='T32IPROTECTREAD'
kordinals.DOSCALLS.1087='T32PMPOSTEVENTSEM'
kordinals.DOSCALLS.1088='T32PMWAITEVENTSEM'
kordinals.DOSCALLS.1089='T32PMREQUESTMUTEXSEM'
kordinals.DOSCALLS.1090='T32PMWAITMUXWAITSEM'
kordinals.DOSCALLS.1091='T32PM16SEMCHK'
kordinals.DOSCALLS.1092='T32ALLOCTHREADLOCALMEMORY'
kordinals.DOSCALLS.1093='T32FREETHREADLOCALMEMORY'
kordinals.DOSCALLS.1094='T32SETEXTLIBPATH'
kordinals.DOSCALLS.1095='T32QUERYEXTLIBPATH'
kordinals.DOSCALLS.1096='T32PM16SEMRST'
kordinals.DOSCALLS.1097='T32VERIFYPIDTID'
kordinals.DOSCALLS.1098='T32SYSCTL'

return
