/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* DEM SVC Cross reference. */

signal on halt name haltexit

arg svc .

if svc='?' then do
   say 'DEMSVC <svc>'
   exit 0
end /* do */

call initsvc

if svc='' then do
   do i=0 by 1
      svc=translate(right(d2x(i),2,'0'))
      if demsvcs.svc='' then leave
      else say 'SVC 0x'svc '==>' demsvcs.svc
   end /* do */
   exit 0
end /* do */

if left(svc,2)='0X' then svc=substr(svc,3)
else if right(svc,1)='T' then svc=d2x(left(svc,length(svc)-1))
else if datatype(svc,'x') then do
   say 'Invalid SVC number'
   say 'DEMSVC <svc>'
   exit 0
end /* do */

svc=right(svc,2,'0')

name=demsvcs.svc
if name='' then say 'SVC 0x'svc' not known'
else say 'SVC 0x'svc '==>' name

haltexit: exit 0

initsvc: procedure expose demsvcs.

demsvcs.=''

demsvcs.00='demDup'
demsvcs.01='demInternalError'
demsvcs.02='demTerminate'
demsvcs.03='demClose'
demsvcs.04='demDiskReset'
demsvcs.05='demSetCurrentPDB'
demsvcs.06='demSetDefaultDrive'
demsvcs.07='demSetDTA'
demsvcs.08='demGetVersion'
demsvcs.09='demWrite'
demsvcs.0A='demSetDate'
demsvcs.0B='demSetTime'
demsvcs.0C='demQueryDate'
demsvcs.0D='demQueryTime'
demsvcs.0E='demRead'
demsvcs.0F='demChgFilePtr'
demsvcs.10='demDeleteDir'
demsvcs.11='demCreateDir'
demsvcs.12='demQueryCurrentDir'
demsvcs.13='demSetCurrentDir'
demsvcs.14='demFileTimes'
demsvcs.15='demCommit'
demsvcs.16='demFindFirstFCB'
demsvcs.17='demFindNextFCB'
demsvcs.18='demGetDriveFreespace'
demsvcs.19='demFindFirst'
demsvcs.1A='demChMod'
demsvcs.1B='demNameTrans'
demsvcs.1C='demOpen'
demsvcs.1D='demDeleteFCB'
demsvcs.1E='demRenameFCB'
demsvcs.1F='demDelete'
demsvcs.20='demRename'
demsvcs.21='demGSetMediaID'
demsvcs.22='demIOCTL'
demsvcs.23='demGetDriveInfo'
demsvcs.24='demExtInfo'
demsvcs.25='demFCBOpen'
demsvcs.26='demFCBIO'
demsvcs.27='demFCBClose'
demsvcs.28='demFCBLength'
demsvcs.29='demGetBaseName'
demsvcs.2A='demDupJFT'
demsvcs.2B='demGetVisDrv'
demsvcs.2C='demSetWriteVerify'
demsvcs.2D='demFindNext'
demsvcs.2E='demCreateNew'
demsvcs.2F='demCreateTemp'
demsvcs.30='demSetV86KernelAddr'
demsvcs.31='demMakeFcb'
demsvcs.32='demGeneric'
demsvcs.33='demDosAbort'
demsvcs.34='demYield'
demsvcs.35='demSleep'
demsvcs.36='demInitNLS'
demsvcs.37='demSetCodePage'
demsvcs.38='demGetCountryInfo'
demsvcs.39='demLockOper'
demsvcs.3A='demEnumAttrib'
demsvcs.3B='demQMaxEASize'
demsvcs.3C='demGetDPB'
demsvcs.3D='demAbsDrd'
demsvcs.3E='demAbsDwrt'
demsvcs.3F='demExtHandle'
demsvcs.40='demJSA'
demsvcs.41='demVplCallibrate'
demsvcs.42='demGetMessage'
demsvcs.43='demSetTitle'
demsvcs.44='demSetEAField'
demsvcs.45='demQNMPInfo'
demsvcs.46='demQNMPHandState'
demsvcs.47='demSetNMPHandState'
demsvcs.48='demPeekNMP'
demsvcs.49='demTransactNMP'
demsvcs.4A='demCallNMP'
demsvcs.4B='demWaitNMP'
demsvcs.4C='demRawReadNMP'
demsvcs.4D='demRawWriteNMP'
demsvcs.4E='demSpecialEntries'
demsvcs.4F='demGetLogicalDriveCnt'
demsvcs.50='demVDMInt13Request'
demsvcs.51='demGetCDS'
demsvcs.52='demGetSFT'
demsvcs.53='demBlockDD'
demsvcs.54='demCopyEAs'
demsvcs.55='demSVCNOP'
return


