--------------------------------------------------------
-- PROPRIETARY/CONFIDENTIAL
-- Use of this product is subject to license terms
-- Copyright (c) 2001 SAP AG, Germany
-- All rights reserved
--
-- Schema used by the SAP Directory Interfaces for
-- - User Management
--
----------------------------------------------------------
-- History
--
-- Version 1: initial release
-- Version 2: conversion to .sch format
--
----------------------------------------------------------

SAPUSERSchemaExtensions DEFINITIONS ::=
BEGIN

"sapUsername" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 101}
}

"sapAlias" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 102}
}

"sapCompanyKey" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 103}
}

"birthName" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 104}
}

"buildingName" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{0 9 2342 19200300 100 1 48}
}

"commType" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 106}
}

"floor" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 107}
}

"salutation" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 108}
}

"inHouseMail" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 109}
}

"initialsSig" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 110}
}

"middleName" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 111}
}

"nickName" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 112}
}

"firstPrefix" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 113}
}

"secondPrefix" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 114}
}

"secondName" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 115}
}

"titleAcademic1" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 116}
}

"titleAcademic2" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 117}
}

"sapClass" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 119}
}

"sapValidTo" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 120}
}

"sapValidFrom" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 121}
}

"sapLanguage" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 122}
}

"sapTimeZone" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 123}
}

"sapUserType" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 124}
}

"sapCATT" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 125}
}

"sapDateFormat" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 126}
}

"sapDecimalFormat" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 127}
}

"sapLoginLanguage" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 129}
}

"sapPrintParam3" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 130}
}

"sapPrintParam2" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 131}
}

"sapSpool" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 132}
}

"sapPrintParam1" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 133}
}

"sapStartMenu" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 134}
}

"sapParameters" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 135}
}

"sapSncGuiFlag" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 136}
}

"sapSncName" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 137}
}

"sapRefUser" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 138}
}

"sapGroups" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 139}
}

"sapProfiles" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 140}
}

"sapRoles" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{1 3 6 1 4 1 694 2 1 141}
}

"DirXML-sapLocProfiles" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{2 16 840 1 113719 1 14 4 1 2100}
}

"DirXML-sapLocRoles" ATTRIBUTE ::=
{
	Operation		ADD,
	Flags			{DS_SYNC_IMMEDIATE},
	SyntaxID		SYN_CI_STRING,
	ASN1ObjID		{2 16 840 1 113719 1 14 4 1 2101}
}

"sapAddOnUM"	OBJECT-CLASS ::=
{
	Operation		ADD,
	Flags			{DS_AUXILIARY_CLASS},
	MustContain		{"Surname"},
	MayContain		{"sapUsername"},
	MayContain		{"sapAlias"},
	MayContain		{"sapCompanyKey"},
	MayContain		{"birthName"},
	MayContain		{"buildingName"},
	MayContain		{"commType"},
	MayContain		{"OU"},
	MayContain		{"Internet EMail Address"},
	MayContain		{"Facsimile Telephone Number"},
	MayContain		{"Given Name"},
	MayContain		{"floor"},
	MayContain		{"Title"},
	MayContain		{"inHouseMail"},
	MayContain		{"Initials"},
	MayContain		{"initialsSig"},
	MayContain		{"middleName"},
	MayContain		{"nickname"},
	MayContain		{"firstPrefix"},
	MayContain		{"secondPrefix"},
	MayContain		{"roomNumber"},
	MayContain		{"secondName"},
	MayContain		{"Telephone Number"},
	MayContain		{"titleAcademic1"},
	MayContain		{"titleAcademic2"},
	MayContain		{"salutation"},
	MayContain		{"personalTitle"},
	MayContain		{"NSCP:employeeNumber"},
	MayContain		{"sapClass"},
	MayContain		{"sapValidTo"},
	MayContain		{"sapValidFrom"},
	MayContain		{"sapLanguage"},
	MayContain		{"sapTimeZone"},
	MayContain		{"sapUserType"},
	MayContain		{"sapCATT"},
	MayContain		{"sapDateFormat"},
	MayContain		{"sapDecimalFormat"},
	MayContain		{"costCenter"},
	MayContain		{"sapLoginLanguage"},
	MayContain		{"sapPrintParam3"},
	MayContain		{"sapPrintParam2"},
	MayContain		{"sapPrintParam1"},
	MayContain		{"sapSpool"},
	MayContain		{"sapStartMenu"},
	MayContain		{"sapParameters"},
	MayContain		{"sapSncGuiFlag"},
	MayContain		{"sapSncName"},
	MayContain		{"sapRefUser"},
	MayContain		{"sapGroups"},
	MayContain		{"sapProfiles"},
	MayContain		{"sapRoles"},
	MayContain		{"DirXML-sapLocProfiles"},
	MayContain		{"DirXML-sapLocRoles"},
	ASN1ObjID		{1 3 6 1 4 1 694 2 2 6}
}

END
