/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ndssnapins.loginMethods.WeakPassword;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.common.ui.AdminPage;
import com.novell.admin.ndssnapins.loginMethods.WeakPassword.WeakPassword;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.Rights;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSObjectRights;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.PageSnapin;
import com.novell.application.console.widgets.NVerticalFlowLayout;
import com.novell.application.console.widgets.NWrapLabel;
import com.novell.security.japi.nmas.NMASWrap;
import com.novell.utility.localization.Loc;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;

public final class WeakPasswordPanel
extends AdminPage
implements ItemListener,
ActionListener,
KeyListener {
    private String treeName;
    private String userDN;
    private NSObject userObj;
    private ObjectEntryCollection oec;
    private String noRightsLabel = WeakPassword.getString("WeakPassword_NO_RIGHTS_LABEL");
    private NDSObjectAttribute hostServerAttrib = null;
    private JRadioButton setPasswordRB;
    private JRadioButton removePasswordRB;
    private JCheckBox forcePasswordChangeCB;
    private JPasswordField entryTF;
    private JPasswordField confirmTF;
    private JLabel entryLabel;
    private JLabel confirmLabel;
    private JPanel entryPanel;
    private JPanel confirmPanel;
    private boolean debug = false;
    private boolean hasAdminRights = false;
    private boolean hasWriteRights = true;
    private boolean simplePasswordAssigned = false;
    private boolean AllowModified = false;
    private boolean passwordModified = false;
    private boolean flagsModified = false;
    private boolean initializationComplete = false;
    private boolean multipleUsers = false;
    private Color ColorOn;
    private Color ColorOff;
    private Rights[] rights;
    private NDSNamespace ns;
    private ObjectEntry oe;
    private byte passwordFlags = 0;

    public WeakPasswordPanel(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject, ObjectEntryCollection objectEntryCollection) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
        this.oec = objectEntryCollection;
        this.multipleUsers = objectEntryCollection.hasMultipleElements();
        this.oe = objectEntryCollection.getFirstElement();
        this.ns = (NDSNamespace)this.oe.getObjectType().getNamespace();
        this.treeName = this.oe.getRoot().getName();
        this.userDN = this.ns.getUnrootedName(this.oe);
        this.userObj = nSObject;
        this.printDebuggingLine("tree: " + this.treeName + "   user: " + this.userDN);
        ((Container)((Object)this)).setLayout((LayoutManager)new NVerticalFlowLayout(true, 5));
    }

    protected void layoutControls() {
        NWrapLabel nWrapLabel = new NWrapLabel(WeakPassword.getString("WeakPassword_INSTRUCTIONS"));
        nWrapLabel.setMaxWidth(615);
        this.forcePasswordChangeCB = NConeFactory.novellJCheckBox((JCheckBox)new JCheckBox(), (String)Loc.removeHotChar((String)WeakPassword.getString("WeakPassword_FORCE_CHANGE_LABEL")), (String)"This is a check box");
        Loc.setText((AbstractButton)this.forcePasswordChangeCB, (String)WeakPassword.getString("WeakPassword_FORCE_CHANGE_LABEL"));
        this.forcePasswordChangeCB.setSelected(false);
        this.forcePasswordChangeCB.addItemListener(this);
        this.entryLabel = new JLabel(WeakPassword.getString("WeakPassword_ENTRY_LABEL"));
        Dimension dimension = this.entryLabel.getPreferredSize();
        this.confirmLabel = new JLabel(WeakPassword.getString("WeakPassword_CONFIRM_LABEL"));
        Dimension dimension2 = this.confirmLabel.getPreferredSize();
        int n = Math.max(dimension.width, dimension2.width);
        Dimension dimension3 = new Dimension(n, dimension.height);
        this.entryLabel.setPreferredSize(dimension3);
        this.confirmLabel.setPreferredSize(dimension3);
        this.entryTF = new JPasswordField(20);
        this.entryTF.addKeyListener(this);
        NConeFactory.makeRelation((JLabel)this.entryLabel, (JPasswordField)this.entryTF);
        this.confirmTF = new JPasswordField(20);
        this.confirmTF.addKeyListener(this);
        NConeFactory.makeRelation((JLabel)this.confirmLabel, (JPasswordField)this.confirmTF);
        this.setPasswordRB = NConeFactory.novellJRadioButton((JRadioButton)new JRadioButton(), (String)Loc.removeHotChar((String)WeakPassword.getString("WeakPassword_SET_PASSWORD_LABEL")), (String)"This is a JRadioButton");
        Loc.setText((AbstractButton)this.setPasswordRB, (String)WeakPassword.getString("WeakPassword_SET_PASSWORD_LABEL"));
        this.setPasswordRB.addItemListener(this);
        this.removePasswordRB = NConeFactory.novellJRadioButton((JRadioButton)new JRadioButton(), (String)Loc.removeHotChar((String)WeakPassword.getString("WeakPassword_REMOVE_PASSWORD_LABEL")), (String)"This is a JRadioButton");
        Loc.setText((AbstractButton)this.removePasswordRB, (String)WeakPassword.getString("WeakPassword_REMOVE_PASSWORD_LABEL"));
        this.removePasswordRB.addItemListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.setPasswordRB);
        buttonGroup.add(this.removePasswordRB);
        this.setPasswordRB.setSelected(true);
        NVerticalFlowLayout nVerticalFlowLayout = new NVerticalFlowLayout(true, 5);
        nVerticalFlowLayout.setExternalPadLeft(10);
        JPanel jPanel = new JPanel((LayoutManager)nVerticalFlowLayout);
        jPanel.add((Component)nWrapLabel);
        jPanel.add(this.setPasswordRB);
        this.entryPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.entryPanel.add(this.entryLabel);
        this.entryPanel.add(this.entryTF);
        this.confirmPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.confirmPanel.add(this.confirmLabel);
        this.confirmPanel.add(this.confirmTF);
        this.ColorOff = this.entryLabel.getBackground();
        this.ColorOn = this.entryTF.getBackground();
        NVerticalFlowLayout nVerticalFlowLayout2 = new NVerticalFlowLayout(true, 5);
        nVerticalFlowLayout2.setExternalPadLeft(25);
        JPanel jPanel2 = new JPanel((LayoutManager)nVerticalFlowLayout2);
        jPanel2.add(this.forcePasswordChangeCB);
        jPanel2.add(this.entryPanel);
        jPanel2.add(this.confirmPanel);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 10, 0));
        jPanel3.add(this.removePasswordRB);
        ((Container)((Object)this)).add(jPanel, "Left");
        ((Container)((Object)this)).add(jPanel2, "Left");
        ((Container)((Object)this)).add(jPanel3, "Left");
    }

    protected void readData() {
        int[] nArray = new int[1];
        if (!this.multipleUsers) {
            int[] nArray2 = new int[1];
            byte[] byArray = new byte[1];
            int n = NMASWrap.NMAS_GetLoginConfig((String)this.treeName, (String)this.userDN, (int)4, (int[])WeakPassword.MethodID, (String)"Password FLags", (int)1, (int[])nArray2, (byte[])byArray);
            this.passwordFlags = n != 0 ? (n == -1665 ? (byte)0 : 0) : byArray[0];
            byte[] byArray2 = new byte[512];
            n = NMASWrap.NMAS_GetLoginConfig((String)this.treeName, (String)this.userDN, (int)4, (int[])WeakPassword.MethodID, (String)"Password Hash", (int)512, (int[])nArray2, (byte[])byArray2);
            this.simplePasswordAssigned = n == 0;
        }
    }

    public void setActive(boolean bl) {
        this.printDebuggingLine("setActive.isFirstTimeShown: " + bl);
        super.setActive(bl);
        if (bl) {
            this.setPasswordRB.setSelected(true);
            if (this.multipleUsers) {
                this.forcePasswordChangeCB.setSelected(false);
            } else if (this.simplePasswordAssigned) {
                if ((this.passwordFlags & 1) != 0) {
                    this.forcePasswordChangeCB.setSelected(true);
                } else {
                    this.forcePasswordChangeCB.setSelected(false);
                }
            } else {
                this.forcePasswordChangeCB.setEnabled(true);
            }
            if (this.hasAdminRights || this.hasWriteRights) {
                this.setPasswordRB.setEnabled(true);
                this.removePasswordRB.setEnabled(true);
                this.forcePasswordChangeCB.setEnabled(true);
            } else {
                this.setPasswordRB.setEnabled(false);
                this.removePasswordRB.setEnabled(false);
                this.forcePasswordChangeCB.setEnabled(false);
            }
            this.enablePasswordTextFields(true);
        }
        this.initializationComplete = true;
    }

    protected void checkRights() throws SPIException {
        try {
            ObjectEntry objectEntry = this.ns.getAuthenticatedIdentity(this.oe);
            NDSObjectRights nDSObjectRights = (NDSObjectRights)this.ns.getObjectEffectiveRights(this.oe, objectEntry);
            this.hasAdminRights = nDSObjectRights.hasSupervisorRights();
            if (!this.hasAdminRights) {
                this.hasWriteRights = nDSObjectRights.hasWriteRights();
            }
            this.rights = this.ns.getPropertyEffectiveRights(this.oe, objectEntry, this.getHandledAttributeNames());
        }
        catch (SPIException sPIException) {
            this.printDebuggingLine("Got exception checking for admin rights.");
        }
    }

    public boolean killActive() {
        this.printDebuggingLine("killActive");
        return super.killActive();
    }

    public boolean saveData() {
        return true;
    }

    public boolean savePassword() {
        Object object;
        Object object2;
        if (this.setPasswordRB.isSelected()) {
            Object object3;
            object2 = this.entryTF.getPassword();
            int n = ((char[])object2).length;
            object = this.confirmTF.getPassword();
            int n2 = ((char[])object).length;
            boolean bl = false;
            if (this.passwordModified) {
                if (n != n2) {
                    bl = true;
                } else {
                    int n3 = 0;
                    while (n3 < n) {
                        if (object2[n3] != object[n3]) {
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                }
                if (bl) {
                    String string = WeakPassword.getString("WeakPassword_UNEQUAL_ERR_MSG");
                    NMsgBox nMsgBox = new NMsgBox((Component)this.shell.getShellFrame(), WeakPassword.getString("WeakPassword_UNEQUAL_ERROR_TITLE"), string, 3, null, null);
                    nMsgBox.show();
                    return true;
                }
            }
            if (this.multipleUsers) {
                object3 = new String((char[])object2);
                ObjectEntryEnumeration objectEntryEnumeration = this.oec.elements();
                while (objectEntryEnumeration.hasMoreElements()) {
                    ObjectEntry objectEntry = objectEntryEnumeration.next();
                    this.userDN = this.ns.getUnrootedName(objectEntry);
                    if (this.setPasswordRB.isSelected()) {
                        byte by = this.getPasswordFlagsForUser(this.treeName, this.userDN);
                        if (this.forcePasswordChangeCB.isSelected()) {
                            by = (byte)(by | 1);
                        } else {
                            int n4 = -2;
                            by = (byte)(by & n4);
                        }
                        if (this.passwordModified) {
                            this.setSimplePasswordForUser(this.treeName, this.userDN, (String)object3);
                        }
                        this.setPasswordFlagsForUser(this.treeName, this.userDN, by);
                        continue;
                    }
                    if (!this.removePasswordRB.isSelected()) continue;
                    this.removeSimplePasswordForUser(this.treeName, this.userDN);
                }
                object3 = "";
            } else {
                object3 = new String((char[])object2);
                if (this.passwordModified && this.setSimplePasswordForUser(this.treeName, this.userDN, (String)object3)) {
                    this.forcePasswordChangeCB.removeItemListener(this);
                    this.forcePasswordChangeCB.setEnabled(true);
                    this.forcePasswordChangeCB.addItemListener(this);
                }
                if (this.flagsModified) {
                    if (this.forcePasswordChangeCB.isSelected()) {
                        this.passwordFlags = (byte)(this.passwordFlags | 1);
                    } else {
                        int n5 = -2;
                        this.passwordFlags = (byte)(this.passwordFlags & n5);
                    }
                    this.setPasswordFlagsForUser(this.treeName, this.userDN, this.passwordFlags);
                }
                object3 = "";
            }
            if (n > 0) {
                object3 = new char[n];
                System.arraycopy(object3, 0, object2, 0, n);
            }
            if (n2 > 0) {
                object3 = new char[n2];
                System.arraycopy(object3, 0, object, 0, n2);
            }
            this.passwordModified = false;
            this.flagsModified = false;
        }
        if (this.removePasswordRB.isSelected()) {
            object2 = new NMsgBox((Component)this.shell.getShellFrame(), WeakPassword.getString("WeakPassword_REMOVE_PASSWORD_TITLE"), WeakPassword.getString("WeakPassword_REMOVE_PASSWORD_MSG"), 0, null, null);
            if (object2.launch() == 8) {
                object = this.oec.elements();
                while (object.hasMoreElements()) {
                    ObjectEntry objectEntry = object.next();
                    this.userDN = this.ns.getUnrootedName(objectEntry);
                    if (this.removeSimplePasswordForUser(this.treeName, this.userDN)) continue;
                }
            }
            ((JTextComponent)this.entryTF).setText("");
            ((JTextComponent)this.confirmTF).setText("");
            this.forcePasswordChangeCB.setEnabled(false);
            this.forcePasswordChangeCB.setSelected(false);
        }
        this.propertyBook.setModified(false, (PageSnapin)this.pageSnapin);
        return true;
    }

    public void setupMOD() {
        this.printDebuggingLine("seupMOD() called");
    }

    public void shutdownSnapin() {
        this.printDebuggingLine("shutdownSnapin");
        super.shutdownSnapin();
    }

    public String[] getHandledAttributeNames() {
        String[] stringArray = new String[]{"SAS:Login Configuration", "SAS:Login Configuration Key", "SAS:Login Secret", "SAS:Login Secret Key"};
        return stringArray;
    }

    protected boolean setSimplePasswordForUser(String string, String string2, String string3) {
        Object object;
        String string4 = WeakPassword.ClearTextID + string3 + "\u0000";
        byte[] byArray = string4.getBytes();
        string4 = "";
        int n = NMASWrap.NMAS_PutLoginConfig((String)this.treeName, (String)string2, (int)4, (int[])WeakPassword.MethodID, (String)"Password Hash", (int)byArray.length, (byte[])byArray);
        int n2 = byArray.length;
        if (n2 > 0) {
            object = new byte[n2];
            System.arraycopy(object, 0, byArray, 0, n2);
        }
        if (n != 0) {
            object = MessageFormat.format(WeakPassword.getString("WeakPassword_SAVE_PASSWORD_ERROR_MSG"), new Integer(n), string2);
            NMsgBox nMsgBox = new NMsgBox((Component)this.shell.getShellFrame(), WeakPassword.getString("WeakPassword_SAVE_PASSWORD_ERROR_TITLE"), (String)object, 3, null, null);
            nMsgBox.show();
            return false;
        }
        return true;
    }

    protected boolean setPasswordFlagsForUser(String string, String string2, byte by) {
        byte[] byArray = new byte[]{by};
        int n = NMASWrap.NMAS_PutLoginConfig((String)this.treeName, (String)string2, (int)4, (int[])WeakPassword.MethodID, (String)"Password FLags", (int)1, (byte[])byArray);
        if (n != 0) {
            String string3 = MessageFormat.format(WeakPassword.getString("WeakPassword_ERROR_SAVING_FLAGS_MSG"), new Integer(n), string2);
            NMsgBox nMsgBox = new NMsgBox((Component)this.shell.getShellFrame(), WeakPassword.getString("WeakPassword_ERROR_SAVING_FLAGS_TITLE"), string3, 3, null, null);
            nMsgBox.show();
            return false;
        }
        return true;
    }

    protected boolean removeSimplePasswordForUser(String string, String string2) {
        int n = NMASWrap.NMAS_DeleteLoginConfig((String)string, (String)string2, (int)4, (int[])WeakPassword.MethodID, (String)"Password Hash");
        if (n != 0 && n != -1665 && n != -603) {
            String string3 = MessageFormat.format(WeakPassword.getString("WeakPassword_PASSWORD_REMOVE_ERROR_MSG"), new Integer(n), string2);
            NMsgBox nMsgBox = new NMsgBox((Component)this.shell.getShellFrame(), WeakPassword.getString("WeakPassword_PASSWORD_REMOVE_ERROR_TITLE"), string3, 3, null, null);
            nMsgBox.show();
            return false;
        }
        n = NMASWrap.NMAS_DeleteLoginConfig((String)string, (String)string2, (int)4, (int[])WeakPassword.MethodID, (String)"Password FLags");
        if (n != 0 && n != -1665 && n != -603) {
            String string4 = MessageFormat.format(WeakPassword.getString("WeakPassword_PASSWORD_FLAGS_REMOVE_ERROR_MSG"), new Integer(n), string2);
            NMsgBox nMsgBox = new NMsgBox((Component)this.shell.getShellFrame(), WeakPassword.getString("WeakPassword_PASSWORD_FLAGS_REMOVE_ERROR_TITLE"), string4, 3, null, null);
            nMsgBox.show();
            return false;
        }
        return true;
    }

    protected byte getPasswordFlagsForUser(String string, String string2) {
        int[] nArray = new int[1];
        byte[] byArray = new byte[1];
        int n = NMASWrap.NMAS_GetLoginConfig((String)this.treeName, (String)string2, (int)4, (int[])WeakPassword.MethodID, (String)"Password FLags", (int)1, (int[])nArray, (byte[])byArray);
        if (n != 0) {
            this.passwordFlags = n == -1665 ? (byte)0 : 0;
        }
        return this.passwordFlags;
    }

    protected void printDebuggingLine(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    protected void enablePasswordTextFields(boolean bl) {
        Color color;
        Color color2 = color = bl ? this.ColorOn : this.ColorOff;
        if (this.hasAdminRights) {
            this.entryTF.setEnabled(bl);
            this.entryTF.setBackground(color);
            this.entryLabel.setEnabled(bl);
            this.confirmTF.setEnabled(bl);
            this.confirmTF.setBackground(color);
            this.confirmLabel.setEnabled(bl);
        } else if (this.hasWriteRights) {
            this.entryTF.setEnabled(bl);
            this.entryTF.setBackground(color);
            this.entryLabel.setEnabled(bl);
            this.confirmTF.setEnabled(bl);
            this.confirmTF.setBackground(color);
            this.confirmLabel.setEnabled(bl);
        } else {
            this.entryTF.setEnabled(false);
            this.entryTF.setBackground(this.ColorOff);
            this.entryLabel.setEnabled(false);
            this.confirmTF.setEnabled(false);
            this.confirmTF.setBackground(this.ColorOff);
            this.confirmLabel.setEnabled(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.printDebuggingLine("itemStateChanged.event: " + itemEvent);
        Object object = itemEvent.getSource();
        if (this.initializationComplete) {
            int n;
            if (object == this.forcePasswordChangeCB) {
                this.flagsModified = true;
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
            if (object == this.setPasswordRB && (n = itemEvent.getStateChange()) == 1) {
                this.enablePasswordTextFields(true);
                this.forcePasswordChangeCB.setEnabled(true);
            }
            if (object == this.removePasswordRB) {
                n = itemEvent.getStateChange();
                if (n == 1) {
                    this.enablePasswordTextFields(false);
                    this.forcePasswordChangeCB.setEnabled(false);
                }
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.passwordModified = true;
        this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }
}

