/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: emx_data.h,v $
 * Revision 1.1.2.22  2000/05/16  20:18:49  James_Smart
 *  Check in Rev 1.22 kit to pthwindos.
 *
 * Revision 1.1.2.21  2000/04/12  17:43:25  Alex_Iannicelli
 * 	Check in Rev 1.20 kit to pthwindos
 *
 * Revision 1.1.2.20  2000/04/05  03:35:44  James_Smart
 * 	Check in Rev 1.19 kit to pthwindos
 *
 * Revision 1.1.2.19  2000/03/13  17:24:13  James_Smart
 * 	Check in Rev 1.18 kit to pthwindos
 *
 * Revision 1.1.2.18  2000/02/17  19:59:54  James_Smart
 * 	Check in Rev 1.17 kit to pthwindos
 *
 * Revision 1.1.2.17  2000/01/27  16:50:40  James_Smart
 * 	Check in Rev 1.16 kit to pthwindos
 *
 * Revision 1.1.2.16  2000/01/14  22:50:20  James_Smart
 * 	Check in Rev 1.15 kit to pthwindos
 *
 * Revision 1.1.2.15  2000/01/04  22:35:26  James_Smart
 * 	Check in Rev 1.14 kit to pthwindos
 *
 * Revision 1.1.2.14  1999/12/17  02:30:36  James_Smart
 * 	Check in Rev 1.13 kit to pthwindos
 *
 * Revision 1.1.2.13  1999/10/14  22:13:50  James_Smart
 * 	Check in Rev 1.12 kit to pthwindos
 *
 * Revision 1.1.2.12  1999/06/15  19:39:01  James_Smart
 * 	Check in Rev 1.11 kit to pthwindos
 * 	[1999/06/11  11:31:25  James_Smart]
 *
 * Revision 1.1.2.11  1999/05/04  20:22:43  James_Smart
 * 	Check in Rev 1.10 kit to pthwindos
 * 	[1999/05/04  16:28:43  James_Smart]
 * 
 * Revision 1.1.2.10  1999/03/17  21:07:17  James_Smart
 * 	Check in Rev 1.09 kit to pthwindos
 * 	[1999/03/17  18:19:59  James_Smart]
 * 
 * Revision 1.1.2.9  1999/03/11  19:07:22  James_Smart
 * 	Check in Rev 1.08 kit to pthwindos
 * 	[1999/03/10  19:38:36  James_Smart]
 * 
 * Revision 1.1.2.8  1999/02/24  20:54:04  James_Smart
 * 	Check in Rev 1.06 kit to pthwindos
 * 	[1999/02/23  20:30:38  James_Smart]
 * 
 * Revision 1.1.2.7  1999/02/08  20:55:02  James_Smart
 * 	Check in Rev 1.04 kit to pthwindos
 * 	[1999/02/08  20:41:36  James_Smart]
 * 
 * Revision 1.1.2.6  1999/01/22  22:36:50  James_Smart
 * 	Check in Rev 1.03 kit to pthwindos
 * 	[1999/01/22  17:50:01  James_Smart]
 * 
 * Revision 1.1.2.5  1998/12/07  14:57:08  James_Smart
 * 	Check in Rev 1.00 kit to pthwindos
 * 	[1998/12/04  17:32:13  James_Smart]
 * 
 * Revision 1.1.2.4  1998/11/06  15:11:44  James_Smart
 * 	Check in Rev 0.12 kit to pthwindos
 * 	[1998/10/28  14:58:50  James_Smart]
 * 
 * Revision 1.1.2.3  1998/09/30  15:59:45  James_Smart
 * 	Check in Rev 0.11 kit to pthwindos
 * 	[1998/09/25  14:06:05  James_Smart]
 * 
 * Revision 1.1.2.2  1998/08/20  14:16:37  James_Smart
 * 	Creation for Rev 0.10 kit - to satisfy pool build rules
 * 	[1998/08/20  13:02:55  James_Smart]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: emx_data.h,v $ $Revision: 1.1.2.22 $ (DEC) $Date: 2000/05/16 20:18:49 $
 */

/* ----------------------------------------------------------------------
 *
 * emx_data.h - EMX driver data structures for emx_data.c file
 *
 * Contains data structures used to pass static configuration data to
 * the EMX driver. This data primarily maps FC port names to CAM target
 * id assignments. It also allow the capability to provide per-instance
 * tuneable attributes.
 *
 * There are 2 types of data passed to the kernel.
 *    An attribute values that apply to a particular instance of an
 *      adapter (instance is 0 for emx0, 1 for emx1, etc).
 *    A CAM target ID assignment to FC Port mapping that applies to
 *      a port attached to a particular instance of an adapter.
 *
 * An array of each type of data is passed to the kernel.
 *  
 * ---------------------------------------------------------------------- */

#ifndef _EMX_DATA_H_
#define _EMX_DATA_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Record containing an Adapter Instance Attribute
 */

/* Attribute definitions */
#define EMX_ATTRIB_LINK_TYPE            0x01
#define EMX_ATTRIB_E_D_TOV              0x02
#define EMX_ATTRIB_R_A_TOV              0x03
#define EMX_ATTRIB_ARB_TOV              0x04
#define EMX_ATTRIB_R_T_TOV              0x05
#define EMX_ATTRIB_AL_TOV               0x06
#define EMX_ATTRIB_C_R_TOV              0x07
#define EMX_ATTRIB_C_I_TOV              0x08

typedef struct {
    unsigned int        instance;
    unsigned int        attribute_number;
    unsigned int        attribute_value;
} EMX_ATTRIBUTE_RECORD;

/*
 * Record containing SCSI ID to FC Port mappings
 */

#define NUM_SHORTS_IN_64BITS            4

typedef struct {
    unsigned int        instance;
             int        cam_tgt_id;
    unsigned short      port_name[NUM_SHORTS_IN_64BITS];
    unsigned short      node_name[NUM_SHORTS_IN_64BITS];
} EMX_FCPID_RECORD;

/*
 * 
 * NOTE: the 16bit FC Port Name and Node Name values are byte-swapped due
 *   to endian-ness of the machine (ex: 0x0050 is actually byte values
 *   50 followed by 00). Thus, when comparing with values with those
 *   reported by the HSG80, the following node names are equivalent:
 *       from HSG80:           5000-1fe1-0000-0770
 *       from emx.info: { ...  0x0050, 0xe11f, 0x0000, 0x7007 },
 */

/* instance number that indicates end of array */
#define TERMINAL_INSTANCE_NUMBER        0xFFFFFFFF

/*
 * NOTE:
 *   A cam_tgt_id value that is negative indicates that the corresponding
 *   FC Port Name and Node Name entry id mapping should be deleted from the
 *   persistent database.
 */

/*
 * these are the arrays being compiled at kernel build time
 * into emx_data.o
 */
extern EMX_ATTRIBUTE_RECORD     emx_attribute_records[];
extern EMX_FCPID_RECORD         emx_fcpid_records[];


#ifdef __cplusplus
}
#endif


#endif /* _EMX_DATA_H_ */

