

  TCP/IP Version 2.0 for OS/2 Base Kit

     Note: This TCP/IP kit has Corrective Service UN64092, UN56401, and
     UN52840 already applied.

  ********************************************************************		
   WARNING:  This TCP/IP CSD will not co-exist with AnyNet/2 Sockets
   over SNA (access node and gateway) unless you apply the following
   APAR for your AnyNet product after you install the TCP/IP CSD.
 
   AnyNet/2 V2.0 (Sockets over SNA) - APAR IC07730
 
   AnyNet/2 V1.1 Sockets over SNA Gateway - APAR IC08105
               
  *******************************************************************

     This README file reflects new and changed functions for
     the TCP/IP 2.0 for OS/2: Base kit and the TCP/IP: Applications
     Kit, and contains changes introduced in the original product as well
     as changes due to Corrective Service Diskettes (CSDs) UN64092, UN56401,
     and UN52840.  Contents of this README file include:

               -  Previous CSD Information
               -  Obtaining CSDs
               -  CSD UN64092 Contents 
               -  CSD UN56401 Contents
               -  CSD UN52840 Contents
               -  Fixed APARs



                 *************************************
*****************      Previous CSD Information       *******************
                 *************************************


     This CSD incorporates the corrective service and new functions that
     have been released in all available CSDs for TCP/IP Version 2.0
     for OS/2.  This file contains information about all functions
     described in the following CSDs:

          -  UN64092
          -  UN56401
          -  UN52840



                 *************************************
 ****************           Obtaining CSDs            *******************
                 *************************************


     You can obtain Corrective Service Diskettes (CSDs) electronically
     by:

           o   Using FTP to access SOFTWARE.WATSON.IBM.COM as Anonymous.

               NOTE:  Fixes for TCP/IP for OS/2 are located in the
                      pub\tcpip\os2 directory.

           o   Establishing a modem connection to the NCSBBS bulletin
               board at 1-919-517-0001.

               NOTE:  Set your modem settings to: none,8,1.

     The latest CSDs for TCP/IP Version 2.0 for OS/2 are shown in the
     following table:

        +=============================+===========================+
        | KIT NAME                    | PACKAGE NAME              |
        +=============================+===========================+
        | Applications Kit            | APP20CSD.PKG              |
        +-----------------------------+---------------------------+
        | Base Kit                    | TCP20CSD.PKG              |
        +-----------------------------+---------------------------+
        | Domain Name Server Kit      | DNS20CSD.PKG              |
        +-----------------------------+---------------------------+
        | DOS/Windows Access Kit      | DOS20CSD.PKG              |
        +-----------------------------+---------------------------+
        | Extended Networking Kit     | XNT20CSD.PKG              |
        +-----------------------------+---------------------------+
        | NetBIOS Kit                 | NET20CSD.PKG              |
        +-----------------------------+---------------------------+
        | Network File System Kit     | NFS20CSD.PKG              |
        +-----------------------------+---------------------------+
        | OSF/Motif Kit               | MOT20CSD.PKG              |
        +-----------------------------+---------------------------+
        | Programmer's Tool Kit       | PGM20CSD.PKG              |
        +-----------------------------+---------------------------+
        | X Window System Client Kit  | XCL20CSD.PKG              |
        +-----------------------------+---------------------------+
        | X Window System Server Kit  | PMX20CSD.PKG              |
        +-----------------------------+---------------------------+


                 *************************************
***************** UN56401 CORRECTIVE SERVICE DISKETTE *******************
                 *************************************

   Topics included in CSD UN56401 are:

        1. Remote Installation (CID)
        2. RUNNING TCP/IP FOR OS/2 FROM A FILE SERVER
        3. Autostart Using INETD
        4. Packet Tracing Programs
        5. Changes to FTP, FTPD, and FTPPM
        6. Configuring KEEPALIVE Servers: the INETCFG Command
        7. TelnetPM Cursor Modification
        8. SLIP
        9. SNMP Enhancements
       10. Default 3270 Emulator Keyboard Mappings
       11. The DPKT Utility
       12. Configuration Notebook
       13. Configuring a Token-Ring Adapter using BOOTP
       14. SETTERM
       15. SendMail Server and Client
       16. REXEC and RSH Redirection
       17. Programming Support
       18. Applications Kit / ANYNET Users Information



  --------------------------------------------------------------------
  1. Remote Installation (CID)


     If you are using CID technology to install TCP/IP, the
     statements in the response file that contain the INSTALL_NAME and
     the LINK_NAME must preceed the statements that contain the
     EXEC, DEPENDENCY, or LINK_INFO.  In addition, since CSDs are
     cumulative, you must erase or remark out the lines in your
     DEFAULT.RSP file that pertain to the previous CSD level for the
     component you want to enable.



  --------------------------------------------------------------------
  2. RUNNING TCP/IP FOR OS/2 FROM A FILE SERVER


     If you want to conserve your local disk space, you can run TCP/IP
     for OS/2 from a file server using a requester (such as IBM's OS/2
     LAN Requester or TCP/IP's NFS client).

     To run TCP/IP for OS/2 from a server, ensure the following:

          1.  You have the required local files

          2.  Your PATH statement and environment variables contain
              the correct information

          3.  You have access to the file server

  --------------------------
  2.1 REQUIRED LOCAL FILES

     Although many of the files used by TCP/IP are common and can be
     accessed on the file server, certain files contain configuration
     information and are unique to each installation.  These files must
     be located in directories on your workstation.

     In the tcpip\ETC subdirectory on your workstation, ensure that you
     have copies of all the files from the \ETC subdirectory on the file
     server.

     In the tcpip\BIN subdirectory on your workstation, ensure that you
     have the following files:

          o   CNTRL.EXE
          o   SETUP.CMD
          o   TCPSTART.CMD
          o   PMX.EXE
          o   TCPIPCFG.EXE
          o   TELNET.EXE

     In the \IBMCOM\PROTOCOL subdirectory on your workstation, ensure
     that you have all LAPS files, including the following files:

          o   INET.SYS
          o   IFNDIS.SYS
          o   TCPIP.NIF

     If you are using NFS to access the server, also ensure that you have
     the following files in your tcpip\BIN subdirectory:

          o   NFS200.IFS
          o   NFSCTL.EXE
          o   NFSSTART.CMD
          o   ARP.EXE
          o   ROUTE.EXE
          o   IFCONFIG.EXE
          o   MOUNT.EXE
          o   QMOUNT.EXE
          o   NFSWAIT.EXE

     And in your tcpip\DLL subdirectory:

          o   TCPIPDLL.DLL
          o   CNBAPP.DLL
          o   CNBNFS.DLL
          o   CNBPMX.DLL
          o   CNBSTK.DLL

     In addition, you need the following empty subdirectories:

          o   TCPIP\DOC
          o   TCPIP\TMP

  --------------------------
  2.2 SET PATH STATEMENT AND ENVIRONMENT VARIABLES

     To run TCP/IP from a server, the PATH statement and the environment
     variables must point to the proper locations on the server and on
     your workstation.

     The PATH statement must point to the directory on your workstation
     that contains the local TCP/IP batch files and executables and to
     the directory on the file server that contains the TCP/IP
     executables.  For example, if you access a network drive that
     contains TCP/IP as your X drive, your PATH statement would look
     similar to this:

          PATH=...;C:TCPIP\BIN;X:\TCPIP\BIN;

     The LIBPATH statement must point to the directory on your
     workstation that contains the local TCP/IP dynamic link libraries
     (DLLs) and to the directory on the file server that contains the
     TCP/IP DLLs.  For example, if you access a network drive that
     contains TCP/IP as your X drive, your LIBPATH statement would look
     similar to this:

          LIBPATH=...;C:TCPIP\DLL;X:\TCPIP\DLL;

     The ETC environment variable must point to the ETC subdirectory on
     your workstation.  For example:

          SET ETC=C:\TCPIP\ETC

  --------------------------
  2.3 ACCESS THE SERVER

     If you are using NFS to access the file server, you will need to
     start TCP/IP and NFS before you access the file server.  However,
     no other TCP/IP services should be started until you access the file
     server.  If you are using other methods to access the file server,
     you should access the file server before using any services of
     TCP/IP.



  --------------------------------------------------------------------
  3. Autostart Using INETD


     If you use INETD to autostart TCP/IP services, any parameters that
     you specify will be ignored.

     However, for TFTPD, you can add the following environment variable
     to your CONFIG.SYS to specify the default path:

          SET TFTPDPATH=<path>

     For REXECD, you can add the following environment variable to
     your CONFIG.SYS to specify the timeout:

          SET REXECDTIME=<time>



  --------------------------------------------------------------------
  4. Packet Tracing Programs


     TCP/IP for OS/2 provides a set of utilities that you can use to
     trace packets.  Tracing packets is useful in diagnosing problems
     at your workstation.  These utilities allow you to:

           o   Initiate a trace
           o   Convert trace information to human-readable output
           o   Convert trace information to network analyzer data

  --------------------------
  4.1  Initiating a Trace

     The utility, IPTRACE, traces all packets received from and sent
     to an interface.

     The syntax of the IPTRACE command is:

        >>--iptrace--.-----.--.--------------.------------------------><
                     '- -i-'  | <----------< |
                              '-- interface--'


        -i      Specifies that only IP packets are to be traced.  The
                default is to include all information (such as hardware
                type).  Certain interfaces (for example, X25 and SNALINK)
                require this parameter.

        interface
                Specifies an interface to be traced (for example, lan0
                or sl0).  If not specified, all interfaces are traced.

        NOTES:

        1.  IPTRACE writes data to IPTRACE.DMP in the directory from
            which you initiated the IPTRACE command.  IPTRACE records all
            traffic sent and received, but does not check for sufficient
            disk space to record that information.  As a result, running
            IPTRACE can impact your workstation's performance as the
            IPTRACE.DMP file continues to grow larger.

        2.  IPTRACE is not a network monitor.  It can trace only data
            received by and sent from the specified interfaces.

        3.  IPTRACE provides a time stamp, recording when the packet
            was sent or received.

        4.  To stop IPTRACE, press Enter, Ctrl-Break, or Ctrl-c.

        5.  Use IPFORMAT to convert the IPTRACE.DMP file into a
            user-readable format.

  --------------------------
  4.2  Converting Trace Information

     The IPFORMAT utility converts the data in the IPTRACE.DMP file
     and the SLIPTRC.DMP file (if the file was created without VJ header
     compression on) to either human-readable format, which is displayed
     to the screen, or to data to be used as input to a network analyzer.
     If you choose to convert the data into human-readable format, you
     can redirect the output to a file.

     IPFORMAT reads the header information in the trace to determine
     the type of packet received; for example, token-ring (TRC) or
     ethernet (ENC).  It then separates the data by the IP, TCP, UDP,
     and ICMP layers. The rest of the packet is displayed as hexadecimal
     output.

     The syntax of the IPFORMAT command is:

                                        .- -f IPTRACE.DMP-.
        >>--ipformat--.-----.--.-----.--+-----------------+--.-----.--->
                      '- -a-'  '- -d-'  '- -f filename----'  '- -h-'

        >---.-----.---.---------------.--.-----.--.-------------.-----><
            '- -n-'   '- -s hwaddress-'  '- -x-'  '- > filename-'

        -a      Do not format ARP or RARP packets.

        -d      Do not display the data portion of a packet.

        -f filename
                Specifies the input file name.  The default is
                IPTRACE.DMP.

        -h      Display the raw data packet after the formatted
                information.

        -s hwaddress
                Format data only for the specified hardware address.
                'hwaddress' is the 12-digit hexadecimal address for the
                Ethernet or token-ring adapter.  You can use the
                NETSTAT -N command to display this address.

        -n      Do not display hexadecimal data for unknown data type.

        -x      Converts IPTRACE data to a format that can be read by
                a Network General Sniffer.

        > filename
                Redirect the output to the specified file.

        -?      Display help information.



  --------------------------------------------------------------------
  5. Changes to FTP, FTPD, and FTPPM

  --------------------------
  5.1 IMAGE Subcommand for FTP

     FTP now supports an image transfer type.

     The IMAGE subcommand sets the file transfer type to image.  The
     image file transfer type is useful for image transfers, such as
     executable files.  Using the IMAGE subcommand is the same as issuing
     the TYPE subcommand with the binary parameter.  You can issue the
     IMAGE subcommand with the abbreviation IM.

     >>--image--------------------------------------------------------><

  --------------------------
  5.2 IMAGE Parameter for TYPE Subcommand for FTP

     The TYPE subcommand now supports the IMAGE parameter.

     >>--type--.---------.--------------------------------------------><
               |- ascii--|
               |- binary-|
               '- image--'

     image     Specifies the file transfer type as image (binary).
               Specifying the TYPE subcommand with the image parameter
               is the same as issuing the IMAGE subcommand.

  --------------------------
  5.3 FTPD Trace Facility

     FTPD now includes a trace facility.  The FTPD command uses the
     FTPD.EXE program to start the FTP server.  It runs as a task until
     you shut down the server.

     SYNTAX

     >>--ftpd--.--------------.--.------------.--.-----.--------------><
               '- -c codepage-'  '- -p portno-'  '- -t-'


     -c codepage
               Specifies the ASCII codepage used by the remote host.  If
               you do not specify a codepage, the data is sent
               untranslated.  Possible values are:

                  TCPDECMU      DEC Multinational codepage
                  TCP8859       ISO 8859 codepage
                  NONE          PC codepage 850

     -p portno Specifies the port that you want FTPD to use.  If you omit
               this option, FTPD uses its well-known port assignment.

     -t        Specifies that FTPD is to trace control connection
               commands and replies.  FTPD places the information into
               FTPD.TRC in the subdirectory specified by the ETC
               environment variable.  Tracing will continue until you
               terminate FTPD.

  --------------------------
  5.4 TRACING FTPPM COMMANDS/REPLIES

     If you select the Trace Commands/Replies option, from the Options
     pull-down menu, you can trace your FTPPM session activities.  The
     commands you issue and the replies you receive are written to a file
     named FTPPM.TRC in the directory specified by the ETC environment
     variable.

     The trace file is overlayed (information is not appended) each time
     the trace option is selected.

  --------------------------
  5.5 Ending an FTPPM Session


     You can end an FTPPM session and disconnect from all remote hosts
     in one of the following ways:

        o   Select the Close all Connections option from the Remote
            pull-down menu.  You will be prompted to confirm that you
            want to end all connections.

        o   Press the F3 key to exit.  You will not be prompted to
            confirm that you want to exit the session.

        o   Close the FTPPM window.  You will not be prompted to confirm
            that you want to exit the session.

     NOTE:  Options set for the current session are not saved for
            future sessions.



  --------------------------------------------------------------------
  6. Configuring KEEPALIVE Servers: the INETCFG Command


     The INETCFG command configures TCP/IP parameters.

        >>--inetcfg---- keepalive=value-------------------------------><


        value   The time in minutes until the KEEPALIVE timer expires on
                a TCP socket.  Valid values are from 0 to 120.  If you
                specify 0, INETCFG sets the timer to 120.

     Note:  To use the INETCFG command, Telnetd cannot first be
            started with INETD.


  --------------------------------------------------------------------
  7. TelnetPM Cursor Modification


     You can use the Options menu to alter the way the cursor is
     displayed during your TelnetPM session.

     Your cursor can be defined as follows:

        o   Character
            -   Underscore (Default)
            -   Solid block
            -   Frame block
        o   Blink
            -   On (Default)
            -   Off
        o   Intensity
            -   Normal (Default)
            -   Dim

     To select cursor values for your session:

        1.  Select (using mouse button 1 to click on the field) Options
            from the menu bar.

        2.  Select the Cursor option.

            (The current default is indicated by a checkmark to the left
            of the option on the drop-down menu.)

        3.  Select the desired option.



  --------------------------------------------------------------------
  8. SLIP

  --------------------------
  8.1  The SLIP Command

     The SLIP command is used to start the main slip driver.  Since
     the majority of users only use a single interface, command line
     options for the sl0 interface have been added to simplify making
     a single interface SLIP connection.  These options override the
     default values in the configuration file and cannot be set using
     the Configuration Notebook (TCPIPCFG.EXE).


                           .- -f SLIP.CFG----.
     >>--slip--.--------.--+-----------------+--.------------------.-->
               '- -comn-'  '- -f config_file-'  '- -hangup command-'

     >--.--------------------------.--.-----------------.------------->
        '- -ifconfig ipaddr ipdest-'  '- -modem command-'

     >--.------------.--.-----.--.----------.--.--------------.------->
        '- -mtu size-'  '- -p-'  '- -rtscts-'  '- -speed baud-'

     >--.----------------------.--.------------.--.------.-----------><
        '- -d--.-------------.-'  '- -t--.---.-'  '- -vj-'
               '- > filename-'           |-i-|
                                         '-o-'

     Displaying SLIP Help

     >>--slip-- -?---------------------------------------------------><


        -comn   Specifies the communications port (n) to be used for
                the sl0 interface.

        -f config_file
                Specifies the name of the SLIP configuration file.
                The default is SLIP.CFG.

        -hangup command
                Specifies a command to send to the sl0 communications
                port upon exit.

        -ifconfig ipaddr ipdest
                Specifies IP addresses to use to configure sl0.

        -modem command
                Specifies a command to send to the sl0 communications
                port.

        -mtu size
                Sets the sl0 interface MTU to the specified size.

        -p      Specifies that SLIP communications port and INET
                interface threads be placed in the highest foreground
                server priority.  This prevents packet loss on slow
                machines or in heavily loaded environments.

        -rtscts
                Specifies asynchronous card-to-modem flow control via
                the RTS (request-to-send) and CTS (clear-to-send)
                handshaking signals (RTS/CTS hardware flow control).
                At baud rates above 2400, this option should be enabled
                to prevent modem buffer overruns and packet loss.

        -speed baud
                Specifies the baud rate to which to set the sl0
                communications port.

        -d      Enables debugging output.

                NOTE:  Because this option can produce large amounts of
                output that can degrade performance, you may want to
                redirect the debugging output to a file.

        > filename
                Specifies a file to which to redirect debugging output.

        -t      Specifies that SLIP begin tracing as follows:

                  -t    Traces both input and output packets.
                  -ti   Traces only input packets.
                  -to   Traces only output packets.

                Data is written to SLIPTRC.DMP in the directory from
                which SLIP was started.  To stop the trace, press
                Ctrl-c or Ctrl-Break.  This option produces packets in
                INET trace format.  You can read the output using
                IPFORMAT.

                NOTES:

                1.  As the SLIPTRC.DMP file increases in size, the
                    performance of your workstation can be affected.

                2.  SLIP does not check to ensure that there is
                    sufficient  hard disk space to record the data.

        -vj     Specifies that SLIP is to enable Van Jacobsen (VJ) header
                compression for the sl0 interface.

                NOTE:  If VJ header compression is on, you will not be
                       able to use IPFORMAT to read the SLIPTRC.DMP file.

        -?      Displays the list of parameters and their meanings.

  --------------------------
  8.1.1 SLIP Examples

   Example 1:

     slip -rtscts -modem atdt9,999-9999 -ifconfig 9.67.111.1 9.67.111.2
          -speed 38400 -com2 -mtu 1006 -vj

     This command:
        - Starts SLIP using the sl0 interface
        - Sets RTS/CTS hardware flow control on
        - Sends the command string "atdt9,999-9999" to the modem
           (dial out) attached to comport 2
        - Configures the interface with local IP address 9.67.111.1
           and remote peer IP address 9.67.111.2
        - Sets the baud rate to 38.4K bits
        - Sets the communications port to com2
        - Sets the mtu to 1006 bytes
        - Enables Van Jacobson Header compression


   Example 2:

     slip -rtscts -modem ats0=2s7=30 -ifconfig 9.67.111.2 9.67.111.1
          -speed 38400 -com1 -mtu 1006 -vj -p

     This command:
        - Starts SLIP using the sl0 interface
        - Sets RTS/CTS hardware flow control on
        - Sends the command string "ats0=2s7=30" to the modem (dial in)
           attached to communications port 1
        - Configures the interface with local IP address 9.67.111.2
           and remote peer IP address 9.67.111.1
        - Sets the interface baud rate to 38.4K bits
        - Sets the communications port to com1
        - Sets the mtu to 1006 bytes
        - Enables Van Jacobson Header compression
        - Schedules SLIP execution using time critical server priority

  --------------------------
  8.2  The SLIPTERM Command

     The SLIPTERM command now has the -f and interface parameters.

                                       .- -f SLIP.CFG----.
        >>--slipterm--.-------------.--+-----------------+------------->
                      '- -w---.---.-'  '- -f config_file-'
                              '-n-'
           .-sl0-.
        >--+-----+--.-----.-------------------------------------------><
           '-sln-'  '- -d-'

        -w      Invokes the SLIPWAIT utility.

         n      Specifies the number of seconds to wait (the
                default is 30).

        -f config_file
                Specifies the name of the SLIP configuration file.  The
                default is SLIP.CFG.

        sln     Specifies the interface to be addressed.  The default
                is SL0.

        -d      Enables debugging mode.

  --------------------------
  8.3  The SLIPHOLD Command

     The SLIPHOLD command now has the -f and interface parameters.

                      .- -f SLIP.CFG----.  .-sl0-.
        >>--sliphold--+-----------------+--+-----+--------------------><
                      '- -f config_file-'  '-sln-'

        -f config_file
                Specifies the name of the SLIP configuration file.  The
                default is SLIP.CFG.

        sln     Specifies the interface to be addressed.  The default
                is SL0.

  --------------------------
  8.4  SLIP Correction

     The description of the MODE command in the Installation and
     Administration manual is incorrect.  The speed parameter is the
     async-to-modem bit rate.

          <speed> is the async-to-modem bit rate (1200 to 38400).

     The async card UART (universal asynchronous receiver/transmitter)
     rate is not the same as the modem line rate.  If the modem rate and
     async communications port rate are different, then data flow control
     is used to coordinate the async card and the modem; to prevent one
     from overrunning the other.  This is called "pacing".  Pacing is
     required for newer modems to use data compression.  If the two rates
     are the same, then the modem tries to adjust its rate to that of the
     async communications port.  This is called "bit rate adjustment".
     It is recommended that you use as high a bit rate as is supported
     by the hardware.

     If you are connecting to another modem, the modems need to negotiate
     the highest line rates possible.  To do this, start SLIP with the
     -rtscts parameter.

  --------------------------
  8.5 New Sample Attachment Scripts

     Three new sample attachment scripts have been added for SLIP:

          1. ATDIAL.CMD is a sample attachment script that can be used
             for a basic SLIP client that does not require a user ID and
             password prior to starting a SLIP connection.

          2. DIRECT.CMD is a sample attachment script that can be used
             for a direct connection between two asynchronous lines.

          3. ATANS.CMD is a sample attachment script that can be used for
             putting your modem into auto answer mode to enable others to
             dial into your host.

     These new samples support multiple SLIP interfaces.

  --------------------------
  8.6 Changes to the Way Parameters Are Passed to SLIP Attachment Scripts

     If the ipdest and ipaddress keywords appear in your SLIP
     configuration file, the interface name (slx), IP address,
     destination address, and dial commands are passed to the REXX
     attachment scripts.

     If the ipdest or ipaddress keywords do not appear in your SLIP
     configuration file, only the interface name and dial commands
     are passed to the REXX attachment scripts.

  --------------------------
  8.6.1 Example of Configuring SLIP for More Than One Interface

     Following is an example of a SLIP configuration file for 3
     concurrent dial-in sessions:

       interface sl0 {
            mtu=296               # Use 296 byte MTU for interface 0.
            compression=off       # Disable VJ compression.
            device = com1         # Use com1 for interface sl0.
            ipaddress = 9.67.1.1  # Local IP address.
            ipdest = 9.67.10.1    # Peer IP address.
            attachcmd = atans     # Rexx command to place modem in auto
                                  # answer mode using AT command set and
                                  # ifconfig the interface.
            attachparms = "com1 38400"   # Parameters passed to REXX
                                         # command script.
            }


       interface sl1 {
            mtu=296
            compression=off
            device = com2
            ipaddress = 9.67.1.2
            ipdest = 9.67.10.2
            attachcmd = atans
            attchparms = "com2 38400"
            }

       interface sl2 {
            mtu=296
            compression=off
            device = com3
            ipaddress = 9.67.1.3
            ipdest = 9.67.10.3
            attachcmd = atans
            attparms = "com3 38400"
            }



  --------------------------------------------------------------------
  9. SNMP Enhancements

  --------------------------
  9.1  The SNMP Command

     The Simple Network Management Protocol (SNMP) is a protocol used
     by network elements (for example, hosts and bridges) to exchange
     information about network management.  The snmp command provides
     SNMP manager function to query SNMP agents for network management
     information.

     SYNTAX

     RECEIVING TRAPS

                                              .- -h localhost-.
     >>--snmp--.---------------------------.--+---------------+-------->
               | <-----------------------< |  '- -h host------'
               |        .- 1-----------.   |
               '--- -d--+--------------+---'
                        '- debug_level-'

        .- -c public---------.
     >--+--------------------+-- trap---------------------------------><
        '- -c community_name-'


     SETTING MIB VARIABLE VALUES

                                              .- -h localhost-.
     >>--snmp--.---------------------------.--+---------------+--------->
               | <-----------------------< |  '- -h host------'
               |        .- 1-----------.   |
               '--- -d--+--------------+---'
                        '- debug_level-'

        .- -c public---------.  .- -t 6-------.  .- -p 161--.
     >--+--------------------+--+-------------+--+----------+-- set----->
        '- -c community_name-'  '- -t seconds-'  '- -p port-'

        <------------------------------<
     >--- mib_variable-.-------.- value-------------------------------><
                       '- type-'


     GATHERING INFORMATION ABOUT MIB VARIABLES

                                              .- -h localhost-.
     >>--snmp--.---------------------------.--+---------------+-------->
               | <-----------------------< |  '- -h host------'
               |        .- 1-----------.   |
               '--- -d--+--------------+---'
                        '- debug_level-'

        .- -c public---------.  .- -t 6-------.  .- -p 161--.
     >--+--------------------+--+-------------+--+----------+---------->
        '- -c community_name-'  '- -t seconds-'  '- -p port-'


     >--.- get-----.-- mib_variable-----------------------------------><
        |- getnext-|
        '- walk----'

     Displaying SNMP Help

     >>--snmp-- -?----------------------------------------------------><


     -d    Starts debugging.

     debug_level
           Specifies the debug level.  There are currently 2 debug levels
           (1 and 2).  Level 2 provides more detailed debug and trace
           information than does level 1.

     -h host
           Specifies the destination host to which you want to send a
           request.  This can be either an internet protocol address or a
           host name.  If you do not specify a host, the default is your
           local host.

     -c community_name
           Specifies the community name used to access the specified
           variables on the destination SNMP agent.  If you do not
           specify a community, the default is public.

           NOTE:  Community names are case sensitive.

     trap  SNMP waits for a trap from the specified host.  If no host is
           specified, SNMP waits for a trap from any host.

     -t seconds
           Specifies the amount of time (in seconds) that the SNMP client
           waits for a reply from the SNMP agent.  The default is 6
           seconds.

     -p port
           Specifies the destination (agent) port.  The default is 161.

     set   Sends a request to the SNMP agent to set a specific MIB
           variable.  SNMP then waits for a response, a trap, or a
           timeout.

     mib_variable
           Specifies the MIB object, using its object descriptor (textual
           name), object identifier using ASN.1 notation, or a
           combination of the two.  When used with WALK, this is the MIB
           object prefix.  A prefix can be any leading portion of the
           complete object identifier.

     type  The type of value being set.  To complete an SNMP SET request,
           the SMI_type must be known.  If no type is specified, SNMP
           searches the compiled MIB and the MIB2.TBL to determine the
           type.  If the variable is not found, an error is returned.  If
           a type is specified, the type takes precedence over any type
           that may be assigned in the MIB.  The type and value must be
           compatible.  For example, if you specify a type of "number"
           and a value of "foo," an error will be returned because "foo"
           is not a number.  Possible variable types are:

               Types From MIB2.TBL         ASN.1 SMI_types
               ===================         ===============
                     number          or       INTEGER
                     display
                     object          or       OBJECT_IDENTIFIER
                     internet        or       IPAddress
                     counter
                     gauge
                     ticks           or       TimeTicks
                                              Opaque
                                              NULL

     value Specifies the value to be set by the SET function.  If
           white space is needed in the value, you must use double
           quotes (").  If you want to set a variable to a value that
           is also a type, you must specify the type.

     get   Sends a request to an SNMP agent for a specific management
           information base (MIB) variable.  SNMP then waits for a
           response, a trap, or a timeout.

     getnext
           Sends a request to an SNMP agent for the next MIB variable
           that lexicographically follows the mib_variable specified.
           SNMP then waits for a response, a trap, or a timeout.

     walk  Issues a GETNEXT request for a specified prefix, then
           continues to issue GETNEXT requests for as long as there are
           variables that match the specified prefix.  A prefix can be
           any leading portion of the complete object identifier.

     -?    Displays help information.

  --------------------------
  9.2  The SNMPGRP Command

     The snmpgrp command provides SNMP manager function to query SNMP
     agents for a collection of information contained in tables and other
     related MIB variables.  This information is retrieved using the name
     of the group or table of MIB variables.

     SYNTAX

                                                 .- -h localhost-.
     >>--snmpgrp--.---------------------------.--+---------------+----->
                  | <-----------------------< |  '- -h host------'
                  |        .- 1-----------.   |
                  '--- -d--+--------------+---'
                           '- debug_level-'

        .- -c public---------.  .- -t 6-------.  .- -p 161--.
     >--+--------------------+--+-------------+--+----------+---------->
        '- -c community_name-'  '- -t seconds-'  '- -p port-'

        <-------------<
     >---.-----------.------------------------------------------------><
         |- sys------|
         |- snmp-----|
         |- ip-------|
         |- icmp-----|
         |- udp------|
         |- tcp------|
         |- tcptab---|
         |- udptab---|
         |- iproute--|
         |- ipaddr---|
         |- arptab---|
         |- iftab----|
         '- mediatab-'


     Displaying SNMPGRP Help

     >>--snmpgrp-- -?-------------------------------------------------><


     -d debug_level
               Specifies the debug level.  There are currently 2 debug
               levels (1 and 2).  Level 2 provides more detailed debug
               and trace information than does level 1.  If you do not
               specify a debug level, the default is 1.

     -h host   Specifies the host to which you want to send a request.
               You can specify either an internet protocol address or a
               host name.  If you do not specify a host, the default is
               your local host.

     -c community_name
               Specifies the community name of the simple network
               management protocol agent on the destination host.  If you
               do not specify a community name, the default is public.

               NOTE:  Community names are case sensitive.

     -t seconds
               Specifies the amount of time (in seconds) that SNMPGRP
               waits for a reply.  The default is 6 seconds.

     - p port  Specifies the destination (agent) port.  The default
               is 161.

     NOTE:  The following list represents the names of the groups from
            which you can choose.  If you request more than one group,
            your output will be displayed in the order in which the
            groups appear in the list.

     sys       Requests the System group of MIB variables.

     snmp      Requests the SNMP group of MIB variables.

     ip        Requests the scalar MIB variables in the IP group.

     icmp      Requests the ICMP group of MIB variables.

     udp       Requests the scalar MIB variables in the UDP group.

     tcp       Requests the scalar MIB variables in the TCP group.

     tcptab    Requests the TCP connection table in the TCP group.

     udptab    Requests the UDP listener table in the UDP group.

     iproute   Requests the IP routing table in the IP group.

     ipaddr    Requests the IP address table in the IP group.

     arptab    Requests the AT table in the address translation group.

     iftab     Requests the Interface table in the interfaces group.

     mediatab  Requests the IP address translation table in the IP group.

     -?        Displays help information.

  --------------------------
  9.3  Changes to SNMP

     The SNMP and SNMPGRP commands now search an internal table first to
     find the requested information.  If the mib_name does not exist in
     the internal table, SNMP searches the MIB2.TBL file for the
     information.  The internal table contains all the textual names
     defined in the following RFCs:

           o   RFC1155
           o   RFC1213
           o   RFC1231
           o   RFC1285
           o   RFC1315
           o   RFC1398

     In the MIB2.TBL, the ASN.1 name should now always end in a dot.
     No instance IDs of 0 (zero) should be used.

     The SNMP commands have been changed to comply with the SNMP RFCs.
     Prior to this CSD, trailing zeros (instance 0) were used in the
     MIB2.TBL.  Therefore, if you issued the following command:

           snmp getnext sysDescr

     the value of the sysObjectID.0 would be returned.

     With the new SNMP command, sysDescr is no longer obtained from
     the MIB2.TBL but from the internal table.  In the previous example,
     the outgoing request is for sysDescr (without instance 0).  Since
     the next lexicographical variable is the instance 0 of sysDescr, the
     value of sysDescr.0 will be returned.

     The new SNMP commands require you to specify the instance.  For
     example, if you want to perform a GET or GETNEXT on the instance 0
     of the sysDescr object, you would use the following commands:

           snmp get sysDescr.0
           snmp getnext sysDescr.0

     The SNMP GET command will return the value of the sysDescr object.
     The SNMP GETNEXT will return the value of the sysObjectID, which is
     the next object that lexicographically follows instance 0 of
     sysDescr).

     The following rules apply to object IDs in ASN.1 notation:

           o  The object ID consists of 1 to 128 subIDs, which are
              separated by dots.

           o  Each subID is a positive number.  No negative numbers are
              allowed.

           o  The value of each number cannot exceed 4294967295 (which
              is 2 to the power of 32 minus 1).

           o  The valid values of the first subID are: 0, 1, or 2.

           o  If the first subID has a value of 0 or 1, the second
              subID can only have a value of 0 through 39.

  --------------------------
  9.4  Enhancements to SNMPD

     TCPIPCFG (the Configuration Notebook) now includes an autostart
     option for SNMPD.


  --------------------------------------------------------------------
  10. Default 3270 Emulator Keyboard Mappings


     The following table lists the default keyboard mappings for PMANT
     and TN3270.

     +---------------------------------+--------------------------------+
     | WORKSTATION KEY                 | 3270 FUNCTION                  |
     +---------------------------------+--------------------------------+
     | Alt-1                           | PA1                            |
     +---------------------------------+--------------------------------+
     | Alt-2                           | PA2                            |
     +---------------------------------+--------------------------------+
     | Alt-3                           | PA3                            |
     +---------------------------------+--------------------------------+
     | Backspace                       | Backspace                      |
     +---------------------------------+--------------------------------+
     | Control-End                     | Erase-EOF                      |
     +---------------------------------+--------------------------------+
     | Control-Delete                  | Kill-Word                      |
     +---------------------------------+--------------------------------+
     | Control-F1                      | PA1                            |
     +---------------------------------+--------------------------------+
     | Control-F2                      | PA2                            |
     +---------------------------------+--------------------------------+
     | Control-F3                      | PA3                            |
     +---------------------------------+--------------------------------+
     | Control-Left                    | Move backward a word           |
     +---------------------------------+--------------------------------+
     | Control-Right                   | Move forward a word            |
     +---------------------------------+--------------------------------+
     | Delete                          | Delete                         |
     +---------------------------------+--------------------------------+
     | Down Arrow                      | Down                           |
     +---------------------------------+--------------------------------+
     | End                             | End                            |
     +---------------------------------+--------------------------------+
     | Enter                           | Enter                          |
     +---------------------------------+--------------------------------+
     | Escape                          | Clear                          |
     +---------------------------------+--------------------------------+
     | F1                              | PF1                            |
     +---------------------------------+--------------------------------+
     | F2                              | PF2                            |
     +---------------------------------+--------------------------------+
     | F3                              | PF3                            |
     +---------------------------------+--------------------------------+
     | F4                              | PF4                            |
     +---------------------------------+--------------------------------+
     | F5                              | PF5                            |
     +---------------------------------+--------------------------------+
     | F6                              | PF6                            |
     +---------------------------------+--------------------------------+
     | F7                              | PF7                            |
     +---------------------------------+--------------------------------+
     | F8                              | PF8                            |
     +---------------------------------+--------------------------------+
     | F9                              | PF9                            |
     +---------------------------------+--------------------------------+
     | F10                             | PF10                           |
     +---------------------------------+--------------------------------+
     | F11                             | PF11                           |
     +---------------------------------+--------------------------------+
     | F12                             | PF12                           |
     +---------------------------------+--------------------------------+
     | Home                            | Home                           |
     +---------------------------------+--------------------------------+
     | Insert                          | Insert                         |
     +---------------------------------+--------------------------------+
     | Left Arrow                      | Left                           |
     +---------------------------------+--------------------------------+
     | LeftAlt (PMANT only)            | Gives focus to the menu bar    |
     +---------------------------------+--------------------------------+
     | NewLine                         | Enter                          |
     +---------------------------------+--------------------------------+
     | PageDown                        | PF8                            |
     +---------------------------------+--------------------------------+
     | PageUp                          | PF7                            |
     +---------------------------------+--------------------------------+
     | Right Arrow                     | Right                          |
     +---------------------------------+--------------------------------+
     | RightAlt (PMANT only)           | Gives focus to the menu bar    |
     +---------------------------------+--------------------------------+
     | RightControl                    | Enter                          |
     +---------------------------------+--------------------------------+
     | ScrollLock (PMANT only)         | PA3                            |
     +---------------------------------+--------------------------------+
     | Shift-End                       | Erase-EOF                      |
     +---------------------------------+--------------------------------+
     | Shift-Enter                     | NewLine                        |
     +---------------------------------+--------------------------------+
     | Shift-F1                        | PF13                           |
     +---------------------------------+--------------------------------+
     | Shift-F2                        | PF14                           |
     +---------------------------------+--------------------------------+
     | Shift-F3                        | PF15                           |
     +---------------------------------+--------------------------------+
     | Shift-F4                        | PF16                           |
     +---------------------------------+--------------------------------+
     | Shift-F5                        | PF17                           |
     +---------------------------------+--------------------------------+
     | Shift-F6                        | PF18                           |
     +---------------------------------+--------------------------------+
     | Shift-F7                        | PF19                           |
     +---------------------------------+--------------------------------+
     | Shift-F8                        | PF20                           |
     +---------------------------------+--------------------------------+
     | Shift-F9                        | PF21                           |
     +---------------------------------+--------------------------------+
     | Shift-F10                       | PF22                           |
     +---------------------------------+--------------------------------+
     | Shift-F11                       | PF23                           |
     +---------------------------------+--------------------------------+
     | Shift-F12                       | PF24                           |
     +---------------------------------+--------------------------------+
     | Shift-NewLine                   | NewLine                        |
     +---------------------------------+--------------------------------+
     | Shift-Tab                       | Backtab                        |
     +---------------------------------+--------------------------------+
     | Tab                             | Tab                            |
     +---------------------------------+--------------------------------+
     | Up Arrow                        | Up                             |
     +----------------------------------+-------------------------------+
     | NOTE:  LeftAlt, RightAlt, and ScrollLock are PMANT defaults      |
     | only.  They are not valid for TN3270 sessions.                   |
     +------------------------------------------------------------------+



  --------------------------------------------------------------------
  11. The DPKT Utility


        The DPKT utility will aid in servicing TCP/IP.

        >>--dpkt-- n-------------------------------------------------><


        n       Specifies a number indicating a particular packet
                within the IPTRACE.DMP file created by the IPTRACE.EXE
                utility.  The number you specify must represent a valid
                packet number.



  --------------------------------------------------------------------
  12. Configuration Notebook

  --------------------------
  12.1 The TCPIPCFG Command

     The TCPIPCFG command opens the TCP/IP configuration notebook.  With
     the configuration notebook, you can configure your TCP/IP network
     connections and customize your TCP/IP applications according to your
     preferences.


        >>--tcpipcfg--.-----.-----------------------------------------><
                      '- -d-'


        -d      Specifies that tracing will begin, and upon exiting,
                creates a TCPIPCFG.LOG text file containing debug data.
                Data recorded in the TCPIPCFG.LOG includes:

                   o   Opening files
                   o   Reading-in and initialization of data
                   o   Writing data to files
                   o   Closing files

  --------------------------
  12.2 Changes to the Configuration Notebook

     The Configuration Notebook now includes the following additions
     and changes:

        1.  You can now specify that SNMPD is to autostart.

        2.  You can now specify parameters when you autostart REXECD.

        3.  The default for 'Codepage' is now 'None'.

        4.  You can now specify 5-digit values for the MTU size field.


  --------------------------------------------------------------------
  13. Configuring a Token-Ring Adapter using BOOTP


     To configure a token-ring adapter using BOOTP, ensure that
     the corresponding entry in the BOOTPTAB file has a hardware
     type (ht) of token-ring.  For example:

       frank.tcp.raleigh.ibm.com: tc=subnet22.dummy: ht=token-ring:\
             ha=10005a2f341b: ip=9.67.111.130: hn:



  --------------------------------------------------------------------
  14. SETTERM


  The -f parameter description has been clarified.

  >>--setterm--.-------.--.-----------.--><
               '- -fs -'  '- -f cfile-'


  -f cfile      Instructs SetTerm to access the cfile.CFG configuration
                file in the ETC subdirectory for the SetTerm definitions
                and display a menu to allow changes to the file.  If you
                issue the SETTERM command without this parameter, you
                access the TELNET.CFG file in the ETC subdirectory.



  --------------------------------------------------------------------
  15. SendMail Server and Client


     SendMail can be used in one of two modes, as a server or as
     a client.  The server mode is used for receiving mail, and
     the client mode is used for sending mail.

  --------------------------
  15.1 Server

     If both modes of SendMail are needed (which normally is the case),
     the SendMail server must always be started first.

     Following are examples of commands to start the SendMail server:

       sendmail -bd                start the SendMail server
       sendmail -q30m -bd          start the SendMail server and
                                   process the mail queue every 30
                                   minutes
       sendmail -d1.1 -q30m -bd    start the SendMail server, process
                                   the mail queue every 30 minutes, and
                                   log connections in the SENDMAIL.LOG
                                   file
       Note:  The SENDMAIL.LOG is not a message file.  You should use
              the -d1.1 parameter only for debugging purposes, because
              it records all details of the client-server handshaking
              procedure (as described in RFC 821) in the SENDMAIL.LOG.

     The SendMail server functions as follows:

        1. The command with a -bd flag starts a SendMail server which
           sets up the SendMail environment, copies the SENDMAIL.CF file
           to a shared memory and then waits for requests from SendMail
           clients to establish connections and to deliver mail.

        2. When a request for connection arrives, the server initiates
           another instance of SendMail (a SendMail child process) which
           initializes itself from the configuration information in the
           shared memory, and then services the connection and receives
           mail.

        3. Once the mail has been received and properly delivered to its
           destination, the SendMail child process closes the connection
           and exits.

     The number of SendMail child processes that can run at any one time
     is controlled by a Load Limiting variable which by default is 6,
     but can be changed by the OX option in the SENDMAIL.CF file.

  --------------------------
  15.2 Client

     The SENDMAIL client command now has additional parameters.  The
     SendMail client mode is usually started by a User Mail Agent, but
     can also be started from an OS/2 Command line.

     SYNTAX

     >>--sendmail--.-----.--.------.--.----------------.--------------->
                   '- -q-'  '- -bt-'  '- -Cmyconfig.CF-'

     >-- -af filename--.- -f user@localhost user@remotehost-.---------->
                       '- -t--------------------------------'

     >--.--------.----------------------------------------------------><
        |- -d1.1-|
        '- -d----'


     -q         Instructs SendMail to process the mail queue.  If you
                include other parameters, SENDMAIL will ignore them.

     -bt        Instructs SendMail to run in rule-testing mode.  You can
                use this parameter to test changes to rules in the
                configuration file.  In rule-testing mode, SendMail
                prompts you to enter a rule-set number and address, and
                then displays how the rule-set causes the address to be
                rewritten.  SendMail Version 1.3.0 always calls
                rule-set 3 first and then the entered rule-set number.
                In rule-testing mode, SendMail does not deliver any mail.
                This parameter cannot be used with any other parameter.

     -Cmyconfig.CF
                Specifies the name of a configuration file to use instead
                of SENDMAIL.CF.

     -af filename
                Specifies the name of the file that contains the mail
                message.

     -f user@localhost
                Identifies the user and host name of the sender.

     user@remotehost
                Identifies the user and host name of the receiver (or
                destination).

                NOTE:  OS/2 is not a multiuser operating system.  The
                user field of an address in an item of mail sent to an
                OS/2 system is not significant; however, it is required.
                The significant part of the address is the host name,
                with the domain name expansion if domain names are used.

     -t         Specifies that SENDMAIL retrieves the to and from
                information for the mail from the body of the file rather
                than from the command line.

     -d1.1      Creates only the SENDMAIL.LOG file.  The SENDMAIL.LOG
                file is placed in the ETC directory.

                NOTE:  The SENDMAIL.LOG is not designed to keep track of
                messages you send and receive.  You should use the -d1.1
                parameter only for debugging purposes, because it records
                all details of the client-server handshaking procedure
                (as described in RFC 821) in the SENDMAIL.LOG.

     -d         Writes detailed debugging information to the SENDMAIL
                console and creates a SENDMAIL.LOG file.

                NOTE:  The -d parameter produces a great deal of
                       information, and for performance reasons, should
                       be used only for debugging.

     Examples of the SendMail client startup command are:

            sendmail -af file -f sender recipient
                                            (Send a message using the
                                            SendMail client)

            sendmail -d1.1 -af file -f sender recipient
                                            (Send a message using
                                            the SendMail client
                                            and log the connection
                                            in the SENDMAIL.LOG file)

            sendmail -Cmyconfig.cf -af file -f sender recipient
                                            (Send a message using the
                                            SendMail client and also
                                            using MYCONFIG.CF instead
                                            of SENDMAIL.CF)

     The SendMail client also uses shared memory for Configuration
     information, if present, otherwise it gets this information by
     reading the SENDMAIL.CF file.

  --------------------------
  15.3 Considerations

     If SendMail is used for sending a message to several recipients on
     the same workstation, the number of recipients should be limited
     to 150.  A message for 150 recipients will be received as several
     files with lesser number of recipients in each (the number of
     recipients is limited by the header buffer space; recipients would
     be added to a header until that header ran out of room, then the
     process would begin again with a new header).

     If sending a message to 30 or fewer recipients, the whole file may
     be transmitted in one transaction.

     The processing time for sending a message to several recipients is
     much longer than that for a single recipient.  Potentially, the
     processing time may exceed the time-out of the client.  Time-out is
     determined by the idle time on the socket, and is typically measured
     from the last activity on the socket.  On a UNIX system, the client
     time-out is usually 2 minutes;  on an OS/2 system, it is usually 5
     minutes.

     If a client times out, the connection is not closed properly, and
     SendMail is not made aware of the completion status of the message.
     Sending a message to more than 150 recipients can cause the network
     connection to time out.  Therefore, the number of recipients for a
     given message should be limited to 150.

     On a busy server handling multiple transactions, you run the risk
     of not servicing a given connection fast enough, thereby allowing
     the client that established the connection to time out.  The client,
     not aware of the completion status of the message, then requeues the
     message for later delivery even though it may have been delivered
     already.  At a later time, the client delivers the same message
     again, and if the connection times-out again, the client requeues
     the message again.

     To prevent this undesirable looping, a network connection cannot be
     allowed to time out.  It is, therefore, imperative to use a server
     that has sufficient processing capability to handle the mail
     delivery load.  To send mail to large numbers of recipients, the
     minimum size of machine you should consider is a 33 Megahertz
     machine with 16 MB RAM, HPFS and DISKCACHE to enhance the disk
     performance.



  --------------------------------------------------------------------
  16. REXEC and RSH Redirection


     A redirection facility has been added for REXEC and RSH.

  --------------------------
  16.1 REXEC

     The REXEC command sends a single command to the remote host for
     execution.


     >>--rexec-- host--.---------------.--.--------------.--.-----.--->
                       '- -l loginname-'  '- -p password-'  '- -k-'

     >--.-----.--.-----.--.-----.-- command--.-------------.---------><
        '- -n-'  '- -b-'  '- -i-'            '- < filename-'


     -b   Transfers data to and from the remote host using binary mode.
          If you do not use this switch, REXEC transfers the data using
          ASCII mode.

          If you omit this switch, REXEC will strip the CR from each CRLF
          pair when sending data to the remote host and will add a CR to
          each LF on data received from the remote host.

     -i   Uses interactive mode for input.  REXEC reads input directly
          from the keyboard instead of from standard input (stdin).

     < filename
          Specifies the name of a file containing input to be used by the
          command being issued on the remote host.  Your filename can
          also include the path.  In cases where a command requires or
          accepts additional input, you can use this parameter to specify
          that the input comes from a file rather than from the keyboard.


  --------------------------
  16.2 RSH

     The RSH command issues a specified command at the remote host.


                    .- -l user environment variable-.
     >>--rsh--host--+-------------------------------+----------------->
                    '- -l loginname-----------------'

        .- -u value of -l argument-.
     >--+--------------------------+--.-----.--.-----.--.-----.------->
        '- -u local_loginname------'  '- -n-'  '- -b-'  '- -i-'

     >--.----------.--.-------------.--------------------------------><
        '- command-'  '- < filename-'


     -b   Transfers data to and from the remote host using binary mode.
          If you do not use this switch, RSH transfers the data using
          ASCII mode.

          If you omit this switch, RSH will strip the CR from each CRLF
          pair when sending data to the remote host and will add a CR to
          each LF on data received from the remote host.

     -i   Uses interactive mode for input.  RSH reads input directly
          from the keyboard instead of from standard input (stdin).

     < filename
          Specifies the name of a file containing input to be used by the
          command being issued on the remote host.  Your filename can
          also include the path.  In cases where a command requires or
          accepts additional input, you can use this parameter to specify
          that the input comes from a file rather than from the keyboard.



  --------------------------------------------------------------------
  17. Programming Support

  --------------------------
  17.1  REXX File Transfer Protocol API

     The REXX File Transfer Protocol (FTP) Application Program
     Interface (API) package provides access to the OS/2 TCP/IP FTP
     APIs.  It is assumed you are familiar with the basic FTP.  The
     REXX FTP API function names are similar to the FTP subcommands.
     For more information and installation instructions, view RXFTP.

  --------------------------
  17.2  REXX Socket Support

     The REXX Socket Support package provides access to the OS/2
     TCP/IP socket APIs.  It is assumed you are familiar with the
     basic socket APIs and that you can reference the OS/2 specific
     ones.  For more information and installation instructions,
     view RXSOCKET.



  --------------------------------------------------------------------
  18. Applications Kit / ANYNET Users Information


     If you are an Applications Kit or ANYNET user:

          1.  SO32DLL.DLL and TCP32DLL.DLL are required to run your
              applications.
          2.  These files will be shipped with the NEXT version of
              ANYNET.
          3.  You can unzip the files from BASEOC1.ZIP on disk 4 of
              CSD UN56401.



                 *************************************
***************** UN52840 CORRECTIVE SERVICE DISKETTE *******************
                 *************************************


   Contents of CSD UN52840:


           1. Running TCP/IP on ValuePoint Systems
           2. Using Additional Autostart Files
           3. Specifying a Port for FTPD
           4. Using NR/2 with LaMail
           5. SLIP Information Returned by NETSTAT
           6. Outbound FAX Support
           7. LPR Port Driver Filter Support
           8. The TCPINST Command
           9. The TCPDSKTP Command
          10. New Response File Options
          11. Changes to the CID Installation Process
          12. Adding Additional Device Drivers
          13. The FTPD Command
          14. The REXEC Command
          15. The RSH Command
          16. SENDMAIL.CF Addition
          17. The SLIP Command
          18. 3270 Emulator Keyboard Mappings
          19. TN5250 Emulator Changes
          20. The TELNETD Command
          21. Packet Tracing Programs
          22. Local Setup to Run TCPIPCFG from a LAN
          23. Network Security Program Support



  --------------------------------------------------------------------
  1. Running TCP/IP on ValuePoint Systems


        If you run the TCP/IP protocol stack in a ValuePoint system
        using an IBM Token-Ring 16/4 Adapter II, you may receive a
        TRAP 000D error in IFNET.SYS.  The protocol stack will not
        activate.  This is an error in the MAC driver for the adapter.

        If this error occurs, contact your IBM representative and
        request the latest MAC driver for the adapter.



  --------------------------------------------------------------------
  2. Using Additional Autostart Files


        You can use two command files to start your own processes from
        the TCP/IP autostart command file (TCPSTART.CMD).  One of the
        command files (B4TCP.CMD) is called before TCP/IP starts its
        applications, the other command file (TCPEXIT.CMD) is called
        after TCP/IP starts.

        You can create these files using a system editor.   They
        should be stored in the TCPIP\BIN subdirectory.

        NOTE:  As these files are separate from the TCPSTART.CMD file,
        they are not overwritten when you reinstall TCP/IP or when you
        modify TCPSTART.CMD.

        B4TCP.CMD:  Use this command file to start any processes you
        want to run before the TCP/IP applications are started.  For
        example, you could use this file to start another protocol
        stack.

        TCPEXIT.CMD:  Use this command file to start any processes
        that require TCP/IP to be running.  For example, you could use
        this file to start an OFFLOAD procedure.



  --------------------------------------------------------------------
  3. Specifying a Port for FTPD


        You can use the -p option of the FTPD command to specify a
        port that FTP clients will use to connect to FTPD.

        To specify a port, enter "ftpd -p <port>" where <port> is
        the port you want FTPD to use.  If you omit this option, FTPD
        uses its well-known port assignment.



  --------------------------------------------------------------------
  4. Using NR/2 with LaMail


        You might experience problems when you save an NR/2 file to a
        LaMail folder.  The function will appear to work (no error
        message is displayed), but the post does not appear in the
        folder.  The files may appear in the root directory of the
        drive where NR/2 and LaMail are installed (for example, in a
        file named 61664846.NR2).  A temporary solution for this is:

        1.  Close NR/2

        2.  From the LaMail action bar, select the Set Application
            Options item from the Options pull-down menu.

            a.  Take note of the paths in the Folders and In Basket
                fields.

            b.  Change these two paths to any valid path.

            c.  Select Ok.

                If the paths are not valid, an error message will be
                displayed.

        3.  Then again from the LaMail action bar, select the Set
            Application Options item from the Options pull-down menu.

            a.  Enter the paths that you noted earlier in the Folders
                and In Basket fields.

            b.  Select Ok.

        4.  Restart NR/2.



  --------------------------------------------------------------------
  5. SLIP Information returned by NETSTAT


        If you start SLIP at 76800 baud using the SIO.SYS and VSIO.SYS
        COM port drivers, the NETSTAT command can return incorrect
        information.  Under these circumstances, the "netstat -n"
        command will return an incorrect response of 1200 BPS for the
        SLIP speed.



  --------------------------------------------------------------------
  6. Outbound FAX Support


        TCP/IP Version 2.0 for OS/2 provides outbound FAX support
        through the use of an LPR Port Driver filter.  Any application
        that can print to an OS/2 Print Object can FAX it's printed
        output with no additional software at the client.

        SOFTWARE REQUIREMENTS:  To use the outbound FAX support, you
        must have a copy of FaxWorks for OS/2 at each server.  At each
        client workstation, install the IBM Proprinter Printer Driver,
        which is supplied with the OS/2 operating system.

        CONFIGURING THE LPR PORT DRIVER:  To configure an LPR port
        driver, do the following:

        1.  Create an OS/2 Work Place Shell print object using the
            printer icon in the Templates folder.

        2.  Associate the IBM Proprinter Printer driver with that
            print object.

        3.  Specify an LPD Port on the Output page of the Settings
            notebook.

        4.  Configure the LPD Port icon to specify the name and
            printer of an OS/2 LPD server running FaxWorks for OS/2.
            You will also need check the 'Enable data filter' check box,
            and fill in the 'Filter' entry with a PMFAXW command.

            For more information, see the PMFAXW.EXE filter in the
            section entitled "LPR Port Driver Filter Support" later in
            this file.

        Once this configuration is complete, any application that can
        print to that printer object can produce outbound faxes
        through an OS/2 LPD server.

        LIMITATIONS:  The following limitations exist with the FAX
        support:

        o   Only outbound FAX through a server is supported.

            There is no support for receiving a FAX and distributing
            it to the corresponding client.

        o   The print resolution using the IBM Proprinter printer
            driver is not as fine the resolution you can get using the
            FaxWorks for OS/2 Printer Object directly.



  --------------------------------------------------------------------
  7. LPR Port Driver Filter Support


        NOTE:  To view the figures in this section, please select the
               System Monospace font for your editor.

               If you use the E editor, select Set font from the
               Options pull-down menu.

               In the EPM editor, select Settings from the Preferences
               item on the Options pull-down menu.  Select the System
               Monospace font on the Fonts page.

        Two new fields have been added to the LPD Port Icon Settings
        window.  These fields control the use of a LPR Port Driver
        Filter.  An LPR Port Driver Filter allows the user to specify
        a program that can filter the data that is sent to the LPD
        Server specified in the 'Print Destinations' section of the
        Settings window.  These two fields consist of a checkbox with
        the label 'Enable data filter', and an entry field labeled
        'Filter'.


    Ŀ
    .. \PIPE\LPD<x> - Settings                                              
    ĭ
                                                                             
                                       Ŀ                                   
      Print Destination Ŀ   Display port settings on print    
                  Ŀ                                    
      LPD server                   Ŀ                                   
                  ٳ   Enable data filter                
                  Ŀ         Ŀ 
      LPD printer                      Filter                          
                  ٳ             
                                            
    




        A filter specifies a command run by the LPD Port Driver.  This
        command receives the print data as input (through standard
        input).  The output that the command produces (to standard
        output) is then sent to the LPD Server.  This allows the user
        to specify programs that convert one form of data to another
        for use by a specific device.

        The filter program doesn't have to be an executable; it can be
        anything that the command interpreter (CMD.EXE) can execute.
        For example, you can use the following REXX command to add a
        time and date stamp to the beginning of the data being
        printed:

        /* DATESTMP.CMD: Adds a time and date stamp to the beginning of a file */
           say 'Printing: 'date('W') date('N') 'at' time('C')
           do while stream('STDIN:','S') == 'READY'
                   say linein()
           end
           exit 0


        Note that the program ends in 'exit 0'.  This is necessary
        because if the filter returns anything other than a '0', the
        LPR Port Driver interprets it as an error and will not send
        the job to the server to be printed.

        To specify an LPD Port Filter, select the 'Enable data filter'
        checkbox in the Settings window for the corresponding LPD Port
        icon, and enter a filter command in the Filter field.

        You can enter parameters for the program specified in the
        Filter field.  You can also pass any keywords that are defined
        for use in the 'Additional Control Cards' field (see the
        "Users Guide" for more information about 'Additional Control
        Cards' keywords).

        For example, if you specify 'DATESTMP <document>', and modify
        the above DATESTMP.CMD with the following changes:

        /* DATESTMP.CMD: Adds a time and date stamp to the beginning of a file */
           parse arg filename
           say 'Printing: 'filename' on 'date('W') date('N') 'at' time('C')
           do while stream('STDIN:','S') == 'READY'
                   say linein()
           end
           exit 0

        You will get a timestamp that also has the actual name of the
        file being printed.



    Ŀ
    .. \PIPE\LPD<x> - Settings                                              
    ĭ
                                                                             
                                       Ŀ                                   
      Print Destination Ŀ   Display port settings on print    
                  Ŀ                                    
      LPD server  print_server_1   Ŀ                                   
                  ٳ x Enable data filter                
                  Ŀ         Ŀ 
      LPD printer text_printer         Filter DATESTMP <document>      
                  ٳ             
                                            
    




        We are providing two filters:

        NULFLTR.EXE         Pass through  filter  that  adds  whatever
                            parameters   are   passed  to  it  at  the
                            beginning of the data file.

        PMFAXW.EXE          A filter  which  supports  remote  fax'ing
                            through  a  server  running  OS/2 TCP/IP's
                            LPD.EXE  and  FaxWorks  OS/2  V1.30   from
                            SofNet.   When using this filter, you must
                            select IBM Proprinter as the corresponding
                            Printer Object's printer driver.

                            This filter will pop up a dialog box  when
                            you  print  a  job,  and will allow you to
                            specify both 'To' and 'From' information.

                To:
                   Name    - Name of person to receive fax, which appears
                             on the cover page.
                   Company - Company name of person receiving fax, which
                             appears on the cover page.
                   Fax #   - Fax number to fax file to.  This is a
                             required field, and is where you specify the
                             phone number of the destination fax machine.

                From:

                   Name    - Your name which appears on the cover page.
                   Company - Your company's name which appears on the
                             cover page.
                   Phone # - Your phone number, which appears on the
                             cover page.
                   Fax #   - Your fax number, which appears on the cover
                             page.
                   Comment - Cover page comment.
                   Header  - If specified, defines the page header, and
                             implicitly enables page headers.

        By passing parameters to PMFAXW.EXE, you can specify  defaults
        for  any  or  all of the above fields.  Following is a list of
        parameters that can be passed to PMFAXW:

                   >>TO=<name>,<company>,<faxnumber>
                   >>FROM=<name>,<company>,<phonenumber>,<faxnumber>
                   >>INFO=<comment>,<heading>

        By passing any or all of the above parameters you can  default
        the  corresponding  field in the PMFAXW dialog box.  If you do
        not wish  to  specify  all  of  the  fields  on  a  particular
        parameter,  you  can leave that entry blank, but the number of
        comma's (',') must stay the same.

        Example:
           PMFAXW ">>FROM=JP Doe,Widget's,,(xxx)yyy-zzzz" ">>INFO=,<document>"


        The previous example produces the following  dialog  box  when
        ever  you  go  to  print  a  file to the corresponding Printer
        Object.

        NOTE:  The field with <document> would be filled in  with  the
               corresponding document name actually being printed.

                Ŀ
                  Fax Works Filter                      
                ĭ
                                                        
                   To Ŀ   
                              Ŀ    
                     Name                           
                                  
                              Ŀ    
                     Company                        
                                  
                              Ŀ    
                     Fax #                          
                                  
                     
                                                        
                   From Ŀ   
                              Ŀ    
                     Name     JP Doe                
                                  
                              Ŀ    
                     Company  Widget's              
                                  
                              Ŀ    
                     Phone #                        
                                  
                              Ŀ    
                     Fax #    (xxx)yyy-zzzz         
                                  
                              Ŀ    
                     Comment                        
                                  
                              Ŀ    
                     Header   <document>            
                                  
                     
                                                        
                     Ŀ    Ŀ     
                          OK           CANCEL       
                              
                                                        
                



  --------------------------------------------------------------------
  8. The TCPINST Command


     The TCPINST command has changes to let you:

     o   Specify that TCP/IP start from either the startup folder or the
         STARTUP.CMD file

     o   Specify individual services that will start when TCP/IP starts.

     o   Specify where to write logging information.

     o   Specify that TCPINST will make the necessary changes to the
         CONFIG.SYS file.

       >>tcpinst>
                     /sf
       >>
|          /srv:"service1,service2, ... servicen"
       >>
           /l1:path:\filename.extension
       >><
           /l2:path:\filename.extension   /c   /a

     /sf-      Specifies that TCPSTART will be added to the STARTUP.CMD
               file rather than to the startup folder.  If you omit this
               option, TCPSTART is added to the startup folder and not
               the STARTUP.CMD file.

               Note:  This option causes the /sf- option to be passed to
                      TCPDSKTP, which then adds TCPSTART to the
                      STARTUP.CMD file.

     /srv:"service1,service2, ... servicen"
               Enter /srv: followed by a list of names of TCP/IP
               services, enclosed in quotation marks, that you want
               started from TCPSTART.CMD.  If you enter more than one
               service name, separate the service names with commas.
               You can select service names from this list:

                        inetd            ftpd             tftpd
                        pmx              talkd            portmap
                        nfsd             nfsstart         routed
                        nr2              lamail           lprportd
                        sendmail

     /l1:path\filename.extension
               Writes logging information to the specified file.  For
               example:

                  tcpinst /l1:d:\tmp\tcpip.log

               Writes logging information to the file d:\tmp\tcpip.log.

               Typically the path points to a location on a code server
               so that a network administrator can access the log if a
               failure occurs.

     /l2:path\filename.extension
               Writes logging information to the specified file.  For
               example:

                  tcpinst /l2:d:\tmp\tcpip2.log

               Writes logging information to the file d:\tmp\tcpip2.log.

     /c        Causes TCPINST to make the necessary changes to CONFIG.SYS,
               but does not actually install the product.  This is useful
               if your CONFIG.SYS gets erased during the installation of
               OS/2.  (Note that the installation exits must be in
               SOURCE_PATH because the exits actually modify CONFIG.SYS.)

     /a-       Specifies that the installation will be done unattended.
               The TCP/IP installation window will be displayed at the
               target workstation, but no action is required of the user.



  --------------------------------------------------------------------
  9. The TCPDSKTP Command


     The TCPDSKTP command lets you start TCP/IP from either the startup
     folder or the STARTUP.CMD file.

       >>tcpdsktp><
                      /sf

     /sf-      Specifies that TCPSTART will be added to the STARTUP.CMD
               file rather than to the startup folder.  If you omit this
               option, TCPSTART is added to the startup folder and not
               the STARTUP.CMD file.



  --------------------------------------------------------------------
  10. New Response File Options


     There are new options you can put in a response file.

     TCP_SERVICES        Lets you specify which TCP/IP services to start
                         automatically when you start TCP/IP itself.
                         This is the same as coding the /srv: option on
                         the TCPINST command.

     STARTUP_FOLDER=Y|N  Lets you specify whether TCP/IP starts from the
                         STARTUP.CMD file or the startup folder.  This is
                         the same as using the /sf- option on the TCPINST
                         command.

     And there is a change to the EXEC=BASE line in the default response
     file to work with these new options.


  --------------------------
  10.1 TCP_SERVICES=service1,service2, ... servicen


     Use this option in a response file to specify TCP/IP services to
     start when TCP/IP starts.  You can select service names from this
     list:

                        inetd            ftpd             tftpd
                        pmx              talkd            portmap
                        nfsd             nfsstart         routed
                        nr2              lamail           lprportd
                        sendmail


  --------------------------
  10.2 STARTUP_FOLDER=Y|N


     You can add the STARTUP_FOLDER=Y|N option to the response file to
     specify where TCP/IP starts from.

           STARTUP_FOLDER=N

     The STARTUP_FOLDER=N option in a response file adds TCPSTART to the
     STARTUP.CMD file.  While this option:

           STARTUP_FOLDER=Y

     adds TCPSTART to the Startup folder.


  --------------------------
  10.3 EXEC=BASE Line


     If you will install this kit using a CID installation, be sure to
     merge your current default response file with the default response
     file shipped on this kit.  Then look at your default response file
     to ensure that the TCP_SERVICES and STARTUP_FOLDER options have been
     added to the EXEC=BASE entry like this:

      EXEC = BASE call basext BOOT_DRIVE TARGET_PATH MPTN_INSTALLED NTS2_DIR
        HOSTNAME IP_ADDR NETMASK ROUTE DNSDOMAIN NAMESERVER STARTUP_FOLDER
        TCP_SERVICES



  --------------------------------------------------------------------
  11. Changes to the CID Installation Process


     TCP/IP Version 2.0 for OS/2 has added support for installing TCP/IP
     remotely using a software distribution manager (SDM).  The
     changes are:

     o   Changes to the TCPINST and TCPINST2 commands
     o   Changes to the DEFAULT.RSP used by SDM
     o   Corrections to "Installation and Configuration Parameters"



  --------------------------
  11.1 Changes to the TCPINST and TCPINST2 Commands


     To enable you to install TCP/IP using an SDM, the following
     parameters have been added to the TCPINST and TCPINST2 commands:

     o   /a-

         Specifies that the install is to be performed on an unattended
         basis.  The TCP/IP Installation window will be displayed at the
         target workstation, but no action will be required on the part
         of the user.

     o   /l1:<fully-qualified_path>

         Specifies the fully-qualified path (drive, subdirectories, and
         file name) to which TCP/IP will write a log.  The path typically
         points to a location on the code server so an administrator can
         access the log in case of a failure.


  --------------------------
  11.2 Changes to the DEFAULT.RSP Used by SDM


     Some of the parameters included in the TCP/IP DEFAULT.RSP file are
     incompatible with the SDM parameters.  Source path and response path
     are determined at the time of installation.  Also, software
     distribution managers use a common set of parameters to specify
     variables such as a log path.  Therefore, if you install TCP/IP
     using an SDM, use the TCPINST command line equivalent parameters to
     specify the following:


             RSP_FILE
             SOURCE_PATH
             LOG_PATH
             LAPS_EXEC_PATH
             LAPS_LOG_PATH


  --------------------------
  11.3 Corrections to "Installation and Configuration Parameters"


     This section discusses corrections to the information in the section
     titled "Installation and Configuration Parameters" of the TCP/IP
     Version 2.0 for OS/2:  Installation and Configuration manual.  In
     the printed book, this section starts on page 15.  In the
     BookManager book, this section is topic 2.6.3.

     The following is a corrected description of the LAPS parameter:

         LAPS_RSP_FILE=<laps_response_file>

         Specifies the fully-qualified path (drive, subdirectories, and
         file name) on the code server of the response file to be used
         when LAPS is installed.

         This is optional.  You can specify this information in your
         CONFIG.SYS or as a parameter of the installation command.

     The following is a list of parameters that were not documented:

         HPFS_NEEDED=<name>

         Specifies the abbreviated name of the kit or component being
         installed that requires a high performance file system (HPFS)
         drive.  More than one kit or component can be specified,
         separated by spaces.  This parameter is required if you are
         installing kits that require HPFS.

         For a list of kit and component names, see the table of
         Abbreviated Names in the section titled "Setting up the Code
         Server" of the TCP/IP Version 2.0 for OS/2:  Installation and
         Configuration manual.

         EXEC=<name> CALL <exit_routine> BOOT_DRIVE TARGET_PATH

         Specifies the exit routine to be used for each kit or component.
         The exit routines are named: <name>XT.EXE, where <name> is the
         abbreviated name of the kit or component.  This parameter is
         required for each kit being installed.

         For a list of kit and component names, see the table of
         Abbreviated Names in the section titled "Setting up the Code
         Server" of the TCP/IP Version 2.0 for OS/2:  Installation and
         Configuration manual.

     For additional information about installing a program using an SDM,
     see the documentation for the software distribution manager that you
     are using.



  --------------------------------------------------------------------
  12. Adding Additional Device Drivers


     Use this procedure to add additional Drivers to TCP/IP.  You can use
     this procedure for any card not listed in the default LAPS
     configuration.

     1.  Install LAPS.  Select one of the device drivers listed and save
         it.

     2.  From the adapter-card vendor, get the NDIS Drivers  (the *.OS2
         and *.NIF files), and manually copy them into the IBMCOM\MACS
         subdirectory.

     3.  Rerun LAPS to configure it and select the added driver.

     4.  If the new adapter is not listed in LAPS, edit the .NIF file to
         the same format as one supplied by IBM, or contact the
         adapter-card vendor and get one that will work with IBM's
         TCP/IP.



  --------------------------------------------------------------------
  13. The FTPD Command


     The FTPD command now has a -c option, that lets you specify a
     codepage, and a -p option that lets you specify a port number.

       >>ftpd><
                  -p <portno>   -c <codepage>

     -p <portno>
               Specifies the port that you want FTPD to use.  If you omit
               this option, FTPD uses its well-known port assignment.

     -c <codepage>
               Specifies the ASCII codepage used by the remote host.  If
               you do not specify a codepage, the data is sent
               untranslated.  The possible values are:

               TCPDECMU       for the DEC Multinational codepage
               TCP8859        for ISO 8859 codepage
               NONE           for PC codepage 850



  --------------------------------------------------------------------
  14. The REXEC Command


     The REXEC command adds the -b and -i switches.

       >>rexechost>
                         -l loginname   -p password   -k
       >command><
           -n   -b   -i

     -b        Transfers data to and from the remote host using binary
               mode.  If you do not use this switch, REXEC transfers the
               data using the ascii mode.

               If you omit this switch, RSH will strip the CR from a CRLF
               pair when sending data to the remote host and will add a
               CR to the LF on data received from the remote host.

     -i        Uses interactive mode for input.  REXEC reads input
               directly from the keyboard instead of from standard input
               (stdin).



  --------------------------------------------------------------------
  15. The RSH Command


     The RSH command adds the -u, -b, and -i switches.

                       -l user environment variableĿ
       >>rshhost>
                       -l loginname
           -u value of -l argumentĿ
       >>
           -u local_login_name   -n    -b    -i 
       >><
           command

     -u local_login_name
           Specifies the user ID on the local host.  If you omit this
           value, the value of the -l argument is used by default.

           For example, to use RSH with a VM remote host, you would use
           -l for the VM password and -u for the VM user ID.

     -b    Transfers data to and from the remote host using binary mode.
           If you do not use this switch, RSH transfers the data using
           the ascii mode.

     -i    Uses interactive mode for input.  RSH reads input directly
           from the keyboard instead of from standard input (stdin).



  --------------------------------------------------------------------
  16. SENDMAIL.CF Addition


     You can add the OT option to the Options section of your SENDMAIL.CF
     file.  YOU MUST use an editor (such as the E.EXE editor) that
     preserves tabs!

     Use the OT option to tell the SENDMAIL program at your workstation
     how to process mail to be delivered to a host that is currently not
     receiving.  If you omit the OT option, the mail is deleted from the
     queue when you next start SENDMAIL.  You can use the OT option to
     tell SENDMAIL to keep the mail on its queue, and to continue trying
     to resend it, for a specified period of time.

     The format of the OT option is:

                   OTxt

     OT        Code the characters OT as shown.

     x         This value tells SENDMAIL for how long to keep the mail in
               its queue for re-transmission.  Replace the "x" with a
               number specifying the number of hours, days, minutes, or
               weeks.

     t         This value tells SENDMAIL how often to resend to a server
               that failed.  Replace the "t" with a unit of time.

               w         The x value is the number of weeks.
               d         The x value is the number of days.
               h         The x value is the number of hours.
               m         The x value is the number of minutes.

     Here is an example of the OT option that tells SENDMAIL to keep the
     undelivered mail in its queue, and to keep trying to resend it, for
     8 hours before deleting it from the queue.

        #####################################################################
        # Options Timeout parameter:                                        #
        # Causes notes, sent to a server that was down, to be queued        #
        # for retry.  OTxt   Where x is a number and t is the timeout char: #
        #   h-hours, d-days, m-minutes.                                     #
        # Without the OTxt specification, the message does not get queued.  #
        #####################################################################
        OT8h



  --------------------------------------------------------------------
  17. The SLIP Command


     The SLIP command now has a -t operand to start packet tracing.

       >>><
            -d   -t

     -t        Specifies that the SLIP command start tracing packets.

               The -t option starts SLIP tracing all packets received
               from and sent to the modem.  The data is written to
               SLIPTRC.DMP in the directory from which SLIP was  started.
               To stop the trace, press the Ctrl-c  or Ctrl-Break keys.

               Because SLIP will record all traffic sent and received,
               the SLIPTRC.DMP file can grow quite large.  There is no
               error checking to see if there is enough hard disk space
               available to continue recording the information.  You
               should use this trace option in a limited fashion so that
               it does not impact the performance of the workstation
               where it is being run.



  --------------------------------------------------------------------
  18. 3270 Emulator Keyboard Mappings


     The User's Guide lists the OS/2 keys that you can remap to different
     functions.  Following are changes to the names of the OS/2 keyboard
     keys that you can remap.


  --------------------------
  18.1 Key Name


     You need to use the full name of the key for these keys.


         Change    To

         Del       Delete
         Esc       Escape
         Ins       Insert
         PgDn      Pagedown
         PgUp      Pageup
         Scrlock   Scroll-lock


  --------------------------
  18.2 TN3270 Emulator



     KEYS YOU CANNOT REMAP:  For TN3270, you cannot remap these
     OS/2 keys:

         Backtab
         Space
         ScrLock
         Pause
         Printscreen
         All numeric keypad keys except the Enter key


     KEYS YOU CAN REMAP:  The User's Guide incorrectly lists the OS/2
     keys that you can remap.  It neglects to add the various states of
     the OS/2 function keys.  The following is a corrected list of the
     OS/2 keys and key combinations that you can remap.

     o   F1 through F12
     o   Control-F1 through Control-F12
     o   Alt-F1 through Alt-F12
     o   Shift-F1 through Shift-F12
     o   Control-'unshifted_keypress'
     o   Alt-'unshifted_keypress'
     o   Shift-OS/2_function_key
     o   Alt-OS/2_function_key
     o   Ctrl-OS/2_function_key
     o   Any  OS/2_function_key

     For TN3270, these are the OS/2_function_keys that you can remap:

     Backspace                           Left-Alt
     Delete                              Left-Control
     Down                                Newline (Enter key on alpha keypad)
     End                                 Pagedown
     Enter (Enter key on numeric keypad) Pageup
     Escape                              Right
     F1-F12                              Right-Alt
     Home                                Right-Control
     Insert                              Up
     Left                                Tab


  --------------------------
  18.3 PMANT Emulator


     KEYS YOU CANNOT REMAP:  For PMANT, you cannot remap these OS/2 keys:

         Backtab
         Printscreen
         All numeric keypad keys except the Enter key


     KEYS YOU CAN REMAP:  The User's Guide incorrectly lists the OS/2
     keys that you can remap.  It neglects to add the various states of
     the OS/2 function keys.  The following is a corrected list of the
     OS/2 keys and key combinations that you can remap.

     o   F1 through F12
     o   Control-F1 through Control-F12
     o   Alt-F1 through Alt-F12
     o   Shift-F1 through Shift-F12
     o   Control-'unshifted_keypress'
     o   Alt-'unshifted_keypress'
     o   Shift-OS/2_function_key
     o   Alt-OS/2_function_key
     o   Ctrl-OS/2_function_key
     o   Any  OS/2_function_key

     For PMANT, these are the OS/2_function_keys that you can remap:

     Backspace                           Left-Control
     Delete                              Newline (Enter key on alpha keypad)
     Down                                Pagedown
     End                                 Pageup
     Enter (Enter key on numeric keypad) Pause
     Escape                              Right
     F1-F12                              Right-Alt
     Home                                Right-Control
     Insert                              Scroll-lock
     Left                                Up
     Left-Alt                            Tab



  --------------------------------------------------------------------
  19. TN5250 Emulator Changes


     In the TCP/IP 2.0 for OS/2 User's Guide, we list the OS/2 keys that
     you can remap to different functions.  The syntax for remapping the
     keyboard is:

             os2_key whitespace 5250_function ;optional comment

     Following are changes to the names of the OS/2 keyboard keys that
     you can remap.  The valid 'os2_key' names are:

     o   F1 through F12
     o   Control-F1 through Control-F12
     o   Alt-F1 through Alt-F12
     o   Shift-F1 through Shift-F12
     o   Control-'unshifted_keypress'
     o   Alt-'unshifted_keypress'
     o   Control-os2_function_key
     o   Alt-os2_function_key
     o   Shift-os2_function_key
     o   Any  os2_function_key

     The valid 'os2_function_key' names are:

                       BACKSPACE                  LEFT-CONTROL
                       DELETE                     NEWLINE
                       DOWN                       PAGEDOWN
                       END                        PAGEUP
                       ENTER (On numeric keypad)  RIGHT
                       ESCAPE                     RIGHT-ALT
                       F1-F12                     RIGHT-CONTROL
                       HOME                       SCROLL-LOCK
                       INSERT                     TAB
                       LEFT                       UP
                       LEFT-ALT

     The valid '5250_function' names are:

                       ATTN                       FORWARD-WORD
                       AUTOENTER                  HELP
                       BACKSPACE                  HOME
                       BACKTAB                    INSERT
                       BACKWARD-KILL-WORD         KILL-WORD
                       BACKWARD-WORD              LEFT
                       CENT                       NEWLINE
                       CLEAR                      PF1-PF24
                       DELETE                     PRINT
                       DOWN                       RECBACK
                       DUP                        RESET
                       END                        RIGHT
                       ENTER                      ROLLDOWN
                       ERASE-EOF                  ROLLUP
                       ERASE-INPUT                SPBACKSPACE
                       FIELD-MARK                 SYSREQ
                       FIELDEXIT                  TAB
                       FIELDMINUS                 TESTREQ
                       FIELDPLUS                  UP

     Additional valid '5250_function' names (work only in documents and
     mail):

                       TEXTDPBACKSPACE            TEXTPAGEEND
                       TEXTCARRIERRETURN          TEXTDUP
                       TEXTENDATTRIBUTE           TEXTBOTTOMOFPAGE
                       TEXTFASTLEFT               TEXTBEGINOFLINE
                       TEXTFASTRIGHT              TEXTALTD
                       TEXTINTENSIFY              TEXTTOPOFPAGE
                       TEXTNEWLINE                TEXTFIELDBACKSPACE
                       TEXTRQSPACE                TEXTSTOPCODEFUNCTION
                       TEXTRQTABFUNCTION          TEXTCENT
                       TEXTSYMBOLSCMDPROMPT       TEXTSTOPCODEADVANCE
                       TEXTUNDERSCORE



  --------------------------------------------------------------------
  20. The TELNETD Command


     The TELNETD command now has a -c operand to specify a codepage.

       >>telnetd>
                     -p port   -b   -d   -l
           -e 50Ŀ   -u telnet_passwordĿ
       >>
           -e escapedelay   -u password
       >><
           -c <codepage>

     -c <codepage>
               Specifies the ASCII codepage used by the remote host.  If
               you do not specify a codepage, the data is sent
               untranslated.  The possible values are:

               TCPDECMU       for the DEC Multinational codepage
               TCP8859        for ISO 8859 codepage
               NONE           for PC codepage 850



  --------------------------------------------------------------------
  21. Packet Tracing Programs


     This kit provides documentation for a set of utilities
     that aid in diagnosing problems at your workstation.
     These files are in stalled in the <tcpip>\BIN directory.


             IPTRACE.EXE
             TR2SNIF.EXE
             IPPARSE.EXE
             IPFORMAT.EXE



  --------------------------
  21.1 IPTRACE.EXE


     IPTRACE will trace all packets received from and sent to the
     Ethernet or token-ring adapter.  There are no parameters associated
     with IPTRACE.

       >>iptrace><

     The data is written to IPTRACE.DMP in the directory from which
     IPTRACE was  started.  To stop IPTRACE, press the Ctrl-c keys.
     Because IPTRACE will record all traffic sent and received, the
     IPTRACE.DMP file can grow quite large.  There is no error checking
     to see if there is enough hard disk space available to continue
     recording the information.  You should use IPTRACE in a limited
     fashion so that it does not impact the performance of the
     workstation where it is being run.  IPTRACE is not a network
     monitor.  It can trace only data received by and sent from the
     adapter.  Also, IPTRACE does not provide a time stamp: it does not
     record when the packet was sent or received. After you start
     IPTRACE, it  traces all adapters at the workstation.  You can not
     select one adapter when several are installed.


  --------------------------
  21.2 TR2SNIF.EXE


     TR2SNIF converts the IPTRACE.DMP file to a format that can be viewed
     on a network monitor trace workstation (a network analyzer).  This
     file will not contain any time information.  Start TR2SNIF from the
     same directory where the IPTRACE.DMP file resides. You can code:

       >>tr2snife><
                    t

     e     Specifies Ethernet output.

     t     Specifies token-ring output.


  --------------------------
  21.3 IPPARSE.EXE


     IPPARSE  reads the IPTRACE.DMP file and produces a HEX dump for the
     screen.  You can redirect this information to a file that you can
     browse with an editor.  Start IPPARSE from the same directory where
     the IPTRACE.DMP file resides.

     You can enter IPPARSE with no parameter to dump the data to the
     screen, or you can enter IPPARSE <filename> to dump the data to the
     named file.

       >>ipparse><
                    >filename

     >filename Specifies a file into which the data is dumped.


  --------------------------
  21.4 IPFORMAT.EXE


     IPFORMAT tries to format the IPTRACE.DMP and the SLIPTRC.DMP files
     into a user-readable format and display it to the screen.  You can
     redirect the output  to a file for browsing with a editor.  If
     IPFORMAT cannot determine what type of packet was received, a HEX
     representation of the data is displayed.  IPFORMAT will separate the
     IP, TCP, UDP, and ICMP layers.  The rest of the packet will be
     displayed as HEX output.

     If IPFORMAT encounters a problem with the file, you may receive a
     General Protection Fault message.  Customers should run IPPARSE and
     see if it is able to to parse the file completely or if it returns
     "error reading from iptrace.dmp".  In either case, IPFORMAT will
     format the data until it reaches a problem.

                                        -f IPTRACE.DMPĿ
       >>ipformat>
                      -a   -d   -f filename   -h
       > -? ><
           -n   -s hwaddress  >filename

      -a            Do not format ARP or RARP packets.

      -d            Do not display the data portion of a packet.

      -f filename   Specifies the input fine name.  The default is
                    IPTRACE.DMP.

      -h            Display the raw data packet after the formatted
                    information.

      -s hwaddress  Format data only for the specified hardware address.
                    Replace hwaddress with the 12-digit hexadecimal
                    address for the Ethernet or token-ring adapter.  You
                    can use the NETSTAT -n command to display this
                    address.

      -n            Do not display hexadecimal data for unknown data
                    type.

     > filename     Redirect the output to the specified file.

      -?            Display help information.



  --------------------------------------------------------------------
  22. Local Setup to Run TCPIPCFG from a LAN


     Here are some things you should do to set up your local system to
     run the TCPIPCFG program when TCP/IP resides on a LAN server.  Make
     sure the following are set up on the local workstation:


  --------------------------
  22.1 For the Applications Kit


     Set up:

     1.  A local <tcpip>/bin directory, and specify it in the PATH
         statement before the remote <tcpip>/bin directory.  The local
         directory should contain: inet.sys, telnet.exe, and
         tcpipcfg.exe.

     2.  A local <tcpip>/dll directory, and specify it in the LIBPATH
         statement before you specify a remote <tcpip>/dll directory.
         The local directory should contain: cnbstk.dll and cnbapp.dll.



  --------------------------
  22.2 For the NFS Kit


     Set up:

     1.  A local <tcpip or nfskit>/bin directory, and specify it in the
         PATH statement before the remote <tcpip or nfskit>/bin
         directory.  The local directory should contain nfsd.exe.

     2.  A local <tcpip or nfskit>/dll directory, and specify it before
         the remote <tcpip or nfskit>/dll directory in the LIBPATH
         statement.  The local directory should contain cnbnfs.dll.


  --------------------------
  22.3 For the X Windows System Server kit


     Set up:

     1.  A local <tcpip or pmxkit>/bin directory, and specify it in the
         PATH statement before the remote <tcpip or pmxkit>/bin
         directory.  The local directory should contain pmx.exe.

     2.  A local <tcpip or pmxkit>/dll directory, and specify it before
         the remote <tcpip or pmxkit>/dll directory in the LIBPATH
         statement.  The local directory should contain cnbpmx.dll.



  --------------------------
  22.4 For the Extended Networking Kit


     Set up:

     1.  A local <tcpip or xntkit>/bin directory, and specify in the PATH
         statement before the remote <tcpip or xntkit>/bin directory.
         The local directory should contain x25io.exe.

     2.  A local <tcpip or xntkit>/dll directory, and specify it before
         the remote <tcpip or xntkit>/dll directory in the LIBPATH
         statement.  The local directory should contain cnbx25.dll.



  --------------------------
  22.5 For the DOS/Windows Access kit


     Set up:

     1.  A local <tcpip>/bin directory, and specify it in the PATH
         statement before the remote <tcpip>/bin directory.  The local
         directory should contain vdostcp.vdd.



  --------------------------------------------------------------------
  23. Network Security Program Support


     This kit includes a Telnet server that can use the authentication
     services of the Network Security Program (NetSP).  You can get the
     NetSP by ordering program number 5622-061.  The following
     information tells you how to setup Telnet using the authentication
     feature provided by the Network Security Program (NetSP), and
     includes:

     o   An introduction to Telnet using the NetSP program
     o   Installation and Configuration instructions
     o   How to use Telnet with NetSP

     This file does not contain the information for setting up NetSP.
     For more information about how to set up and use NetSP, please refer
     to the Network Security Program for AIX, OS/2, and DOS: Developer's
     Guide (SC31-6500).


  --------------------------
  23.1 Introduction


     The Network Security Program (NetSP) provides a trusted third-party
     security program that authenticates the credentials of both a user
     at the Telnet client workstation and the server program at the
     Telnet server workstation.  This trusted third party is called the
     Authentication Server, and provides the means by which the user's
     program and application program can identify and validate each
     other.

     The Telnet server and client identify the Telnet user at the client
     workstation and at the Telnet server workstation using the
     Authentication Server provided by NetSP.  This third party
     authentication process is efficient because it reduces the number of
     administrative tasks when you want to add, change, or delete users
     and their access to programs.  After you define a user to the
     Authentication Server, and after that user gets security credentials
     from the Authentication Server, that user can be authenticated to
     use any application program known to that Authentication Server.  In
     effect, it takes only one administrative action to add a new client
     to all application servers in the network.

     Telnet, using the authentication feature provided by NetSP, no
     longer requires the user to enter the Telnet password of the target
     host for authorized Telnet connection.  This yields Telnet
     connections that are more convenient and more secure.


  --------------------------
  23.2 Installation and Configuration


     In order to use the Telnet with NetSP, you must install both TCP/IP
     and NetSP on the Telnet server and client workstations, and
     configure those workstations to use the authentication feature.

     The following is a brief overview of the installation and
     configuration processes for Telnet with NetSP:

     1.  Use TCPINST to install TCP/IP V2.0 for OS/2 on the Telnet server
         and client workstations.

     2.  Follow NetSP installation process to install NetSP on your
         Telnet server and client workstations.

     3.  Have your Authentication Server administrator add the Telnet
         server name to the Authentication Server.  The Telnet server
         name should contain the character string "TELNET." followed by
         the complete host name of the Telnet server workstation.  For
         example, if the host name is test.raleigh.ibm.com, the Telnet
         server name would be TELNET.test.raleigh.ibm.com.

     4.  Have your Authentication Server administrator add the Telnet
         user's name to the Authentication Server.

     5.  Ensure that you have the <tcpip>\bin subdirectory on your PATH
         statement, and that the KK.DLL and KKTelnet.DLL files are in a
         directory that is in your LIBPATH statement.

     6.  On the Telnet server workstation, use the SETTCPPF command to
         set the Telnet authentication option in the TCP/IP profile
         (TCPIP.INI) to optional (1) or required (2).  The SETTCPPF
         command has the following format:

           >>settcppf -Telnet 0><
                                    1ĭ  
                                    2  
                          -displayĭ
                          ?

         -Telnet <value> Specifies

                        0    Sets authentication off.
                        1    Sets authentication to optional.  The server
                             will attempt to authenticate the user, but
                             will complete the login even if the
                             authentication fails.
                        2    Sets authentication to mandatory.  The
                             server will attempt to authenticate the
                             user, and will complete the login only if
                             the authentication is successful.

         -display       Displays the authentication status at the
                        workstation.

         ?              Displays the syntax of the settcppf command.



  --------------------------
  23.3 Authenticating a Telnet Connection


     Before using Telnet with NetSP, create a master-key cache file on
     both Telnet server and client workstations.

     To create master-key cache file on the Telnet server workstation,
     use KKINSTK (a NetSP function) to enter a master key into the cache
     file.  You should use the KKINSTK command with -s option to
     initialize a cache file on the Telnet server workstation.  (For
     information about KKINSTK, see the Network Security Program for AIX,
     OS/2, and DOS: Developer's Guide.)

     To create master-key cache file on the Telnet client workstation,
     use KKLOGIN (another NetSP function) or KKINSTK to enter a master
     key into the cache file.  (For information about KKINSTK and
     KKLOGIN, see the Network Security Program for AIX, OS/2, and DOS:
     Developer's Guide.)

     After you create master-key cache files on both Telnet client and
     server workstations, you can issue the Telnet command to start
     Telnet.

           telnet <targetName>

     If the Telnet authentication option is set to optional (1) or
     required (2) on the Telnet server workstation, an authentication
     message is displayed on the Telnet client when authentication is
     started.  When authentication process ends, an authentication
     success or failed message is displayed on the Telnet client.  If
     authentication fails, and the Telnet authentication option on the
     server work station is set to optional (1), the normal login process
     is performed as usual.




                 *************************************
*****************            Fixed APARs              *******************
                 *************************************


  1. APARs Fixed


     The following is a list of APARs fixed since this release became
     available.  APARs are grouped numerically by CSD.

  --------------------------
  1.1 APARS Fixed in CSD UN56401

     +==========+===============+=======================================+
     |          | MODULES       |                                       |
     | APAR     | AFFECTED      | DESCRIPTION                           |
     +==========+===============+=======================================+
     | PN46622  | TCPINST.EXE   | Fixed: When performing a CID Attended |
     |          | TCPINST2.EXE  | Install, the INSTALL program did not  |
     |          |               | select the adapter or the protocol.   |
     +----------+---------------+---------------------------------------+
     | PN47008  | SENDMAIL.EXE  | Fixed: Multiple Sendmail causing      |
     |          |               | system to hang.                       |
     +----------+---------------+---------------------------------------+
     | PN47308  | TELNETPM.EXE  | Fixed: When opening multiple telnetpm |
     |          |               | windows, cursor is not displayed on   |
     |          |               | the first telnetpm window.            |
     +----------+---------------+---------------------------------------+
     | PN47373  | TELNETPM.EXE  | Fixed: When using TelentPM to log     |
     |          |               | onto an OS/2 machine using VT220 mode,|
     |          |               | if a command is entered that will     |
     |          |               | scroll the screen, TelnetPM either    |
     |          |               | forces the user off or stops          |
     |          |               | displaying the results on the screen. |
     +----------+---------------+---------------------------------------+
     | PN48022  | PMANT.EXE     | Fixed: PMANT and TN3270 to a COMTEN   |
     |          | TN3270.EXE    | that is connected to MVS doesn't      |
     |          |               | display logon screen on the console.  |
     +----------+---------------+---------------------------------------+
     | PN48051  | SNMPD.EXE     | Fixed: SYSUPTIME is set to zero in    |
     |          |               | SNMPTRAP.                             |
     +----------+---------------+---------------------------------------+
     | PN48241  | SNMPTRAP.EXE  | Fixed: SNMP TRAP addressing exception |
     |          | SNMPTRAP.HLP  | occurs when using enterprise specific |
     |          | SNMP.EXE      | trap.                                 |
     +----------+---------------+---------------------------------------+
     | PN48275  | RSHD.EXE      | Fixed: RSHD does not accept commands; |
     |          |               | "Unauthorized Request Rejected" error |
     |          |               | message displays.                     |
     +----------+---------------+---------------------------------------+
     | PN48444  | TN3270.EXE    | Fixed: Issuing TN3270 using syntax    |
     |          |               | shown in the Command Reference with   |
     |          |               | the -ext parameter before the port    |
     |          |               | parameter results in message that the |
     |          |               | remote host name is missing.          |
     +----------+---------------+---------------------------------------+
     | PN48454  | NR2.EXE       | Fixed: When NR/2 is accessing the News|
     |          |               | Server, it will stop at a News Group  |
     |          |               | and issue the message, "The News      |
     |          |               | Server does not handle XHDR."  NR/2   |
     |          |               | stops processing.                     |
     +----------+---------------+---------------------------------------+
     | PN48509  | NR2.EXE       | Fixed: While running NR/2, and        |
     |          | NR2.HLP       | attempting to add multiple News       |
     |          |               | Groups, the function fails to         |
     |          |               | complete.                             |
     +----------+---------------+---------------------------------------+
     | PN48570  | TELNET.EXE    | Fixed: PRINT THRU does not work       |
     |          | TELNETPM.EXE  | properly with TELNET (VT100/VT220)    |
     +----------+---------------+---------------------------------------+
     | PN48742  | TELNET.EXE    | Fixed: When using VT220 to DEC        |
     |          | TELNETPM.EXE  | machine, all tab fields in which      |
     |          |               | the cursor resides are corrupted.     |
     +----------+---------------+---------------------------------------+
     | PN48816  | TELNETPM.EXE  | Fixed: The cursor in telnetpm is hard |
     |          |               | to see when it reaches the bottom of  |
     |          |               | the window.  Need block cursor.       |
     +----------+---------------+---------------------------------------+
     | PN48902  | SENDMAIL.EXE  | Fixed: SENDMAIL receives stack over-  |
     |          |               | flow msg and stops.                   |
     +----------+---------------+---------------------------------------+
     | PN49057  | TELNETPM.EXE  | Fixed: TELNETPM V2.0 not processing   |
     |          | TELNET.EXE    | screen size parameters properly       |
     +----------+---------------+---------------------------------------+
     | PN49117  | FTPPM.EXE     | Fixed: FTPPM to an MVS machine results|
     |          |               | in truncated host dataset names.  Any |
     |          |               | attempt to put/get local/remote files |
     |          |               | fails.                                |
     +----------+---------------+---------------------------------------+
     | PN49266  | SENDMAIL.EXE  | Fixed: SENDMAIL 1.2.12 makes only one |
     |          |               | attempt to deliver mail to hosts that |
     |          |               | are inactive.                         |
     +----------+---------------+---------------------------------------+
     | PN49360  | PMANT.EXE     | Fixed: Not all applications that      |
     |          | TN3270.EXE    | contain APL box characters work       |
     |          | 3278XLT.TBL   | properly.                             |
     +----------+---------------+---------------------------------------+
     | PN49775  | CNBNFS.DLL    | Fixed: When using the Configuration   |
     |          |               | Notebook to set up the exports, unable|
     |          |               | to make a directory R/O if no hostname|
     |          |               | is specified.                         |
     +----------+---------------+---------------------------------------+
     | PN50202  | SNMPD.EXE     | Fixed: SNMPD loses requests when      |
     |          |               | connection is still open.             |
     +----------+---------------+---------------------------------------+
     | PN50269  | FTPPM.EXE     | Fixed: FTPPM, when left idle, will    |
     |          | FTPAPI.DLL    | restore files to home directory.      |
     +----------+---------------+---------------------------------------+
     | PN50287  | FTP.EXE       | Fixed: 'Codepage none' is not the     |
     |          |               | default when starting the FTP client. |
     +----------+---------------+---------------------------------------+
     | PN50505  | TELNET.EXE    | Fixed: TELNET VT220 connection to     |
     |          | TELNETPM.EXE  | Silicon Graphics machine hangs.       |
     +----------+---------------+---------------------------------------+
     | PN50783  | SENDMAIL.EXE  | Fixed: SENDMAIL for TCP/IP 2.0 cannot |
     |          |               | handle MAILGATE.COMPUSERVE.COM        |
     +----------+---------------+---------------------------------------+
     | PN50873  | WPTELNET.DLL  | Fixed: Telnet template doesn't save   |
     |          |               | port number properly.                 |
     +----------+---------------+---------------------------------------+
     | PN50874  | SLIP.EXE      | Fixed: When NFS is running over SLIP  |
     |          | SLCFG.EXE     | to an OS/2 NFS server, if a DIR       |
     |          | SLIPHOLD.EXE  | command results in more than 74 files,|
     |          | SLIPTERM.EXE  | NFS hangs.                            |
     |          | SLIPWAIT.EXE  |                                       |
     |          | ATANS.CMD     |                                       |
     |          | ATDIAL.CMD    |                                       |
     +----------+---------------+---------------------------------------+
     | PN51021  | FTPWPS.DLL    | Fixed: FTPPM doesn't save user ID and |
     |          |               | password settings properly.           |
     +----------+---------------+---------------------------------------+
     | PN51031  | FTPPM.EXE     | Fixed: Drag-and-drop to FTPPM results |
     |          | FTPPM.HLP     | in local directory name being lost.   |
     |          | FTPAPI.DLL    |                                       |
     +----------+---------------+---------------------------------------+
     | PN51032  | FTPPM.EXE     | Fixed: Trailing colon on remote       |
     |          |               | directory names (for Sun and Unix     |
     |          |               | workstations) prevents doubleclicking |
     |          |               | on a directory name to change to it.  |
     +----------+---------------+---------------------------------------+
     | PN51218  | TELNET.EXE    | Fixed: Telnet displays File Not Found |
     |          | TELNETPM.EXE  | message when scrolling up or down in  |
     |          |               | UniSPF editor window.                 |
     +----------+---------------+---------------------------------------+
     | PN51436  | SO32DLL.DLL   | Fixed: Select() call fails when more  |
     |          |               | than 256 connections are attempted.   |
     +----------+---------------+---------------------------------------+
     | PN51569  | RSH.EXE       | Fixed: RSH doesn't accept commands of |
     |          | REXEC.EXE     | the form: /USR/BIN/LS                 |
     +----------+---------------+---------------------------------------+
     | PN51617  | TCPINST.EXE   | Fixed: Installing TCPIP from a        |
     |          | TCPINST2.EXE  | diskette drive other than drive A:,   |
     |          |               | TCPINST continues to ask for          |
     |          |               | information from drive A: and not B:. |
     +----------+---------------+---------------------------------------+
     | PN51626  | PMANT.EXE     | Fixed: TN3270 PMANT reset modified    |
     |          | TN3270.EXE    | data tag fields using -ext option not |
     |          |               | being returned properly;  protected   |
     |          |               | versus unprotected field attributes   |
     |          |               | not being saved properly.             |
     +----------+---------------+---------------------------------------+
     | PN51641  | IFNDIS.SYS    | Fixed: ARP -s does not work.          |
     +----------+---------------+---------------------------------------+
     | PN51643  | BOX.EX        | Fixed: LaMail doesn't place notes in  |
     |          | DRAW.EX       | correct folder.                       |
     |          | E3EMUL.EX     |                                       |
     |          | EPM.EX        |                                       |
     |          | EPMLEX.EX     |                                       |
     |          | EPMLIST.EX    |                                       |
     |          | EXTRA.EX      |                                       |
     |          | FIC.DLL       |                                       |
     |          | GET.EX        |                                       |
     |          | HELP.EX       |                                       |
     |          | LAM55LE.DLL   |                                       |
     |          | LAM55LR.DLL   |                                       |
     |          | LAMAIL.EXE    |                                       |
     |          | LAMAIL.HLP    |                                       |
     |          | LAMAILER.DLL  |                                       |
     |          | LAMEXTRA.EX   |                                       |
     |          | LAMFILES.OUT  |                                       |
     |          | LAMRES.DLL    |                                       |
     |          | MAILLIST.EX   |                                       |
     |          | MATHLIB.EX    |                                       |
     |          | PUT.EX        |                                       |
     +----------+---------------+---------------------------------------+
     | PN51923  | WPTELNET.DLL  | Fixed: TelnetPM settings notebook does|
     |          |               | not properly process the Logfile and  |
     |          |               | Tracefile fields.                     |
     +----------+---------------+---------------------------------------+
     | PN52008  | RSH.EXE       | Fixed: RSH and REXEC are only able to |
     |          | REXEC.EXE     | transmit first part of large files.   |
     +----------+---------------+---------------------------------------+
     | PN52479  | TELNETPM.EXE  | Fixed: TELNETPM copy to clipboard     |
     |          |               | replaces some lines with CRLF.        |
     +----------+---------------+---------------------------------------+
     | PN52743  | TELNET.EXE    | Fixed: VI editor problems occur when  |
     |          | TELNETPM.EXE  | using VT100 emulator.                 |
     +----------+---------------+---------------------------------------+
     | PN52769  | CNBSTK.DLL    | Fixed: When using the TCP/IP          |
     |          | CNBAPP.DLL    | Configuration utility to edit the     |
     |          |               | sendmail.cf file, the Mlocal          |
     |          |               | definition is deleted or commented    |
     |          |               | out.                                  |
     +----------+---------------+---------------------------------------+
     | PN52828  | TELNET.EXE    | Fixed: Unable to emulate VT100 in     |
     |          | TELNETPM.EXE  | Telnet.                               |
     +----------+---------------+---------------------------------------+
     | PN52910  | CNBAPP.DLL    | Fixed: TCPIPCFG doesn't build the     |
     |          |               | RHOSTS file properly.                 |
     +----------+---------------+---------------------------------------+
     | PN53112  | FTP.EXE       | Fixed: When using the FTP client to go|
     |          |               | to an MVS or VM machine, some ASCII   |
     |          |               | characters are translated to EBCDIC   |
     |          |               | incorrectly.                          |
     +----------+---------------+---------------------------------------+
     | PN53370  | IFCONFIG.EXE  | Fixed: Unable to enter all 1's as a   |
     |          |               | broadcast address.                    |
     +----------+---------------+---------------------------------------+
     | PN53515  | LAMAIL.EXE    | Fixed: First note sent after startup  |
     |          | LAM551R.DLL   | is lost.                              |
     +----------+---------------+---------------------------------------+
     | PN53518  | LAMAIL.EXE    | Fixed: LaMail Nickname file is lost   |
     |          |               | from notes options panel.             |
     +----------+---------------+---------------------------------------+
     | PN53573  | RPCGEN.EXE    | Fixed: RPCGEN.EXE doesn't produce the |
     |          |               | proper TYPEDEF statement.             |
     +----------+---------------+---------------------------------------+
     | PN53626  | FTPD.EXE      | Fixed: Using DOS FTP or WFTP to OS/2  |
     |          | FTPDC.EXE     | produces:  550 GETCWD ERROR: ERROR 13 |
     |          | FTPDTRC.EXE   |                                       |
     +----------+---------------+---------------------------------------+
     | PN53938  | TELNET.EXE    | Fixed: Lines do not wrap properly in  |
     |          |               | an ansi telnet VI session.            |
     +----------+---------------+---------------------------------------+
     | PN54025  | FTPPM.EXE     | Fixed: FTPPM settings does not allow  |
     |          | FTPAPI.DLL    | creation of a new window.             |
     |          | FTPWPS.DLL    |                                       |
     +----------+---------------+---------------------------------------+
     | PN54041  | SNMPD.EXE     | Fixed: SNMPD.EXE crashes if an OID    |
     |          |               | has more than 50 sub-IDs              |
     +----------+---------------+---------------------------------------+
     | PN54999  | FTPWPS.DLL    | Fixed: FTPPM icon disappears from     |
     |          |               | TCP/IP and templates folders.         |
     +----------+---------------+---------------------------------------+
     | PN55603  | TCPIPCFG.EXE  | Fixed: When SLIP changes for          |
     |          | CNBSTK.DLL    | SETUP.CMD are saved the lan adapter   |
     |          | CNBAPP.DLL    | settings get lost.                    |
     +----------+---------------+---------------------------------------+
     | PN56391  | FTPPM.EXE     | Fixed: FTPPM does not send a proper   |
     |          | FTPAPI.DLL    | character for a space when it is part |
     |          |               | of the password.                      |
     +----------+---------------+---------------------------------------+


  --------------------------
  1.2 The following APARs were fixed in CSD UN52840.  These
      changes are included in this CSD as well.

     +==========+===============+=======================================+
     |          | MODULES       |                                       |
     | APAR     | AFFECTED      | DESCRIPTION                           |
     +==========+===============+=======================================+
     | PN45987  | TN3270.EXE    | Fixed: TN3270 resizes the OS/2 window |
     |          |               | when finished.                        |
     +----------+---------------+---------------------------------------+
     | PN46145  | TN3270.EXE    | Fixed: TN3270 and PMANT blank fill    |
     |          | PMANT.EXE     | invisible input fields.               |
     +----------+---------------+---------------------------------------+
     | PN46718  | TCPINST.EXE   | Fixed: TCP/IP for OS/2 is not CID     |
     |          |               | enabled.                              |
     +----------+---------------+---------------------------------------+
     | PN47132  | TN5250.EXE    | Fixed: Unable to remap some TN5250    |
     |          |               | functions to different keys.          |
     +----------+---------------+---------------------------------------+
     | PN47313  | TELNETD.EXE   | Fixed: TELNET to OS/2 cannot Ctl-c    |
     |          | TELNETDC.EXE  | out.                                  |
     +----------+---------------+---------------------------------------+
     | PN49178  | WPTELNET.EXE  | Fixed: Terminal type on TEMPLATE is   |
     |          |               | not being passed.                     |
     +----------+---------------+---------------------------------------+
     | PN47508  | TELNET.EXE    | Fixed: VT220 keyboard mapping of      |
     |          |               | SETTERM facility produces X'0D'.      |
     +----------+---------------+---------------------------------------+
     | PN47668  | CNBAPP.DLL    | Fixed: TCPIPCFG SLIP doesn't check    |
     |          |               | ATTACH parms for double quotes.       |
     +----------+---------------+---------------------------------------+
     | PN47666  | CNBAPP.DLL    | Fixed: TCPIPCFG does not read SLIP    |
     |          |               | script ATTACH parms with comma.       |
     +----------+---------------+---------------------------------------+
     | PN47906  | TELNET.EXE    | Fixed: Unable to Telnet to HP         |
     |          | TELNETPM.EXE  | machine.                              |
     +----------+---------------+---------------------------------------+
     | PN49356  | RSH.EXE       | Fixed: RSH causes CPU utilization to  |
     |          |               | go to 100%.                           |
     +----------+---------------+---------------------------------------+

