/*
 * Decompiled with CFR 0.152.
 */
package xnap.util.prefs;

import java.text.MessageFormat;
import java.util.StringTokenizer;
import xnap.XNap;
import xnap.util.prefs.Validator;

public class PortRangeValidator
implements Validator {
    private int min;
    private int max;
    private boolean valid;

    public void validate(String string) throws IllegalArgumentException {
        this.valid = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() == 0) continue;
            try {
                if (string2.indexOf("-") != -1) {
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-");
                    if (stringTokenizer2.countTokens() == 2) {
                        int n = Integer.parseInt(stringTokenizer2.nextToken());
                        int n2 = Integer.parseInt(stringTokenizer2.nextToken());
                        this.check(n);
                        this.check(n2);
                        this.valid |= n <= n2;
                        continue;
                    }
                    throw new IllegalArgumentException(XNap.tr("Malformed range."));
                }
                this.check(Integer.parseInt(string2));
                this.valid = true;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(XNap.tr("Malformed number."));
            }
        }
        if (!this.valid) {
            throw new IllegalArgumentException(XNap.tr("No port given."));
        }
    }

    public void check(int n) throws IllegalArgumentException {
        if (n < this.min || n > this.max) {
            throw new IllegalArgumentException(MessageFormat.format(XNap.tr("Port out of range {0}."), "(" + this.min + " - " + this.max + ")"));
        }
    }

    public PortRangeValidator(int n, int n2) {
        this.min = n;
        this.max = n2;
    }

    public PortRangeValidator() {
        this(1, 65535);
    }
}

