/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import xnap.util.JarClassLoader;
import xnap.util.Preferences;
import xnap.util.SearchFilter;
import xnap.util.SearchFilterHelper;

public class FileHelper {
    private static Logger logger = Logger.getLogger(class$Lxnap$util$FileHelper != null ? class$Lxnap$util$FileHelper : (class$Lxnap$util$FileHelper = FileHelper.class$("xnap.util.FileHelper")));
    private static /* synthetic */ Class class$Lxnap$util$FileHelper;

    public static synchronized File createUnique(String string) throws IOException {
        logger.debug("FileHelper: creating unique: " + string);
        File file = new File(FileHelper.uniqueName(string));
        file.createNewFile();
        return file;
    }

    public static synchronized File createUnique(String string, String string2) throws IOException {
        File file = new File(string);
        if (file.isDirectory() || file.mkdirs()) {
            string2 = string2.replace(File.separatorChar, '_');
            return FileHelper.createUnique(string + string2);
        }
        throw new FileNotFoundException();
    }

    public static synchronized File moveUnique(File file, String string, String string2) throws IOException {
        String string3 = FileHelper.appendSeparator(string) + string2;
        logger.debug("moveUnique new name: " + string3);
        if (string3.equals(file.getAbsolutePath())) {
            return file;
        }
        File file2 = new File(string);
        if (file2.isDirectory() || file2.mkdirs()) {
            File file3 = new File(FileHelper.uniqueName(string3));
            logger.debug("moveUnique new file: " + file3);
            if (FileHelper.move(file, file3)) {
                return file3;
            }
            throw new FileNotFoundException("Could not rename " + file.getAbsolutePath() + " to " + file3.getAbsolutePath());
        }
        throw new FileNotFoundException("Could not create " + file2.getAbsolutePath());
    }

    public static synchronized File moveUnique(File file, String string) throws IOException {
        return FileHelper.moveUnique(file, string, file.getName());
    }

    public static boolean move(File file, File file2) throws IOException {
        if (!file.renameTo(file2)) {
            FileHelper.copy(file, file2);
            file.delete();
        }
        return true;
    }

    public static void copy(File file, File file2) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            while ((n = bufferedInputStream.read()) != -1) {
                ((BufferedOutputStream)filterOutputStream).write(n);
            }
        }
        finally {
            IOException iOException2;
            Object var5_5 = null;
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException2) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException2) {}
            }
        }
    }

    public static String extension(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0 || n == string.length() - 1) {
            return "";
        }
        return string.substring(n + 1, string.length()).toLowerCase();
    }

    public static String extension(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n < 0 || n == string.length() - 1) {
            return "";
        }
        return string.substring(n + 1, string.length()).toLowerCase();
    }

    public static String getDownloadDirFromExtension(String string) {
        String string2 = FileHelper.extension(string);
        int n = SearchFilterHelper.getMediatypeFromExtension(string2);
        Preferences preferences = Preferences.getInstance();
        String string3 = preferences.getMediaTypeDownloadDir((String)SearchFilter.media[n]);
        if (n != 0 && string3.length() > 0) {
            return string3;
        }
        return preferences.getDownloadDir();
    }

    public static URL getResource(String string) {
        return JarClassLoader.getInstance().getResource(string);
    }

    public static InputStream getResourceAsStream(String string) {
        JarClassLoader.getInstance();
        return ClassLoader.getSystemResourceAsStream(string);
    }

    public static String name(String string) {
        int n = string.lastIndexOf(".");
        if (n < 1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String uniqueName(String string) {
        return FileHelper.uniqueName(string, "");
    }

    public static String uniqueName(String string, String string2) {
        String string3 = FileHelper.extension(string);
        if (string3.length() > 0) {
            string3 = "." + string3;
            string = FileHelper.name(string);
        }
        if (string2.length() > 0) {
            string2 = "." + string2;
        }
        if (FileHelper.exists(string + string2 + string3)) {
            int n = 1;
            while (true) {
                if (!FileHelper.exists(string + string2 + "." + n + string3)) {
                    return string + string2 + "." + n + string3;
                }
                ++n;
            }
        }
        return string + string2 + string3;
    }

    public static boolean exists(String string) {
        return new File(string).exists();
    }

    public static final String getHomeDir(String string) {
        String string2;
        File file;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("user.home"));
        stringBuffer.append(File.separatorChar);
        stringBuffer.append(".xnap");
        stringBuffer.append(File.separatorChar);
        if (string.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append(File.separatorChar);
        }
        if ((file = new File(string2 = stringBuffer.toString())).isDirectory() || file.mkdirs()) {
            return string2;
        }
        return "";
    }

    public static final String getHomeDir() {
        return FileHelper.getHomeDir("");
    }

    public static String appendSeparator(String string) {
        if (string.length() > 0 && !string.endsWith(File.separator)) {
            return string + File.separator;
        }
        return string;
    }

    public static String directory(String string) {
        if ((string = string.trim()).length() == 0) {
            string = System.getProperty("user.dir");
        }
        return FileHelper.appendSeparator(string);
    }

    public static String directories(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            File file = new File(string2);
            stringBuffer.append(file.getAbsolutePath());
            stringBuffer.append(";");
        }
        string = stringBuffer.toString();
        return string.length() > 0 ? string.substring(0, string.length() - 1) : "";
    }

    /*
     * Loose catch block
     */
    public static void shorten(File file, long l) {
        block10: {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                randomAccessFile.setLength(Math.max(randomAccessFile.length() - l, 0L));
                Object var5_4 = null;
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
                break block10;
                {
                    catch (IOException iOException) {
                        Object var5_5 = null;
                        try {
                            randomAccessFile.close();
                        }
                        catch (IOException iOException2) {}
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeProperties(File file, Properties properties) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "This file was automatically generated.");
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (fileOutputStream == null) return;
        fileOutputStream.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readBinary(File file, Collection collection) throws IOException {
        logger.debug("reading binary file: " + file);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
            int n = objectInputStream.readInt();
            int n2 = 0;
            while (n2 < n) {
                try {
                    Object object = objectInputStream.readObject();
                    if (object != null) {
                        collection.add(object);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.warn("error while reading binary file", classNotFoundException);
                }
                ++n2;
            }
            Object var4_8 = null;
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            try {
                if (objectInputStream == null) throw throwable;
                objectInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (objectInputStream == null) return;
        objectInputStream.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeBinary(File file, Collection collection) throws IOException {
        logger.debug("writing " + collection.size() + " items to binary file: " + file);
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeInt(collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                objectOutputStream.writeObject(iterator.next());
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                if (objectOutputStream == null) throw throwable;
                objectOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (objectOutputStream == null) return;
        objectOutputStream.close();
        return;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

