/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import java.io.IOException;
import java.util.Arrays;
import xnap.cmdl.Console;
import xnap.net.IChannel;
import xnap.net.IChatServer;
import xnap.net.event.ChannelListener;
import xnap.net.event.ChannelSupport;
import xnap.util.EventVector;
import xnap.util.Notifier;
import xnap.util.Preferences;

public class ChatManager {
    private static ChatManager singleton = new ChatManager();
    private static Console console = Console.getInstance();
    private static Preferences prefs = Preferences.getInstance();
    protected ChannelSupport cs = new ChannelSupport(this);
    protected EventVector channels = new EventVector();
    protected EventVector chatServers = new EventVector();

    public static synchronized ChatManager getInstance() {
        return singleton;
    }

    public void addChannel(IChannel iChannel) {
        this.channels.add(iChannel);
        Notifier.getInstance().channelAdded(iChannel);
    }

    public void addServer(IChatServer iChatServer) {
        if (!this.chatServers.contains(iChatServer)) {
            this.chatServers.add(iChatServer);
            String[] stringArray = prefs.getAutoJoinChannelsArray();
            int n = 0;
            while (n < stringArray.length) {
                try {
                    IChannel iChannel = iChatServer.create(stringArray[n]);
                    iChannel.join();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++n;
            }
        }
    }

    public EventVector getChannels() {
        return this.channels;
    }

    public void addChannelListener(ChannelListener channelListener) {
        this.cs.addChannelListener(channelListener);
    }

    public EventVector getChatServers() {
        return this.chatServers;
    }

    public void globalMessageReceived(String string) {
        this.cs.fireMessageReceived(string, 2);
    }

    public void removeChannel(IChannel iChannel) {
        iChannel.close();
        this.channels.remove(iChannel);
    }

    public void removeChannelListener(ChannelListener channelListener) {
        this.cs.removeChannelListener(channelListener);
    }

    public void removeServer(IChatServer iChatServer) {
        this.chatServers.remove(iChatServer);
    }

    public boolean isAutoJoinChannel(IChannel iChannel) {
        String[] stringArray = prefs.getAutoJoinChannelsArray();
        return Arrays.asList(stringArray).contains(iChannel.getName().toLowerCase());
    }

    private ChatManager() {
    }
}

