/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net.msg.client;

import java.io.File;
import xnap.io.MP3File;
import xnap.io.VideoFile;
import xnap.plugin.nap.net.msg.client.ClientMessage;
import xnap.plugin.nap.util.NapFileHelper;
import xnap.util.FileHelper;
import xnap.util.SearchFilterHelper;

public class ShareFileMessage
extends ClientMessage {
    public static final int TYPE = 100;

    public ShareFileMessage(int n, File file) {
        super(100);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        stringBuffer.append(NapFileHelper.getShareString(n, file));
        stringBuffer.append("\" ");
        if (file instanceof MP3File) {
            MP3File mP3File = (MP3File)file;
            stringBuffer.append("0 ");
            stringBuffer.append(mP3File.length());
            stringBuffer.append(" ");
            stringBuffer.append(mP3File.getBitrate());
            stringBuffer.append(" ");
            stringBuffer.append(mP3File.getFrequency());
            stringBuffer.append(" ");
            stringBuffer.append(mP3File.getPlayingTime());
        } else if (file instanceof VideoFile) {
            this.type = 10300;
            stringBuffer.append(file.length());
            stringBuffer.append(" 0 video");
        } else {
            int n2 = SearchFilterHelper.getMediatypeFromExtension(FileHelper.extension(file.getName()));
            if (n2 == 0) {
                stringBuffer.append("0 ");
                stringBuffer.append(file.length());
                stringBuffer.append(" ");
                stringBuffer.append("24 16000 600");
            } else {
                this.type = 10300;
                stringBuffer.append(file.length() + " 0 ");
                switch (n2) {
                    case 1: {
                        stringBuffer.append("audio");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("video");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("image");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("application");
                        break;
                    }
                    case 5: {
                        stringBuffer.append("text");
                        break;
                    }
                    default: {
                        stringBuffer.append("text");
                    }
                }
            }
        }
        this.data = stringBuffer.toString();
    }
}

