/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;
import xnap.io.ThrottledInputStream;
import xnap.net.AbstractDownload;
import xnap.net.IDownloadContainer;
import xnap.net.NetHelper;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.net.DownloadSocket;
import xnap.plugin.nap.net.SearchResult;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.msg.ExceptionListener;
import xnap.plugin.nap.net.msg.FilenameMessage;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.AltDownloadRequestMessage;
import xnap.plugin.nap.net.msg.client.DownloadCompleteMessage;
import xnap.plugin.nap.net.msg.client.DownloadRequestMessage;
import xnap.plugin.nap.net.msg.client.DownloadingFileMessage;
import xnap.plugin.nap.net.msg.client.PrivateMessage;
import xnap.plugin.nap.net.msg.server.AcceptFailedMessage;
import xnap.plugin.nap.net.msg.server.DownloadAckMessage;
import xnap.plugin.nap.net.msg.server.ErrorMessage;
import xnap.plugin.nap.net.msg.server.GetErrorMessage;
import xnap.plugin.nap.net.msg.server.MessageListener;
import xnap.plugin.nap.net.msg.server.MessageStream;
import xnap.plugin.nap.net.msg.server.QueueLimitMessage;
import xnap.plugin.nap.net.msg.server.ServerMessage;

public class Download
extends AbstractDownload
implements MessageListener,
ExceptionListener {
    public static final int SERVER_TIMEOUT = 120000;
    public static final int CONNECT_TIMEOUT = 60000;
    public static final int QUEUED_REQUEST_INTERVAL = 300000;
    public static final int REQUEST_INTERVAL = 120000;
    public static final int MAX_WANT_QUEUE = 5;
    protected static Logger logger = Logger.getLogger(class$Lxnap$plugin$nap$net$Download != null ? class$Lxnap$plugin$nap$net$Download : (class$Lxnap$plugin$nap$net$Download = Download.class$("xnap.plugin.nap.net.Download")));
    private SearchResult sr;
    private Server server;
    protected Socket socket;
    protected InputStream in;
    protected OutputStream out;
    protected long offset;
    protected int port;
    protected String ip;
    private boolean subscribed = false;
    private boolean requestSent = false;
    private long lastRequestSent = 0L;
    private int wantQueueCount = 0;
    private static /* synthetic */ Class class$Lxnap$plugin$nap$net$Download;

    public int available() throws IOException {
        return this.in.available();
    }

    public void close(boolean bl) {
        if (bl) {
            MessageHandler.send(new DownloadCompleteMessage());
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        this.close(true);
    }

    public boolean connect(long l) throws IOException {
        if (this.requestSent) {
            this.requestSent = false;
            this.sr.getNapUser().incQueuedCount(-1);
        }
        this.setQueuePos(-1);
        this.wantQueueCount = 0;
        this.start();
        this.offset = l;
        if (this.port == 0) {
            if (!this.establishReverseStream()) {
                return false;
            }
        } else {
            this.establishStream(this.ip, this.port);
        }
        this.in = new ThrottledInputStream(this.in);
        MessageHandler.send(new DownloadingFileMessage());
        return true;
    }

    public void dequeue() {
        if (this.requestSent) {
            this.requestSent = false;
            this.sr.getNapUser().incQueuedCount(-1);
        }
        this.wantQueueCount = 0;
        this.lastRequestSent = 0L;
        this.unsubscribe(this);
    }

    public void exceptionThrown(Exception exception) {
        this.getParent().remove(this);
    }

    public void enqueue(IDownloadContainer iDownloadContainer) {
        this.setParent(iDownloadContainer);
        this.subscribe(this);
        boolean bl = this.sr.getNapUser().isAllowedToRequestDownload();
        if (bl || this.requestSent) {
            if (!this.requestSent) {
                this.requestSent = true;
                this.sr.getNapUser().incQueuedCount(1);
            }
            this.sendDownloadRequest(false);
        } else if (!bl && this.requestSent) {
            this.requestSent = false;
            this.sr.getNapUser().incQueuedCount(-1);
        }
        this.lastTry = System.currentTimeMillis();
    }

    private final int getRequestInterval() {
        String string = this.sr.getUser().getClientInfo();
        if (string != null && string.startsWith("nap") || this.getQueuePos() <= 0) {
            return 120000;
        }
        return 300000;
    }

    private final void sendDownloadRequest(boolean bl) {
        if (bl || System.currentTimeMillis() - this.lastRequestSent > (long)this.getRequestInterval()) {
            DownloadRequestMessage downloadRequestMessage = new DownloadRequestMessage(this.sr.getUser().getName(), this.sr.getFilename());
            downloadRequestMessage.setExceptionListener(this);
            MessageHandler.send(this.server, downloadRequestMessage);
            this.lastRequestSent = System.currentTimeMillis();
        }
    }

    private final void establishStream(String string, int n) throws IOException {
        logger.debug("opening socket " + string + ":" + n);
        this.socket = NetHelper.connect(string, n, 60000L);
        try {
            this.socket.setSoTimeout(60000);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.out = this.socket.getOutputStream();
        this.in = new BufferedInputStream(this.socket.getInputStream());
        logger.debug("reading magic number");
        char c = (char)this.in.read();
        if (c != '1') {
            throw new IOException(Plugin.tr("Invalid request"));
        }
        String string2 = "GET";
        this.out.write(string2.getBytes());
        this.out.flush();
        string2 = this.server.getUsername() + " " + "\"" + this.sr.getFilename() + "\"" + " " + this.offset;
        logger.debug("the whole request: " + string2);
        this.out.write(string2.getBytes());
        this.out.flush();
        String string3 = this.sr.getFilesize() + "";
        StringBuffer stringBuffer = new StringBuffer();
        while (stringBuffer.length() < string3.length()) {
            int n2 = this.in.read();
            if (n2 == -1) {
                throw new IOException(Plugin.tr("Socket error"));
            }
            c = (char)n2;
            if (Character.isDigit(c)) {
                if (this.sr.getFilesize() != 0L && stringBuffer.length() == 0 && c == '0') continue;
                stringBuffer.append(c);
                continue;
            }
            if (c == 'F') {
                throw new IOException(Plugin.tr("File not shared"));
            }
            throw new IOException(Plugin.tr("Invalid request"));
        }
        logger.debug("file length: " + stringBuffer.toString());
        if (Long.parseLong(stringBuffer.toString()) != this.sr.getFilesize()) {
            throw new IOException(Plugin.tr("Filesizes did not match"));
        }
    }

    private final boolean establishReverseStream() throws IOException {
        if (this.server.getLocalPort() == 0) {
            throw new IOException(Plugin.tr("Both parties firewalled"));
        }
        MessageStream messageStream = new MessageStream(this.server);
        MessageHandler.subscribe(404, messageStream);
        this.server.send(new AltDownloadRequestMessage(this.sr.getUser().getName(), this.sr.getFilename()));
        DownloadSocket downloadSocket = new DownloadSocket(this.sr.getUser().getName(), this.sr.getFilename(), this.sr.getFilesize());
        this.checkForError(messageStream);
        if (this.getQueuePos() > 0) {
            return false;
        }
        downloadSocket = (DownloadSocket)this.server.getListener().waitForSocket(downloadSocket, 60000L);
        this.checkForError(messageStream);
        MessageHandler.unsubscribe(404, messageStream);
        if (downloadSocket == null) {
            if (this.getQueuePos() >= 0) {
                return false;
            }
            throw new IOException(Plugin.tr("Listener timeout"));
        }
        logger.debug("reverse stream socket established");
        this.socket = downloadSocket.socket;
        try {
            this.socket.setSoTimeout(60000);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.out = this.socket.getOutputStream();
        this.in = downloadSocket.in;
        this.out.write(new Long(this.offset).toString().getBytes());
        this.out.flush();
        return true;
    }

    private final void checkForError(MessageStream messageStream) throws IOException {
        while (messageStream.hasNext()) {
            String string;
            ServerMessage serverMessage = messageStream.next();
            if (!(serverMessage instanceof ErrorMessage) || !((ErrorMessage)serverMessage).message.equals(string = this.sr.getUser().getName() + " is not firewalled")) continue;
            MessageHandler.unsubscribe(404, messageStream);
            throw new IOException(Plugin.tr("User is not firewalled"));
        }
    }

    public void messageReceived(ServerMessage serverMessage) {
        if (!(serverMessage instanceof FilenameMessage) || !((FilenameMessage)((Object)serverMessage)).getFilename().equals(this.sr.getFilename()) || serverMessage.getServer() != this.server) {
            return;
        }
        serverMessage.consume();
        if (serverMessage instanceof QueueLimitMessage) {
            int n = ((QueueLimitMessage)serverMessage).maxDownloads;
            if (n == 0 || n >= 10000) {
                this.setQueuePos(0);
                if (this.sendWantQueue()) {
                    this.sendDownloadRequest(true);
                }
            } else if (n > 0 && n < 10000) {
                this.setQueuePos(n);
            } else {
                this.setQueuePos(-1);
            }
            logger.debug(this.sr.getUser().getName() + " has queued us at pos " + this.getQueuePos());
        } else if (serverMessage instanceof AcceptFailedMessage || serverMessage instanceof GetErrorMessage) {
            logger.debug(this.sr.getUser().getName() + " telling parent to remove " + this.sr.getFilename());
            this.getParent().remove(this);
        } else if (serverMessage instanceof DownloadAckMessage) {
            DownloadAckMessage downloadAckMessage = (DownloadAckMessage)serverMessage;
            this.ip = downloadAckMessage.ip;
            this.port = downloadAckMessage.port;
            logger.debug("telling parent to start me " + this.ip + ":" + this.port + " " + this);
            this.getParent().start(this);
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public boolean sendWantQueue() {
        if (this.wantQueueCount >= 5) {
            return false;
        }
        String string = this.sr.getUser().getClientInfo();
        boolean bl = false;
        if (string != null) {
            bl |= string.startsWith("WinMX v2.6");
            bl |= string.startsWith("Napigator");
            bl |= string.startsWith("TrippyMX");
            bl |= this.wantQueueCount > 2 && string.startsWith("WinMX");
        }
        if (bl) {
            logger.debug("Sending //WantQueue to " + this.sr.getUser().getName() + " who uses client " + string);
            MessageHandler.send(this.server, new PrivateMessage(this.sr.getUser().getName(), "//WantQueue"));
        }
        ++this.wantQueueCount;
        return true;
    }

    private final void subscribe(MessageListener messageListener) {
        if (this.subscribed) {
            return;
        }
        MessageHandler.subscribe(204, messageListener);
        MessageHandler.subscribe(620, messageListener);
        MessageHandler.subscribe(206, messageListener);
        MessageHandler.subscribe(609, messageListener);
        this.subscribed = true;
    }

    private final void unsubscribe(MessageListener messageListener) {
        if (!this.subscribed) {
            return;
        }
        MessageHandler.unsubscribe(204, messageListener);
        MessageHandler.unsubscribe(620, messageListener);
        MessageHandler.unsubscribe(206, messageListener);
        MessageHandler.unsubscribe(609, messageListener);
        this.subscribed = false;
    }

    public String toString() {
        return "download " + this.sr.getFilename() + "@" + this.sr.getUser().getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Download(SearchResult searchResult) {
        super(searchResult.getUser(), searchResult.getFilesize());
        this.sr = searchResult;
        this.server = searchResult.getNapUser().getServer();
        searchResult.getNapUser().update();
    }
}

