/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.gui.table;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import xnap.gui.table.AbstractDynamicTableModel;
import xnap.gui.table.Column;
import xnap.gui.table.NumberCellRenderer;
import xnap.gui.table.StringCellRenderer;
import xnap.gui.util.SwingSynchronizedCache;
import xnap.net.event.StatusChangeEvent;
import xnap.net.event.StatusChangeListener;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.util.NapPreferences;
import xnap.util.EventVector;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;

public class ServerTableModel
extends AbstractDynamicTableModel
implements ListListener,
StatusChangeListener {
    public static final int HOST = 0;
    public static final int NETWORK = 1;
    public static final int LOCAL_PORT = 2;
    public static final int VERSION = 3;
    public static final int FILE_COUNT = 4;
    public static final int FILE_SIZE = 5;
    public static final int USER_COUNT = 6;
    public static final int STATUS = 7;
    protected Column[] columns = new Column[]{new Column(Plugin.tr("Server"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ServerTableModel.class$("java.lang.String")), new StringCellRenderer()), new Column(Plugin.tr("Network"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ServerTableModel.class$("java.lang.String"))), new Column(Plugin.tr("Local Port"), class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = ServerTableModel.class$("java.lang.Integer"))), new Column(Plugin.tr("Version"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ServerTableModel.class$("java.lang.String")), new StringCellRenderer()), new Column(Plugin.tr("Files"), class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = ServerTableModel.class$("java.lang.Integer")), new NumberCellRenderer()), new Column(Plugin.tr("Total (GB)"), class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = ServerTableModel.class$("java.lang.Integer")), new NumberCellRenderer()), new Column(Plugin.tr("Users"), class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = ServerTableModel.class$("java.lang.Integer")), new NumberCellRenderer()), new Column(Plugin.tr("Status"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ServerTableModel.class$("java.lang.String")), new StringCellRenderer())};
    private ArrayList rows = new ArrayList();
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$Integer;

    public void elementAdded(ListEvent listEvent) {
        Server server = (Server)listEvent.getElement();
        server.addStatusChangeListener(this);
        this.rows.add(server);
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
    }

    public void elementRemoved(ListEvent listEvent) {
        if (listEvent.getID() == 3) {
            int n = this.rows.size();
            if (n > 0) {
                Iterator iterator = ((AbstractList)this.rows).iterator();
                while (iterator.hasNext()) {
                    Server server = (Server)iterator.next();
                    server.removeStatusChangeListener(this);
                }
                this.rows.clear();
                this.fireTableRowsDeleted(0, n - 1);
            }
        } else {
            int n = this.rows.indexOf(listEvent.getElement());
            if (n != -1) {
                Server server = (Server)listEvent.getElement();
                server.removeStatusChangeListener(this);
                this.rows.remove(n);
                this.fireTableRowsDeleted(n, n);
            }
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Server get(int n) {
        return (Server)this.rows.get(this.mapToIndex(n));
    }

    public Object get(int n, int n2) {
        Server server = (Server)this.rows.get(n);
        switch (n2) {
            case 0: {
                return server.getHost() + ":" + server.getPort();
            }
            case 1: {
                return server.getNetwork();
            }
            case 2: {
                return new Integer(server.getLocalPort());
            }
            case 3: {
                return server.getVersion().toString();
            }
            case 4: {
                return new Integer(server.getFileCount());
            }
            case 5: {
                return new Integer(server.getFileSize());
            }
            case 6: {
                return new Integer(server.getUserCount());
            }
            case 7: {
                return server.getStatusText();
            }
        }
        return null;
    }

    public String getTableName() {
        return Plugin.tr("Server Table");
    }

    public void statusChange(StatusChangeEvent statusChangeEvent) {
        SwingUtilities.invokeLater(new StatusChangeEventHandler(statusChangeEvent.getSource()));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ServerTableModel(EventVector eventVector) {
        super("server", NapPreferences.getInstance());
        SwingSynchronizedCache swingSynchronizedCache = new SwingSynchronizedCache(this);
        eventVector.addListListener(swingSynchronizedCache);
        this.setColumns(this.columns);
    }

    private class StatusChangeEventHandler
    implements Runnable {
        Object item;

        public void run() {
            int n = ServerTableModel.this.rows.indexOf(this.item);
            if (n != -1 && n < ServerTableModel.this.rows.size()) {
                ServerTableModel.this.fireTableRowsUpdated(n, n);
            }
        }

        public StatusChangeEventHandler(Object object) {
            this.item = object;
        }
    }
}

