/*
 * Decompiled with CFR 0.152.
 */
package xnap.net;

import java.io.File;
import org.apache.log4j.Logger;
import xnap.net.AbstractRunnable;
import xnap.net.ITransferContainer;
import xnap.net.IUser;

public abstract class AbstractTransferContainer
extends AbstractRunnable
implements ITransferContainer,
Runnable {
    public static final int RECALC_INTERVAL = 5000;
    public static final int MIN_RECALC_INTERVAL = 50;
    protected static Logger logger = Logger.getLogger("xnap.net.transfer");
    protected long bytesTransferred = 0L;
    protected long totalBytesTransferred = 0L;
    protected File file = null;
    private long lastBytesTransferred = 0L;
    private long lastElapsedTime = 0L;
    private long lastRate = 0L;
    protected long totalRate = -1L;
    protected long transferStartTime = -1L;

    public boolean isDone() {
        return this.status == 6 || this.status == 7 || this.status == 9 || this.status == 12 || this.status == 13;
    }

    public boolean isResumable() {
        return !this.isAborting() && (this.status == 0 || this.status == 7 || this.status == 9 || this.status == 2);
    }

    public boolean isRunning() {
        return this.status == 1 || this.status == 2 || this.status == 4 || this.status == 5 || this.status == 10 || this.status == 11;
    }

    public long getAverageRate() {
        if (this.totalRate != -1L) {
            return this.totalRate;
        }
        if (this.getStatus() != 4 && this.getStatus() != 5) {
            return -1L;
        }
        long l = this.getElapsedTime();
        if (l > 0L) {
            return this.getBytesTransferred() * 1000L / l;
        }
        return this.getBytesTransferred();
    }

    public long getBytesTransferred() {
        return this.bytesTransferred;
    }

    public long getTotalBytesTransferred() {
        return this.totalBytesTransferred;
    }

    public long getCurrentRate() {
        if (this.totalRate != -1L) {
            return this.totalRate;
        }
        if (this.status != 4 && this.status != 5) {
            return -1L;
        }
        long l = System.currentTimeMillis() - this.lastElapsedTime;
        if (l > 50L) {
            long l2 = this.getBytesTransferred() - this.lastBytesTransferred;
            if (this.getElapsedTime() < 5000L) {
                this.lastRate = l2 * 1000L / l;
            } else {
                this.lastBytesTransferred += l2;
                this.lastElapsedTime += l;
                long l3 = 5000L - l;
                if (l3 > 0L) {
                    l2 += l3 * this.lastRate / 1000L;
                    l = 5000L;
                }
                this.lastRate = l2 * 1000L / l;
            }
        }
        return this.lastRate;
    }

    protected long getElapsedTime() {
        return System.currentTimeMillis() - this.transferStartTime;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFilename() {
        File file = this.getFile();
        return file != null ? file.getName() : "";
    }

    public long getFilesize() {
        File file = this.getFile();
        return file != null ? file.length() : 0L;
    }

    public abstract IUser getUser();

    public void setStatus(int n, String string) {
        super.setStatus(n, string);
        if (this.isDone()) {
            long l = this.getElapsedTime();
            this.totalRate = l > 0L ? this.getBytesTransferred() * 1000L / l : this.getBytesTransferred();
            this.totalRate = this.totalRate > 0L ? this.totalRate : -1L;
        }
    }

    public String getStatusMsg(int n) {
        return ITransferContainer.STATUS_MSGS[n];
    }

    public void abort() {
        if (!this.isDone()) {
            logger.debug("abort " + this.getFile());
            this.die(9);
        }
    }

    public void delete() {
        this.getFile().delete();
        this.die(12);
    }

    public void fail(String string) {
        this.die(7, string);
    }

    public void locallyQueued() {
        this.setStatus(2);
    }

    public abstract void run();

    public void start() {
        if (!this.canStart()) {
            logger.error("already running");
            return;
        }
        this.die = false;
        this.setStatus(0);
        this.runner = new Thread((Runnable)this, "Transfer " + this.getFilename());
        this.runner.start();
    }

    public String toString() {
        return this.getFilename() + ", " + this.getFilesize();
    }

    protected void startTransfer() {
        this.bytesTransferred = 0L;
        this.lastBytesTransferred = 0L;
        this.lastElapsedTime = this.transferStartTime = System.currentTimeMillis();
        this.totalRate = -1L;
    }

    protected AbstractTransferContainer() {
        this.status = 0;
    }
}

