/*
 * Decompiled with CFR 0.152.
 */
package xnap.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import xnap.io.RepositoryFile;
import xnap.util.Debug;
import xnap.util.Formatter;

public class VideoFile
extends RepositoryFile {
    protected static final int PACK_START_CODE = 442;
    protected static final int SEQ_START_CODE = 435;
    protected static final int GROUP_START_CODE = 440;
    protected static final int MAX_FORWARD_READ_LENGTH = 50000;
    protected static final int MAX_BACKWARD_READ_LENGTH = 3000000;
    protected static final int ASF_FILE_PROPERTIES_SIZE = 80;
    protected static final int ASF_STREAM_PROPERTIES_SIZE = 1024;
    protected static final int GUID_SIZE = 16;
    protected final transient GUID ASF_HEADER_GUID = new GUID(1974609456, 26254, 4559, new byte[]{-90, -39, 0, -86, 0, 98, -50, 108});
    protected final transient GUID ASF_FILE_PROPERTIES_GUID = new GUID(-1934893919, 43335, 4559, new byte[]{-114, -28, 0, -64, 12, 32, 83, 101});
    protected final transient GUID ASF_STREAM_PROPERTIES_GUID = new GUID(-1210316911, 43447, 4559, new byte[]{-114, -26, 0, -64, 12, 32, 83, 101});
    protected final transient GUID ASF_AUDIO_MEDIA_GUID = new GUID(-127295936, 23373, 4559, new byte[]{-88, -3, 0, -128, 95, 92, 68, 43});
    protected final transient GUID ASF_CODEC_LIST_GUID = new GUID(-2033102272, 12573, 4560, new byte[]{-93, -92, 0, -96, -55, 3, 72, -10});
    private int height = -1;
    private int length = -1;
    private int width = -1;
    protected transient RandomAccessFile raf;

    /*
     * Loose catch block
     */
    public boolean parse() {
        boolean bl;
        block10: {
            block9: {
                bl = false;
                Debug.log("VideoFile: parsing " + this.getName());
                this.raf = new RandomAccessFile(this, "r");
                bl = this.lookForAVI();
                if (!bl) {
                    bl = this.lookForMPEG();
                }
                if (bl) break block9;
                bl = this.lookForASF();
            }
            Object var3_2 = null;
            try {
                this.raf.close();
            }
            catch (IOException iOException) {}
            break block10;
            {
                catch (IOException iOException) {
                    Debug.log("VideoFile " + iOException);
                    Object var3_3 = null;
                    try {
                        this.raf.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                try {
                    this.raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bl;
    }

    public int getHeight() {
        return this.height;
    }

    public String getInfo() {
        return Formatter.formatLength(this.getLength());
    }

    public int getLength() {
        return this.length;
    }

    public int getWidth() {
        return this.width;
    }

    protected boolean lookForAVI() throws IOException {
        boolean bl = false;
        this.raf.seek(0L);
        String string = this.readChunk();
        if (string.equals("RIFF")) {
            this.raf.skipBytes(4);
            string = this.readChunk();
            if (string.equals("AVI ")) {
                while (true) {
                    string = this.readChunk();
                    this.raf.skipBytes(4);
                    if (!string.equals("LIST")) break;
                    string = this.readChunk();
                    if (!string.equals("hdrl")) continue;
                    string = this.readChunk();
                    int n = this.readBigEndianInt();
                    if (!string.equals("avih") || n < 56) continue;
                    double d = this.readBigEndianInt();
                    this.raf.skipBytes(12);
                    double d2 = this.readBigEndianInt();
                    this.length = (int)(d2 * (d / 1000000.0));
                    this.raf.skipBytes(12);
                    this.width = this.readBigEndianInt();
                    this.height = this.readBigEndianInt();
                    this.raf.skipBytes(n - 40);
                    bl = true;
                }
            }
        }
        return bl;
    }

    protected boolean lookForASF() throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ASFMainHeader aSFMainHeader = null;
        ASFStreamHeader aSFStreamHeader = null;
        ASFCodecList aSFCodecList = null;
        this.raf.seek(0L);
        Debug.log("looking for asf");
        while (!(bl && bl2 && bl3)) {
            GUID gUID = new GUID();
            long l = this.readBigEndianLong() - 24L;
            Debug.log("GUID " + gUID);
            Debug.log("size " + l);
            if (l < 0L) {
                return false;
            }
            if (gUID.equals(this.ASF_HEADER_GUID)) {
                Debug.log("Found header, skipping 6 bytes");
                this.raf.skipBytes(6);
                continue;
            }
            if (gUID.equals(this.ASF_FILE_PROPERTIES_GUID)) {
                Debug.log("Found asf main header");
                if (l < 80L) {
                    Debug.log("main header too small");
                    return false;
                }
                aSFMainHeader = new ASFMainHeader(this);
                this.raf.skipBytes((int)(l - 80L));
                bl = true;
                continue;
            }
            if (gUID.equals(this.ASF_STREAM_PROPERTIES_GUID)) {
                Debug.log("Found stream props");
                aSFStreamHeader = new ASFStreamHeader(l);
                if (l > (long)aSFStreamHeader.count) {
                    this.raf.skipBytes((int)(l - (long)aSFStreamHeader.count));
                }
                bl2 = true;
                continue;
            }
            if (gUID.equals(this.ASF_CODEC_LIST_GUID)) {
                Debug.log("Found codec list header");
                aSFCodecList = new ASFCodecList(l);
                bl3 = true;
                continue;
            }
            Debug.log("Unknown packet, skipping " + l);
            this.raf.skipBytes((int)l);
        }
        if (bl && bl2 && bl3) {
            this.length = (int)(aSFMainHeader.play_time / 10000000L);
            Debug.log("asf length " + this.length);
            if (aSFStreamHeader.videoHeader) {
                this.height = aSFStreamHeader.height;
                this.width = aSFStreamHeader.width;
            }
            return true;
        }
        return false;
    }

    protected boolean lookForMPEG() throws IOException {
        this.raf.seek(0L);
        if (this.nextStartCode() && this.raf.readInt() == 442) {
            byte[] byArray = new byte[6];
            Long l = null;
            this.raf.readFully(byArray);
            if ((byArray[0] & 0xF0) == 32) {
                l = this.getMPEGSCR(byArray);
            } else if ((byArray[0] & 0xC0) == 64) {
                l = this.getMPEG2SCR(byArray);
            }
            boolean bl = false;
            while (this.nextStartCode()) {
                if (this.raf.readInt() != 435) continue;
                bl = true;
                break;
            }
            if (bl) {
                byArray = new byte[3];
                this.raf.readFully(byArray);
                this.width = (byArray[0] & 0xFF) << 4 | byArray[1] & 0xF0;
                this.height = (byArray[1] & 0xF) << 8 | byArray[2] & 0xFF;
                boolean bl2 = false;
                this.raf.seek(this.raf.length());
                while (this.previousStartCode()) {
                    if (this.raf.readInt() == 442) {
                        bl2 = true;
                        break;
                    }
                    this.raf.seek(this.raf.getFilePointer() - 4L);
                }
                if (bl2) {
                    byArray = new byte[6];
                    Long l2 = null;
                    this.raf.readFully(byArray);
                    if ((byArray[0] & 0xF0) == 32) {
                        l2 = this.getMPEGSCR(byArray);
                    } else if ((byArray[0] & 0xC0) == 64) {
                        l2 = this.getMPEG2SCR(byArray);
                    }
                    if (l != null && l2 != null) {
                        this.length = (int)(l2 - l);
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected final String readChunk() throws IOException {
        byte[] byArray = new byte[4];
        this.raf.readFully(byArray);
        return new String(byArray);
    }

    protected final short readBigEndianShort() throws IOException {
        byte[] byArray = new byte[2];
        this.raf.readFully(byArray);
        return (short)(byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8);
    }

    protected final int readBigEndianInt() throws IOException {
        byte[] byArray = new byte[4];
        this.raf.readFully(byArray);
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
    }

    protected final long readBigEndianLong() throws IOException {
        return this.readBigEndianInt() | this.readBigEndianInt() << 32;
    }

    protected Long getMPEGSCR(byte[] byArray) {
        long l;
        int n = byArray[0] >> 3 & 1;
        long l2 = l = (long)(((byArray[0] & 0xFF) >> 1 & 3) << 30 | (byArray[1] & 0xFF) << 22 | (byArray[2] & 0xFF) >> 1 << 15 | (byArray[3] & 0xFF) << 7 | (byArray[4] & 0xFF) >> 1);
        return new Long(l2 /= 90000L);
    }

    protected Long getMPEG2SCR(byte[] byArray) {
        int n = (byArray[0] & 0x20) >> 5;
        long l = (byArray[0] & 0x18) >> 3 << 30 | (byArray[0] & 3) << 28 | (byArray[1] & 0xFF) << 20 | (byArray[2] & 0xF8) >> 1 << 15 | (byArray[2] & 3) << 13 | (byArray[3] & 0xFF) << 5 | (byArray[4] & 0xFF) >> 3;
        int n2 = (byArray[4] & 3) << 7 | (byArray[5] & 0xFF) >> 1;
        long l2 = l;
        if (n2 == 0) {
            return new Long(l2 /= 90000L);
        }
        return null;
    }

    protected boolean nextStartCode() {
        byte[] byArray = new byte[1024];
        boolean bl = false;
        try {
            int n = 0;
            while (n < 50000 && !bl) {
                int n2 = this.raf.read(byArray);
                if (n2 > 0) {
                    n += n2;
                    int n3 = 0;
                    while (n3 < n2 - 2) {
                        if (byArray[n3] == 0 && byArray[n3 + 1] == 0 && byArray[n3 + 2] == 1) {
                            this.raf.seek(this.raf.getFilePointer() - (long)(n2 - n3));
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    n += n2;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    protected boolean previousStartCode() {
        byte[] byArray = new byte[8024];
        boolean bl = false;
        try {
            int n = 0;
            while (n < 3000000 && !bl) {
                long l = this.raf.getFilePointer() - (long)byArray.length;
                if (l < 0L) {
                    if (l <= (long)byArray.length) break;
                    l = 0L;
                }
                this.raf.seek(l);
                this.raf.readFully(byArray);
                int n2 = byArray.length - 1;
                while (n2 > 1) {
                    if (byArray[n2 - 2] == 0 && byArray[n2 - 1] == 0 && byArray[n2] == 1) {
                        this.raf.seek(this.raf.getFilePointer() - (long)(byArray.length - n2) - 2L);
                        bl = true;
                        break;
                    }
                    --n2;
                }
                if (!bl) {
                    this.raf.seek(this.raf.getFilePointer() - (long)byArray.length);
                }
                n += byArray.length;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public VideoFile(File file) {
        super(file);
    }

    protected class GUID {
        public int f1;
        public short f2;
        public short f3;
        public byte[] f4;

        public boolean equals(Object object) {
            if (!(object instanceof GUID)) {
                return false;
            }
            GUID gUID = (GUID)object;
            if (this.f1 != gUID.f1 || this.f2 != gUID.f2 || this.f3 != gUID.f3) {
                return false;
            }
            int n = 0;
            while (n < this.f4.length) {
                if (this.f4[n] != gUID.f4[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public String toString() {
            return "f1 " + this.f1 + "\n" + "f2 " + this.f2 + "\n" + "f3 " + this.f3 + "\n";
        }

        public GUID() throws IOException {
            this.f4 = new byte[8];
            this.f1 = VideoFile.this.readBigEndianInt();
            this.f2 = VideoFile.this.readBigEndianShort();
            this.f3 = VideoFile.this.readBigEndianShort();
            int n = 0;
            while (n < this.f4.length) {
                this.f4[n] = VideoFile.this.raf.readByte();
                ++n;
            }
        }

        public GUID(int n, int n2, int n3, byte[] byArray) {
            this.f1 = n;
            this.f2 = (short)n2;
            this.f3 = (short)n3;
            this.f4 = byArray;
        }
    }

    protected class ASFMainHeader {
        public GUID guid;
        long file_size;
        long create_time;
        long pkts_count;
        public long play_time;
        long send_time;
        int preroll;
        int ignore;
        int flags;
        int min_pktsize;
        int max_pktsize;
        int max_bitrate;
        private final /* synthetic */ VideoFile this$0;

        public ASFMainHeader(VideoFile videoFile) throws IOException {
            VideoFile videoFile2 = this.this$0 = videoFile;
            if (videoFile2 == null) {
                throw null;
            }
            this.guid = videoFile2.new GUID();
            this.file_size = this.this$0.readBigEndianLong();
            this.create_time = this.this$0.readBigEndianLong();
            this.pkts_count = this.this$0.readBigEndianLong();
            this.play_time = this.this$0.readBigEndianLong();
            this.send_time = this.this$0.readBigEndianLong();
            this.preroll = this.this$0.readBigEndianInt();
            this.ignore = this.this$0.readBigEndianInt();
            this.flags = this.this$0.readBigEndianInt();
            this.min_pktsize = this.this$0.readBigEndianInt();
            this.max_pktsize = this.this$0.readBigEndianInt();
            this.max_bitrate = this.this$0.readBigEndianInt();
        }
    }

    protected class ASFStreamHeader {
        public GUID stream_guid;
        public GUID error_guid;
        public long time_offset;
        public int stream_size;
        public int error_size;
        public short stream;
        public int reserved;
        public int width;
        public int height;
        public byte flags;
        public short data_size;
        public int count = 0;
        public boolean videoHeader = false;

        public ASFStreamHeader(long l) throws IOException {
            if ((long)this.count < l - 16L) {
                VideoFile videoFile2 = VideoFile.this;
                if (videoFile2 == null) {
                    throw null;
                }
                this.stream_guid = videoFile2.new GUID();
                this.count += 16;
            }
            if ((long)this.count < l - 16L) {
                VideoFile videoFile3 = VideoFile.this;
                if (videoFile3 == null) {
                    throw null;
                }
                this.error_guid = videoFile3.new GUID();
                this.count += 16;
            }
            if ((long)this.count < l - 8L) {
                this.time_offset = VideoFile.this.readBigEndianLong();
                this.count += 8;
            }
            if ((long)this.count < l - 4L) {
                this.stream_size = VideoFile.this.readBigEndianInt();
                this.count += 4;
            }
            if ((long)this.count < l - 4L) {
                this.error_size = VideoFile.this.readBigEndianInt();
                this.count += 4;
            }
            if ((long)this.count < l - 2L) {
                this.stream = VideoFile.this.readBigEndianShort();
                this.count += 2;
            }
            if ((long)this.count < l - 4L) {
                this.reserved = VideoFile.this.readBigEndianInt();
                this.count += 4;
            }
            if (!this.stream_guid.equals(VideoFile.this.ASF_AUDIO_MEDIA_GUID)) {
                this.videoHeader = true;
                if ((long)this.count < l - 4L) {
                    this.width = VideoFile.this.readBigEndianInt();
                    this.count += 4;
                }
                if ((long)this.count < l - 4L) {
                    this.height = VideoFile.this.readBigEndianInt();
                    this.count += 4;
                }
                if ((long)this.count < l - 1L) {
                    this.flags = VideoFile.this.raf.readByte();
                    ++this.count;
                }
                if ((long)this.count < l - 2L) {
                    this.data_size = VideoFile.this.readBigEndianShort();
                    this.count += 2;
                }
            }
        }
    }

    protected class ASFCodecList {
        public final String[] names = new String[]{"Codec Name", "Codec Description", "Information"};

        public short getShort(byte[] byArray, int n) {
            return (short)(byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8);
        }

        public String getString(byte[] byArray, int n, int n2) {
            StringBuffer stringBuffer = new StringBuffer(n2);
            int n3 = 0;
            while (n3 < n2 && byArray[n3] != 0) {
                stringBuffer.append((char)byArray[n3]);
                n3 += 2;
            }
            return stringBuffer.toString();
        }

        public ASFCodecList(long l) throws IOException {
            byte[] byArray = new byte[(int)l];
            VideoFile.this.raf.readFully(byArray);
            StringBuffer stringBuffer = new StringBuffer(byArray.length);
            StringBuffer stringBuffer2 = new StringBuffer(byArray.length);
            int n = 0;
            while (n < byArray.length) {
                stringBuffer.append((char)byArray[n]);
                stringBuffer2.append(n % 10);
                ++n;
            }
            Debug.log(stringBuffer);
            Debug.log(stringBuffer2);
            n = byArray[16] & 0xFF | (byArray[17] & 0xFF) << 8 | (byArray[18] & 0xFF) << 16 | (byArray[19] & 0xFF) << 32;
            Debug.log("count " + n);
            int n2 = 20;
            int n3 = 0;
            while (n3 < n) {
                short s = this.getShort(byArray, n2);
                n2 += 2;
                Debug.log("ASF reader Codec Type: " + s);
                int n4 = 0;
                while (n4 < 3) {
                    short s2 = this.getShort(byArray, n2);
                    n2 += 2;
                    if (n4 < 2) {
                        s2 = (short)(s2 * 2);
                        String string = this.getString(byArray, n2, s2);
                        Debug.log(this.names[n4] + " " + string);
                    }
                    n2 += s2;
                    ++n4;
                }
                ++n3;
            }
        }
    }
}

