/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import xnap.util.Preferences;

public class GUIHelper {
    protected static Preferences prefs = Preferences.getInstance();

    public static void bindToKey(JButton jButton, KeyStroke keyStroke, String string) {
        InputMap inputMap = jButton.getInputMap(2);
        ActionMap actionMap = jButton.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke, string);
            actionMap.put(string, jButton.getAction());
        }
    }

    public static Color getColor(String string) {
        return GUIHelper.decodeColor(prefs.getColor(string));
    }

    public static Font getFont(String string) {
        return GUIHelper.decodeFont(prefs.getFont(string));
    }

    public static Color decodeColor(int n) {
        return new Color(n & 0xFF, n >> 8 & 0xFF, n >> 16 & 0xFF);
    }

    public static int encodeColor(int n, int n2, int n3) {
        return n + 256 * n2 + 65536 * n3;
    }

    public static int encodeColor(Color color) {
        return GUIHelper.encodeColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Font decodeFont(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.countTokens() >= 3) {
            try {
                String string2 = stringTokenizer.nextToken();
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                return new Font(string2, n, n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Font("Monospaced", 0, 12);
    }

    public static String encodeFont(Font font) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(font.getName());
        stringBuffer.append(";");
        stringBuffer.append(font.getStyle());
        stringBuffer.append(";");
        stringBuffer.append(font.getSize());
        return stringBuffer.toString();
    }

    public static void setAccelerator(JMenuItem jMenuItem, int n) {
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, n2));
    }

    public static void setColor(String string, Color color) {
        prefs.setColor(string, GUIHelper.encodeColor(color));
    }

    public static void setFont(String string, Font font) {
        prefs.setFont(string, GUIHelper.encodeFont(font));
    }

    public static void setMnemonics(Container container) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = 0;
        while (n < container.getComponentCount()) {
            Component component = container.getComponent(n);
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                if (abstractButton.getMnemonic() == 0) {
                    GUIHelper.setMnemonics(abstractButton, hashSet);
                } else {
                    hashSet.add(new Integer(abstractButton.getMnemonic()));
                }
            }
            if (component instanceof JMenu) {
                GUIHelper.setMnemonics(((JMenu)component).getPopupMenu());
            }
            if (component instanceof Container) {
                GUIHelper.setMnemonics((Container)component);
            }
            ++n;
        }
    }

    private static final boolean setMnemonics(AbstractButton abstractButton, HashSet hashSet) {
        String string = abstractButton.getText().toUpperCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            Integer n = new Integer(stringTokenizer.nextToken().charAt(0));
            if (hashSet.contains(n)) continue;
            hashSet.add(n);
            abstractButton.setMnemonic(n);
            return true;
        }
        int n = 1;
        while (n < string.length()) {
            Integer n2 = new Integer(string.charAt(n));
            if (string.charAt(n) != ' ' && !hashSet.contains(n2)) {
                hashSet.add(n2);
                abstractButton.setMnemonic(n2);
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String tt(String string) {
        StringBuffer stringBuffer = new StringBuffer(33 + string.length() + 25);
        stringBuffer.append("<html><table><tr><td width=\"300\">");
        stringBuffer.append(string);
        stringBuffer.append("</td></tr></table></html>");
        return stringBuffer.toString();
    }

    public static void limitSize(JComponent jComponent) {
        jComponent.setMaximumSize(new Dimension(jComponent.getPreferredSize().width, jComponent.getMaximumSize().height));
    }
}

