/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.tree;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import xnap.gui.Dialogs;
import xnap.gui.event.FileArray;
import xnap.gui.event.TransferableFile;
import xnap.util.FileHelper;

public class DroppableJTree
extends JTree
implements DropTargetListener,
Autoscroll {
    public static final int AUTOSCROLL_MARGIN = 14;
    private static Logger logger = Logger.getLogger(class$Lxnap$gui$tree$DroppableJTree != null ? class$Lxnap$gui$tree$DroppableJTree : (class$Lxnap$gui$tree$DroppableJTree = DroppableJTree.class$("xnap.gui.tree.DroppableJTree")));
    protected DropTarget dropTarget = new DropTarget(this, this);
    protected TreePath originalPath = null;
    protected Timer delayTimer;
    protected Component parent;
    protected boolean dndActive = false;
    private TreePath lastPath;
    private static /* synthetic */ Class class$Lxnap$gui$tree$DroppableJTree;

    public void autoscroll(Point point) {
        int n = this.getClosestRowForLocation(point.x, point.y);
        if (n < 0) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        n = point.y + rectangle.y <= 14 ? --n : ++n;
        if (n >= 0 && n < this.getRowCount()) {
            this.scrollRowToVisible(n);
        }
    }

    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.getParent().getBounds();
        return new Insets(rectangle2.y - rectangle.y + 14, rectangle2.x - rectangle.x + 14, rectangle.height - rectangle2.height - rectangle2.y + rectangle.y + 14, rectangle.width - rectangle2.width - rectangle2.x + rectangle.x + 14);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.originalPath = this.getSelectionPath();
        this.dndActive = true;
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        logger.debug("dragExit!");
        if (this.lastPath == null) {
            this.lastPath = this.getSelectionPath();
            logger.debug("path: " + this.lastPath);
        }
        this.cleanUp();
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        TreePath treePath = this.getClosestPathForLocation(point.x, point.y);
        if (treePath != this.getSelectionPath()) {
            this.delayTimer.restart();
            this.setSelectionPath(treePath);
        }
    }

    protected void cleanUp() {
        logger.debug("cleanUp!");
        this.dndActive = false;
        if (this.originalPath != null) {
            this.setSelectionPath(this.originalPath);
            this.scrollPathToVisible(this.originalPath);
        }
        this.delayTimer.stop();
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (!this.dndActive) {
            super.fireValueChanged(treeSelectionEvent);
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        block9: {
            logger.debug("dropped!");
            this.delayTimer.stop();
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (!transferable.isDataFlavorSupported(TransferableFile.FILE_FLAVOR)) {
                    dropTargetDropEvent.rejectDrop();
                    this.cleanUp();
                    return;
                }
                dropTargetDropEvent.acceptDrop(2);
                FileArray fileArray = (FileArray)transferable.getTransferData(TransferableFile.FILE_FLAVOR);
                TreePath treePath = this.getSelectionPath().equals(this.originalPath) ? this.lastPath : this.getSelectionPath();
                this.lastPath = null;
                if (treePath == null) {
                    dropTargetDropEvent.rejectDrop();
                    this.cleanUp();
                    return;
                }
                Object object = treePath.getLastPathComponent();
                if (!(object instanceof File)) break block9;
                File file = (File)object;
                File[] fileArray2 = Dialogs.showMoveDialog(this.parent, fileArray.getFiles(), file);
                if (fileArray2 == null) {
                    dropTargetDropEvent.dropComplete(false);
                    this.cleanUp();
                    return;
                }
                int n = 0;
                while (n < fileArray2.length) {
                    try {
                        FileHelper.moveUnique(fileArray2[n], file.getAbsolutePath());
                    }
                    catch (IOException iOException) {
                        logger.debug("drag move failed", iOException);
                    }
                    ++n;
                }
                dropTargetDropEvent.dropComplete(true);
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
        this.cleanUp();
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public DroppableJTree(TreeModel treeModel, Component component) {
        super(treeModel);
        this.parent = component;
        this.delayTimer = new Timer(500, new HoverListener());
        this.delayTimer.setRepeats(false);
    }

    protected class HoverListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = DroppableJTree.this.getSelectionPath();
            if (treePath == null) {
                return;
            }
            if (DroppableJTree.this.isExpanded(treePath)) {
                DroppableJTree.this.collapsePath(treePath);
            } else {
                DroppableJTree.this.scrollPathToVisible(treePath);
                DroppableJTree.this.expandPath(treePath);
            }
        }

        HoverListener() {
        }
    }
}

