/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import xnap.XNap;
import xnap.gui.AbstractSaveablePanel;
import xnap.gui.GridBagHelper;
import xnap.gui.ValidatedTextField;
import xnap.net.IUser;
import xnap.user.UserManager;

public class UserEditorPanel
extends AbstractSaveablePanel {
    private IUser user;
    private JTextField jtName;
    private JTextField jtComment;
    private JComboBox jcbCategory;
    private JCheckBox jcbIgnoreChat;
    private JRadioButton jrbUploadDefault;
    private JRadioButton jrbUploadNever;
    private JRadioButton jrbUploadAlways;
    private ButtonGroup bgUpload;
    private JRadioButton jrbDownloadDefault;
    private JRadioButton jrbDownloadNever;
    private ButtonGroup bgDownload;

    private final void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagHelper.addLabel(this, XNap.tr("Name"));
        this.jtName = new ValidatedTextField("", 20, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.@_-&");
        this.jtName.setEditable(false);
        GridBagHelper.add((Container)this, this.jtName);
        GridBagHelper.addLabel(this, XNap.tr("Comment"));
        this.jtComment = new JTextField("", 20);
        GridBagHelper.add((Container)this, this.jtComment);
        GridBagHelper.addLabel(this, XNap.tr("Category"));
        this.jcbCategory = new JComboBox<String>(UserManager.CATEGORIES);
        GridBagHelper.add((Container)this, this.jcbCategory);
        GridBagHelper.addLabel(this, "");
        this.jcbIgnoreChat = new JCheckBox(XNap.tr("Ignore Chat"));
        GridBagHelper.add((Container)this, this.jcbIgnoreChat);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(XNap.tr("Allow Uploads To This User", 1)));
        GridBagHelper.add((Container)this, jPanel);
        this.jrbUploadDefault = new JRadioButton(XNap.tr("Default"));
        this.jrbUploadDefault.setActionCommand("-1");
        GridBagHelper.add((Container)jPanel, this.jrbUploadDefault);
        this.jrbUploadNever = new JRadioButton(XNap.tr("Never"));
        this.jrbUploadNever.setActionCommand("0");
        GridBagHelper.add((Container)jPanel, this.jrbUploadNever);
        this.jrbUploadAlways = new JRadioButton(XNap.tr("Always"));
        this.jrbUploadAlways.setActionCommand("2147483647");
        GridBagHelper.add((Container)jPanel, this.jrbUploadAlways);
        this.bgUpload = new ButtonGroup();
        this.bgUpload.add(this.jrbUploadDefault);
        this.bgUpload.add(this.jrbUploadNever);
        this.bgUpload.add(this.jrbUploadAlways);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(XNap.tr("Allow Downloads From This User", 1)));
        GridBagHelper.add((Container)this, jPanel2);
        this.jrbDownloadDefault = new JRadioButton(XNap.tr("Default"));
        this.jrbDownloadDefault.setActionCommand("-1");
        GridBagHelper.add((Container)jPanel2, this.jrbDownloadDefault);
        this.jrbDownloadNever = new JRadioButton(XNap.tr("Never"));
        this.jrbDownloadNever.setActionCommand("0");
        GridBagHelper.add((Container)jPanel2, this.jrbDownloadNever);
        this.bgDownload = new ButtonGroup();
        this.bgDownload.add(this.jrbDownloadDefault);
        this.bgDownload.add(this.jrbDownloadNever);
    }

    public void apply() {
        this.user.setComment(this.jtComment.getText());
        this.user.setCategory(this.jcbCategory.getSelectedItem().toString());
        this.user.setChatIgnored(this.jcbIgnoreChat.isSelected());
        this.user.setMaxUploads(this.getValue(this.bgUpload));
        this.user.setMaxDownloads(this.getValue(this.bgDownload));
        this.user.setTemporary(false);
    }

    public IUser getUser() {
        return this.user;
    }

    public boolean hasChanged() {
        boolean bl = false;
        bl |= !this.jtComment.getText().equals(this.user.getComment());
        bl |= !this.jcbCategory.getSelectedItem().toString().equals(this.user.getCategory());
        bl |= !(this.jcbIgnoreChat.isSelected() == this.user.isChatIgnored());
        bl |= !(this.user.getMaxUploads() == this.getValue(this.bgUpload));
        return bl |= !(this.user.getMaxDownloads() == this.getValue(this.bgDownload));
    }

    public void setUser(IUser iUser) {
        this.user = iUser;
        this.jtName.setText(iUser.getName());
        this.jtComment.setText(iUser.getComment());
        this.jcbCategory.setSelectedItem(iUser.getCategory());
        this.jcbIgnoreChat.setSelected(iUser.isChatIgnored());
        this.setValue(this.bgDownload, iUser.getMaxDownloads());
        this.setValue(this.bgUpload, iUser.getMaxUploads());
    }

    private final int getValue(ButtonGroup buttonGroup) {
        return Integer.parseInt(buttonGroup.getSelection().getActionCommand());
    }

    private final void setValue(ButtonGroup buttonGroup, int n) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (!abstractButton.getActionCommand().equals(n + "")) continue;
            abstractButton.setSelected(true);
            return;
        }
    }

    public UserEditorPanel(IUser iUser) {
        this.initialize();
        this.setUser(iUser);
    }

    public UserEditorPanel() {
        this.initialize();
    }
}

