/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.cmdl.Console;
import xnap.cmdl.ConsoleWriter;
import xnap.gui.AbstractPanel;
import xnap.gui.CloseableTabbedPane;
import xnap.gui.EditableComboBox;
import xnap.gui.OptionsBox;
import xnap.gui.SearchSubPanel;
import xnap.gui.SearchSubTreePanel;
import xnap.gui.TransferSubPanel;
import xnap.gui.XNapFrame;
import xnap.gui.action.MenuAction;
import xnap.gui.event.EraseAction;
import xnap.gui.event.ShowAction;
import xnap.gui.event.UserSupport;
import xnap.gui.menu.UserMenu;
import xnap.gui.util.GUIHelper;
import xnap.io.Repository;
import xnap.net.AutoDownload;
import xnap.net.ISearchResult;
import xnap.net.IUser;
import xnap.net.SearchResultContainer;
import xnap.util.Browser;
import xnap.util.DownloadQueue;
import xnap.util.FileHelper;
import xnap.util.ISearchContainer;
import xnap.util.Preferences;
import xnap.util.SearchFilter;
import xnap.util.SearchFilterHelper;
import xnap.util.SearchManager;
import xnap.util.StringHelper;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;
import xnap.util.event.SearchManagerListener;

public class SearchPanel
extends AbstractPanel
implements ListListener,
ChangeListener,
PropertyChangeListener,
SearchManagerListener,
UserSupport {
    public static final String HISTORY_FILENAME = FileHelper.getHomeDir() + "search_history";
    public static final String HISTORY_FILENAME_2 = FileHelper.getHomeDir() + "search_history2";
    protected static Logger logger = Logger.getLogger(class$Lxnap$gui$SearchPanel != null ? class$Lxnap$gui$SearchPanel : (class$Lxnap$gui$SearchPanel = SearchPanel.class$("xnap.gui.SearchPanel")));
    protected static Preferences prefs = Preferences.getInstance();
    private JPopupMenu popup;
    private EditableComboBox jcSearch;
    private OptionsBox opBox;
    private JComboBox jcMediaType;
    private CloseableTabbedPane jtpSearches;
    private JSplitPane jsp;
    private JMenu jmBrowse;
    private JPanel jpOptions;
    private AbortAction acAbort = new AbortAction();
    private AutoDownloadAction acAutoDownload = new AutoDownloadAction();
    private EraseAction acErase = new EraseAction();
    private QueryAction acQuery = new QueryAction();
    private ResumeFromAction acResumeFrom = new ResumeFromAction();
    private SearchRepositoryAction acSearchRepository = new SearchRepositoryAction();
    private MenuAction acMenu = new MenuAction(new UserMenu(this));
    private CardLayout clCenter;
    private Container jpCenter;
    private static /* synthetic */ Class class$Lxnap$gui$SearchPanel;

    private final void initialize() {
        this.popup = new JPopupMenu();
        this.popup.add(this.acAutoDownload);
        this.popup.add(this.acResumeFrom);
        this.popup.addSeparator();
        this.popup.add(this.acSearchRepository);
        if (prefs.getSearchResultOpenAction().length() > 0) {
            this.popup.add(new SearchResultOpenAction());
        }
        this.popup.addSeparator();
        this.popup.add(new UserMenu(this));
        Box box = new Box(0);
        JButton jButton = new JButton(this.acErase);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        box.add(jButton);
        this.jcSearch = new EditableComboBox(this.acQuery, prefs.getSearchHistorySize());
        File file = new File(HISTORY_FILENAME_2);
        if (file.exists()) {
            this.jcSearch.readBinaryHistoryFile(file);
        } else {
            this.jcSearch.readHistoryFile(new File(HISTORY_FILENAME));
        }
        this.jcSearch.addActionListener(new FilterSelectionListener());
        this.jcSearch.getJTextField().setColumns(40);
        this.jcSearch.getJTextField().setMaximumSize(new Dimension(this.jcSearch.getJTextField().getPreferredSize().width, this.jcSearch.getMaximumSize().height));
        box.add(this.jcSearch);
        this.acErase.setJTextField(this.jcSearch.getJTextField());
        this.jcMediaType = new JComboBox<Object>(SearchFilter.media);
        this.jcMediaType.addActionListener(new MediaTypeSelectionListener());
        GUIHelper.limitSize(this.jcMediaType);
        box.add(this.jcMediaType);
        this.opBox = new OptionsBox(0);
        this.jcMediaType.setSelectedIndex(prefs.getSearchMediaType());
        this.jpOptions = new JPanel();
        this.jpOptions.setLayout(new BoxLayout(this.jpOptions, 1));
        this.jpOptions.add(Box.createVerticalStrut(2));
        this.jpOptions.add(this.opBox);
        this.jpOptions.setVisible(prefs.getShowSearchOptions());
        JButton jButton2 = new JButton(this.acQuery);
        box.add(jButton2);
        JButton jButton3 = new JButton(new ShowAction(this, this.jpOptions));
        jButton3.setMargin(new Insets(1, 1, 1, 1));
        box.add(jButton3);
        box.add(Box.createHorizontalGlue());
        this.jtpSearches = new CloseableTabbedPane();
        this.jtpSearches.addContainerListener(new TabListener());
        this.jtpSearches.addChangeListener(this);
        JLabel jLabel = new JLabel(XNapFrame.getImage("xnap_logo.png"));
        this.clCenter = new CardLayout();
        this.jpCenter = new Container();
        this.jpCenter.setLayout(this.clCenter);
        this.jpCenter.add((Component)jLabel, "Logo");
        this.jpCenter.add((Component)this.jtpSearches, "Search");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new TitledBorder(XNap.tr("Search", 1)));
        jPanel.add(box);
        jPanel.add(this.jpOptions);
        TransferSubPanel transferSubPanel = new TransferSubPanel(true, true);
        transferSubPanel.setStatusListener(this);
        this.jsp = new JSplitPane(0);
        this.jsp.setDividerLocation(prefs.getSearchDividerLocation());
        this.jsp.setOneTouchExpandable(true);
        this.jsp.setResizeWeight(1.0);
        this.jsp.add((Component)this.jpCenter, "top");
        this.jsp.add((Component)transferSubPanel, "bottom");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)this.jsp, "Center");
        this.updateActions();
    }

    public void download(SearchResultContainer searchResultContainer, SearchFilter searchFilter, File file) {
        if (searchFilter == null) {
            searchFilter = new SearchFilter();
        }
        boolean bl = false;
        ISearchResult[] iSearchResultArray = searchResultContainer.getSearchResults();
        int n = 0;
        while (n < iSearchResultArray.length) {
            if (iSearchResultArray[n].canGroup()) {
                bl = true;
            } else if (!iSearchResultArray[n].download(searchFilter, file)) {
                this.setStatus(XNap.tr("Already downloading that file."));
            }
            ++n;
        }
        if (bl) {
            AutoDownload autoDownload = new AutoDownload(iSearchResultArray, searchFilter, file);
            if (!DownloadQueue.getInstance().add(autoDownload)) {
                this.setStatus(XNap.tr("Already downloading that file."));
            }
        }
    }

    public void elementAdded(ListEvent listEvent) {
        ISearchContainer iSearchContainer = (ISearchContainer)listEvent.getElement();
        SearchSubPanel searchSubPanel = iSearchContainer instanceof Browser ? new SearchSubTreePanel(this, iSearchContainer) : new SearchSubPanel(this, iSearchContainer);
        this.jtpSearches.addTab(searchSubPanel.getTitle(), searchSubPanel);
        XNapFrame.setFocusTo("search");
    }

    public void elementRemoved(ListEvent listEvent) {
    }

    public int getDividerLocation() {
        return this.jsp.getDividerLocation();
    }

    public void readyToSearch(boolean bl) {
        Runnable runnable = new Runnable(this, bl){
            private final /* synthetic */ SearchPanel this$0;
            private final /* synthetic */ boolean val$ready;

            public final void run() {
                SearchPanel.access$0(this.this$0).setEnabled(this.val$ready);
            }
            {
                this.val$ready = bl;
                this.this$0 = searchPanel;
                this.constructor$0(searchPanel);
            }

            private final void constructor$0(SearchPanel searchPanel) {
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setDividerLocation(int n) {
        if (n == -1) {
            this.jsp.setDividerLocation(0.8);
        } else {
            this.jsp.setDividerLocation(n);
        }
    }

    public SearchFilter getSearchFilter() {
        SearchFilter searchFilter = new SearchFilter();
        searchFilter.setSearchText(this.jcSearch.getText().trim());
        if (this.opBox.isBitrateEnabled()) {
            searchFilter.setBitrateCompare(this.opBox.getBitrateCompare());
            searchFilter.setBitrate(this.opBox.getBitrate());
        }
        searchFilter.setMediaType(this.jcMediaType.getSelectedIndex());
        searchFilter.setFilesizeCompare(this.opBox.getFilesizeCompare());
        searchFilter.setFilesize(this.opBox.getFilesize());
        return searchFilter;
    }

    public void setSearchFilter(SearchFilter searchFilter) {
        this.opBox.setBitrateCompare(searchFilter.getBitrateCompare());
        this.opBox.setBitrate(SearchFilterHelper.getIndexFromBitrate(searchFilter.getBitrate()));
        this.jcMediaType.setSelectedIndex(searchFilter.getMediaType());
        this.opBox.setFilesizeCompare(searchFilter.getFilesizeCompare());
        this.opBox.setFilesize(searchFilter.getFilesize());
    }

    public AbstractAction getDefaultAction() {
        return this.acAutoDownload;
    }

    public AbstractAction[] getActions() {
        AbstractAction[] abstractActionArray = new AbstractAction[]{this.acAutoDownload, this.acResumeFrom, null, this.acAbort, null, this.acMenu};
        AbstractAction[] abstractActionArray2 = new AbstractAction[abstractActionArray.length];
        System.arraycopy(abstractActionArray, 0, abstractActionArray2, 0, abstractActionArray.length);
        return abstractActionArray2;
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void purgeHistory() {
        this.jcSearch.removeAllItems();
    }

    public void savePrefs() {
        prefs.setShowSearchOptions(this.jpOptions.isVisible());
        prefs.setSearchBitrate(this.opBox.getBitrate());
        prefs.setSearchCompare(this.opBox.getBitrateCompare());
        prefs.setSearchMediaType(this.jcMediaType.getSelectedIndex());
        this.jcSearch.setHistorySize(prefs.getSearchHistorySize());
        this.jcSearch.writeBinaryHistoryFile(new File(HISTORY_FILENAME_2));
        prefs.setSearchDividerLocation(this.getDividerLocation());
    }

    public SearchSubPanel getSelectedSubPanel() {
        return (SearchSubPanel)this.jtpSearches.getSelectedComponent();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updateActions();
    }

    public void setTitle(SearchSubPanel searchSubPanel, String string) {
        int n = this.jtpSearches.indexOfComponent(searchSubPanel);
        if (n != -1) {
            this.jtpSearches.setTitleAt(n, string);
        }
    }

    public IUser[] getUsers() {
        SearchResultContainer[] searchResultContainerArray;
        SearchSubPanel searchSubPanel = this.getSelectedSubPanel();
        if (searchSubPanel != null && (searchResultContainerArray = searchSubPanel.getSelectedResults()) != null) {
            LinkedList<IUser> linkedList = new LinkedList<IUser>();
            int n = 0;
            while (n < searchResultContainerArray.length) {
                ISearchResult[] iSearchResultArray = searchResultContainerArray[n].getSearchResults();
                int n2 = 0;
                while (n2 < iSearchResultArray.length) {
                    linkedList.add(iSearchResultArray[n2].getUser());
                    ++n2;
                }
                ++n;
            }
            IUser[] iUserArray = new IUser[linkedList.size()];
            System.arraycopy(linkedList.toArray(), 0, iUserArray, 0, iUserArray.length);
            return iUserArray;
        }
        return null;
    }

    public void updateActions() {
        SearchSubPanel searchSubPanel = this.getSelectedSubPanel();
        if (searchSubPanel != null) {
            this.acAbort.setEnabled(true);
            this.acAutoDownload.setEnabled(true);
            this.acResumeFrom.setEnabled(true);
        } else {
            this.acAbort.setEnabled(false);
            this.acAutoDownload.setEnabled(false);
            this.acResumeFrom.setEnabled(false);
        }
    }

    static /* synthetic */ QueryAction access$0(SearchPanel searchPanel) {
        return searchPanel.acQuery;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SearchPanel() {
        this.initialize();
        this.addPropertyChangeListener("searchHistorySize", this);
        SearchManager.getInstance().addListListener(this);
        SearchManager.getInstance().setListener(this);
    }

    private class TabListener
    implements ContainerListener {
        public void componentAdded(ContainerEvent containerEvent) {
            this.updateLayout(containerEvent.getID());
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            this.updateLayout(containerEvent.getID());
        }

        private final void updateLayout(int n) {
            if (n == 301 && SearchPanel.this.jtpSearches.getComponentCount() == 0) {
                SearchPanel.this.clCenter.show(SearchPanel.this.jpCenter, "Logo");
            } else {
                SearchPanel.this.clCenter.show(SearchPanel.this.jpCenter, "Search");
            }
        }

        TabListener() {
        }
    }

    private class QueryAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            SearchFilter searchFilter = SearchPanel.this.getSearchFilter();
            if (searchFilter.getSearchText().length() > 0) {
                SearchManager.getInstance().search(searchFilter);
                SearchPanel.this.jcSearch.addDistinctItemAtTop(searchFilter);
            } else {
                SearchPanel.this.setStatus(XNap.tr("What are you trying to search for?"));
            }
        }

        public QueryAction() {
            this.putValue("Name", XNap.tr("Query"));
            this.putValue("ShortDescription", XNap.tr("Perform search"));
            this.putValue("MnemonicKey", new Integer(81));
        }
    }

    private class AbortAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            SearchSubPanel searchSubPanel = SearchPanel.this.getSelectedSubPanel();
            if (searchSubPanel != null) {
                searchSubPanel.abort();
            }
        }

        public AbortAction() {
            this.putValue("Name", XNap.tr("Abort"));
            this.putValue("ShortDescription", XNap.tr("Abort search"));
            this.putValue("SmallIcon", XNapFrame.getIcon("round_stop.png"));
            this.putValue("MnemonicKey", new Integer(65));
        }
    }

    private class AutoDownloadAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            SearchSubPanel searchSubPanel = SearchPanel.this.getSelectedSubPanel();
            if (searchSubPanel != null) {
                SearchResultContainer[] searchResultContainerArray = searchSubPanel.getSelectedResults();
                if (searchResultContainerArray.length == 0) {
                    SearchPanel.this.setStatus(XNap.tr("Please select a row first."));
                } else {
                    int n = 0;
                    while (n < searchResultContainerArray.length) {
                        SearchPanel.this.download(searchResultContainerArray[n], searchSubPanel.getOriginalFilter(), null);
                        ++n;
                    }
                }
            }
        }

        public AutoDownloadAction() {
            this.putValue("Name", XNap.tr("Download"));
            this.putValue("ShortDescription", XNap.tr("Download selected file(s)"));
            this.putValue("SmallIcon", XNapFrame.getIcon("down.png"));
            this.putValue("MnemonicKey", new Integer(68));
        }
    }

    private class ResumeFromAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            SearchSubPanel searchSubPanel = SearchPanel.this.getSelectedSubPanel();
            if (searchSubPanel != null) {
                SearchResultContainer[] searchResultContainerArray = searchSubPanel.getSelectedResults();
                if (searchResultContainerArray.length != 1) {
                    SearchPanel.this.setStatus(XNap.tr("Please select a single result."));
                } else {
                    JFileChooser jFileChooser = new JFileChooser();
                    if (jFileChooser.showOpenDialog(SearchPanel.this) == 0) {
                        SearchPanel.this.download(searchResultContainerArray[0], searchSubPanel.getOriginalFilter(), jFileChooser.getSelectedFile());
                    }
                }
            }
        }

        public ResumeFromAction() {
            this.putValue("Name", XNap.tr("Resume from") + "...");
            this.putValue("ShortDescription", XNap.tr("Resume file with a selected search results"));
            this.putValue("SmallIcon", XNapFrame.getIcon("noatunloopsong.png"));
        }
    }

    private class SearchRepositoryAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            SearchSubPanel searchSubPanel = SearchPanel.this.getSelectedSubPanel();
            if (searchSubPanel != null) {
                SearchResultContainer[] searchResultContainerArray = searchSubPanel.getSelectedResults();
                if (searchResultContainerArray.length == 0) {
                    SearchPanel.this.setStatus(XNap.tr("Please select a row first."));
                } else {
                    boolean bl = (actionEvent.getModifiers() & ActionEvent.CTRL_MASK) > 0;
                    int n = 0;
                    while (n < searchResultContainerArray.length) {
                        File[] fileArray;
                        String string = searchResultContainerArray[n].getShortFilename();
                        string = FileHelper.name(string);
                        String string2 = StringHelper.stripExtra(string);
                        File[] fileArray2 = fileArray = bl ? Repository.getInstance().search(string2, searchResultContainerArray[n].getFilesize()) : Repository.getInstance().search(string2);
                        if (fileArray != null) {
                            StringBuffer stringBuffer = new StringBuffer();
                            int n2 = 0;
                            while (n2 < fileArray.length) {
                                stringBuffer.append(fileArray[n2].getName());
                                if (n2 < fileArray.length - 1) {
                                    stringBuffer.append(", ");
                                }
                                ++n2;
                            }
                            searchResultContainerArray[n].setStatus(stringBuffer.toString());
                        } else {
                            searchResultContainerArray[n].setStatus("-");
                        }
                        ++n;
                    }
                }
            }
        }

        public SearchRepositoryAction() {
            this.putValue("Name", XNap.tr("Search Library"));
            this.putValue("ShortDescription", XNap.tr("Searches library for search result."));
            this.putValue("SmallIcon", XNapFrame.getIcon("find.png"));
            this.putValue("MnemonicKey", new Integer(83));
        }
    }

    private class SearchResultOpenAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            SearchSubPanel searchSubPanel = SearchPanel.this.getSelectedSubPanel();
            if (searchSubPanel != null) {
                SearchResultContainer[] searchResultContainerArray = searchSubPanel.getSelectedResults();
                if (searchResultContainerArray.length == 0) {
                    SearchPanel.this.setStatus(XNap.tr("Please select a row first."));
                } else {
                    int n = 0;
                    while (n < searchResultContainerArray.length) {
                        SearchPanel searchPanel = SearchPanel.this;
                        if (searchPanel == null) {
                            throw null;
                        }
                        SearchResultOpener searchResultOpener = searchPanel.new SearchResultOpener(searchResultContainerArray[n]);
                        Thread thread = new Thread((Runnable)searchResultOpener, "SearchResultOperner");
                        thread.start();
                        ++n;
                    }
                }
            }
        }

        public SearchResultOpenAction() {
            this.putValue("Name", prefs.getSearchResultOpenAction());
            this.putValue("ShortDescription", XNap.tr("Execute command"));
            this.putValue("SmallIcon", XNapFrame.getIcon("fileopen.png"));
            this.putValue("MnemonicKey", new Integer(79));
        }
    }

    public class SearchResultOpener
    extends ConsoleWriter {
        SearchResultContainer c;

        public void write(String string) {
            super.write(string);
            String string2 = this.c.getStatus();
            this.c.setStatus(string2 == null ? string : string2 + ", " + string);
        }

        static /* synthetic */ InputStream access$0(SearchResultOpener searchResultOpener) {
            return searchResultOpener.inStream;
        }

        public SearchResultOpener(SearchResultContainer searchResultContainer) {
            Process process;
            this.c = searchResultContainer;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(prefs.getSearchResultOpenAction());
            stringBuffer.append(" ");
            stringBuffer.append(searchResultContainer.getShortFilename());
            String[] stringArray = StringHelper.toArray(stringBuffer.toString(), " ");
            try {
                process = Runtime.getRuntime().exec(stringArray);
            }
            catch (IOException iOException) {
                logger.warn("open failed", iOException);
                return;
            }
            this.inStream = process.getInputStream();
            Console.getInstance().add(process.getErrorStream());
        }
    }

    private class FilterSelectionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = SearchPanel.this.jcSearch.getSelectedItem();
            if (object != null && object instanceof SearchFilter) {
                SearchPanel.this.setSearchFilter((SearchFilter)object);
            }
        }

        FilterSelectionListener() {
        }
    }

    private class MediaTypeSelectionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = SearchPanel.this.jcMediaType.getSelectedIndex();
            if (n == 0 || n == 1) {
                SearchPanel.this.opBox.setBitrateEnabled(true);
            } else {
                SearchPanel.this.opBox.setBitrateEnabled(false);
            }
        }

        MediaTypeSelectionListener() {
        }
    }
}

