/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IconSplitPane
extends JSplitPane {
    private JList jlIcons;
    private DefaultListModel dlmIcons;
    private CardLayout clCenter;
    private Container jpCenter;
    protected ChangeListener changeListener = null;
    protected transient ChangeEvent changeEvent = null;
    protected Component selection;
    private static /* synthetic */ Class class$Ljavax$swing$event$ChangeListener;

    private final void initialize() {
        this.setOneTouchExpandable(true);
        this.jlIcons = new JList();
        this.dlmIcons = new DefaultListModel();
        this.jlIcons.setModel(this.dlmIcons);
        this.jlIcons.addListSelectionListener(new IconListener());
        this.jlIcons.setSelectionMode(0);
        this.jlIcons.setCellRenderer(new IconRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.jlIcons);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)jScrollPane, "left");
        this.clCenter = new CardLayout();
        this.jpCenter = new Container();
        this.jpCenter.setLayout(this.clCenter);
        this.add((Component)this.jpCenter, "right");
    }

    public void addTab(String string, Icon icon, Component component) {
        this.insertTab(string, icon, component, this.dlmIcons.size());
    }

    public void insertTab(String string, Icon icon, Component component, int n) {
        if (icon != null) {
            if (icon instanceof ImageIcon) {
                ((ImageIcon)icon).setDescription(string);
            }
            this.dlmIcons.insertElementAt(icon, n);
        } else {
            this.dlmIcons.insertElementAt(string, n);
        }
        this.jpCenter.add(component, string, n);
        this.setDividerLocation(this.jlIcons.getPreferredSize().width + 30);
        if (this.dlmIcons.size() == 1) {
            this.jlIcons.setSelectedIndex(0);
        } else if (this.jlIcons.getSelectedIndex() >= n) {
            this.jlIcons.setSelectedIndex(this.jlIcons.getSelectedIndex() + 1);
        }
    }

    public int indexOf(Component component) {
        int n = this.jpCenter.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.jpCenter.getComponent(n2) == component) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Component[] getTabs() {
        return this.jpCenter.getComponents();
    }

    public Component getTabAt(int n) {
        return this.jpCenter.getComponents()[n];
    }

    public int getTabCount() {
        return this.jpCenter.getComponentCount();
    }

    public String getDescriptionAt(int n) {
        Object e = this.dlmIcons.get(n);
        if (e != null) {
            if (e instanceof ImageIcon) {
                return ((ImageIcon)e).getDescription();
            }
            return e.toString();
        }
        return null;
    }

    public Icon getIconAt(int n) {
        Object e = this.dlmIcons.get(n);
        if (e instanceof Icon) {
            return (Icon)e;
        }
        return null;
    }

    public String getTitleAt(int n) {
        return this.dlmIcons.get(n).toString();
    }

    public void setIconAt(int n, Icon icon) {
        if (icon != null) {
            if (icon instanceof ImageIcon) {
                ((ImageIcon)icon).setDescription(this.getDescriptionAt(n));
            }
            this.dlmIcons.set(n, icon);
        }
    }

    public int getSelectedIndex() {
        return this.jlIcons.getSelectedIndex();
    }

    public void setSelectedComponent(Component component) {
        int n = this.indexOf(component);
        if (n != -1) {
            this.jlIcons.setSelectedIndex(n);
        }
    }

    public void remove(Component component) {
        if (this.jpCenter == null) {
            return;
        }
        int n = this.indexOf(component);
        if (n != -1) {
            this.removeTabAt(n);
        }
    }

    public void removeTabAt(int n) {
        if (n == this.jlIcons.getSelectedIndex()) {
            this.jlIcons.setSelectedIndex(0);
        }
        this.jpCenter.remove(n);
        this.dlmIcons.remove(n);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$Ljavax$swing$event$ChangeListener != null ? class$Ljavax$swing$event$ChangeListener : (class$Ljavax$swing$event$ChangeListener = IconSplitPane.class$("javax.swing.event.ChangeListener")), changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$Ljavax$swing$event$ChangeListener != null ? class$Ljavax$swing$event$ChangeListener : (class$Ljavax$swing$event$ChangeListener = IconSplitPane.class$("javax.swing.event.ChangeListener")), changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$Ljavax$swing$event$ChangeListener != null ? class$Ljavax$swing$event$ChangeListener : IconSplitPane.class$("javax.swing.event.ChangeListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public Component getSelectedComponent() {
        return this.jpCenter.getComponent(this.jlIcons.getSelectedIndex());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public IconSplitPane() {
        super(1);
        this.initialize();
    }

    private class IconListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = IconSplitPane.this.jlIcons.getSelectedIndex();
            if (n != -1) {
                String string = null;
                Object e = IconSplitPane.this.dlmIcons.elementAt(n);
                if (e instanceof ImageIcon) {
                    string = ((ImageIcon)e).getDescription();
                } else if (e instanceof String) {
                    string = (String)e;
                }
                IconSplitPane.this.clCenter.show(IconSplitPane.this.jpCenter, string);
                IconSplitPane.this.fireStateChanged();
            }
        }

        IconListener() {
        }
    }

    private class IconRenderer
    extends JLabel
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setText(null);
            this.setIcon(null);
            if (object instanceof ImageIcon) {
                ImageIcon imageIcon = (ImageIcon)object;
                this.setText(imageIcon.getDescription());
                this.setIcon(imageIcon);
            } else if (object instanceof String) {
                this.setText((String)object);
            }
            return this;
        }

        public IconRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
        }
    }
}

