/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import xnap.gui.FontChooserDialog;
import xnap.gui.XNapFrame;

public class FontPanel
extends JPanel {
    private Component parent;
    private Font font;
    private JLabel jlFont;

    public Font getSelectedFont() {
        return this.font;
    }

    public void setSelectedFont(Font font) {
        this.font = font;
        this.jlFont.setFont(this.font);
        this.jlFont.setText(" " + this.font.getName() + ", " + this.font.getSize());
    }

    public FontPanel(Component component, Font font) {
        this.parent = component;
        this.setLayout(new BorderLayout());
        this.jlFont = new JLabel();
        this.jlFont.setBorder(new BevelBorder(1));
        this.add((Component)this.jlFont, "Center");
        JButton jButton = new JButton(new FontAction());
        jButton.setMargin(new Insets(1, 1, 1, 1));
        this.add((Component)jButton, "East");
        this.setSelectedFont(font);
    }

    private class FontAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Font font = FontChooserDialog.showDialog(FontPanel.this.parent, FontPanel.this.getSelectedFont());
            if (font != null) {
                FontPanel.this.setSelectedFont(font);
            }
        }

        public FontAction() {
            this.putValue("ShortDescription", "Opens font selection dialog.");
            this.putValue("SmallIcon", XNapFrame.getSmallIcon("charset.png"));
            this.putValue("MnemonicKey", new Integer(79));
        }
    }
}

