/*
 * Decompiled with CFR 0.152.
 */
package xnap.cmdl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import xnap.cmdl.ParameterException;
import xnap.cmdl.SyntaxException;

public abstract class AbstractCommand {
    public static final String CMD = "cmd";
    public static final String LONG_HELP = "longHelp";
    public static final String PARAMETER = "parameter";
    public static final String SHORT_HELP = "shortHelp";
    private Hashtable table = new Hashtable();

    public abstract boolean execute(String[] var1) throws SyntaxException, ParameterException;

    public String[] getCommands() {
        ArrayList arrayList = (ArrayList)this.table.get(CMD);
        if (arrayList != null) {
            String[] stringArray = new String[arrayList.size()];
            System.arraycopy(arrayList.toArray(), 0, stringArray, 0, stringArray.length);
            return stringArray;
        }
        return new String[0];
    }

    public String getLongHelp() {
        Object v = this.table.get(LONG_HELP);
        return v != null ? v.toString() : this.getShortHelp();
    }

    public String getParameter() {
        Object v = this.table.get(PARAMETER);
        return v != null ? v.toString() : "";
    }

    public String getShortHelp() {
        Object v = this.table.get(SHORT_HELP);
        return v != null ? v.toString() : "Sorry, no help available.";
    }

    protected void putValue(String string, Object object) {
        if (string.equals(CMD)) {
            ArrayList<Object> arrayList = (ArrayList<Object>)this.table.get(CMD);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                this.table.put(string, arrayList);
            }
            if (object instanceof String) {
                arrayList.add(object);
            } else if (object instanceof String[]) {
                arrayList.addAll(Arrays.asList((String[])object));
            }
        } else {
            this.table.put(string, object);
        }
    }

    protected int getInt(String[] stringArray, int n, int n2) throws SyntaxException, ParameterException {
        int n3;
        if (stringArray.length != 2) {
            throw new SyntaxException();
        }
        try {
            n3 = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SyntaxException();
        }
        if (n3 < n || n3 > n2) {
            throw new ParameterException("Invalid id.");
        }
        return n3;
    }
}

