/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.readline;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.gnu.readline.ReadlineCompleter;
import org.gnu.readline.ReadlineLibrary;

public class Readline {
    private static ReadlineCompleter iCompleter = null;
    private static ReadlineLibrary iLib = ReadlineLibrary.PureJava;
    private static BufferedReader iReader = null;
    private static boolean iThrowException = false;

    public static final void load(ReadlineLibrary readlineLibrary) throws UnsatisfiedLinkError {
        if (readlineLibrary == iLib) {
            return;
        }
        if (readlineLibrary == ReadlineLibrary.PureJava) {
            iLib = readlineLibrary;
            return;
        }
        System.loadLibrary(readlineLibrary.getName());
        iLib = readlineLibrary;
    }

    public static void initReadline(String string) {
        if (iLib != ReadlineLibrary.PureJava) {
            Readline.initReadlineImpl(string);
        }
    }

    public static String readline(String string) throws EOFException, IOException, UnsupportedEncodingException {
        String string2;
        if (iLib != ReadlineLibrary.PureJava) {
            return Readline.readlineImpl(string);
        }
        System.out.print(string);
        if (iReader == null) {
            iReader = new BufferedReader(new InputStreamReader(System.in));
        }
        if ((string2 = iReader.readLine()) == null) {
            throw new EOFException("EOF");
        }
        return string2.length() == 0 ? null : string2;
    }

    public static void readInitFile(String string) throws IOException {
        if (iLib == ReadlineLibrary.GnuReadline) {
            Readline.readInitFileImpl(string);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static boolean parseAndBind(String string) {
        if (iLib == ReadlineLibrary.GnuReadline) {
            return Readline.parseAndBindImpl(string);
        }
        if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return true;
    }

    public static void readHistoryFile(String string) throws EOFException, UnsupportedEncodingException {
        if (iLib != ReadlineLibrary.PureJava) {
            Readline.readHistoryFileImpl(string);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static void writeHistoryFile(String string) throws EOFException, UnsupportedEncodingException {
        if (iLib != ReadlineLibrary.PureJava) {
            Readline.writeHistoryFileImpl(string);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static void setCompleter(ReadlineCompleter readlineCompleter) {
        iCompleter = readlineCompleter;
        if (iLib != ReadlineLibrary.PureJava) {
            Readline.setCompleterImpl(iCompleter);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static ReadlineCompleter getCompleter() {
        return iCompleter;
    }

    public static void cleanup() {
        if (iLib != ReadlineLibrary.PureJava) {
            Readline.cleanupReadlineImpl();
        }
    }

    public static String getWordBreakCharacters() {
        if (iLib != ReadlineLibrary.PureJava) {
            return Readline.getWordBreakCharactersImpl();
        }
        if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public static String getLineBuffer() {
        if (iLib != ReadlineLibrary.PureJava) {
            return Readline.getLineBufferImpl();
        }
        if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public static void setWordBreakCharacters(String string) throws UnsupportedEncodingException {
        if (iLib != ReadlineLibrary.PureJava) {
            Readline.setWordBreakCharactersImpl(string);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static void setThrowExceptionOnUnsupportedMethod(boolean bl) {
        iThrowException = bl;
    }

    public static boolean getThrowExceptionOnUnsupportedMethod() {
        return iThrowException;
    }

    private static final native void initReadlineImpl(String var0);

    private static final native void cleanupReadlineImpl();

    private static final native String readlineImpl(String var0) throws EOFException, UnsupportedEncodingException;

    private static final native void readInitFileImpl(String var0) throws IOException;

    private static final native String getLineBufferImpl();

    private static final native boolean parseAndBindImpl(String var0);

    private static final native void readHistoryFileImpl(String var0) throws EOFException, UnsupportedEncodingException;

    private static final native void writeHistoryFileImpl(String var0) throws EOFException, UnsupportedEncodingException;

    private static final native void setCompleterImpl(ReadlineCompleter var0);

    private static final native String getWordBreakCharactersImpl();

    private static final native void setWordBreakCharactersImpl(String var0) throws UnsupportedEncodingException;
}

