
#ifndef WPDataFile_Source
#define WPDataFile_Source

#include <wpfsys.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);

#define MAX_ASSOC_ITEMS 12

class WPDataFile : public WPFileSystem {

     #pragma SOMMap (WPDataFile, "WPDataFile", "M_WPDataFile")

     #pragma SOMClassVersion (WPDataFile, 1, 2)

     #pragma SOMCallstyle (WPDataFile, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual ULONG wpAddFileTypePage(HWND hwndNotebook);
     virtual BOOL wpPrintMetaFile(PPRINTDEST pPrintDest);
     virtual BOOL wpPrintPifFile(PPRINTDEST pPrintDest);
     virtual BOOL wpPrintPrinterSpecificFile(PPRINTDEST pPrintDest);
     virtual BOOL wpPrintUnknownFile(PPRINTDEST pPrintDest);
     virtual WPObject* wpQueryAssociatedProgram(ULONG ulView,
                                                PULONG pulHowMatched,
                                                PSZ pszMatchString,
                                                ULONG cbMatchString,
                                                PSZ pszDefaultType);
     virtual void wpSetAssociatedFileIcon();
     virtual MRESULT wpDragOver(HWND hwndCnr, PDRAGINFO pdrgInfo);
     virtual BOOL wpRestoreState(ULONG ulReserved);
     virtual BOOL wpSetDefaultView(ULONG ulView);
     virtual BOOL wpSetRealName(PSZ pszName);
     virtual BOOL wpSetType(PSZ pszTypes, PFEA2LIST pfeal);
     virtual void wpUnInitData();
     virtual BOOL wpAddSettingsPages(HWND hwndNotebook);
     virtual ULONG wpAddObjectWindowPage(HWND hwndNotebook);
     virtual HWND wpOpen(HWND hwndCnr, ULONG ulView, ULONG param);
     virtual BOOL wpPrintObject(PPRINTDEST pPrintDest, ULONG ulReserved);
     virtual BOOL wpModifyPopupMenu(HWND hwndMenu, HWND hwndCnr,
                                    ULONG iPosition);
     virtual BOOL wpMenuItemSelected(HWND hwndFrame, ULONG ulMenuId);
     virtual BOOL wpMenuItemHelpSelected(ULONG MenuId);
     virtual BOOL wpQueryDefaultHelp(PULONG pHelpPanelId, PSZ HelpLibrary);
     virtual BOOL wpFormatDragItem(PDRAGITEM pdrgItem);
     virtual ULONG wpConfirmRenameFileWithExt();
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ( \
                              wpAddFileTypePage, \
                              wpPrintMetaFile, \
                              wpPrintPifFile, \
                              wpPrintPrinterSpecificFile, \
                              wpPrintUnknownFile, \
                              wpQueryAssociatedProgram, \
                              wpSetAssociatedFileIcon)
};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* WPDataFile_Source */

#ifndef M_WPDataFile_Source
#define M_WPDataFile_Source

#include <wpfsys.hh>
#include <somcls.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class M_WPDataFile : public M_WPFileSystem {

     #pragma SOMClassVersion (M_WPDataFile, 1, 2)

     #pragma SOMCallstyle (M_WPDataFile, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual PSZ wpclsQueryTitle();
     virtual ULONG wpclsQueryIconData(PICONINFO pIconInfo);
     virtual ULONG wpclsQueryStyle();
     virtual ULONG wpclsQueryDefaultView();
     virtual BOOL wpclsQueryDefaultHelp(PULONG pHelpPanelId,
                                        PSZ pszHelpLibrary);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ()

};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* M_WPDataFile_Source */

