/*  PM Radio 1.4 Installation/Upgrade */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
signal on halt
inifile = 'PMRADIO.INI'
germanini = 'PMRADIOD.INI'
languages.0 = 4
languages.1 = 'English'
languages.2 = 'German'
languages.3 = 'Spanish'
languages.4 = 'Italian'
definstpath = 'C:\PMRADIO'
exename = 'PMRADIO.EXE'
ddname = 'FMRADIO.SYS'
files.0 = 5
files.1 = exename
files.2 = 'PR0UTIL.DLL'
files.3 = 'PMRADIO.DOC'
files.4 = 'RADIO.EXE'
files.5 = ddname

say
say 'PM Radio 1.4 Installation'
say
say 'Languages available:'
do i = 1 to languages.0
  say '  '||i||'.  '||languages.i
end
say
call charout , 'Select language: '
pull language
if left(language, 1) >= 'A' then
  do i = 1 to languages.0
    parse upper var languages.i ulang
    if left(ulang, length(language)) = language then do
      language = i
      leave
    end
  end
select
  when language = 1 then do
    instpath = getpath(definstpath)
    call install instpath
  end
  when language = 2 then do
    instpath = getpath(definstpath)
    '@copy PMRADIOD.DLL' instpath||'PMRADIO.DLL >nul 2>&1'
    if rc <> 0 then
      say 'Error copying PMRADIOD.DLL to' instpath||'PMRADIO.DLL'
    call install instpath
  end
  when language = 3 then do
    instpath = getpath(definstpath)
    '@copy PMRADIOS.DLL' instpath||'PMRADIO.DLL >nul 2>&1'
    if rc <> 0 then
      say 'Error copying PMRADIOS.DLL to' instpath||'PMRADIO.DLL'
    call install instpath
  end
  when language = 4 then do
    instpath = getpath(definstpath)
    '@copy PMRADIOI.DLL' instpath||'PMRADIO.DLL >nul 2>&1'
    if rc <> 0 then
      say 'Error copying PMRADIOI.DLL to' instpath||'PMRADIO.DLL'
    call install instpath
  end
  otherwise
    say 'Installation aborted'
    exit
end

call SysFileTree instpath||inifile, 'fname', 'O'
call SysFileTree instpath||germanini, 'gname', 'O'
if fname.0 = 0 & gname.0 <> 0 then
  '@ren' instpath||germanini inifile
inifile = instpath||inifile
call SysFileTree inifile, 'fname', 'O'
if fname.0 <> 0 then do
  call SysIni inifile, 'Event', 'Event_1'
  if result \= 'ERROR:' then do
    call SysIni inifile, 'Events', 'Event_1', result
    call SysIni inifile, 'Event', 'Event_1', 'DELETE:'
    say inifile 'updated'
  end
end

halt:
exit

getpath:
  arg defpath
  do forever
    say
    call charout , 'Install into directory ('||defpath||'): '
    pull instpath
    say
    if instpath == '' then
      instpath = defpath
    if pos(':\', instpath) = 2 then
      leave
    say 'Please enter fully qualified path name'
  end
  if right(instpath, 1) <> '\' then
    instpath = instpath||'\'
  call SysMkDir left(instpath, length(instpath) - 1)
  return instpath

install:
  arg instpath
  do i = 1 to files.0
    '@copy' files.i instpath||files.i '>nul 2>&1'
    if rc <> 0 then
      say 'Error copying' files.i 'to' instpath||files.i
  end
  say 'Creating Desktop object'
  call SysCreateObject 'WPProgram', 'PM Radio', '<WP_DESKTOP>',,
    'EXENAME='||instpath||exename, 'U'
  say 'Updating CONFIG.SYS'
  instdd = instpath||ddname
  call SysIni 'SYSTEM', 'FolderWorkareaRunningObjects', 'ALL:', 'objects'
  cfgsys = left(objects.1, 2)||'\CONFIG.SYS'
  cfgpmr = left(cfgsys, length(cfgsys) - 3)||'PMR'
  '@del' cfgpmr '2>nul'
  '@ren' cfgsys filespec('N', cfgpmr) '>nul 2>&1'
  found = 0
  do while lines(cfgpmr)
    line = linein(cfgpmr)
    parse upper var line uline
    if pos(ddname, uline) <> 0 then do
      parse var line . '=' . cmdargs
      line = 'DEVICE='||instdd cmdargs
      found = 1
    end
    call lineout cfgsys, line
  end
  if found = 0 then do
    say
    say 'I/O ports:'
    say '  1.  30F'
    say '  2.  20F'
    say
    call charout , 'Select I/O port: '
    pull portno
    if portno = 2 then
      portstr = ' /P:20F'
    else
      portstr = ''
    say
    say 'Radio Card type:'
    say '  1.  Reveal RA300 or AIMS Labs. Radiotrack Old Version'
    say '  2.  AIMS Labs. Radiotrack New Version'
    say
    call charout , 'Select Radio Card type: '
    pull cardtype
    if cardtype = 2 then
      cardstr = ' /RT'
    else
      cardstr = ''
    call charout cfgsys, 'DEVICE='||instdd||portstr||cardstr
  end
  call lineout cfgsys
  return
