/**************************************************************
 *                                                            *
 *                   MainActor Rexx Script                    *
 *                                                            *
 *  Writes all available information for the frames of the    *
 *  current project to a file                                 *
 *                                                            *
 *                                                            *
 *  Last modified: 09/06/97, Written by: Markus Moenig        *
 *                                                            *
 **************************************************************/
 
  filename="c:\frames.txt"                            /* Set output filename */

  IF GetGlobalInfo("LOADEDPROJECTS")= "0" THEN DO     /* Check if there are */
   BEGIN                                              /* any projects loaded */
    say "No project loaded! Trying to load project..."/* No: try to load one */
    rc=LoadProject("")                                /* If succeeded, rc = 0 */
    IF rc <> "0" THEN DO
      say "No project loaded! Exiting ..."            /* Failed, exiting ... */
      exit
    END 
   END

  SetInfoText("Writing frame information ...")     /* Set descriptive info text */
  say "Writing frame information to" filename "..."

  hasAudio="0"
  IF GetProjectInfo("AUDIOMODE") <> NULL THEN hasAudio="1"  /* Check for audio */

  isPictureList="0"                  /* Check if project is picture list */
  IF GetProjectInfo("TYPE") ="Picture List" THEN isPictureList="1"

  frames=GetProjectInfo("FRAMES")
  i=1;
  DO WHILE i <= frames                            /* Iterate through all frames */
   CALL LineOut filename, "Info for frame" i ":"
   CALL LineOut filename, "  Image Data Size:" GetFrameInfo(i, "SIZE")
   CALL LineOut filename, "  Image Data Offset:" GetFrameInfo(i, "OFFSET")
   CALL LineOut filename, "  Timecode:" GetFrameInfo(i, "TIMECODE") "ms"
   CALL LineOut filename, "  Compression:" GetFrameInfo(i, "COMPRESSION")
   CALL LineOut filename, "  Keyframe:" GetFrameInfo(i, "KEYFRAME")
   IF hasAudio <> "0" THEN CALL LineOut filename, "  Audio Size:" GetFrameInfo(i, "AUDIOSIZE")
   IF isPictureList ="1" THEN CALL LineOut filename, "  Picture Name:" GetFrameInfo(i, "PICTURENAME")
   i=i+1
  END

  CALL LineOut filename                 /* Close stream */

  say "Ready."