unit Tm_Strgs;

interface

Function StrPosC(s,t : pchar) : Longint; {index of string in substring, 1 based}
Function StrIPos(s,t : pchar) : pchar;
Function StrIPosC(s,t : pchar) : longint;
PROCEDURE StrLInsert(s,i : pchar; pos, MaxStrLen : longint);
Procedure StrDelete(s : pchar; pos, count : longint); {?}
Function  StrSubstStr(s, target, rep : pchar; MaxL : longint; cs : boolean) : pchar;
          {substitute target with rep in s, with case sensitivity}
Function LoChar(Ch : Char) : Char;
Function UpChar(Ch : Char) : Char;
Function StrQuoted(p : pchar; ql,qr : char) : pchar;
Function StrReplace(var cur : pchar; newpchar : pchar) : pchar;
procedure StrAppend(var p: pchar; a : pchar);

Function  Ltrim(s : pchar; c : char) : pchar;
Function  Rtrim(s : pchar; c : char) : pchar;

Function Str2Pchar(var s : string) : pchar;
Function MakeStrNew(s : string) : pchar;


implementation
uses strings;

{
procedure  StrLcat(s1, s2 : pchar; MaxL : longint);
var P : pointer;
begin
     Strmove(strEnd(s1),s2,strLen(s2)+1);
end;
}

Function LoChar(Ch : Char) : Char;
begin
  If Ord(Ch) In [65..90] Then Ch := Chr(Ord(Ch) + 32)
  Else If Ord(Ch) > 122 Then
    If Ch='' Then Ch := ' '
    Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:=''
    Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:=''
    Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:=''
    Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:='';
  LoChar := Ch;
end;

Function UpChar(Ch : Char) : Char;
begin
  If Ord(Ch) In [97..122] Then Ch := Chr(Ord(Ch) - 32)
  Else If Ord(Ch) > 90 Then
    If Ch='' Then Ch:=''
    Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:=''
    Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:=''
    Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:=''
    Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:='';
  UpChar:=Ch;
end;

Function StrPosC(s,t : pchar) : Longint;
var ps : pchar;
begin
     ps:=StrPos(s,t);
     if ps=nil then StrPosC:=0
     else StrPosC:=succ(longint(s))-longint(t);
end;

Function StrIPos(s,t : pchar) : pchar;
var
   ps,pt : pchar;
begin
     StrIPos:=nil;
     if (s=nil)or(t=nil)or(s^=#0)or(t^=#0) then exit;
     while (s^<>#0) do begin
           pt:=t; ps:=s;
           while (pt^<>#0)and((upchar(pt^)=ps^)or(loChar(pt^)=ps^)) do begin
                 inc(pt);inc(ps);
           end;
           if pt^=#0 then begin StrIPos:=s; break; end;
           inc(s);
     end;
end;

Function StrIPosC(s,t : pchar) : longint;
var p : pchar;
begin
     p:=StrIPos(s,t);
     if p=nil then StrIPosC:=0
     else StrIPosC:=succ(longint(p))-longint(s);
End;

Function Str2Pchar(var s : string) : pchar;
var l : byte;
begin
     l:=byte(s[0]);
     if l>0 then begin
        move(s[1],s[0],l);
        s[l]:=#0;
        Str2Pchar:=@s;
     end else Str2Pchar:=Nil;
end;

Function MakeStrNew(s : string) : pchar;
var p : pchar;
begin
     p:=Str2Pchar(s);
     MakeStrNew:=StrNew(p);
end;


Procedure StrLInsert(s,i : pchar; pos, MaxStrLen : longint);
var
   p : pchar;
   l : longint;
begin
     if (Pos<MaxStrLen)and(pos>0) then begin  { don't insert past end of buffer}
        l:=StrLen(s);
        if pos>l then StrLCat(s,i,MaxStrLen)
        else begin
             p := StrNew(s+pred(pos));
             (s+pred(pos))^:=#0;
             StrLCat(s,i,MaxStrLen);
             StrLCat(s,p,MaxStrLen);
             StrDispose(p);
        end;
     end;
end;

Procedure StrDelete(s : pchar; pos, count : longint); {?}
var Len : longint;
    pSource,pDest : POINTER;
begin
     Len:=StrLen(s);
     if (Pos<=Len)and(pos>0) then begin  { don't insert past end of buffer}
        if (pred(pos)+count)>=Len then (s+pred(pos))^:=#0
        else begin
             pSource:=s+pred(pos)+count; pDest:=s+pred(pos);
             StrCopy(pDest,pSource);
        end;
     end;
end;

Function StrDDelete(s : pchar; pos, count : longint) : pchar; {?}
var Len : longint;
    p   : pchar;
begin
     Len:=succ(StrLen(s));
     GetMem(p,Len);
     StrCopy(p,s);
     StrDelete(p,pos,count);
     StrDDelete:=StrNew(p);
     strDispose(s);
     FreeMem(p,len);
end;

Function  StrSubstStr(s, target, rep : pchar; MaxL : longint; cs : boolean) : pchar;
          {substitute target with rep in s, with case sensitivity}
var x : longint;
    l : longint;
    ps : pchar;
    len : longint;
begin
     StrSubstStr:=s;
     ps:=nil;
     if (s=nil)or(target=nil)or(rep=nil)or(rep^=#0)or(target^=#0) then exit;
     if CS then x:=StrPosC(s,target) else x:=StrIPosC(s,target);
     if x>0 then begin
          ps:=StrNew((s+(x-1)+StrLen(target)));
          (s+x-1)^:=#0;
          {StrLcat(s,rep,MaxL);}
          StrLcopy(strEnd(s),rep,MaxL-strLen(s));
          if ps<>nil then StrLCat(s,ps,MaxL);
          StrDispose(ps);
     end;
end;

Function StrQuoted(p : pchar; ql,qr : char) : pchar;
var q1,q2 : pchar;
    x : longint;
begin
     StrQuoted:=nil;
     q1:=StrScan(p,ql);                     {left quote char}
     if q1<>nil then begin
        inc(q1);                            {one past left quote}
        q2:=StrRScan(p,qr);                 {right quote char}
        if (q2<>nil)and(q2>q1) then begin
           q2^:=#0;                         {temp set end of string}
           StrQuoted:=StrNew(q1);           {make new string}
           q2^:=qr;                         {put back right quote char}
        end;
     end;
end;

Function  Ltrim(s : pchar; c : char) : pchar;
begin
     if s<>nil then begin
        while (s^=c)and(s^<>#0) do inc(s);
     end;
     Ltrim:=s;
end;

Function  Rtrim(s : pchar; c : char) : pchar;
var e : pchar;
begin
     e := StrEnd(s);
     dec(e);
     if e<>s then begin
        while (e^=c)and(s^<>#0) do dec(e);
     end;
     if e^=c then e^:=#0 else (e+1)^:=#0;
     Rtrim:=s;
end;

procedure StrAppend(var p: pchar; a : pchar);
var
   t : pchar;
begin
     if a=nil then exit;
     if (p=nil) then begin
        if (a=nil) then exit
        else p:=StrNew(a);
     end
     else begin
          getMem(t,Strlen(p)+strLen(a)+1);
          if t<>nil then begin
             StrCopy(t,p);
             StrCat(t,a);
             StrDispose(p);
             p:=t;
          end;
     end;
end;

Function StrReplace(var cur : pchar; newpchar : pchar) : pchar;
begin
     strDispose(cur);
     cur := newpchar;
     StrReplace := newpchar;
end;

Begin
End.



