/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pdb;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.adapter.readers.pdb.PdbReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class JmolDataReader
extends PdbReader {
    private Map<String, float[]> props;
    private String[] residueNames;
    private String[] atomNames;

    @Override
    protected void checkRemark() {
        if (this.line.length() >= 30 && this.line.indexOf("Jmol") == 11) {
            switch ("Ppard".indexOf(this.line.substring(16, 17))) {
                case 0: {
                    this.props = new Hashtable<String, float[]>();
                    this.asc.setInfo("jmolData", (Object)this.line);
                    if (this.line.endsWith("#noautobond")) break;
                    this.line = this.line + "#noautobond";
                    break;
                }
                case 1: {
                    int pt1 = this.line.indexOf("[");
                    int pt2 = this.line.indexOf("]");
                    if (pt1 < 25 || pt2 <= pt1) {
                        return;
                    }
                    String name = this.line.substring(25, pt1).trim();
                    this.line = this.line.substring(pt1 + 1, pt2).replace(',', ' ');
                    String[] tokens = this.getTokens();
                    Logger.info((String)("reading " + name + " " + tokens.length));
                    float[] prop = new float[tokens.length];
                    int i = prop.length;
                    while (--i >= 0) {
                        prop[i] = this.parseFloatStr(tokens[i]);
                    }
                    this.props.put(name, prop);
                    break;
                }
                case 2: {
                    this.line = this.line.substring(27);
                    this.atomNames = this.getTokens();
                    Logger.info((String)("reading atom names " + this.atomNames.length));
                    break;
                }
                case 3: {
                    this.line = this.line.substring(30);
                    this.residueNames = this.getTokens();
                    Logger.info((String)("reading residue names " + this.residueNames.length));
                    break;
                }
                case 4: {
                    Logger.info((String)this.line);
                    float[] data = new float[15];
                    Parser.parseStringInfestedFloatArray((String)this.line.substring(10).replace('=', ' ').replace('{', ' ').replace('}', ' '), null, (float[])data);
                    P3 minXYZ = P3.new3((float)data[0], (float)data[1], (float)data[2]);
                    P3 maxXYZ = P3.new3((float)data[3], (float)data[4], (float)data[5]);
                    this.fileScaling = P3.new3((float)data[6], (float)data[7], (float)data[8]);
                    this.fileOffset = P3.new3((float)data[9], (float)data[10], (float)data[11]);
                    P3 plotScale = P3.new3((float)data[12], (float)data[13], (float)data[14]);
                    if (plotScale.x <= 0.0f) {
                        plotScale.x = 100.0f;
                    }
                    if (plotScale.y <= 0.0f) {
                        plotScale.y = 100.0f;
                    }
                    if (plotScale.z <= 0.0f) {
                        plotScale.z = 100.0f;
                    }
                    if (this.fileScaling.y == 0.0f) {
                        this.fileScaling.y = 1.0f;
                    }
                    if (this.fileScaling.z == 0.0f) {
                        this.fileScaling.z = 1.0f;
                    }
                    this.setFractionalCoordinates(true);
                    this.latticeCells = new int[4];
                    this.asc.xtalSymmetry = null;
                    this.setUnitCell(plotScale.x * 2.0f / (maxXYZ.x - minXYZ.x), plotScale.y * 2.0f / (maxXYZ.y - minXYZ.y), plotScale.z * 2.0f / (maxXYZ.z == minXYZ.z ? 1.0f : maxXYZ.z - minXYZ.z), 90.0f, 90.0f, 90.0f);
                    this.unitCellOffset = P3.newP((T3)plotScale);
                    this.unitCellOffset.scale(-1.0f);
                    this.getSymmetry();
                    this.symmetry.toFractional((T3)this.unitCellOffset, false);
                    this.unitCellOffset.scaleAdd2(-1.0f, (T3)minXYZ, (T3)this.unitCellOffset);
                    this.symmetry.setOffsetPt((T3)this.unitCellOffset);
                    this.asc.setInfo("jmolDataScaling", (Object)new P3[]{minXYZ, maxXYZ, plotScale});
                    this.doApplySymmetry = true;
                }
            }
        }
        this.checkCurrentLineForScript();
    }

    @Override
    protected void setAdditionalAtomParameters(Atom atom) {
        if (this.residueNames != null && atom.index < this.residueNames.length) {
            atom.group3 = this.residueNames[atom.index];
        }
        if (this.atomNames != null && atom.index < this.atomNames.length) {
            atom.atomName = this.atomNames[atom.index];
        }
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.asc.setCurrentModelInfo("jmolDataProperties", this.props);
        this.finalizeReaderPDB();
    }
}

