/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.CU;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class PmeshReader
extends PolygonFileReader {
    private boolean isBinary;
    protected int nPolygons;
    protected String pmeshError;
    protected String type;
    protected boolean isClosedFace;
    protected int fixedCount;
    protected boolean onePerLine;
    protected int vertexBase;
    protected int[] vertexMap;
    protected String[] tokens = new String[0];
    protected int iToken = 0;

    PmeshReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2PR(sg, br);
    }

    protected void init2PR(SurfaceGenerator sg, BufferedReader br) {
        this.init2PFR(sg, br);
        String fileName = (String)((Object[])sg.getReaderData())[0];
        if (fileName == null) {
            return;
        }
        this.type = "pmesh";
        this.setHeader();
        this.isBinary = this.checkBinary(fileName);
        this.isClosedFace = !this.isBinary;
    }

    protected void setHeader() {
        this.jvxlFileHeaderBuffer.append(this.type + " file format\nvertices and triangles only\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    protected boolean checkBinary(String fileName) {
        try {
            this.br.mark(4);
            char[] buf = new char[5];
            this.br.read(buf, 0, 5);
            if (new String(buf).startsWith("PM\u0001\u0000")) {
                this.br.close();
                this.binarydoc = this.newBinaryDocument();
                this.setStream(fileName, buf[4] == '\u0000');
                return true;
            }
            this.br.reset();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return false;
    }

    @Override
    void getSurfaceData() throws Exception {
        if (this.readVerticesAndPolygons()) {
            Logger.info((String)((this.isBinary ? "binary " : "") + this.type + " file contains " + this.nVertices + " vertices and " + this.nPolygons + " polygons for " + this.nTriangles + " triangles"));
        } else {
            Logger.error((String)(this.params.fileName + ": " + (this.pmeshError == null ? "Error reading pmesh data " : this.pmeshError)));
        }
    }

    protected boolean readVerticesAndPolygons() {
        block4: {
            try {
                if (this.isBinary && !this.readBinaryHeader()) {
                    return false;
                }
                if (this.readVertices() && this.readPolygons()) {
                    return true;
                }
            }
            catch (Exception e) {
                if (this.pmeshError != null) break block4;
                this.pmeshError = this.type + " ERROR: " + e;
            }
        }
        return false;
    }

    boolean readBinaryHeader() {
        this.pmeshError = "could not read binary Pmesh file header";
        try {
            byte[] ignored = new byte[64];
            this.binarydoc.readByteArray(ignored, 0, 8);
            this.nVertices = this.binarydoc.readInt();
            this.nPolygons = this.binarydoc.readInt();
            this.binarydoc.readByteArray(ignored, 0, 64);
        }
        catch (Exception e) {
            this.pmeshError = this.pmeshError + " " + e.toString();
            this.binarydoc.close();
            return false;
        }
        this.pmeshError = null;
        return true;
    }

    protected boolean readVertices() throws Exception {
        return this.readVerticesPM();
    }

    protected boolean readVerticesPM() throws Exception {
        this.pmeshError = this.type + " ERROR: vertex count must be positive";
        if (!this.isBinary) {
            this.nVertices = this.getInt();
            if (this.nVertices == Integer.MIN_VALUE) {
                this.nVertices = this.getInt();
            }
        }
        if (this.onePerLine) {
            this.iToken = Integer.MAX_VALUE;
        }
        if (this.nVertices <= 0) {
            this.pmeshError = this.pmeshError + " (" + this.nVertices + ")";
            return false;
        }
        this.pmeshError = this.type + " ERROR: invalid vertex list";
        this.vertexMap = new int[this.nVertices];
        for (int i = 0; i < this.nVertices; ++i) {
            P3 pt = P3.new3((float)this.getFloat(), (float)this.getFloat(), (float)this.getFloat());
            if (this.isAnisotropic) {
                this.setVertexAnisotropy((T3)pt);
            }
            if (Logger.debugging) {
                Logger.debug((String)(i + ": " + pt));
            }
            this.vertexMap[i] = this.addVertexCopy((T3)pt, 0.0f, i, false);
            if (!this.onePerLine) continue;
            this.iToken = Integer.MAX_VALUE;
        }
        this.pmeshError = null;
        return true;
    }

    protected boolean readPolygons() throws Exception {
        return this.readPolygonsPM();
    }

    protected boolean readPolygonsPM() throws Exception {
        this.pmeshError = this.type + " ERROR: polygon count must be zero or positive";
        if (!this.isBinary) {
            this.nPolygons = this.getInt();
        }
        if (this.onePerLine) {
            this.iToken = Integer.MAX_VALUE;
        }
        int[] vertices = new int[5];
        if (this.nPolygons == -1) {
            this.nPolygons = Integer.MAX_VALUE;
        }
        int nread = 0;
        for (int iPoly = 0; iPoly < this.nPolygons; ++iPoly) {
            int i;
            int vertexCount;
            boolean haveColor;
            int intCount;
            int n = intCount = this.fixedCount == 0 ? this.getInt() : this.fixedCount;
            if (intCount == 0) break;
            ++nread;
            boolean bl = haveColor = intCount < 0;
            if (haveColor) {
                intCount = -intCount;
            }
            if ((vertexCount = intCount - (intCount > 3 && this.isClosedFace ? 1 : 0)) < 1 || vertexCount > 4) {
                this.pmeshError = this.type + " ERROR: bad polygon (must have 1-4 vertices) at #" + (iPoly + 1);
                return false;
            }
            boolean isOK = true;
            for (i = 0; i < intCount; ++i) {
                vertices[i] = this.getInt() - this.vertexBase;
                if (vertices[i] < 0 || vertices[i] >= this.nVertices) {
                    this.pmeshError = this.type + " ERROR: invalid vertex index: " + vertices[i];
                    return false;
                }
                vertices[i] = this.vertexMap[vertices[i]];
                if (vertices[i] >= 0) continue;
                isOK = false;
            }
            if (this.onePerLine) {
                this.iToken = Integer.MAX_VALUE;
            }
            if (!isOK) continue;
            if (vertexCount < 3) {
                for (i = vertexCount; i < 3; ++i) {
                    vertices[i] = vertices[i - 1];
                }
            }
            int color = 0;
            if (haveColor) {
                if (this.isBinary) {
                    color = this.getInt();
                } else {
                    String c = this.nextToken();
                    try {
                        color = c.startsWith("0x") ? PT.parseIntRadix((String)c.substring(2), (int)16) : this.parseIntStr(c);
                    }
                    catch (Throwable e) {
                        color = Integer.MIN_VALUE;
                    }
                    if (color == Integer.MIN_VALUE) {
                        color = CU.getArgbFromString((String)c);
                    }
                }
                color |= 0xFF000000;
            }
            if (vertexCount == 4) {
                this.nTriangles += 2;
                this.addTriangleCheck(vertices[0], vertices[1], vertices[3], 5, 0, false, color);
                this.addTriangleCheck(vertices[1], vertices[2], vertices[3], 3, 0, false, color);
                continue;
            }
            ++this.nTriangles;
            this.addTriangleCheck(vertices[0], vertices[1], vertices[2], 7, 0, false, color);
        }
        if (this.isBinary) {
            this.nBytes = this.binarydoc.getPosition();
        }
        this.nPolygons = nread;
        return true;
    }

    private String nextToken() throws Exception {
        while (this.iToken >= this.tokens.length) {
            this.iToken = 0;
            this.rd();
            this.tokens = this.getTokens();
        }
        return this.tokens[this.iToken++];
    }

    private int getInt() throws Exception {
        return this.isBinary ? this.binarydoc.readInt() : this.parseIntStr(this.nextToken());
    }

    private float getFloat() throws Exception {
        return this.isBinary ? this.binarydoc.readFloat() : this.parseFloatStr(this.nextToken());
    }
}

