/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;

abstract class MapFileReader
extends VolumeFileReader {
    protected float dmin = Float.MAX_VALUE;
    protected float dmax;
    protected float dmean;
    protected float drange;
    protected int mapc;
    protected int mapr;
    protected int maps;
    protected int n0;
    protected int n1;
    protected int n2;
    protected int mode;
    protected float[] xyzStart = new float[3];
    protected int na;
    protected int nb;
    protected int nc;
    protected float a;
    protected float b;
    protected float c;
    protected float alpha;
    protected float beta;
    protected float gamma;
    protected P3 origin = new P3();
    protected P3[] vectors = new P3[3];
    protected int xIndex = -1;
    protected int yIndex;
    protected int zIndex;
    protected P3 p3 = new P3();

    MapFileReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2MFR(sg, br);
    }

    protected void init2MFR(SurfaceGenerator sg, BufferedReader br) {
        this.init2VFR(sg, br);
        this.isAngstroms = true;
    }

    protected void checkInsideOut(int mapc, int mapr, int maps) {
        if (this.params.thePlane == null) {
            this.params.insideOut = ";123;231;312;".indexOf(";" + mapc + mapr + maps) >= 0;
        }
    }

    protected void getVectorsAndOrigin() {
        this.checkInsideOut(this.mapc, this.mapr, this.maps);
        Logger.info((String)("grid parameters: nx,ny,nz: " + this.n0 + "," + this.n1 + "," + this.n2));
        Logger.info((String)("grid parameters: nxStart,nyStart,nzStart: " + this.xyzStart[0] + "," + this.xyzStart[1] + "," + this.xyzStart[2]));
        Logger.info((String)("grid parameters: mx,my,mz: " + this.na + "," + this.nb + "," + this.nc));
        Logger.info((String)("grid parameters: a,b,c,alpha,beta,gamma: " + this.a + "," + this.b + "," + this.c + "," + this.alpha + "," + this.beta + "," + this.gamma));
        Logger.info((String)("grid parameters: mapc,mapr,maps: " + this.mapc + "," + this.mapr + "," + this.maps));
        Logger.info((String)("grid parameters: originX,Y,Z: " + this.origin));
        SimpleUnitCell unitCell = SimpleUnitCell.newA((float[])new float[]{this.a / (float)this.na, this.b / (float)this.nb, this.c / (float)this.nc, this.alpha, this.beta, this.gamma});
        this.vectors[0] = P3.new3((float)1.0f, (float)0.0f, (float)0.0f);
        this.vectors[1] = P3.new3((float)0.0f, (float)1.0f, (float)0.0f);
        this.vectors[2] = P3.new3((float)0.0f, (float)0.0f, (float)1.0f);
        unitCell.toCartesian((T3)this.vectors[0], false);
        unitCell.toCartesian((T3)this.vectors[1], false);
        unitCell.toCartesian((T3)this.vectors[2], false);
        Logger.info((String)"Jmol unit cell vectors:");
        Logger.info((String)("    a: " + this.vectors[0]));
        Logger.info((String)("    b: " + this.vectors[1]));
        Logger.info((String)("    c: " + this.vectors[2]));
        this.voxelCounts[0] = this.n2;
        this.voxelCounts[1] = this.n1;
        this.voxelCounts[2] = this.n0;
        this.volumetricVectors[0].setT((T3)this.vectors[this.maps - 1]);
        this.volumetricVectors[1].setT((T3)this.vectors[this.mapr - 1]);
        this.volumetricVectors[2].setT((T3)this.vectors[this.mapc - 1]);
        if (this.origin.x == 0.0f && this.origin.y == 0.0f && this.origin.z == 0.0f) {
            if (this.xIndex == -1) {
                int[] xyz2crs = new int[3];
                xyz2crs[this.mapc - 1] = 0;
                xyz2crs[this.mapr - 1] = 1;
                xyz2crs[this.maps - 1] = 2;
                this.xIndex = xyz2crs[0];
                this.yIndex = xyz2crs[1];
                this.zIndex = xyz2crs[2];
            }
            this.origin.scaleAdd2(this.xyzStart[this.xIndex], (T3)this.vectors[0], (T3)this.origin);
            this.origin.scaleAdd2(this.xyzStart[this.yIndex], (T3)this.vectors[1], (T3)this.origin);
            this.origin.scaleAdd2(this.xyzStart[this.zIndex], (T3)this.vectors[2], (T3)this.origin);
        }
        this.volumetricOrigin.setT((T3)this.origin);
        Logger.info((String)("Jmol grid origin in Cartesian coordinates: " + this.origin));
        Logger.info((String)"Use  isosurface OFFSET {x y z}  if you want to shift it.\n");
        this.p3.set((float)this.na, (float)this.nb, (float)this.nc);
        unitCell.toCartesian((T3)this.p3, true);
        this.p3.add((T3)this.origin);
        Logger.info((String)("boundbox corners " + this.origin + " " + this.p3 + ";draw bbox boundbox mesh nofill"));
    }

    protected void setCutoffAutomatic() {
        if (this.params.thePlane == null && this.params.cutoffAutomatic) {
            this.params.cutoff = -1.0f;
            Logger.info((String)("MapReader: setting cutoff to default value of " + this.params.cutoff + (this.boundingBox == null ? " (no BOUNDBOX parameter)\n" : "\n")));
        }
    }
}

