/*
 * select.c -- List selection callbacks for the X user interface
 *             to the Problem Tracking System (PTS) database.
 * Dean Collins 
 * created: Fri Apr 24 10:12:52 PDT 1992
 * modified: Sat Feb 13 02:15:19 PST 1993
 * modified: Dean collins Wed Nov 16 12:23:00 PST 1994 
 *	Added Priority field code.
 * modified: Dean Collins Sat Nov 19 19:39:22 PST 1994
 *	Added PriorityIncSelect() and PriorityDecSelect(). 
 */

/*
 * Copyright (c) 1995,1994,1993,1992 Dean Collins.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that neither the name of the University of
 * Idaho nor the name of Dean Collins be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission from both parties.  Neither The University of Idaho
 * nor Dean Collins make any representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF IDAHO AND DEAN COLLINS DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */

#include <stdlib.h>             /* General C utilities header file */
#include <stdio.h>		/* Standard input/output utilities hdr. file */

#include <X11/Intrinsic.h>      /* Include standard Toolkit Header file. */
#include <X11/StringDefs.h>     /* Include StringDefs header file */
#include <X11/Shell.h>          /* Include the Shell header file for popups */

#include <X11/Xaw/AsciiText.h>  /* Include the ascii Text widget hdr. file */
#include <X11/Xaw/Box.h>        /* Include the Box widget header file */
#include <X11/Xaw/Command.h>    /* Include the Command widget header file */
#include <X11/Xaw/Dialog.h>     /* Include the Dialog widget header file */
#include <X11/Xaw/Form.h>       /* Include the Form widget header file */
#include <X11/Xaw/List.h>       /* Include the List widget header file */
#include <X11/Xaw/Paned.h>      /* Include the Paned widget header file */
#include <X11/Xaw/Viewport.h>   /* Include the Viewport widget header file */

#include <X11/Xaw/Cardinals.h>  /* Definitions of ZERO, ONE, etc... */

#include "zdbm.h"               /* Zombie Database Manager header file */
#include "cloud.h"		/* Nebulous Cloud header file */
#include "clouderror.h"         /* Nebulous Cloud error rtn. header file */
#include "xpts.h"               /* Xpts header file */

extern bool NoQuit ;		/* True if user started PTS in "no-quit" mode, */
				/* false otherwise. */

      /* The current problem record.  This ideally would
       * be part of a new widget.  The widget would have the
       * resources listed in ProblemType.  It would have functions
       * to display, read and write the problem.
       * Next version, maybe...
       */
extern problem_record * ProblemRecord ;

      /* The current list of problem summaries.  Similar
       * comment to that above.
       */
extern String *SummaryItems ;

extern char Node[] ;

	/* The priority of a new problem (before it is placed in
	 * the database
	 */
/*extern signed char Priority ;*/

        /* The problem types tree. */
extern ProblemTree *ProbTree ;

        /* Information about the user. */
extern UserInfo UserInfoRec ;

        /* The path for the problem types tree. */
extern char Path[] ;
extern char ProblemText[] ;

extern String *ProblemItems ;

/* The following string will be displayed by the "About PTS" button
 * on the Main Menu: 
 */
extern const char PTSInfoText[] ;

extern Summary *CloudUnSummaries ;
extern Summary *CloudSummaries ;


/******************** MODULES *************************************/
/*
______________________________________________________________________
AddProblemSelect()

FUNCTION DESCRIPTION:

     This function will add a problem to the PTS database.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/21/92
     Modified: Dean Collins Sat Nov 19 18:20:49 PST 1994
	Modifications needed to account for revised ProblemEntryPopup().
	Mainly, changed from using dialogs to text.
______________________________________________________________________
*/


void
AddProblemSelect(Widget     w,
                XtPointer   client_data, 
                XtPointer   call_data)

     /* Interface description:
         INPUT:
          w              - The widget for which this callback is registered.
          client_data    - Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this a list of widgets like this:

					 (modified 11/16/94 DC)
                              client_data[0] = type text widget
                              client_data[1] = summary text widget
                              client_data[2] = node text widget
                              client_data[3] = priority dialog widget
                              client_data[4] = problem text widget
			      client_data[5] = array to pass to DestroyPopup
					 [5][0] = problem entry popup
					 [5][1] = NULL
					(OK, so this is gross.... :-)

       call_data      - Specifies any callback-specific data the widget w
                           wants to pass to the client.
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   Widget asciiSource ;
   Widget popup ;
   Widget parent ;
   Widget list ;
   signed char PriorityVal=DEF_PRIORITY ;

          /* Minor */
   XtPointer *ptrlist ;
   XtPointer *ptrlist2 ;
   Arg args[3] ;
   String text = NULL ;
   char short_desc[MAXSUMLEN+1] ;
   char tmpstr[MAXSUMLEN+1] ;
   char tmpstr2[MAXHOSTNAMELEN+1] ;
   String tmpstr3 = NULL ;
   char *c ;
   int i ;

   /*------------- Start of AddProblemSelect() routine -------------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering AddProblemSelect()\n") ;
#endif

     /* Get the information input by the user about the new problem. */

   ptrlist = (XtPointer *) client_data ;

	/**** PATH ****/

/* This was removed since the user is not allowed to change the path
 * from the ProblemEntryPopup.
 *   strcpy (Path,   XawDialogGetValueString((Widget)(ptrlist[0]))) ;
 */

	/**** SUMMARY ****/

   asciiSource = XawTextGetSource((Widget)(ptrlist[1])) ;
   XtVaGetValues(asciiSource, XtNstring, &tmpstr3, NULL) ;
   strncpy(tmpstr,tmpstr3,MAXSUMLEN) ;


   tmpstr[MAXSUMLEN-1] = '\0' ;		/* Make sure it's terminated */
#ifdef DEBUG
   printf("XPTS(select.c): summary(before)='%s'\n",tmpstr) ;
#endif

   c=FixStr(tmpstr) ;  /* Strip leading & trailing spaces; remove newlines */

#ifdef DEBUG
   printf("XPTS(select.c): summary(after)='%s'\n",c) ;
#endif
   strcpy(short_desc,c) ;
   if (strlen(short_desc) == 0)
      if (! SuperWarningPopup("warning", w, EMPTY_DESC_WARNING))
         return ;


	/**** NODE ****/

   asciiSource = XawTextGetSource((Widget)(ptrlist[2])) ;
   XtVaGetValues(asciiSource, XtNstring, &tmpstr3, NULL) ;
   strncpy(tmpstr2,tmpstr3,MAXHOSTNAMELEN) ;

   tmpstr2[MAXHOSTNAMELEN-1] = '\0' ;
#ifdef DEBUG
   printf("XPTS(select.c): node(before)='%s'\n",tmpstr2) ;
#endif

   c=FixStr(tmpstr2) ;  /* Strip leading & trailing spaces; remove newlines */

#ifdef DEBUG
   printf("XPTS(select.c): node(after)='%s'\n",c) ;
#endif
   strcpy(Node,c) ;
   if (strlen(Node) == 0)
      if (! SuperWarningPopup("warning", w, EMPTY_NODE_WARNING))
         return ;
    


	/**** PRIORITY ****/

#ifdef DO_PRIORITY
		/* Snag priority */
   XtVaGetValues((Widget)(ptrlist[3]), XtNlabel, &tmpstr3, NULL) ;
#ifdef DEBUG
   printf("XPTS(select.c): priority='%s'\n",tmpstr3) ;
#endif

   if (strlen(tmpstr3) == 0)
	PriorityVal = DEF_PRIORITY ;
   else PriorityVal = atoi(tmpstr3) ;

#endif
    

	/**** DESCRIPTION ****/

   asciiSource = XawTextGetSource((Widget)(ptrlist[4])) ;
   XtSetArg(args[0], XtNstring, &text) ;
   XtGetValues(asciiSource, args, ONE) ;
   if (strlen(text) == 0)
      if (! SuperWarningPopup("warning", w, EMPTY_LOG_WARNING))
         return ;


#ifdef DEBUG
   printf("XPTS(select.c): AddProblemSelect()\n") ;
   printf("XPTS(select.c): \tSummary: %s\n", short_desc) ;
   printf("XPTS(select.c): \tNode: %s\n", Node) ;
   printf("XPTS(select.c): \tPath: %s\n", Path) ;
   printf("XPTS(select.c): \tPriority: %d\n", PriorityVal) ;
   printf("XPTS(select.c): \tText:\n%s\n", text) ;
#endif

     /* Call WriteProblem() with the problem information. */
#ifdef DEBUG
   printf ("XPTS(select.c): Calling WriteProblem().\n") ;
#endif
/*CLD*/   if (WriteProblem(ProbTree,Path,&UserInfoRec,text,short_desc,
			   Node,PriorityVal) == (int)NULL) /*11/16/94 DC*/
   {    /* If WriteProblem() returns an error, call the ErrorPopup()
         * with an error message indicating what happened.
         */
      char errorstr[MAXERROR] ;
      sprintf(errorstr,
                "Error writing problem!\n\nPossible error cause:\n%s\n",
/*CLD*/         CloudStrerror()) ;
      ErrorPopup("error", w, errorstr) ;
      return ;
   }

#ifdef DEBUG
   printf ("XPTS(select.c): Returned from WriteProblem() ok.\n") ;
#endif

     /* Otherwise, destroy the problem viewer and regenerate the 
      * list of problem summaries.
      */
   ptrlist  = (XtPointer *)client_data ;
   ptrlist2 = (XtPointer *)(ptrlist[5]) ;
   popup    = (Widget)(ptrlist2[0]) ;
   parent   = XtParent(popup) ;

     /* Regenerate the problem summaries list */ 
#ifdef DEBUG
   printf("XPTS(misc.c): Calling ReadSummaries() to update the list...") ;
#endif
/*CLD*/ CloudSummaries = ReadSummaries(ProbTree, Path, &SummaryItems) ;
#ifdef DEBUG
   printf("XPTS(misc.c): Returned from ReadSummaries()...\n") ;
#endif

#ifdef DEBUG
   for (i=0; SummaryItems[i] != NULL; ++i)
   { printf("XPTS(misc.c): SummaryItems[%d]=%p\n",i, SummaryItems[i]) ;
     printf("XPTS(misc.c): SummaryItems[%d]='%s'\n", i, SummaryItems[i]) ;
   }
   printf("XPTS(misc.c): SummaryItems[%d] is NULL\n", i) ;
#endif


   list=XtNameToWidget(parent, "panes.viewport.list") ;
#ifdef DEBUG
   printf("list = %p, %s.\n", list, XtName(list)) ;
#endif
   XtSetSensitive(list, True) ;
   XawListChange(list, SummaryItems, ZERO, ZERO, TRUE) ;


     /* Destroy the problem entry popup */
   XtSetSensitive(parent, True) ;
   DestroyPopup(w, (XtPointer)ptrlist2, NULL) ;

#ifdef DEBUG
   printf("XPTS(select.c): Leaving AddProblemSelect()...(whew!...made it!)\n") ;
#endif
}  /*----------------- End of AddProblemSelect() -------------------------*/

  
/*
______________________________________________________________________
CancelReopenSelect()

FUNCTION DESCRIPTION:

______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  6/24/92
______________________________________________________________________
*/


void
CancelReopenSelect(Widget     w,
                   XtPointer  client_data,
                   XtPointer  call_data)

     /* Interface description:
         INPUT:
          w              - The widget for which this callback is registered.
          client_data    - Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this is an array of widgets, defined 
                           like this:

                           client_data[0]  = text edit widget
                           client_data[1]  = buttonBox widget
			   client_data[2]  = buttonBox3 widget
			   client_data[3]  = helpLine widget
                           client_data[4]  = text widget
                           client_data[5]  = helpLine3 widget

          call_data      - Specifies any callback-specific data the widget w
                           wants to pass to the client.
           
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   Widget edit ;
   Widget buttonBox ;
   Widget buttonBox3 ;
   Widget helpLine ;
   Widget helpLine3 ;
   Widget text ;
          /* Minor */
   XtPointer *ptrlist ;

   /*-------------- Start of CancelReopenSelect() routine ---------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering CancelReopenSelect()\n") ;
#endif

   ptrlist = (XtPointer *)client_data ;
   edit       = (Widget) (ptrlist[0]) ;
   buttonBox  = (Widget) (ptrlist[1]) ;
   buttonBox3 = (Widget) (ptrlist[2]) ;
   helpLine   = (Widget) (ptrlist[3]) ;
   text       = (Widget) (ptrlist[4]) ;
   helpLine3  = (Widget) (ptrlist[5]) ;

     /* Unmanage the buttonBox3, edit and helpLine3 widgets.
      * Manage the helpLine and buttonBox widgets.
      */
   XtUnmanageChild (buttonBox3) ;
   XtUnmanageChild (helpLine3) ;
   XtUnmanageChild (edit) ;
   XtManageChild   (helpLine) ;
   XtManageChild   (buttonBox) ;
   XtSetSensitive  (buttonBox3,False) ;
   XtSetSensitive  (buttonBox,True) ;

#ifdef DEBUG
   printf("XPTS(select.c): Leaving CancelReopenSelect()\n") ;
#endif
}  /*------------------ End of CancelReopenSelect() ---------------------*/

  
/*
______________________________________________________________________
CancelSaveSelect()

FUNCTION DESCRIPTION:

     This function will allow the sysop user to cancel the update to
a problem log.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  5/2/92
______________________________________________________________________
*/


void
CancelSaveSelect(Widget     w,
                 XtPointer  client_data,
                 XtPointer  call_data)

     /* Interface description:
         INPUT:
          w              - The widget for which this callback is registered.
          client_data    - Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this is an array of widgets, defined 
                           like this:

                           client_data[0]  = text edit widget
                           client_data[1]  = buttonBox widget
			   client_data[2]  = buttonBox2 widget
			   client_data[3]  = helpLine widget
                           client_data[4]  = text widget
                           client_data[5]  = helpLine2 widget
                           client_data[6]  = higherButton widget
                           client_data[7]  = lowerButton widget
			   client_data[8]  = priority widget
			   client_data[9]  = summary widget

          call_data      - Specifies any callback-specific data the widget w
                           wants to pass to the client.
           
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   Widget edit ;
   Widget buttonBox ;
   Widget buttonBox2 ;
   Widget helpLine ;
   Widget helpLine2 ;
   Widget text ;
   Widget higherButton ;
   Widget lowerButton ;
   Widget priority ;
   Widget summary ;

          /* Minor */
   XtPointer *ptrlist ;

   /*-------------- Start of CancelSaveSelect() routine ---------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering CancelSaveSelect()\n") ;
#endif

     /* Make sure only sysops are executing this function. */
   if (!IsSysop(&UserInfoRec))
   { 
#ifdef DEBUG
        fprintf(stderr,
       "XPTS(select.c): Illegal access to CancelSaveSelect() by non-sysop.\n") ;
#endif
     return ;
   }

#ifdef DEBUG
   printf("XPTS(select.c): Calling UnlockProblem()...\n") ;
#endif
     /* Unlock the problem with UnlockProblem() since we're done
      * editing it.
      */
   LockedProblem(FALSE) ; /* Reset lock flag for potential emergency clean-up.*/
/*CLD*/ if (UnlockProblem(Path, ProblemRecord) == (int)NULL)
   {  /* Error unlocking problem */
      char errorstr[MAXERROR] ;
      sprintf(errorstr, "Error unlocking problem!\n"
                        "\nPossible error cause:\n%s\n",
/*CLD*/                 CloudStrerror()) ;
      ErrorPopup("error", w, errorstr) ;
      return ;
   }

#ifdef DEBUG
   printf("XPTS(select.c): Returned without an error from UnlockProblem().\n") ;
#endif


   ptrlist = (XtPointer *)client_data ;
   edit         = (Widget) (ptrlist[0]) ;
   buttonBox    = (Widget) (ptrlist[1]) ;
   buttonBox2   = (Widget) (ptrlist[2]) ;
   helpLine     = (Widget) (ptrlist[3]) ;
   text         = (Widget) (ptrlist[4]) ;
   helpLine2    = (Widget) (ptrlist[5]) ;
   higherButton = (Widget) (ptrlist[6]) ;
   lowerButton  = (Widget) (ptrlist[7]) ;
   priority	= (Widget) (ptrlist[8]) ;
   summary	= (Widget) (ptrlist[9]) ;

     /* Unmanage the buttonBox2, edit and helpLine2 widgets.
      * Manage the helpLine and buttonBox widgets.
      */
   XtUnmanageChild (buttonBox2) ;
   XtUnmanageChild (helpLine2) ;
   XtUnmanageChild (edit) ;
   XtManageChild   (helpLine) ;
   XtManageChild   (buttonBox) ;
   XtSetSensitive  (buttonBox2,False) ;
   XtSetSensitive  (buttonBox,True) ;
#ifdef DO_PRIORITY
   XtSetSensitive  (higherButton,False) ;
   XtSetSensitive  (lowerButton,False) ;
#endif

   XawTextDisplayCaret(summary, FALSE) ;


#ifdef DEBUG
   printf("XPTS(select.c): Leaving CancelSaveSelect()\n") ;
#endif

}  /*------------------ End of CancelSaveSelect() ---------------------*/

    
/*
______________________________________________________________________
DeleteProblemSelect()

FUNCTION DESCRIPTION:

     This function will determine which problem the sysop user has selected and
delete the problem from the PTS database after creating a warning popup. 
The user will be given a chance to change their mind.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/21/92
______________________________________________________________________
*/


void
DeleteProblemSelect(Widget     w,
                    XtPointer  client_data,
                    XtPointer  call_data)

     /* Interface description:
         INPUT:
          w            - The widget for which this callback is registered.
          client_data  - Specifies arbitrary client-supplied data
                         that the widget w should pass back to the
                         client when the widget executes the client's
                         callback procedure.  In this callback, 
                         this is the problem viewer popup widget.
          call_data    - Specifies any callback-specific data the widget w
                         wants to pass to the client.
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   Widget probViewer ;
          /* Minor */
          /* NONE */


   /*----------------- Start of DeleteProblemSelect() routine -------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering DeleteProblemSelect()\n") ;
#endif

     /* Make sure only sysops are executing this function. */
   if (!IsSysop(&UserInfoRec))
   {
#ifdef DEBUG
        fprintf(stderr,
        "XPTS(DeleteProblemSelect()): Illegal access to DeleteProblemSelect() "
	"by non-sysop.\n") ;
#endif
     return ;
   }

     /* Display a warning using WarningPopup(). */
     /* If the user responds to the warning with "continue",
      * use the DoDeleteProblem() callback function to delete the
      * problem from the database.
      */

   probViewer = (Widget) (client_data) ;
#ifdef DEBUG
   printf("XPTS(DeleteProblemSelect()): probViewer=%p."
	  "warning=%p.\n", probViewer, XtParent(probViewer)) ;
#endif
   WarningPopup("warning", probViewer, DELETE_WARNING,
                (XtPointer)DoDeleteProblem, client_data) ;

#ifdef DEBUG
   printf("XPTS(select.c): Leaving DeleteProblemSelect()\n") ;
#endif

}  /*--------------------- End of DeleteProblemSelect() -------------------*/


/*
______________________________________________________________________
EditProblemSelect()

FUNCTION DESCRIPTION:

     This function will allow the sysop user to append a log entry to a
problem log.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/21/92
     Modified: Dean Collins Tue Nov 22 15:44:24 PST 1994
	Added higherButton & lowerButton for priority field handling.
______________________________________________________________________
*/


void
EditProblemSelect(Widget     w,
                  XtPointer  client_data,
                  XtPointer  call_data)

     /* Interface description:
         INPUT:
          w              - The widget for which this callback is registered.
          client_data    - Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this is an array with the following values:

                           client_data[0]  = edit widget
                           client_data[1]  = buttonBox widget
                           client_data[2]  = buttonBox2 widget
                           client_data[3]  = helpLine widget
                           client_data[4]  = text widget
                           client_data[5]  = helpLine2 widget
			   client_data[6]  = higherButton widget
			   client_data[7]  = lowerButton widget
			   client_data[8]  = priority widget
			   client_data[9]  = summary widget

          call_data      - Specifies any callback-specific data the widget w
                           wants to pass to the client.
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   Widget save=NULL ;     /* The button used to save the edited log. */
   Widget cancel=NULL ;   /* The button used to cancel the editing session. */
   Widget edit=NULL ;
   Widget buttonBox=NULL ;
   Widget buttonBox2=NULL ;
   Widget helpLine=NULL ;
   Widget helpLine2=NULL ;
   Widget text=NULL ;
   Widget higherButton=NULL ;
   Widget lowerButton=NULL ;
   Widget priority=NULL ;
   Widget summary=NULL ;
   problem_record *newprob=NULL ;

          /* Minor */
   XtPointer *ptrlist=NULL ;
   Arg args[3] ;



   /*-------------- Start of EditProblemSelect() routine ---------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering EditProblemSelect()\n") ;
#endif

   ptrlist = (XtPointer *) client_data ;
   edit         = (Widget) (ptrlist[0]) ;
   buttonBox    = (Widget) (ptrlist[1]) ;
   buttonBox2   = (Widget) (ptrlist[2]) ;
   helpLine     = (Widget) (ptrlist[3]) ;
   text         = (Widget) (ptrlist[4]) ;
   helpLine2    = (Widget) (ptrlist[5]) ;
   higherButton = (Widget) (ptrlist[6]) ;
   lowerButton  = (Widget) (ptrlist[7]) ;
   priority	= (Widget) (ptrlist[8]) ;
   summary	= (Widget) (ptrlist[9]) ;


     /* Lock this problem record using LockProblem(). */
   LockedProblem(TRUE) ;  /* Set lock flag for potential emergency clean-up. */
/*CLD*/   if (LockProblem(Path, ProblemRecord) == (int)NULL)
   {  /* Error locking problem, so call ErrorPopup() and return */
      char errorstr[MAXERROR] ;
      sprintf(errorstr, "Unable to lock problem.\n"
			"Someone else is probably editing it.\n"
			"You will not be able to edit this problem until\n"
			"they are done.\n"
                        "\nPossible error cause:\n%s\n",
/*CLD*/                 CloudStrerror()) ;
      ErrorPopup("error", w, errorstr) ;
      XtSetSensitive(buttonBox,True) ;
      LockedProblem(FALSE) ;  /* Reset lock flag. */
      return ;
   }


     /* Make sure we've got a current problem record.
      * [Added 5/27/95 DC]
      */
/*ZDBM*/ newprob = ReadProblemPRID(Path,ProblemRecord->prid) ;
   if (newprob)
   {
      ProblemRecord = newprob ;  /* ReadProblemPRID() has already made a copy
				  * for us to use, so just point to it.
				  */
      XtVaSetValues(text, XtNstring, FormatProblem(ProblemRecord,Path), NULL) ;
   }
   else
   {  /* Error updating problem in memory, so call ErrorPopup() and return */
      char errorstr[MAXERROR] ;
      sprintf(errorstr, "Unable to access problem for editing.\n"
                        "\nPossible error cause:\n%s\n",
/*CLD*/                 CloudStrerror()) ;
      ErrorPopup("error", w, errorstr) ;
      XtSetSensitive(buttonBox,True) ;
      UnlockProblem(Path, ProblemRecord) ;
      LockedProblem(FALSE) ;  /* Reset lock flag. */
      return ;
   }


     /* Clear the edit widget, used to enter log entries. */
   XtSetArg(args[0], XtNstring, "") ;
   XtSetValues(edit, args, ONE) ;

     /* Unmanage the buttonBox, helpLine, and edit widgets.
      * Manage the helpLine2 and buttonBox2 widgets.
      */
   XtUnmanageChild (buttonBox) ;
   XtUnmanageChild (helpLine) ;
   XtManageChild   (edit) ;
   XtManageChild   (helpLine2) ;
   XtManageChild   (buttonBox2) ;
   XtSetSensitive  (buttonBox,False) ;
   XtSetSensitive  (buttonBox2,True) ;
#ifdef DO_PRIORITY
   XtSetSensitive  (higherButton, True) ;
   XtSetSensitive  (lowerButton, True) ;
#endif

/*
   XawTextSetInsertionPoint(summary,
	strlen(ProblemRecord->short_description)) ;
   XawTextDisplayCaret(summary, TRUE) ;
*/

   XtVaSetValues(summary, XtNdisplayCaret, True, XtNinsertPosition, 
	strlen(ProblemRecord->short_description), NULL) ;



#ifdef DEBUG
   printf("XPTS(select.c): Leaving EditProblemSelect()\n") ;
#endif
}  /*------------------ End of EditProblemSelect() ---------------------*/


/*
______________________________________________________________________
MoveProblemSelect()

FUNCTION DESCRIPTION:

     This function will allow the sysop user to move a problem to a different
problem type in the PTS database.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/21/92
______________________________________________________________________
*/


void
MoveProblemSelect(Widget        w, 
                XtPointer       client_data, 
                XtPointer       call_data)

     /* Interface description:
         INPUT:
          w            - The widget for which this callback is registered.
          client_data  - Specifies arbitrary client-supplied data
                         that the widget w should pass back to the
                         client when the widget executes the client's
                         callback procedure.  In this callback, 
                         this is an array with the following values:

                         client_data[0] = problem viewer popup widget
                         client_data[1] = dialog widget containing
                                         problem type

          call_data    - Specifies any callback-specific data the widget w
                         wants to pass to the client.
           
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
     Widget probViewer ;
     Widget movePopup ;
     char newtype[MAXSUMLEN] ;

          /* Minor */
     XtPointer *ptrlist ;



   /*----------------- Start of MoveProblemSelect() routine -------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering MoveProblemSelect()\n") ;
#endif
     
     /* Make sure only sysops are executing this function. */
   if (!IsSysop(&UserInfoRec))
   {
#ifdef DEBUG
        fprintf(stderr,
      "XPTS(select.c): Illegal access to MoveProblemSelect() by non-sysop.\n") ;
#endif
     return ;
   }

   ptrlist=(XtPointer *)client_data ;
   probViewer=(Widget)(ptrlist[0]) ;
#ifdef DEBUG
   printf("XPTS(select.c): probViewer = %p,'%s'.\n",
	(XtPointer)probViewer, XtName(probViewer)) ;
#endif
   
     /* Use StringEntryPopup() to get the problem type that
      * the problem should be moved to.
      */
   StringEntryPopup("movePopup", &movePopup, probViewer,
		    "Enter new problem type:", (XtPointer)DoMoveProblem1) ;

     /* Draw the popup */
   XtPopup(movePopup, XtGrabExclusive) ;

#ifdef DEBUG
   printf("XPTS(select.c): Leaving MoveProblemSelect()\n") ;
#endif

}  /*------------------ End of MoveProblemSelect() ---------------------*/


/*
______________________________________________________________________
PreviousMenuSelect()

FUNCTION DESCRIPTION:

     This function will move the user to the parent problem type (the
super-type).
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/25/92
______________________________________________________________________
*/


void
PreviousMenuSelect(Widget       w, 
                  XtPointer     client_data, 
                  XtPointer     call_data)

     /* Interface description:
         INPUT:
          w              - The widget for which this callback is registered.
          client_data    - Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this is information to be passed to
                           ChangeList().  It is defined in the
			   following manner:

                                client_data[0] = list widget
                                client_data[1] = dialog widget
                                client_data[2] = parent widget
                                client_data[3] = quitButton widget
                                client_data[4] = previousButton widget
                                client_data[5] = newProblem widget
                                client_data[6] = pickProblem popup widget

          call_data      - Specifies any callback-specific data the widget w
                           wants to pass to the client.
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
          /* NONE */
          /* Minor */
          /* NONE */

   /*------------ Start of PreviousMenuSelect() routine ------------------*/

#ifdef DEBUG
   printf("XPTS(select.c): Entering PreviousMenuSelect()\n") ;
#endif

   if (strcmp(Path, ROOTSTR) != 0) /* Aren't at root already */
          /* Use ChangeList() to change to the previous problem type.  */
      ChangeList(Path, (int)NULL, PREV_TYPE, client_data) ;
#ifdef DEBUG
   else printf("XPTS(select.c): Ignoring button press -- already at ROOT!\n") ;
#endif

#ifdef DEBUG
   printf("XPTS(select.c): Leaving PreviousMenuSelect()\n") ;
#endif
}  /*---------------- End of PreviousMenuSelect() ------------------------*/


/*
______________________________________________________________________
PrintProblemSelect()

FUNCTION DESCRIPTION:

     This function will print a problem.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/21/92
______________________________________________________________________
*/


void
PrintProblemSelect(Widget       w, 
                   XtPointer    client_data, 
                   XtPointer    call_data)

     /* Interface description:
         INPUT:
          w              - The widget for which this callback is registered.
          client_data    - Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this is NULL.
          call_data      - Specifies any callback-specific data the widget w
                           wants to pass to the client.
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   Widget text ;

          /* Minor */
   XtPointer *ptrlist ;

   /*-------------- Start of PrintProblemSelect() routine ---------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering PrintProblemSelect()\n") ;
#endif

   ptrlist = (XtPointer *)client_data ;
   text       = (Widget) (ptrlist[4]) ;

     /* Use PrintProblem() to print the problem to a printer. */

/*CLD*/   if (PrintProblem(ProbTree, Path, ProblemRecord) == (int)NULL)
   {
     /* If any errors occur, use ErrorPopup() to display an
      * appropriate message with widget w as the popup parent.
      */
      char errorstr[MAXERROR] ;
      sprintf(errorstr, "Error printing problem!\n"
                        "\nPossible error cause:\n%s\n",
/*CLD*/                 CloudStrerror()) ;
      ErrorPopup("error", w, errorstr) ;
      return ;
   } else NoticePopup("notice", w, PRINTING_NOTICE) ;

     
#ifdef DEBUG
   printf("XPTS(select.c): Leaving PrintProblemSelect()\n") ;
#endif
}  /*------------------ End of PrintProblemSelect() ---------------------*/


/*
______________________________________________________________________
QuitMainMenuSelect()

FUNCTION DESCRIPTION:

     This function will unrealize the main menu and all of it's children. 
If "no-quit" mode has been selected, PTS will enter "sleep" mode by realizing
the sleep button.  Otherwise, PTS will exit.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/21/92
______________________________________________________________________
*/


void
QuitMainMenuSelect(Widget     w,
                   XtPointer  client_data,
                   XtPointer  call_data)

     /* Interface description:
         INPUT:
          w              - The widget for which this callback is registered.
          client_data    - Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this is an array of widgets, defined 
                           like this:

                           client_data[0]        - application context
                           client_data[1]        - mainMenu widget
                           client_data[2]        - sleepButton widget

          call_data      - Specifies any callback-specific data the widget w
                           wants to pass to the client.
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   Widget mainMenu ;
   Widget sleepPopup ;
   XtAppContext app_con ;       /* The PTS application context */
   XtPointer *ptrlist ;		/* An array of pointers */

          /* Minor */
          /* NONE */


   /*------------ Start of QuitMainMenuSelect() routine ------------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering QuitMainMenuSelect()\n") ;
#endif

   ptrlist    = (XtPointer *) client_data ;
   app_con    = (XtAppContext)(ptrlist[0]) ;
   mainMenu   = (Widget)      (ptrlist[1]) ;
   sleepPopup = (Widget)      (ptrlist[2]) ;

     /* If  PTS was started in "no-quit" mode, go into sleep mode
      *         by unrealizing the main menu and realizing 
      *         the sleep button;  also, make sure the main menu popup
      *		is set to be sensitive;
      *    else exit the application.
      */
   if (NoQuit)
   {  XtPopup(sleepPopup, XtGrabExclusive) ;
      XtPopdown(mainMenu) ;
      XtSetSensitive(sleepPopup,True) ;
   }
   else
   {  XtDestroyApplicationContext(app_con) ;
      XtFree(client_data) ;
      exit(0) ;
   }

#ifdef DEBUG
   printf("XPTS(select.c): Leaving QuitMainMenuSelect()\n") ;
#endif
}  /*--------------------- End of QuitMainMenuSelect() -------------------*/


/*
______________________________________________________________________
ReopenAcceptSelect()

FUNCTION DESCRIPTION:

     This function will allow a sysop to accept a users request to reopen a
solved problem, turning it back into an unsolved problem.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/21/92
______________________________________________________________________
*/


void
ReopenAcceptSelect(Widget  w, 
                XtPointer  client_data, 
                XtPointer  call_data)

     /* Interface description:
         INPUT:
          w            - The widget for which this callback is registered.
          client_data  - Specifies arbitrary client-supplied data
                         that the widget w should pass back to the
                         client when the widget executes the client's
                         callback procedure.  In this callback, 
                         this is an array of widgets, defined
                           like this:

                           client_data[0]  = text edit widget
                           client_data[1]  = buttonBox widget
                           client_data[2]  = buttonBox4 widget
                           client_data[3]  = helpLine widget
                           client_data[4]  = text widget
                           client_data[5]  = helpLine4 widget

          call_data    - Specifies any callback-specific data the widget w
                         wants to pass to the client.
           
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   Widget edit ;
   Widget buttonBox ;
   Widget buttonBox4 ;
   Widget helpLine ;
   Widget text ;
   Widget helpLine4 ;
   Widget probViewer ;

          /* Minor */
   XtPointer *ptrlist ;
   String editstr ;
   Arg args[3] ;
   Widget wid ;
/*   char *tmptext=NULL ;*/

   int timeval=0 ;
   char info[256] ;
   problem_record *newproblem ;


   /*----------------- Start of ReopenAcceptSelect() routine -------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering ReopenAcceptSelect()\n") ;
#endif

     /* Make sure only sysops are executing this function. */
   if (!IsSysop(&UserInfoRec))
   {
#ifdef DEBUG
        fprintf(stderr,
     "XPTS(select.c): Illegal access to ReopenAcceptSelect() by non-sysop.\n") ;
#endif
     return ;
   }

#ifdef DEBUG
   printf("XPTS(select.c): ProblemRecord=%p\n",ProblemRecord) ;
   printf("XPTS(select.c): ProblemRecord->status = %d\n", ProblemRecord->status) ;
#endif
   if (ProblemRecord)
      if (ProblemRecord->status != REOPENED)
      {  
#ifdef DEBUG
         printf("XPTS(select.c): ProblemRecord->status != REOPENED !!!  Returning.\n");
#endif 
         return ;
      }


   ptrlist = (XtPointer *)client_data ;
   edit       = (Widget) (ptrlist[0]) ;
   buttonBox  = (Widget) (ptrlist[1]) ;
   buttonBox4 = (Widget) (ptrlist[2]) ;
   helpLine   = (Widget) (ptrlist[3]) ;
   text       = (Widget) (ptrlist[4]) ;
   helpLine4  = (Widget) (ptrlist[5]) ;
   probViewer = XtParent(XtParent(buttonBox)) ; /* hack,hack...chough,cough. */


   XtSetSensitive  (buttonBox4,False) ;

     /* Format a log string; put "PROBLEM REOPENED", the date/time,
      * the sysop who reopened it and their real name.
      */

   timeval=time(0) ;
   sprintf(info,"%s %s   %s (%s)\n",
           REOPENED_ENTRY_STR, 
           ctime((time_t *)&timeval),
           UserInfoRec.username,
           UserInfoRec.realname) ;
#ifdef DEBUG
   printf("XPTS(select.c): Calling ReopenProblem() with info=%s\n", info) ;
#endif

     /* Reopen the problem. */
/*CLD*/   if ((newproblem =
               ReopenProblem(ProbTree, Path, ProblemRecord, info)) == NULL)
   {
     /* If any errors occur, use ErrorPopup() to display an
      * appropriate message with widget w as the popup parent.
      */
      char errorstr[MAXERROR] ;
      sprintf(errorstr, "Error reopening problem!\n"
                        "\nPossible error cause:\n%s\n",
/*CLD*/                 CloudStrerror()) ;
      ErrorPopup("error", w, errorstr) ;
      return ;
   }

   else ProblemRecord=newproblem ;

     /***** Update the screen *****/
        /* Update the problem viewer.
         *   Update the problem text.
         *   Display the correct buttons for a solved problem.
         * Update the parent widget's summaries list.
         */
   XtSetArg(args[0], XtNstring, FormatProblem(ProblemRecord,Path)) ;
   XtSetValues(XawTextGetSource(text), args, ONE) ;

   if (wid=XtNameToWidget (buttonBox, "reopenAccept"))  XtUnmanageChild(wid) ;
   if (wid=XtNameToWidget (buttonBox, "reopenDeny"))    XtUnmanageChild(wid) ;
   if (wid=XtNameToWidget (buttonBox, "editButton"))    XtManageChild(wid) ;
   if (wid=XtNameToWidget (buttonBox, "moveButton"))    XtManageChild(wid) ;
   if (wid=XtNameToWidget (buttonBox, "reportAgain"))   XtManageChild(wid) ;
   if (wid=XtNameToWidget (buttonBox, "deleteProblem")) XtManageChild(wid) ;
   if (wid=XtNameToWidget (buttonBox, "saveButton"))    XtManageChild(wid) ;
   if (wid=XtNameToWidget (buttonBox, "solveButton"))   XtManageChild(wid) ;

        /* Remove the edit window and associated widgets.
         * Restore the helpLine and buttonBox widgets.
         */
   XtUnmanageChild (buttonBox4) ;
   XtUnmanageChild (helpLine4) ;
   XtUnmanageChild (edit) ;
   XtManageChild   (helpLine) ;
   XtManageChild   (buttonBox) ;
   /*buttonBox4 is set insensitive above...*/
   XtSetSensitive  (buttonBox,True) ;

   XFlush(XtDisplay(buttonBox)) ;

        /* Update the list of summaries for the parent popup.
         * This might be the pickProblem popup or the unsolvedPopup popup.
         */

   ReadList(XtParent(probViewer), probViewer) ;


#ifdef DEBUG
   printf("XPTS(select.c): newproblem=%p\n",newproblem) ;
   printf("XPTS(select.c): Leaving ReopenAcceptSelect()\n") ;
#endif
}  /*--------------------- End of ReopenAcceptSelect() -------------------*/


/*
______________________________________________________________________
ReopenDenyMailSelect()

FUNCTION DESCRIPTION:

     This function will send the sysop's mail to a user who has requested that
a solved problem be reopened, explaining why the request was denied.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/21/92
______________________________________________________________________
*/


void
ReopenDenyMailSelect(Widget    w, 
                    XtPointer  client_data, 
                    XtPointer  call_data)

     /* Interface description:
         INPUT:
          w              - The widget for which this callback is registered.
          client_data    - Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this is an array of widgets, defined
                           like this:

                           client_data[0]  = text edit widget
                           client_data[1]  = buttonBox widget
                           client_data[2]  = buttonBox4 widget
                           client_data[3]  = helpLine widget
                           client_data[4]  = text widget
                           client_data[5]  = helpLine4 widget

          call_data      - Specifies any callback-specific data the widget w
                           wants to pass to the client.
         OUTPUT:
           
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   Widget edit ;
   Widget buttonBox ;
   Widget buttonBox4 ;
   Widget helpLine ;
   Widget text ;
   Widget helpLine4 ;
   Widget probViewer ;

          /* Minor */
   XtPointer *ptrlist ;
   String editstr ;
   Arg args[3] ;

   /*----------------- Start of ReopenDenyMailSelect() routine -------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering ReopenDenyMailSelect()\n") ;
#endif

     /* Make sure only sysops are executing this function. */
   if (!IsSysop(&UserInfoRec))
   {
#ifdef DEBUG
        fprintf(stderr,
        "XPTS(select.c): Illegal access to ReopenDenyMailSelect() by non-sysop.\n") ;
#endif
     return ;
   }

   ptrlist = (XtPointer *)client_data ;
   edit       = (Widget) (ptrlist[0]) ;
   buttonBox  = (Widget) (ptrlist[1]) ;
   buttonBox4 = (Widget) (ptrlist[2]) ;
   helpLine   = (Widget) (ptrlist[3]) ;
   text       = (Widget) (ptrlist[4]) ;
   helpLine4  = (Widget) (ptrlist[5]) ;
   probViewer = XtParent(XtParent(buttonBox)) ; /* hack,hack...chough,cough. */

   XtSetArg(args[0], XtNstring, &editstr) ;
   XtGetValues(XawTextGetSource(edit), args, ONE) ;

     /* Use the DenyReopen() function to send mail to 
      * the user explaining why their reopen request
      * was refused.
      */
/*CLD*/   if (DenyReopen(ProbTree, Path, ProblemRecord, &UserInfoRec, 
              editstr) == (int)NULL)
   {
     /* If any errors occur, use ErrorPopup() to display an
      * appropriate message with widget w as the popup parent.
      */
      char errorstr[MAXERROR] ;
      sprintf(errorstr, "Error denying reopen request!\n"
                        "\nPossible error cause:\n%s\n",
/*CLD*/                 CloudStrerror()) ;
      ErrorPopup("error", w, errorstr) ;
      return ;
   }

/* else NoticePopup("notice", w, DENY_REOP_NOTICE) ;*/
   

        /* Update the list of summaries for the parent popup.
         * This might be the pickProblem popup or the unsolvedPopup popup.
         */
   ReadList(XtParent(probViewer), probViewer) ;

     /* Destroy the problem viewer widget.  Realize it's parent,
      * the problem tree navigation widget.
      */

   XtSetSensitive(XtParent(probViewer), True) ;

#ifdef DEBUG
   printf("XPTS(select.c): Destroying the problem viewer "
          "for the reopen request, '%s'...\n", XtName(probViewer)) ;
#endif
   XtDestroyWidget(probViewer) ;

#ifdef DEBUG
   printf("XPTS(select.c): Leaving ReopenDenyMailSelect()\n") ;
#endif
}  /*--------------------- End of ReopenDenyMailSelect() -------------------*/


/*
______________________________________________________________________
ReopenDenyCancelSelect()

FUNCTION DESCRIPTION:

     This function is called when the sysop user cancels their
editing of the reopen denial text.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  6/24/92
______________________________________________________________________
*/


void
ReopenDenyCancelSelect(Widget     w,
                       XtPointer  client_data,
                       XtPointer  call_data)

     /* Interface description:
         INPUT:
          w           - The widget for which this callback is registered.
          client_data - Specifies arbitrary client-supplied data
                        that the widget w should pass back to the
                        client when the widget executes the client's
                        callback procedure.  In this callback,
                        this is an array of widgets, defined
                           like this:

                           client_data[0]  = text edit widget
                           client_data[1]  = buttonBox widget
                           client_data[2]  = buttonBox4 widget
                           client_data[3]  = helpLine widget
                           client_data[4]  = text widget
                           client_data[5]  = helpLine4 widget


          call_data   - Specifies any callback-specific data the widget w
                        wants to pass to the client.
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */

{
     /* Internal variables: */
          /* Major */
Widget text ;        /* The widget to contain the text description */
                     /*  of why the problem is not being reopened. */
Widget edit ;
Widget buttonBox ;
Widget buttonBox4 ;
Widget helpLine ;
Widget helpLine4 ;

          /* Minor */
XtPointer *ptrlist ;



   /*------- Start of ReopenDenyCancelSelect() routine --------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering ReopenDenyCancelSelect()\n") ;
#endif

   ptrlist = (XtPointer *)client_data ;
   edit       = (Widget) (ptrlist[0]) ;
   buttonBox  = (Widget) (ptrlist[1]) ;
   buttonBox4 = (Widget) (ptrlist[2]) ;
   helpLine   = (Widget) (ptrlist[3]) ;
   text       = (Widget) (ptrlist[4]) ;
   helpLine4  = (Widget) (ptrlist[5]) ;

     /* Remove the edit window and associated widgets.
      * Restore the helpLine and buttonBox widgets.
      */
   XtUnmanageChild (buttonBox4) ;
   XtUnmanageChild (helpLine4) ;
   XtUnmanageChild (edit) ;
   XtManageChild   (helpLine) ;
   XtManageChild   (buttonBox) ;
   XtSetSensitive  (buttonBox4,False) ;
   XtSetSensitive  (buttonBox,True) ;

#ifdef DEBUG
   printf("XPTS(select.c): Leaving ReopenDenyCancelSelect()\n") ;
#endif
}  /*----------- End of ReopenDenyCancelSelect() --------------*/


/*
______________________________________________________________________
ReopenDenySelect()

FUNCTION DESCRIPTION:

     This function will allow a sysop to deny a users request to reopen
a solved problem, creating a popup so the sysop can send the user mail
explaining why their request was denied.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/21/92
______________________________________________________________________
*/


void
ReopenDenySelect(Widget     w,
                XtPointer  client_data,
                XtPointer  call_data)

     /* Interface description:
         INPUT:
          w           - The widget for which this callback is registered.
          client_data - Specifies arbitrary client-supplied data
                        that the widget w should pass back to the
                        client when the widget executes the client's
                        callback procedure.  In this callback,
                        this is an array of widgets, defined
                           like this:

                           client_data[0]  = text edit widget
                           client_data[1]  = buttonBox widget
                           client_data[2]  = buttonBox4 widget
                           client_data[3]  = helpLine widget
                           client_data[4]  = text widget
                           client_data[5]  = helpLine4 widget


          call_data   - Specifies any callback-specific data the widget w
                        wants to pass to the client.
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */

{
     /* Internal variables: */
          /* Major */
Widget text ;        /* The widget to contain the text description */
                     /*  of why the problem is not being reopened. */
Widget edit ;
Widget buttonBox ;
Widget buttonBox4 ;
Widget helpLine ;
Widget helpLine4 ;

          /* Minor */
XtPointer *ptrlist ;



   /*----------------- Start of ReopenDenySelect() routine ------------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering ReopenDenySelect()\n") ;
#endif

   ptrlist = (XtPointer *)client_data ;
   edit       = (Widget) (ptrlist[0]) ;
   buttonBox  = (Widget) (ptrlist[1]) ;
   buttonBox4 = (Widget) (ptrlist[2]) ;
   helpLine   = (Widget) (ptrlist[3]) ;
   text       = (Widget) (ptrlist[4]) ;
   helpLine4  = (Widget) (ptrlist[5]) ;

     /* Unmanage the buttonBox and helpLine widgets.
      * Manage the edit, helpLine4 and buttonBox4 widgets.
      * This will create an edit window in which the sysop user
      * will input their reason for not reopening a problem.
      * This reason will be mailed to the reporter if the
      * mail button (saveButton4) is selected.
      */

   XtUnmanageChild (buttonBox) ;
   XtUnmanageChild (helpLine) ;
   XtManageChild   (edit) ;
   XtManageChild   (helpLine4) ;
   XtManageChild   (buttonBox4) ;
   XtSetSensitive  (buttonBox,False) ;
   XtSetSensitive  (buttonBox4,True) ;

#ifdef DEBUG
   printf("XPTS(select.c): Leaving ReopenDenySelect()\n") ;
#endif
}  /*--------------------- End of ReopenDenySelect() ------------------------*/


/*
______________________________________________________________________
ReopenRequestSelect()

FUNCTION DESCRIPTION:
     
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  6/24/92
______________________________________________________________________
*/


void
ReopenRequestSelect(Widget     w, 
                    XtPointer  client_data, 
                    XtPointer  call_data)

     /* Interface description:
         INPUT:
          w              - The widget for which this callback is registered.
          client_data    - Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
			   this is an array of widgets, defined
                           like this:

                           client_data[0]  = edit widget
                           client_data[1]  = buttonBox widget
                           client_data[2]  = buttonBox3 widget
                           client_data[3]  = helpLine widget
                           client_data[4]  = text widget
                           client_data[5]  = helpLine3 widget

          call_data      - Specifies any callback-specific data the widget w
                           wants to pass to the client.
         OUTPUT:
           
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   Widget edit ;
   Widget buttonBox ;
   Widget buttonBox3 ;
   Widget helpLine ;
   Widget helpLine3 ;
   Widget text ;
   Widget textSrc ;
   Widget parent ;
          /* Minor */
   int length ;
   String editstr ;
   XtPointer *ptrlist ;
   Arg args[3] ;


   /*------------ Start of ReopenRequestSelect() routine -------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering ReopenRequestSelect()\n") ;
#endif

   ptrlist = (XtPointer *)client_data ;
   edit       = (Widget) (ptrlist[0]) ;
   buttonBox  = (Widget) (ptrlist[1]) ;
   buttonBox3 = (Widget) (ptrlist[2]) ;
   helpLine   = (Widget) (ptrlist[3]) ;
   text       = (Widget) (ptrlist[4]) ;
   helpLine3  = (Widget) (ptrlist[5]) ;
   parent     = XtParent(XtParent(buttonBox3)) ;

              
   XtSetArg(args[0], XtNstring, &editstr) ;
   XtGetValues(XawTextGetSource(edit), args, ONE) ;
#  ifdef DEBUG
   printf ("XPTS(select.c): Path = '%s'\n", Path) ;
   printf ("XPTS(select.c): edit string = '%s'\n", editstr) ;
#  endif
   if (strlen(editstr) == 0)
      if (! SuperWarningPopup("warning", w, EMPTY_REQ_WARNING))
         return ;


#  ifdef DEBUG
   printf("XPTS(select.c): Saving reopen request using ReopenRequest()\n") ;
#  endif

     /* Use ReopenRequest() to save the reopen request. */
/*CLD*/   if (ReopenRequest(Path, ProblemRecord, editstr, &UserInfoRec) == (int)NULL)
   {  /* If any errors occur, call ErrorPopup() and return. */
      char errorstr[MAXERROR] ;
      sprintf(errorstr, "Error requesting the reopening of the problem!\n"
                        "\nPossible error cause:\n%s\n",
/*CLD*/                 CloudStrerror()) ;
      ErrorPopup("error", parent, errorstr) ;
      return ;
   }

   else /* Notify the user that the request has been made. */
   {
#     ifdef DEBUG
      if (parent) printf("XPTS(select.c): parent='%s'\n",XtName(parent)) ;
      printf("XPTS(select.c): Problem successfully (requested to be) reopened.\n") ;
#     endif
      NoticePopup("notice", parent, REOPEN_NOTICE) ;
   }


     /* Get rid of the edit window & it's associated widgets,
      * restoring the helpLine and buttonBox widgets.
      */
   XtUnmanageChild (buttonBox3) ;
   XtUnmanageChild (edit) ;
   XtUnmanageChild (helpLine3) ;
   XtManageChild   (helpLine) ;
   XtManageChild   (buttonBox) ;
   XtSetSensitive  (buttonBox3,False) ;
   XtSetSensitive  (buttonBox,True) ;

#  ifdef DEBUG
   printf("XPTS(select.c): Leaving ReopenRequestSelect()\n") ;
#  endif
}  /*---------------- End of ReopenRequestSelect() -------------------*/


/*
______________________________________________________________________
ReopenSelect()

FUNCTION DESCRIPTION:
     This function allows the user to enter a reopen request for
a problem.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  6/24/92
______________________________________________________________________
*/


void
ReopenSelect(Widget     w, 
             XtPointer  client_data, 
             XtPointer  call_data)

     /* Interface description:
         INPUT:
          w              - The widget for which this callback is registered.
          client_data    - Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this is an array with the following values:

                           client_data[0]  = edit widget
                           client_data[1]  = buttonBox widget
                           client_data[2]  = buttonBox3 widget
                           client_data[3]  = helpLine widget
                           client_data[4]  = text widget
                           client_data[5]  = helpLine3 widget

          call_data      - Specifies any callback-specific data the widget w
                           wants to pass to the client.
         OUTPUT:
           
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   Widget save ;     /* The button used to save the edited log. */
   Widget cancel ;   /* The button used to cancel the editing session. */
   Widget edit ;
   Widget buttonBox ;
   Widget buttonBox3 ;
   Widget helpLine ;
   Widget helpLine3 ;
   Widget text ;

          /* Minor */
   XtPointer *ptrlist ;
   Arg args[3] ;

   /*------------ Start of ReopenSelect() routine -------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering ReopenSelect()\n") ;
#endif

   ptrlist = (XtPointer *)client_data ;
   edit       = (Widget) (ptrlist[0]) ;
   buttonBox  = (Widget) (ptrlist[1]) ;
   buttonBox3 = (Widget) (ptrlist[2]) ;
   helpLine   = (Widget) (ptrlist[3]) ;
   text       = (Widget) (ptrlist[4]) ;
   helpLine3  = (Widget) (ptrlist[5]) ;


     /* Clear the edit widget, used to enter the "reason" text. */
   XtSetArg(args[0], XtNstring, "") ;
   XtSetValues(edit, args, ONE) ;

     /* Unrealize the edit, solve and quit buttonBox.
      * Realize the buttonBox3 for saving and canceling.
      * Realize the edit widget for entering the "reason" text.
      */
   XtUnmanageChild (buttonBox) ;
   XtUnmanageChild (helpLine) ;
   XtManageChild   (edit) ;
   XtManageChild   (helpLine3) ;
   XtManageChild   (buttonBox3) ;
   XtSetSensitive  (buttonBox,False) ;
   XtSetSensitive  (buttonBox3,True) ;

#ifdef DEBUG
   printf("XPTS(select.c): Leaving ReopenSelect()\n") ;
#endif
}  /*---------------- End of ReopenSelect() -------------------*/


/*
______________________________________________________________________
ReportAgainSelect()

FUNCTION DESCRIPTION:

     This function will add the user to the reporters list of an unsolved
problem.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/21/92
______________________________________________________________________
*/


void
ReportAgainSelect(Widget     w, 
                  XtPointer  client_data, 
                  XtPointer  call_data)

     /* Interface description:
         INPUT:
          w              - The widget for which this callback is registered.
          client_data    - Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this is an array with the following values:

                           client_data[0]  = edit widget
                           client_data[1]  = buttonBox widget
                           client_data[2]  = buttonBox2 widget
                           client_data[3]  = helpLine widget
                           client_data[4]  = text widget
                           client_data[5]  = helpLine2 widget

          call_data      - Specifies any callback-specific data the widget w
                           wants to pass to the client.
         OUTPUT:
           
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   Widget edit=NULL ;
   Widget buttonBox=NULL ;
   Widget buttonBox2=NULL ;
   Widget helpLine=NULL ;
   Widget text=NULL ;
   Widget helpLine2=NULL ;
   Widget probViewer=NULL ;

          /* Minor */
   XtPointer *ptrlist=NULL ;
   char *tmptext=NULL ;
   String editstr=NULL ;
   Arg args[3] ;
   problem_record *tmpprob=NULL ;


   /*------------ Start of ReportAgainSelect() routine -------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering ReportAgainSelect()\n") ;
#endif
     
   ptrlist = (XtPointer *)client_data ;
   edit       = (Widget) (ptrlist[0]) ;
   buttonBox  = (Widget) (ptrlist[1]) ;
   buttonBox2 = (Widget) (ptrlist[2]) ;
   helpLine   = (Widget) (ptrlist[3]) ;
   text       = (Widget) (ptrlist[4]) ;
   helpLine2  = (Widget) (ptrlist[5]) ;
   probViewer = XtParent(XtParent(buttonBox)) ;

     /* Use ReportAgain() to add the user to the list of reporters for
      *   the problem.
      * If any errors occur,
      *   use ErrorPopup() to display an appropriate message
      *   with widget w as the popup parent.
      * Otherwise, just update the display.
      */
/*CLD*/ tmpprob = ReportAgain(Path, &UserInfoRec, ProblemRecord) ;

   if (!tmpprob)
   {
      char tmpstr[1000] ;
      sprintf(tmpstr, "Error appending to the problem reporters list!\n\n"
                      "Possible error cause:\n%s\n",
/*CLD*/               CloudStrerror()) ;
      ErrorPopup("error", w, tmpstr) ;
      return ;
   } else ProblemRecord=tmpprob ;
   

   XtSetArg(args[0], XtNstring, FormatProblem(ProblemRecord,Path)) ;
   XtSetValues(XawTextGetSource(text), args, ONE) ;


#ifdef DEBUG
   printf("XPTS(select.c): Leaving ReportAgainSelect()\n") ;
#endif
}  /*---------------- End of ReportAgainSelect() -------------------*/


/*
______________________________________________________________________
SaveMOTDButtonSelect()

FUNCTION DESCRIPTION:

     This function will save the Message of the Day file that the sysop user
has modified.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/25/92
______________________________________________________________________
*/


void
SaveMOTDButtonSelect(Widget          w, 
                     XtPointer       client_data, 
                     XtPointer       call_data)

     /* Interface description:
         INPUT:
          w              - The widget for which this callback is registered.
          client_data    - Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this is the text widget to save.
          call_data      - Specifies any callback-specific data the widget w
                           wants to pass to the client.
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   Widget asciiText ;
   Widget asciiSource ;
          /* Minor */
   Bool   status ;
   char   fname[80] ;
   Arg    args[3] ;

   /*------------ Start of SaveMOTDButtonSelect() routine -------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering SaveMOTDButtonSelect()\n") ;
#endif

     /* Make sure only sysops are executing this function. */
   if (!IsSysop(&UserInfoRec))
   {
#ifdef DEBUG
        fprintf(stderr,
   "XPTS(select.c): Illegal access to SaveMOTDButtonSelect() by non-sysop.\n") ;
#endif
     return ;
   }

   asciiText = (Widget)client_data ;

     /* Get the asciiSource object. */
   asciiSource = XawTextGetSource(asciiText) ;

     /* Save the text file using XawAsciiSave(). */
   status = XawAsciiSave(asciiSource) ;

     /* If any errors occured, call ErrorPopup(). */
   if (status = FALSE)
   {  XtSetArg(args[0], XtNstring, fname) ;
      XtGetValues(asciiText, args, ONE) ; 
      ErrorPopup("error", asciiText,
                 "Error saving Message of the Day file .\n") ;
   }

#ifdef DEBUG
   printf("XPTS(select.c): Leaving SaveMOTDButtonSelect()\n") ;
#endif
}  /*--------------- End of SaveMOTDButtonSelect() --------------------*/


/*
______________________________________________________________________
SaveProblemSelect()

FUNCTION DESCRIPTION:

     This function will allow the sysop user to save a log entry for a
problem into the database.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/25/92
______________________________________________________________________
*/


void
SaveProblemSelect(Widget     w,
                  XtPointer  client_data,
                  XtPointer  call_data)

     /* Interface description:
         INPUT:
          w              - The widget for which this callback is registered.
          client_data    - Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this is an array of widgets, defined 
                           like this:

                           client_data[0]  = edit widget
                           client_data[1]  = buttonBox widget
                           client_data[2]  = buttonBox2 widget
                           client_data[3]  = helpLine widget
                           client_data[4]  = text widget
                           client_data[5]  = helpLine2 widget
			   client_data[6]  = higherButton widget
			   client_data[7]  = lowerButton widget
			   client_data[8]  = priority widget
			   client_data[9]  = summary widget

          call_data      - Specifies any callback-specific data the widget w
                           wants to pass to the client.
           
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   Widget	edit=NULL ;
   Widget	buttonBox=NULL ;
   Widget	buttonBox2=NULL ;
   Widget	helpLine=NULL ;
   Widget	helpLine2=NULL ;
   Widget	text=NULL ;
   Widget	textSrc=NULL ;
   Widget	higherButton=NULL ;
   Widget	lowerButton=NULL ;
   Widget	priority=NULL ;
   Widget	summary=NULL ;
   Widget	asciiSource=NULL ;
   Widget	probViewer=NULL ;

          /* Minor */
   int		length ;
   String	editstr ;
   XtPointer	*ptrlist ;
   Arg		args[3] ;
   char		*tmptext ;
   int		timeval ;
   char		info[256] ;
   String	tmpstr=NULL ;
   String	tmpstr2=NULL ;
   char		tmpstr3[MAXSUMLEN+1] ;
   char		short_desc[MAXSUMLEN+1] ;
   char		*c ;
   int		NeedToCallReadList=FALSE ;

   /*-------------- Start of SaveProblemSelect() routine ---------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering SaveProblemSelect()\n") ;
#endif

     /* Make sure only sysops are executing this function. */
   if (!IsSysop(&UserInfoRec))
   {
#ifdef DEBUG
        fprintf(stderr,
       "XPTS(select.c): Illegal access to SaveProblemSelect() by non-sysop.\n") ;
#endif
     return ;
   }

   if (ProblemRecord)
      if (ProblemRecord->status != UNSOLVED)
      {
#ifdef DEBUG
         printf("XPTS(select.c): ProblemRecord->status != UNSOLVED !!!  Returning.\n");
#endif
         return ;
      }


   ptrlist = (XtPointer *)client_data ;
   edit         = (Widget) (ptrlist[0]) ;
   buttonBox    = (Widget) (ptrlist[1]) ;
   buttonBox2   = (Widget) (ptrlist[2]) ;
   helpLine     = (Widget) (ptrlist[3]) ;
   text         = (Widget) (ptrlist[4]) ;
   helpLine2    = (Widget) (ptrlist[5]) ;
   higherButton = (Widget) (ptrlist[6]) ;
   lowerButton  = (Widget) (ptrlist[7]) ;
   priority     = (Widget) (ptrlist[8]) ;
   summary	= (Widget) (ptrlist[9]) ;



     /* Append to the text widget value a string indicating that
      * a log entry was started by the current sysop user.
      * Get the new text and add it to the existing problem text.
      */
   XtSetArg(args[0], XtNstring, &editstr) ;
   XtGetValues(XawTextGetSource(edit), args, ONE) ;
   if (strlen(editstr) == 0)
   {  if (! SuperWarningPopup("warning", w, EMPTY_LOG_WARNING)) return ;
   }

   tmptext = XtMalloc(strlen(ProblemRecord->log_file) + strlen(editstr) + 1000) ;
   strcpy(tmptext, ProblemRecord->log_file) ;
   strcat(tmptext, LOG_ENTRY_STR) ;
   timeval=time(0) ;
   sprintf(info,"%s   %s (%s)\n", ctime((time_t *)&timeval),
           UserInfoRec.username, UserInfoRec.realname) ;
   strcat (tmptext, info) ;
   strcat (tmptext, editstr) ;
#ifdef DEBUG
   printf("XPTS(select.c): New Problem Log:\n%s\n", tmptext) ;
#endif
     /* Update the problem log on the screen. */
/*   XtFree(ProblemRecord->log_file) ;*/
   ProblemRecord->log_file = tmptext ;
   XtSetArg(args[0], XtNstring, FormatProblem(ProblemRecord,Path)) ;
   XtSetValues(XawTextGetSource(text), args, ONE) ;


	/* Get the new priority from the screen... */
#ifdef DO_PRIORITY
   XtVaGetValues (priority, XtNlabel, &tmpstr, NULL) ;
#ifdef DEBUG
   printf("XPTS[SaveProblemSelect()]: priority='%s'\n",tmpstr) ;
#endif
   ProblemRecord->priority = atoi(tmpstr) ;
#endif


	/* Get the new summary from the screen... */

   asciiSource = XawTextGetSource((Widget)summary) ;
   XtVaGetValues(asciiSource, XtNstring, &tmpstr2, NULL) ;
   strncpy(tmpstr3,tmpstr2,MAXSUMLEN) ;

   tmpstr3[MAXSUMLEN-1] = '\0' ;         /* Make sure it's terminated */
#ifdef DEBUG
   printf("XPTS[SaveProblemSelect()]: summary(before)='%s'\n",tmpstr3) ;
#endif

   c=FixStr(tmpstr3) ;  /* Strip leading & trailing spaces; remove newlines */

#ifdef DEBUG
   printf("XPTS[SaveProblemSelect()]: summary(after)='%s'\n",c) ;
#endif
/*
   strcpy(short_desc,c) ;
   if (strlen(short_desc) == 0)
      if (! SuperWarningPopup("warning", w, EMPTY_DESC_WARNING))
         return ;
*/
   if (strcmp(ProblemRecord->short_description, c/******/) != 0)
   {  strncpy (ProblemRecord->short_description, c /*******/, MAXSUMLEN) ;
	  /* Will need to regenerate the summaries list for the parent
 	   * window after saving this info. since we've changed the summary.
	   */
      NeedToCallReadList = TRUE ;
   }
   else
      NeedToCallReadList = FALSE ;



     /* Save the problem to the database using AppendProblem(),
      * then unlock the problem.
      */
/*CLD*/   if (AppendProblem(ProbTree, Path, ProblemRecord, &UserInfoRec, 
              tmptext) == (int)NULL)
   { /* If error occurs, call ErrorPopup() and return */
      char errorstr[MAXERROR] ;
      sprintf(errorstr, "Error appending to problem!\n"
                        "\nPossible error cause:\n%s\n",
/*CLD*/                 CloudStrerror()) ;
      ErrorPopup("error", w, errorstr) ;
      return ;
   }


   if (NeedToCallReadList == TRUE)
   {    /*
	 * Update the list of summaries for the parent popup.
	 * This might be the pickProblem popup or the unsolvedPopup popup.
	 */
      probViewer = XtParent(XtParent(buttonBox)) ; /*hack,hack...chough,cough.*/
      ReadList(XtParent(probViewer), probViewer) ;
   }


     /* If everything went OK, then get rid of the edit window. */
   XtUnmanageChild (buttonBox2) ;
   XtUnmanageChild (edit) ;
   XtUnmanageChild (helpLine2) ;
   XtManageChild   (helpLine) ;
   XtManageChild   (buttonBox) ;
   XtSetSensitive  (buttonBox2,False) ;
   XtSetSensitive  (buttonBox,True) ;
#ifdef DO_PRIORITY
   XtSetSensitive  (higherButton, False) ;
   XtSetSensitive  (lowerButton, False) ;
#endif

   XawTextDisplayCaret(summary, FALSE) ;

   LockedProblem(FALSE) ; /* Reset lock flag for potential emergency clean-up.*/
/*CLD*/   if (UnlockProblem(Path, ProblemRecord) == (int)NULL)
   {
      char errorstr[MAXERROR] ;
      sprintf(errorstr, "Error unlocking problem!\n"
                        "\nPossible error cause:\n%s\n",
/*CLD*/                 CloudStrerror()) ;
      ErrorPopup("error", w, errorstr) ;
      return ;
   }


#ifdef DEBUG
   printf("XPTS(select.c): Leaving SaveProblemSelect()\n") ;
#endif
}  /*------------------ End of SaveProblemSelect() ---------------------*/


/*
______________________________________________________________________
SleepButtonSelect()

FUNCTION DESCRIPTION:

     This function unrealizes the sleep button and realizes the PTS main menu.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/21/92
______________________________________________________________________
*/


void
SleepButtonSelect(Widget     w,
                  XtPointer  client_data,
                  XtPointer  call_data)

     /* Interface description:
         INPUT:
          w              - The widget for which this callback is registered.
          client_data    - Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this is an array of widgets, defined 
                           like this:

                           client_data[0]        - application context
                           client_data[1]        - mainMenu widget
                           client_data[2]        - sleepButton widget

          call_data      - Specifies any callback-specific data the widget w
                           wants to pass to the client.
           
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   XtPointer *ptrlist ;
   Widget mainMenu ;
   Widget sleepPopup ;

          /* Minor */
          /* NONE */


   /*--------------- Start of SleepButtonSelect() routine -----------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering SleepButtonSelect()\n") ;
#endif

   ptrlist    = (XtPointer *) client_data ;
   mainMenu   = (Widget)      (ptrlist[1]) ;
   sleepPopup = (Widget)      (ptrlist[2]) ;


     /* Leave sleep mode by unrealizing the sleep button and realizing
      * the main menu.  Make sure it's set to be sensitive.
      */
   XtPopup(mainMenu, XtGrabNone) ;
   XtPopdown(sleepPopup) ;
   XtSetSensitive(mainMenu, True) ; /* Just to be sure */

#ifdef DEBUG
   printf("XPTS(select.c): Leaving SleepButtonSelect()\n") ;
#endif

}  /*------------------- End of SleepButtonSelect() ------------------------*/


/*
______________________________________________________________________
SolveProblemSelect()

FUNCTION DESCRIPTION:

     This function will allow the sysop user to mark a problem as solved.
This also saves the problem, just like SaveProblemSelect().
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/21/92
______________________________________________________________________
*/


void
SolveProblemSelect(Widget     w,
                   XtPointer  client_data,
                   XtPointer  call_data)

     /* Interface description:
         INPUT:
          w           - The widget for which this callback is registered.
          client_data - Specifies arbitrary client-supplied data
                        that the widget w should pass back to the
                        client when the widget executes the client's
                        callback procedure.  In this callback, 
                        this is an array of widgets, defined
                           like this:

                           client_data[0]  = text edit widget
                           client_data[1]  = buttonBox widget
                           client_data[2]  = buttonBox2 widget
                           client_data[3]  = helpLine widget
                           client_data[4]  = text widget
                           client_data[5]  = helpLine2 widget
                           client_data[6]  = higherButton widget
                           client_data[7]  = lowerButton widget
                           client_data[8]  = priority widget
			   client_data[9]  = summary widget


          call_data   - Specifies any callback-specific data the widget w
                        wants to pass to the client.
           
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   XtPointer	*ptrlist=NULL ;
   Widget	edit=NULL ;
   Widget	buttonBox=NULL ;
   Widget	buttonBox2=NULL ;
   Widget	helpLine=NULL ;
   Widget	text=NULL ;
   Widget	helpLine2=NULL ;
   Widget	list=NULL ;
   Widget	probViewer=NULL ;
   Widget	higherButton=NULL ;
   Widget 	lowerButton=NULL ;
   Widget 	priority=NULL ;
   Widget	summary=NULL ;
   Widget       asciiSource=NULL ;


          /* Minor */
   String	editstr=NULL ;
   Arg		args[5] ; 
   char		*tmptext=NULL ;
   int		timeval=0 ;
   char		info[256] ;
   Widget	wid=NULL ;
   String	tmpstr=NULL ;
   String       tmpstr2=NULL ;
   char         tmpstr3[MAXSUMLEN+1] ;
   char         short_desc[MAXSUMLEN+1] ;
   char         *c ;



   /*-------------- Start of SolveProblemSelect() routine ---------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering SolveProblemSelect()\n") ;
#endif

     /* Make sure only sysops are executing this function. */
   if (!IsSysop(&UserInfoRec))
   {
#ifdef DEBUG
        fprintf(stderr,
                "Illegal access to SolveProblemSelect() by non-sysop.\n") ;
#endif
     return ;
   }

   if (ProblemRecord)
      if (ProblemRecord->status != UNSOLVED)
      {
#ifdef DEBUG
         printf("XPTS(select.c): ProblemRecord->status != UNSOLVED !!!  Returning.\n");
#endif
         return ;
      }


   ptrlist = (XtPointer *)client_data ;
   edit         = (Widget) (ptrlist[0]) ;
   buttonBox    = (Widget) (ptrlist[1]) ;
   buttonBox2   = (Widget) (ptrlist[2]) ;
   helpLine     = (Widget) (ptrlist[3]) ;
   text         = (Widget) (ptrlist[4]) ;
   helpLine2    = (Widget) (ptrlist[5]) ;
   higherButton = (Widget) (ptrlist[6]) ;
   lowerButton  = (Widget) (ptrlist[7]) ;
   priority     = (Widget) (ptrlist[8]) ;
   summary	= (Widget) (ptrlist[9]) ;
   probViewer = XtParent(XtParent(buttonBox)) ; /* hack,hack...chough,cough. */


     /* Use WarningPopup() to get an acknowledgement from the
      * user that they really wish to mark the problem
      * as solved.
      */

	/* Nah... That'd be annoying. */

     /* If the user responds affirmative, then
      *   mark the unsolved problem as solved using SolveProblem().
      *   Append to the problem log a string indicating that
      *   the problem was solved by the current sysop user.
      *   Get the new text and add it to the existing problem text.
      */
   XtSetArg(args[0], XtNstring, &editstr) ;
   XtGetValues(XawTextGetSource(edit), args, ONE) ;
   if (strlen(editstr) == 0)
   {  if (! SuperWarningPopup("warning", w, EMPTY_LOG_WARNING)) return ;
   }

   tmptext = XtMalloc(strlen(ProblemRecord->log_file) + strlen(editstr) + 1000) ;
   strcpy(tmptext, ProblemRecord->log_file) ;
   strcat(tmptext, SOLVED_ENTRY_STR) ;
   timeval=time(0) ;
   sprintf(info,"%s   %s (%s)\n", ctime((time_t *)&timeval),
           UserInfoRec.username, UserInfoRec.realname) ;
   strcat (tmptext, info) ;
   strcat (tmptext, editstr) ;
#ifdef DEBUG
   printf("XPTS(select.c): New Problem Log:\n%s\n", tmptext) ;
#endif
     /* Update the problem log on the screen. */
/*   XtFree(ProblemRecord->log_file) ;*/
   ProblemRecord->log_file = tmptext ;
   ProblemRecord->status = SOLVED ;
   ProblemRecord->old_reporter_list = ProblemRecord->reporter_list ;
   ProblemRecord->num_old_rep = ProblemRecord->num_rep ;

        /* Get the new priority from the screen... */
#ifdef DO_PRIORITY
   XtVaGetValues (priority, XtNlabel, &tmpstr, NULL) ;
#ifdef DEBUG
   printf("XPTS[SolveProblemSelect()]: priority='%s'\n",tmpstr) ;
#endif
   ProblemRecord->priority = atoi(tmpstr) ;
#endif

        /* Get the new summary from the screen... */


   asciiSource = XawTextGetSource((Widget)summary) ;
   XtVaGetValues(asciiSource, XtNstring, &tmpstr2, NULL) ;
   strncpy(tmpstr3,tmpstr2,MAXSUMLEN) ;

   tmpstr3[MAXSUMLEN-1] = '\0' ;         /* Make sure it's terminated */
#ifdef DEBUG
   printf("XPTS[SolveProblemSelect()]: summary(before)='%s'\n",tmpstr3) ;
#endif

   c=FixStr(tmpstr3) ;  /* Strip leading & trailing spaces; remove newlines */

#ifdef DEBUG
   printf("XPTS[SolveProblemSelect()]: summary(after)='%s'\n",c) ;
#endif
/*
   strcpy(short_desc,c) ;
   if (strlen(short_desc) == 0)
      if (! SuperWarningPopup("warning", w, EMPTY_DESC_WARNING))
         return ;
*/
   if (strcmp(ProblemRecord->short_description, c/******/) != 0)
      strncpy (ProblemRecord->short_description, c /*******/, MAXSUMLEN) ;



     /* SOLVE IT! (Using SolveProblem())*/
/*CLD*/   if (SolveProblem(ProbTree, Path, ProblemRecord,
		tmptext, &UserInfoRec) == (int)NULL)
   {  /* If any errors occur, call ErrorPopup() and return */
      char errorstr[MAXERROR] ;
      sprintf(errorstr, "Error marking problem as solved!\n"
                        "\nPossible error cause:\n%s\n",
/*CLD*/                 CloudStrerror()) ;
      ErrorPopup("error", w, errorstr) ;
      return ;
   } else NoticePopup("notice", w, SOLVED_NOTICE) ;




     /* Unlock the problem since we're done editing it.  */

   LockedProblem(FALSE) ; /* Reset lock flag for potential emergency clean-up.*/
/*CLD*/   if (UnlockProblem(Path, ProblemRecord) == (int)NULL)
   {
      char errorstr[MAXERROR] ;
      sprintf(errorstr, "Error unlocking problem!\n"
                        "\nPossible error cause:\n%s\n",
/*CLD*/                 CloudStrerror()) ;
      ErrorPopup("error", w, errorstr) ;
      return ;
   }


     /***** Update the screen *****/
	/* Update the problem viewer.  
	 *   Update the problem text.
	 *   Display the correct buttons for a solved problem.
	 * Update the parent widget's summaries list.
         */
   XtSetArg(args[0], XtNstring, FormatProblem(ProblemRecord,Path)) ;
   XtSetValues(XawTextGetSource(text), args, ONE) ;

   if (wid=XtNameToWidget (buttonBox, "editButton"))   XtUnmanageChild(wid) ;
   if (wid=XtNameToWidget (buttonBox, "reportAgain"))  XtUnmanageChild(wid) ;
   if (wid=XtNameToWidget (buttonBox, "reopenButton")) XtManageChild(wid) ;

/*
   XtUnmanageChild (XtNameToWidget (buttonBox, "editButton")) ;
   XtUnmanageChild (XtNameToWidget (buttonBox, "reportAgain")) ;
   XtManageChild   (XtNameToWidget (buttonBox, "reopenButton")) ;
*/

   XtUnmanageChild (buttonBox2) ;
   XtUnmanageChild (edit) ;
   XtUnmanageChild (helpLine2) ;
   XtManageChild   (helpLine) ;
   XtManageChild   (buttonBox) ;
   XtSetSensitive  (buttonBox2,False) ;
   XtSetSensitive  (buttonBox,True) ;
#ifdef DO_PRIORITY
   XtSetSensitive  (higherButton,False) ;
   XtSetSensitive  (lowerButton,False) ;
#endif

   XawTextDisplayCaret(summary, FALSE) ;



	/* Update the list of summaries for the parent popup.
	 * This might be the pickProblem popup or the unsolvedPopup popup.
	 */
   ReadList(XtParent(probViewer), probViewer) ;

#ifdef DEBUG
   printf("XPTS(select.c): Leaving SolveProblemSelect()\n") ;
#endif
}  /*------------------ End of SolveProblemSelect() ---------------------*/

    
/*
______________________________________________________________________
PriorityIncSelect()

FUNCTION DESCRIPTION:

     This function will increase a new problem's priority.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  11/19/94
______________________________________________________________________
*/


void
PriorityIncSelect(Widget     w,
                    XtPointer  client_data,
                    XtPointer  call_data)

     /* Interface description:
         INPUT:
          w            - The widget for which this callback is registered.
          client_data  - Specifies arbitrary client-supplied data
                         that the widget w should pass back to the
                         client when the widget executes the client's
                         callback procedure.  In this callback, 
                         this is the priority label to change.
          call_data    - Specifies any callback-specific data the widget w
                         wants to pass to the client.
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   Widget priority ;
   String str ;
   signed char priority_val ;
          /* Minor */
          /* NONE */


   /*----------------- Start of PriorityIncSelect() routine -------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering PriorityIncSelect()\n") ;
#endif

   priority = (Widget) (client_data) ;
   XtVaGetValues (priority, XtNlabel, &str, NULL) ;

#ifdef DEBUG
   printf("XPTS(select.c): old priority=%s\n", str) ;
#endif

   priority_val = atoi(str) + 1 ;

#ifdef DEBUG
   printf("XPTS(select.c): new priority=%s\n", sctoa((int)priority_val)) ;
#endif

   SetPriorityValue(priority,priority_val) ;

#ifdef DEBUG
   printf("XPTS(select.c): Leaving PriorityIncSelect()\n") ;
#endif

}  /*--------------------- End of PriorityIncSelect() -------------------*/

    
/*
______________________________________________________________________
PriorityDecSelect()

FUNCTION DESCRIPTION:

     This function will decrease a new problem's priority.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  11/19/94
______________________________________________________________________
*/


void
PriorityDecSelect(Widget     w,
                    XtPointer  client_data,
                    XtPointer  call_data)

     /* Interface description:
         INPUT:
          w            - The widget for which this callback is registered.
          client_data  - Specifies arbitrary client-supplied data
                         that the widget w should pass back to the
                         client when the widget executes the client's
                         callback procedure.  In this callback, 
                         this is the priority label to change.
          call_data    - Specifies any callback-specific data the widget w
                         wants to pass to the client.
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   Widget priority ;
   String str ;
   signed char priority_val ;
          /* Minor */
          /* NONE */


   /*----------------- Start of PriorityDecSelect() routine -------------*/
#ifdef DEBUG
   printf("XPTS(select.c): Entering PriorityDecSelect()\n") ;
#endif

   priority = (Widget) (client_data) ;
   XtVaGetValues (priority, XtNlabel, &str, NULL) ;

#ifdef DEBUG
   printf("XPTS(select.c): old priority=%s\n", str) ;
#endif

   priority_val = atoi(str) - 1 ;

#ifdef DEBUG
   printf("XPTS(select.c): new priority=%s\n", sctoa((int)priority_val)) ;
#endif

   SetPriorityValue(priority,priority_val) ;

#ifdef DEBUG
   printf("XPTS(select.c): Leaving PriorityDecSelect()\n") ;
#endif

}  /*--------------------- End of PriorityDecSelect() -------------------*/

/* end of select.c */
