/* This is in the public-domain */


#include <stdio.h>
#include "zdbm.h" /* Only for zdebug() macros, which can be deleted */

#define LF 10
#define CR 13

#define UPPERHEX 1
#define LOWERHEX 2
#define BOTHHEX  3  /* UPPERHEX | LOWERHEX */



/* Extract a substring from the front of a string */
void
getword (char *sub,
         char *str, 
         char  endc)
{
   int i=0 ;		/* A counter    */
   int j=0 ;		/* ditto, dufus */
   char c='\0' ;	/* A character being copied */

	/* Copy the substring while searching for the marker character endc */
   while (str[i] != '\0' && str[i] != endc)
   {  sub[i] = str[i] ;
      ++i ;
   }
   sub[i] = '\0' ;

	/* If we didn't hit the end of str we need to skip the endc character */
   if (str[i])
      ++i ;

	/* If we didn't hit the end of str we need to skip the endc character */
   do
   {  c = str[j++] = str[i++] ;
   } while (c) ;

	/* Delete the substring from the original string. */
   while (str[j++] = str[i++]) ;

}



char *
makeword (char *str,
          char  endc)
{
   int i=0 ;		/* A counter    */
   int j=0 ;		/* ditto, dufus */
   char c='\0' ;	/* A character being copied */
   char *sub=NULL ;	/* The substring extracted */

	/* sub cannot require more room than str itself takes up.  */
   sub = (char *)malloc(sizeof(char) * (strlen(str) + 1)) ;

	/* Copy the substring while searching for the marker character endc */
   while (str[i] != '\0' && str[i] != endc)
   {  sub[i] = str[i] ;
      ++i ;
   }
   sub[i] = '\0' ;

	/* If we didn't hit the end of str we need to skip the endc character */
   if (str[i])
      ++i ;

	/* Delete the substring from the original string. */
   do
   {  c = str[j++] = str[i++] ;
   } while (c) ;

   return (sub) ;
}


#if 0
char *fmakeword(FILE *f, char stop, int *cl) {
    int wsize;
    char *word;
    int ll;

    wsize = 102400;
    ll=0;
    word = (char *) malloc(sizeof(char) * (wsize + 1));

    while(1) {
        word[ll] = (char)fgetc(f);
        if(ll==wsize) {
            word[ll+1] = '\0';
            wsize+=102400;
            word = (char *)realloc(word,sizeof(char)*(wsize+1));
        }
        --(*cl);
        if((word[ll] == stop) || (feof(f)) || (!(*cl))) {
            if(word[ll] != stop) ll++;
            word[ll] = '\0';
            return word;
        }
        ++ll;
    }
}
#endif


char *fmakeword(FILE *f, char stop, int *cl)
{
   int wsize=0 ;
   char *word=NULL ;
   char *tmp=NULL ;
   int ll=0 ;

   while (1)
   {
      wsize += 1024 ;
      zdebug2("str A ='%s'; wsize=%d\n", word, wsize) ;
      tmp = (char *) malloc (sizeof(char) * (wsize + 1)) ;
      tmp[0] = '\0' ;
      if (word)
      {
         word[ll+1] = '\0' ;
         strcpy (tmp, word) ;
         free(word) ;
      }
      word = tmp ;
      zdebug2("str B ='%s'; wsize=%d\n", word, wsize) ;

      while (ll <= wsize)
      {
         word[ll] = (char)fgetc(f);
         --(*cl) ;  /*NOTICE THIS CHANGES THE PARENT'S CONTEXT-LENGTH VAR. */
         zdebug3("word[%d]='%c'; cl=%d\n", ll, word[ll], *cl) ;

         if (word[ll] == stop || feof(f) || (!(*cl)))
         {
            if (word[ll] != stop)
               ++ll ;
            word[ll] = '\0' ;
            zdebug2("str C ='%s'; wsize=%d\n", word, wsize) ;
            return (word) ;
         }
         ++ll ;
      }
   }
}



int hexval(char c, int hextype)
{
   if (isdigit(c))
      return (c - '0') ;

   if ((hextype | UPPERHEX) && isalpha(c) && c >= 'A' && c <= 'F')
         return (c - 'A' + 10) ;

   if ((hextype | LOWERHEX) && isalpha(c) && c >= 'a' && c <= 'f')
      return (c - 'a' + 10) ;

   return 0 ;

}

char
x2c(char *str, int hextype)
{
   return (hexval(str[0],hextype) * 16 + hexval(str[1],hextype)) ;
}



void 
unescape_url (char *str)
{
   int i=0 ;		/* A counter    */
   int j=0 ;		/* ditto, dufus */
   char c='\0' ;

   while (str[j])
   {		/* copy chars, looking for a '%' escape character */
      c = str[i] = str[j] ;
      if (c == '%')
      {		/* Found one, so extract the next two chars. as a hex number*/
         str[i] = x2c(&(str[j+1]),UPPERHEX) ;
         j += 2 ;  /* ...and skip over them. */
      }
      ++i ;  /* "next, please" */
      ++j ;  /* "next, please" */
   }
   str[i] = '\0' ;  /* terminate 'er */
}



void
plustospace (char *str)
{
   int i=0 ;

   while (str[i] != '\0')
   {   if (str[i] == '+')
          str[i] = ' ' ;
       ++i ;
   }
}


